unit sbaradd;

interface

type play_info=record
    name:string[30];
    barcash:longint;
    job:byte;
  end;
  namestring=string[30];
  pathstring=string[120];
    type player_info = record
  names: string[20]; {player handle in the game}
real_names: string[50] {real name/or handle from BBS} ;
hit_points  {player hit points}
,bad  {don't know - might not be used at all}
,rate: integer; {again, couldn't find this one in the source}
hit_max: integer; {hit_point max}
weapon_num: integer; {weapon number}

weapon: string[20]; {name of weapon}
seen_master: integer; {equals 5 if seen master, else 0}
fights_left: integer; {forest fights left}
human_left: integer; {human fights left}
gold: longint; {gold in hand}
bank: longint; {gold in bank}
def: integer;  {total defense points }
strength: integer; {total strength}
charm: integer; {good looking meter}
seen_dragon: integer; {seen dragon?  5 if yes else 0}
seen_violet: integer; {seen violet?  5 if yes else 0}
level: integer; {level of player}
time: word; {day # that player last played on}
arm: string[20]; {armour name}
arm_num: integer; {armour number}
dead: shortint; {player dead?  5 if yes else 0}
inn: shortint; {player sleeping at inn?  5 if yes else 0}
gem: integer; {# of gems on hand}
exp: longint; {experience}
sex: shortint; {gender, 5 if female else 0}
seen_bard: shortint; {seen bard?  5 if yes else 0}
last_alive_time: integer; {day # player was last reincarnated on}
Lays: integer; {players lays stat}
Why: integer; {not used yet}
on_now: boolean; {is player on?}
m_time: integer; {day on_now stat was last used}
time_on: string[5]; {time player logged on in Hour:Minutes format}
class: shortint; {class, should be 1, 2 or 3}
extra: integer;      {*NEW*  If 1, player has a horse}
love: string[25]; {not used - may be used for inter-player marrages later}
married: integer; {who player is married to, should be -1 if not married}
kids: integer; {# of kids}
king: integer; {# of times player has won game}
skillw: shortint; {number of Death Knight skill points}
skillm: shortint; {number of Mystical Skills points}
skillt: shortint; {number of Thieving Skills points}

levelw: shortint; {number of Death Knight skill uses left today}
levelm: shortint; {number of Mystical skill uses left today}
levelt: shortint; {number of Thieving skill uses left today}

inn_random: boolean; {not used yet}
married_to: integer; {same as Married, I think - don't know why it's here}
v1: longint;
v2: integer; {# of player kills}
v3: integer; {if 5, 'wierd' event in forest will happen}
v4: boolean; {has player done 'special' for that day?}
v5: shortint; {has player flirted with another player that day?  if so, 5}
  new_stat1: shortint;
  new_stat2: shortint;  {these 3 are unused right now}
  new_stat3: shortint;  {Warning: Joseph's NPCLORD screws with all three}
  end;



procedure cfgin2;
   procedure fwrite(s:string);
   procedure talksandtiger(t:longint;var playrec:player_info;var barcash:longint);
   procedure extraconfig;
   procedure installnet;
   procedure config;
   function convertacard(s:byte;ctype:shortint):string;
   procedure moreprompt;
   procedure fivecard(var gamb1:longint;var prec:play_info;var maxbet1:longint;var ctype3:shortint;var playrec:player_info
;var barcash:longint);
   function convert(anguish:string;level:byte):longint;
   function fileexists(FNAME:string):boolean;
   function caps(s:string):string;
   procedure configuration(var spath:pathstring);


implementation
uses ddplusa,dos,crt,filelock;




var playrec:array[1..149] of ^player_info;
    bcash:longint;
    errcode:integer;
    lefttoday : byte;
    poker,registered:boolean;
    bbsname,reg,sysopsname:string[60];
    prec:play_info;
    nc,hp,sm,ff,uf,gp,df,st,ch,fv,ge,ex,sc,cc,hb,sk,fa,di,ho:string[30];
    mynum,mynumber:byte;
    di1,nc1,hp1,sm1,ff1,uf1,gp1,df1,st1,ch1,fv1,ge1,ex1,sc1,cc1,hb1,sk1,fa1,ho1:longint;
    path:string;
    i:byte;
    playfile:file of player_info;
    elbow:array[1..13] of string;
    tempnum:byte;
    tempnum2:array[1..4] of longint;
    yipper:byte;






function caps(s:string):string;
 var c:byte;
  begin
    for c := 1 to length(s) do s[c] := UPCASE(s[c]);
    caps := s;
  end;



procedure fwriteln(s:string);
 label DEVIL;
 var f,g,h: string;
     done:boolean;
     q:byte;
  begin
    done := false;
   repeat
    IF (pos('`',s) > 0) and (s[pos('`',s)+1] IN ['0','1','2','3','4','5','6','7','8','9','!','@','#','$','%']) then begin
       g := '';
       for q := 1 to POS('`',s)-1 do g := g + s[q];
       swrite(g);
       CASE s[POS('`',s)+1] of
       '1':set_foreground(1);
       '2':set_foreground(2);
       '3':set_foreground(3);
       '4':set_foreground(4);
       '5':set_foreground(5);
       '6':set_foreground(6);
       '7':set_foreground(7);
       '8':set_foreground(8);
       '9':set_foreground(9);
       '0':set_foreground(10);
       '!':set_foreground(11);
       '@':set_foreground(12);
       '#':set_foreground(13);
       '$':set_foreground(14);
       '%':set_foreground(15);
       end;
       f := '';
       for q := (POS('`',s)+2) to length(s) do f := f + s[q];
       s := f;
       end;
   until POS('`',s) = 0;
    swriteln(s)
  end;



procedure fwrite(s:string);
 label DEVIL;
 var f,g,h: string;
     done:boolean;
     q:byte;
  begin
    done := false;
    IF NOT POS('`',s) > 0 then begin
      swrite(s);
      exit;
    end;
   repeat
    IF s[pos('`',s)+1] IN ['0','1','2','3','4','5','6','7','8','9','!','@','#','$','%'] then begin
       g := '';
       for q := 1 to POS('`',s)-1 do g := g + s[q];
       swrite(g);
       CASE s[POS('`',s)+1] of
       '1':SET_foreground(1);
       '2':SET_foreground(2);
       '3':SET_foreground(3);
       '4':SET_foreground(4);
       '5':SET_foreground(5);
       '6':SET_foreground(6);
       '7':set_foreground(7);
       '8':set_foreground(8);
       '9':set_foreground(9);
       '0':set_foreground(10);
       '!':set_foreground(11);
       '@':set_foreground(12);
       '#':set_foreground(13);
       '$':set_foreground(14);
       '%':set_foreground(15);
       end;
       f := '';
       for q := (POS('`',s)+2) to length(s) do f := f + s[q];
       s := f;
       end;
   until POS('`',s) = 0;
   swrite(s);
  end;

procedure moreprompt;
  var ch:char;
  begin
    fwriteln('`2<`0MORE`2>');
    sread_char(ch);
    swriteln('');
  end;

  function convertacard(s:byte;ctype:shortint):string;
var l,f:byte;
tempstr,tempst:string;
  begin
    f := 1;
    while (S > 13) do begin
      inc(f);
      dec(s,13);
    end;
    IF (CTYPE = 1) then begin
    CASE S of
      1: tempstr := '`%Ace ';
      2: tempstr := '`%Two ';
      3: tempstr := '`%Three ';
      4: tempstr := '`%Four ';
      5: tempstr := '`%Five ';
      6: tempstr := '`%Six ';
      7: tempstr := '`%Seven ';
      8: tempstr := '`%Eight ';
      9: tempstr := '`%Nine ';
     10: tempstr := '`%Ten ';
     11: tempstr := '`%Jack ';
     12: tempstr := '`%Queen ';
     13: tempstr := '`%King ';
    end;
    end
    else begin
    CASE S of
      1: tempstr := '`%A';
      2: tempstr := '`%2';
      3: tempstr := '`%3';
      4: tempstr := '`%4';
      5: tempstr := '`%5';
      6: tempstr := '`%6';
      7: tempstr := '`%7';
      8: tempstr := '`%8';
      9: tempstr := '`%9';
     10: tempstr := '`%10';
     11: tempstr := '`%J';
     12: tempstr := '`%Q';
     13: tempstr := '`%K';
    end;
    end;
    IF (CTYPE = 1) then begin
    case f of
      1: tempst := ' `$Diamonds';
      2: tempst := ' `0Clubs';
      3: tempst := ' `@Hearts';
      4: tempst := ' `7Spades';
    end;
    end
    else begin
    case f of
      1: tempst := '`$'+chr(4);
      2: tempst := '`0'+chr(5);
      3: tempst := '`@'+chr(3);
      4: tempst := '`7'+chr(6);
    end;
    end;
    IF (ctype = 1) then convertacard := tempstr+'of'+tempst else
    convertacard := tempstr+tempst;
  end;



procedure fivecard(var gamb1:longint;var prec:play_info;var maxbet1:longint;var ctype3:shortint;var playrec:player_info
;var barcash:longint);
vaR ch:char;
  cards:array[1..52] of byte;
  t:array[1..7] of shortint;
  tn:array[1..7] of string[20];
  tt:array[1..7,1..7] of string[40];
  f:array[1..7] of boolean;
  ts:array[1..7,1..7] of byte;
  tf:array[1..7,1..7] of byte;
  five:array[1..7,1..5] of byte;
  six:array[1..7,1..5] of byte;
  stay:array[1..7] of boolean;
  done:boolean;
  tabit,cash,s,te,temp,tem,y,gh:byte;
  temps,tempstr,tempst :string;
  money,crackdown:longint;
  new:boolean;
  label baja,baja2,baja3,again;
  begin
    poker := true;
    swriteln('');
    fwrite('`2You need rules? `![`2Y`0/`2N`!] ');
    sread_char(ch);
    IF UPCASE(CH) = 'Y' then begin
       sclrscr;
       fwriteln('`0Five Card Draw is a game of luck and skill.  You are dealt');
       fwriteln('five cards at the beginning of each game.  You are given a');
       fwriteln('chance to discard from 0 to 5 cards once in the game.  The');
       fwriteln('goal is to get the highest hand possible.');
       swriteln('');
       fwriteln('However, at Sandtiger''s Bar, the rules are slightly');
       fwriteln('modified.  Nobody likes to be a loser - the last time Koz');
       fwriteln('lost, he shot and killed 4 people.  So, if you get at least');
       fwriteln('three of a kind, it doesn''t matter what card you have,');
       fwriteln('everyone with three of a kind will win.  However, if you');
       fwriteln('have a two pair or lower, the highest wins!');
       swriteln('');
       moreprompt;
    end;
    again:
    IF (gamb1 < 1) then begin

       sclrscr;
       fwriteln('`2The gambling group is tired of you winning all the time.');
       swriteln('');
       fwriteln('`2Maybe you should come back later.');
       moreprompt;
       exit;
    end;
    new := true;
    sclrscr;
    fwriteln('`%        Bet whatever you want.  If you win, you get it times 6 back.');
    fwriteln('`%        If you tie, you''ll split the winnings.');
    repeat
    for gh := 1 to 7 do for temp := 1 to 7 do begin
       tt[gh,temp] := '';
       tf[gh,temp] := 0;
    end;
    swriteln('');
    str(barcash,tempstr);
    fwriteln('`2You have `%'+tempstr+' `2in BarCoins.');
    fwrite('`2Your Bet? `0(`%0 `2to quit`0) ');
    set_foreground(15);
    sread(tempstr);
    val(tempstr,money,errcode);
    until (errcode = 0) and ((barcash - money) > -1) and (money > -1) and
           (money < maxbet1);
    dec(barcash,money);
    for cash := 1 to 7 do stay[cash] := false;
    IF (money = 0) then exit;
    cash := 7;
      randomize;
      IF NEW then begin
         randomize;
         new := false;
         for temp := 2 to 7 do begin
           sclrscr;
           fwriteln('`$Shuffling...');
           for s := 1 to 52 do cards[s] := s;
           for s := 1 to 7 do begin
           CASE s of
             2:tn[s] := 'Nennahs';
             3:tn[s] := 'Koz';
             4:tn[s] := 'DEKrueger';
             5:tn[s] := 'Tabula';
             6:tn[s] := 'Bat';
             7:tn[s] := 'Slunk';
           end;
         end;
         end;
         tn[1] := playrec.names;
      end;
      sclrscr;
      fwriteln('`%Five Card Draw...');
      swriteln('');
      for s := 2 to 7 do begin
        for gh := 1 to 5 do begin
        new := true;
        baja:
        temp := 0;
        repeat
          IF (temp = 52) then begin
            for y := 1 to 52 do cards[y] := y;
            temp := 0;
          end;
          inc(temp);
          y := 1+random(52);
        until not (cards[y] = 0);
        cards[y] := 0;
        tt[s,gh] := convertacard(y,ctype3);
        ts[s,gh] := 0;
        WHILE (Y > 13) do begin
           dec(y,13);
           inc(ts[s,gh]);
        end;
        IF (gh > 1) then begin
          tt[s,gh] := '`2/`0'+tt[s,gh];
        end;
        tf[s,gh] := y;
        end;
        fwriteln('`#'+tn[s]+'`!: ');
        fwriteln('`3Covered Cards');
        new := false;
      end;
      swriteln('');
      tn[1] := playrec.names;
      fwriteln('`%'+tn[1]+'`!: ');
      for gh := 1 to 5 do begin
      temp := 0;
        repeat
          IF (temp = 52) then begin
            fwriteln('`$Shuffling Deck...');
            for y := 1 to 52 do cards[y] := y;
            temp := 0;
          end;
          inc(temp);
          y := 1+random(52);
        until not (cards[y] = 0);
        cards[y] := 0;
        tt[1,gh] := convertacard(y,ctype3);
        ts[1,gh] := 0;
        WHILE (Y > 13) do begin
           dec(y,13);
           inc(ts[1,gh]);
        end;
        tf[1,gh] := y;
        IF (gh > 1) then
          if (tt[1,gh][1] = '1') then tt[1,gh] := ' '+ tt[1,gh]
            else tt[1,gh] := '  '+tt[1,gh];
      end;
      fwriteln('`2  1   2   3   4   5');
      fwriteln('`0 --- --- --- --- ---');
      fwriteln('`% '+tt[1,1]+tt[1,2]+tt[1,3]+tt[1,4]+tt[1,5]);
                           for y := 1 to 7 do begin
                             for temp := 1 to 5 do five[y,temp] := tf[y,temp];
                             for temp := 1 to 5 do six[y,temp] := ts[y,temp];
                               for s := 5 downto 2 do
                               for gh := 1 to s do begin
                                  IF (five[y,s] > five[y,gh]) then begin
                                    te := five[y,gh];
                                    tem := six[y,gh];
                                    five[y,gh] := five[y,s];
                                    six[y,gh] := six[y,s];
                                    five[y,s] := te;
                                    six[y,s] := tem;
                                  end;
                               end;
                             end;


      repeat
        swriteln('');
        fwrite('`2Discard How Many Cards? ');
        sread_char(ch);
      until upcase(ch) in ['1','2','3','4','5','0'];
      fwrite('`5'+ch);
      val(ch,s,errcode);
      swriteln('');
      for te := 1 to s do begin
            repeat
            swriteln('');
            str(te,tempstr);
            fwrite('`2Enter the number of the card you want to discard: ');
            set_foreground(15);
            sread_char(ch);
            until (UPCASE(CH) in ['1','2','3','4','5']);
            fwrite('`5'+ch);
            val(ch,tem,errcode);
            temp := 0;
              repeat
              IF (temp = 52) then begin
            for y := 1 to 52 do cards[y] := y;
            temp := 0;
          end;
          inc(temp);
          y := 1+random(52);
        until not (cards[y] = 0);
        cards[y] := 0;
        tt[1,tem] := convertacard(y,ctype3);
        ts[1,tem] := 0;
        WHILE (Y > 13) do begin
           dec(y,13);
           inc(ts[1,tem]);
        end;
        tf[1,tem] := y;
        IF (tem > 1) then
          if (tt[1,tem][1] = '1') then tt[1,tem] := ' '+ tt[1,tem]
            else tt[1,tem] := '  '+tt[1,tem];
      end;
      sclrscr;
      for y := 2 to 7 do begin
         tabit := 0;
         for tem := 1 to 5 do begin
           te := 0;
           IF (five[y,tem] = five[y,1]) then inc(te);
           IF (five[y,tem] = five[y,2]) then inc(te);
           IF (five[y,tem] = five[y,3]) then inc(te);
           IF (five[y,tem] = five[y,4]) then inc(te);
           IF (five[y,tem] = five[y,5]) then inc(te);
           IF (TE = 1) then begin
            inc(tabit);
            temp := 0;
            repeat
              IF (temp = 52) then begin
                for te := 1 to 52 do cards[te] := te;
                temp := 0;
              end;
              inc(temp);
              te := 1+random(52);
            until not (cards[te] = 0);
            cards[te] := 0;
            tt[y,tem] := convertacard(te,ctype3);
            ts[y,tem] := 0;
            WHILE (te > 13) do begin
              dec(te,13);
              inc(ts[y,tem]);
            end;
            tf[y,tem] := te;
            IF (tem > 1) then tt[y,tem] := '`2/`0'+tt[y,tem];
           end;
         end;
         str(tabit,tempstr);
         swriteln('');
         fwriteln('`0'+tn[y]+' `2takes `%'+tempstr+' `2cards.');
         moreprompt;
      end;
      for y := 1 to 7 do begin
                             for temp := 1 to 5 do five[y,temp] := tf[y,temp];
                             for temp := 1 to 5 do six[y,temp] := ts[y,temp];
                               for s := 5 downto 2 do
                               for gh := 1 to s do begin
                                  IF (five[y,s] > five[y,gh]) then begin
                                    te := five[y,gh];
                                    tem := six[y,gh];
                                    five[y,gh] := five[y,s];
                                    six[y,gh] := six[y,s];
                                    five[y,s] := te;
                                    six[y,s] := tem;
                                  end;
                               end;
                             end;
              for y := 1 to 7 do stay[y] := false;
              temp := 0;
              repeat
                inc(temp);
                for y := 1 to 7 do begin
                  s := five[y,1];
                  CASE TEMP OF
                    1:IF (six[y,1] = six[y,2]) and (six[y,3] = six[y,4]) and
                      (six[y,5] = six[y,2]) and (six[y,1] = six[y,4]) and
                      (five[y,1] = 13) and (five[y,2] = 12) and (five[y,3] = 11)
                      and (five[y,4] = 10) and (five[y,5] = 1) then stay[y] := true;
                    2:IF (six[y,1] = six[y,2]) and (six[y,3] = six[y,4]) and
                      (six[y,5] = six[y,2]) and (six[y,1] = six[y,4]) and
                      (five[y,1] = s) and (five[y,2] = s-1) and (five[y,3]=s-2)
                      and (five[y,4]=s-3) and (five[y,5]=s-4) then stay[y] := true;
                    3:IF ((five[y,1] = five[y,2]) and (five[y,2] = five[y,3]) and
                      (five[y,3] = five[y,4])) OR ((five[y,2] = five[y,3]) and
                      (five[y,3] = five[y,4]) and (five[y,4] = five[y,5])) then
                      stay[y] := true;
                    4:IF ((five[y,1] = five[y,2]) and (five[y,2] = five[y,3]) and
                      (five[y,4] = five[y,5])) OR ((five[y,1] = five[y,2]) and
                      (five[y,3] = five[y,4]) and (five[y,4] = five[y,5])) then
                      stay[y] := true;
                    5:IF (six[y,1] = six[y,2]) and (six[y,3] = six[y,4]) and
                      (six[y,5] = six[y,2]) and (six[y,1] = six[y,4]) then
                      stay[y] := true;
                    6:if (five[y,1] = s) and (five[y,2] = s-1) and (five[y,3]=s-2)
                      and (five[y,4]=s-3) and (five[y,5]=s-4) then stay[y] := true;
                    7:IF ((five[y,1] = five[y,2]) and (five[y,2] = five[y,3]))
                      OR ((five[y,3] = five[y,2]) and (five[y,3] = five[y,4]))
                      or ((five[y,4] = five[y,5]) and (five[y,3] = five[y,4]))
                      then stay[y] := true;
                  end;
                  IF (TEMP = 8) then begin
                    s := 0;
                    for tem := 1 to 5 do begin
                    te := 0;
                    IF (five[y,tem] = five[y,1]) then inc(te);
                    IF (five[y,tem] = five[y,2]) then inc(te);
                    IF (five[y,tem] = five[y,3]) then inc(te);
                    IF (five[y,tem] = five[y,4]) then inc(te);
                    IF (five[y,tem] = five[y,5]) then inc(te);
                    IF (TE > 1) then inc(s);
                    end;
                    S := S DIV 2;
                    IF (S = 2) then stay[y] := true;
                  end;
                  IF (TEMP = 9) then begin
                    s := 0;
                    for tem := 1 to 5 do begin
                    te := 0;
                    IF (five[y,tem] = five[y,1]) then inc(te);
                    IF (five[y,tem] = five[y,2]) then inc(te);
                    IF (five[y,tem] = five[y,3]) then inc(te);
                    IF (five[y,tem] = five[y,4]) then inc(te);
                    IF (five[y,tem] = five[y,5]) then inc(te);
                    IF (TE > 1) then inc(s);
                    end;
                    S := S DIV 2;
                    IF (S = 1) then stay[y] := true;
                  end;
                  IF (TEMP = 10) then begin
                    tem := 0;
                    for te := 1 to 7 do if (five[te,5] = 1) then five[te,1] := 14;
                    for te := 1 to 7 do if (five[te,1] >= tem) then begin
                       for s := 1 to 7 do if (five[s,1] < tem) then stay[s] := false;
                       tem := five[te,1];
                       stay[te] := true;
                    end;
                  end;
              end;
              until (stay[1]) or (stay[2]) or (stay[3]) or (stay[4]) or (stay[5]);
        crackdown := temp;
        if (temp = 8) then begin
          gh := 0;
          for y := 1 to 7 do begin
            IF (stay[y]) then begin
              for tem := 1 to 5 do begin
                IF (five[y,tem] = 1) then five[y,tem] := 14;
                te := 0;
                IF (five[y,tem] = five[y,1]) then inc(te);
                IF (five[y,tem] = five[y,2]) then inc(te);
                IF (five[y,tem] = five[y,3]) then inc(te);
                IF (five[y,tem] = five[y,4]) then inc(te);
                IF (five[y,tem] = five[y,5]) then inc(te);
                IF (TE = 1) then five[y,tem] := 0;
              end;
              tabit := five[y,1]+five[y,2]+five[y,3]+five[y,4]+five[y,5];
              IF (tabit >= gh) then begin
                for temp := y downto 1 do
                  if (five[temp,1]+five[temp,2]+five[temp,3]+five[temp,4]+
                      five[temp,5] < tabit) then stay[temp] := false;
                gh := tabit;
                stay[y] := true;
              end
              else stay[y] := false;
            end;
          end;
        end;
        if (crackdown = 9) then begin
          gh := 0;
          for y := 1 to 7 do begin
            IF (stay[y]) then begin
              for tem := 1 to 5 do begin
                IF (five[y,tem] = 1) then five[y,tem] := 14;
                te := 0;
                IF (five[y,tem] = five[y,1]) then inc(te);
                IF (five[y,tem] = five[y,2]) then inc(te);
                IF (five[y,tem] = five[y,3]) then inc(te);
                IF (five[y,tem] = five[y,4]) then inc(te);
                IF (five[y,tem] = five[y,5]) then inc(te);
                IF (TE = 1) then five[y,tem] := 0;
              end;
              tabit := five[y,1]+five[y,2]+five[y,3]+five[y,4]+five[y,5];
              IF (tabit >= gh) then begin
                for temp := (y-1) downto 1 do
                  if (five[temp,1]+five[temp,2]+five[temp,3]+five[temp,4]+
                      five[temp,5] < tabit) then stay[temp] := false;
                gh := tabit;
                stay[y] := true;
              end
              else stay[y] := false;
            end;
          end;
        end;
        CASE CRACKDOWN OF
          1:tempstr := '`%Royal Flush';
          2:tempstr := '`%Straight Flush';
          3:tempstr := '`%Four of a Kind';
          4:tempstr := '`%Full House';
          5:tempstr := '`%Flush';
          6:tempstr := '`%Straight';
          7:tempstr := '`%Three of a Kind';
          8:tempstr := '`%Two Pair';
          9:tempstr := '`%Pair';
          10:tempstr := '`%High Card';
        end;
        sclrscr;
        fwriteln('`%Final Standings...');
        swriteln('');
        for y := 2 to 7 do begin
           fwrite('`9'+tn[y]+'`!:  ');
           IF not (stay[y]) then fwriteln('`#Loser!')
           else fwriteln('`#'+tempstr);
           fwriteln('`0'+tt[y,1]+tt[y,2]+tt[y,3]+tt[y,4]+tt[y,5]);
        end;
        swriteln('');
        fwrite('`!'+tn[1]+'`0: ');
        y := 1;
        IF not (stay[y]) then fwriteln('`#Loser!')
           else fwriteln('`#'+tempstr);
        fwriteln('`2  1   2   3   4   5');
        fwriteln('`0 --- --- --- --- ---');
        fwriteln('`% '+tt[1,1]+tt[1,2]+tt[1,3]+tt[1,4]+tt[1,5]);
        swriteln('');
        swriteln('');
        baja2:
          IF (stay[1] = false) then begin
            fwriteln('`0You won nothing!');
            moreprompt;
          end
          else begin
    cash := 0;
    for y := 2 to 7 do if stay[y] then inc(cash);
    CASE CASH OF
      0: begin
           str(money*7,tempst);
           IF (money*7) < 0 then dec(barcash,money*7) else
           inc(barcash,money*7);
         end;
      1: begin
           str(money*3,tempst);
           IF (money*3) < 0 then dec(barcash,money*3) else
           inc(barcash,money*3);
         end;
      2: begin
           str(money*2,tempst);
           IF (money*2) < 0 then dec(barcash,money*2) else
           inc(barcash,money*2);
         end;
      3: begin
           str(money*2-(MONEY DIV 2),tempst);
           IF (money*2-(MONEY DIV 2)) < 0 then dec(barcash,money*2-(MONEY DIV 2)) else
           inc(barcash,money*2);
         end;
      4: tempst := '0';
      5: tempst := '0';
      6: tempst := '0';
      7: tempst := '0';
    end;
    IF tempst[1] = '-' then tempst[1] := ' ';
    fwriteln('`0You win `%'+tempst+' `0BarCoins!');
    moreprompt;
    end;
    baja3:
    swriteln('');
    repeat
      fwriteln('`2Wanna play again? `0[`2Y`0/`2N`0] ');
      sread_char(ch);
    until upcase(ch) IN ['Y','N'];
    dec(gamb1);
    IF UPCASE(CH) = 'Y' then goto again;
  end;




   function drinkcheck(drink:byte;var barcash:longint):byte;
  var ch:char;
  data:text;
  tempstr:string;
  begin
    IF (DRINK > 0) then begin
       drinkcheck := drink;
       exit;
    end;
    swriteln('');
    fwriteln('`2Sandtiger looks sadly at his empty beer glass.');
    swriteln('');
    fwriteln('`2Now he''s looking at you...  What will you do?');
    swriteln('');
    fwriteln('`0[`2B`0]`2uy the man another beer!');
    fwriteln('`0[`2S`0]`2tand up and leave the table.');
    repeat
    sread_char(ch);
    until UPCASE(CH) in ['B','S'];
    swriteln('');
    CASE UPCASE(CH) of
      'S':drink := 250;
      'B':begin
            swriteln('');
            fwriteln('`2A good-looking waitress comes over to your table.');
            fwriteln('She takes one glance at Sandtiger, and then at you.');
            fwriteln('`0"`2Buying a drink for the boss?`0"');
            swriteln('');
            fwriteln('`2  We got...');
            fwriteln('                 `0(`#P`0)`2hlegm Nog `!- `2   3 `#BarCoins');
            fwriteln('                 `0(`#N`0)`2yte-Quill `!- `2  10 `#BarCoins');
            fwriteln('                 `0(`#S`0)`2ake       `!- `2  25 `#BarCoins');
            fwriteln('                 `0(`#R`0)`2ed Dawg   `!- `2  50 `#BarCoins');
            fwriteln('                 `0(`#H`0)`2urricane  `!- `2 100 `#BarCoins');
            fwriteln('                 `0(`#E`0)`2verClear  `!- `21000 `#BarCoins');
            swriteln('');
            fwriteln('`2Or if you wish to leave the boss `#[`0A`#]`2lone, I understand.');
            swriteln('');
            str(barcash,tempstr);
            fwriteln('`2You have `%'+tempstr+'`2 BarCoins.');
            repeat
            sread_char(ch);
            until UPCASE(CH) in ['P','S','E','N','R','H','A'];
            CASE UPCASE(CH) of
              'A':drink := 250;
              'P':BEGIN
                    IF (barcash < 3) then begin
                      drinkcheck := 250;
                      fwriteln('`2You can''t afford to pay this!');
                      moreprompt;
                      exit;
                    end
                    else begin
                      dec(barcash,3);
                      drink := 5;
                    end;
                  end;
              'S':BEGIN
                    IF (barcash < 25) then begin
                      drinkcheck := 250;
                      fwriteln('`2You can''t afford to pay this!');
                      moreprompt;
                      exit;
                    end
                    else begin
                      dec(barcash,25);
                      drink := 15;
                    end;
                  end;
              'N':BEGIN
                    IF (barcash < 10) then begin
                      drinkcheck := 250;
                      fwriteln('`2You can''t afford to pay this!');
                      moreprompt;
                      exit;
                    end
                    else begin
                      dec(barcash,10);
                      drink := 11;
                    end;
                  end;
              'R':BEGIN
                    IF (barcash < 50) then begin
                      drinkcheck := 250;
                      fwriteln('`2You can''t afford to pay this!');
                      moreprompt;
                      exit;
                    end
                    else begin
                      dec(barcash,50);
                      drink := 29;
                    end;
                  end;
              'H':BEGIN
                    IF (barcash < 100) then begin

                      drinkcheck := 250;
                      fwriteln('`2You can''t afford to pay this!');
                      moreprompt;
                      exit;
                    end
                    else begin
                      dec(barcash,100);
                      drink := 49;
                    end;
                  end;
              'E':BEGIN
                    IF (barcash < 100) then begin
                      drinkcheck := 250;
                      fwriteln('`2You can''t afford to pay this!');
                      moreprompt;
                      exit;
                    end
                    else begin
                      dec(barcash,1000);
                      drink := 79;
                    end;
                  end;
              end;
            end;
            end;
            drinkcheck := drink;
            moreprompt;
end;



procedure cfgin;
  var data:text;
      tempstr:string;
      y:byte;
  begin
    assign(data,paramstr(1)+'\sandbar.cfg');
    reset(data);
    readln(data,path);
    readln(data,nc);readln(data,hp);readln(data,sm);readln(data,ff);readln(data,uf);readln(data,gp);
    readln(data,df);readln(data,st);readln(data,ch);readln(data,fv);readln(data,ge);readln(data,ex);
    readln(data,ex);readln(data,sc);readln(data,cc);readln(data,hb);readln(data,sk);readln(data,fa);
    readln(data,ho);readln(data,di);readln(data,sysopsname);readln(data,reg);
    str(ord(sysopsname[1])*ord(sysopsname[3])+ord(sysopsname[5]),tempstr);
    IF (tempstr=reg) then registered := true else registered := false;
    registered := true;
    close(data);
    tempstr := '';
    for y := 1 to length(path)-1 do tempstr := tempstr + path[y];
    chdir(tempstr);
  end;








procedure talksandtiger(t:longint;var playrec:player_info;var barcash:longint);
var drink : byte;
ch:char;
data:text;
tempstr : string;
label baja;

  begin
    sclrscr;
    fwriteln('`2You timidly approach Sandtiger, who is currently nursing a beer');
    fwriteln('in the corner.  He takes one last gulp, and motions for you to');
    fwriteln('take a seat.');
    moreprompt;
    sclrscr;
    drink := 0;
    repeat
      baja:
      drink := drinkcheck(drink,barcash);
      IF (drink = 250) then exit;
      swriteln('');
      fwriteln('`2Sandtiger nurses his drink, waiting for your next request.');
      fwrite('`0] ');
      set_foreground(15);
      sread(tempstr);
      swriteln('');
      IF (POS('HELP',caps(tempstr)) > 0) or (POS('?',caps(tempstr)) > 0) then begin
         swriteln('');
         fwriteln('`2Well...  Most people like to ask about beautiful women.');
         fwriteln('`2Or how to cheat...');
         fwriteln('`2But most like to chat about the history of this place.');
         moreprompt;
      end;
      IF (POS('LORD',caps(tempstr)) > 0) or (POS('LEGEND',caps(tempstr)) > 0) then begin
        swriteln('');
        fwriteln('`2That''s an interesting concept.  But have you heard of New World?');
        moreprompt;
        goto baja;
      end;
      IF (POS('VIOL',caps(tempstr)) > 0) then begin
        swriteln('');
        fwriteln('`2Turgon''s daughter is almost beautiful as Jennie Garth.');
        moreprompt;
        goto baja;
      end;
      IF (POS('DRAG',caps(tempstr)) > 0) then begin
        swriteln('');
        fwriteln('`2I don''t think you could take him on...');
        moreprompt;
        goto baja;
      end;
      IF (POS('SETH',caps(tempstr)) > 0) then begin
        swriteln('');
        fwriteln('`2Seth Able?  The man with the angelic voice.');
        moreprompt;
        goto baja;
      end;
      IF (POS('GOD',caps(tempstr)) > 0) then begin
        swriteln('');
        fwriteln('`2Jennie Garth is a god.');
        moreprompt;
        goto baja;
      end;
      IF (POS('HELLO',caps(tempstr)) > 0) then begin
         swriteln('');
         fwriteln('`2Greetings, '+playrec.names);
         moreprompt;
         goto baja;
      end;
      IF (POS('FUCK',caps(tempstr)) > 0) or (POS('SHIT',caps(tempstr)) > 0) then begin
         swriteln('');
         fwriteln('`2Sandtiger stands up and strikes you down!  You lose two hit points!');
         IF (playrec.hit_max > 2) then dec(playrec.hit_max,2);
         moreprompt;
         goto baja;
      end;
      IF POS('JENN',caps(tempstr)) > 0 then begin
         swriteln('');
         fwriteln('`0"`2So... You wanna know about Jennie Garth, eh, child?`0"');
         swriteln('');
         fwriteln('`2Sandtiger takes a monstrous gulp of the murky liquid.');
         IF (DRINK < 15) then drink := 0 else dec(drink,15);
         swriteln('');
         fwriteln('`2Well, she certainly is a BABE...');
         drink := drinkcheck(drink,barcash);
         IF (drink = 250) then exit;
         IF (DRINK < 15) then drink := 0 else dec(drink,15);
         swriteln('');
         fwriteln('`2And I guess you could call her SEXY... or FOXY...');
         drink := drinkcheck(drink,barcash);
         IF (drink = 250) then exit;
         IF (DRINK < 15) then drink := 0 else dec(drink,15);
         swriteln('');
         fwriteln('`2But don''t call her UGLY or DUNG!');
         moreprompt;
         goto baja;
      end;
      IF (POS('WITCH',caps(tempstr)) > 0) then begin
         swriteln('');
         fwriteln('`0"`2So... You wanna know about the Old Witch?`0"');
         swriteln('');
         fwriteln('`2Sandtiger takes a sip of the murky liquid.');
         IF (DRINK < 5) then drink := 0 else dec(drink,5);
         swriteln('');
         fwriteln('`2Hmmm... standard curses take a chunk off your defense.');
         drink := drinkcheck(drink,barcash);
         IF (drink = 250) then exit;
         IF (DRINK < 10) then drink := 0 else dec(drink,10);
         moreprompt;
         swriteln('');
         fwriteln('`2And mind fries are strength takers-away.');
         moreprompt;
         drink := drinkcheck(drink,barcash);
         IF (drink = 250) then exit;
         IF (DRINK < 15) then drink := 0 else dec(drink,15);
         swriteln('');
         fwriteln('`2But the dwarfing is both... but stronger than either one!');
         moreprompt;
         drink := drinkcheck(drink,barcash);
         IF (drink = 250) then exit;
         IF (DRINK < 25) then drink := 0 else dec(drink,25);
         swriteln('');
         fwriteln('`2The Abandonment?  Huh?');
         drink := drinkcheck(drink,barcash);
         IF (drink = 250) then exit;
         IF (DRINK < 35) then drink := 0 else dec(drink,35);
         swriteln('');
         fwriteln('`2Let me think about this....');
         moreprompt;
         drink := drinkcheck(drink,barcash);
         IF (drink = 250) then exit;
         IF (DRINK < 50) then drink := 0 else dec(drink,50);
         swriteln('');
         fwriteln('`2It just leaves you alone, I think... maybe another drink would help.');
         moreprompt;
         drink := drinkcheck(drink,barcash);
         IF (drink = 250) then exit;
         IF (DRINK < 76) then drink := 0 else dec(drink,76);
         swriteln('');
         fwriteln('`2Something about getting killed by higher levels...');
         moreprompt;
         goto baja;
      end;
      IF (POS('CHEAT',caps(tempstr)) > 0) or (POS('TRICK',caps(tempstr)) > 0) then begin
         swriteln('');
         fwriteln('`0"`2What?  Me Cheat?  I can''t even spell JENNIE right!`0"');
         swriteln('');
         goto baja;
      end;
      IF (POS('HIST',caps(tempstr)) > 0) or (POS('STOR',caps(tempstr)) > 0) then begin
        swriteln('');
        fwriteln('`2I like stories too.  But first, a drink!');
        moreprompt;
        drink := 0;
        drink := drinkcheck(drink,barcash);
        IF (drink = 250) then exit;
        sclrscr;
        fwriteln('`2I know lots of stories!');
        swriteln('');
        fwriteln('     `0(`5H`0)`2alder''s Story');
        fwriteln('     `0(`5T`0)`2he Barak Life');
        fwriteln('     `0(`5A`0)`2ragorn vs. Olodrin');
        fwriteln('     `0(`5C`0)`2hance''s Exile');
        swriteln('');
        fwrite('`2Pick a story, my child: ');
        sread_char(ch);
        CASE UPCASE(CH) of
           'H':begin
                 sclrscr;
                 fwriteln('`2   Halder was born in Devonshire.  His parents were both');
                 fwriteln('quite wealthy, and gave him everything he ever needed.');
                 fwriteln('However, this is not the way to raise a budding young');
                 fwriteln('warrior, and Halder was spoiled rotten.  He began to');
                 fwriteln('visit the nightclubs daily, not do his work, and got');
                 fwriteln('very lazy.');
                 swriteln('');
                 fwriteln('   Indeed, his parents got quite worried about him.  His');
                 fwriteln('younger sister, Yundra, wandered off one day into the woods');
                 fwriteln('-- near the dragon''s den.  Halder was sent off in search');
                 fwriteln('her, and when he returned, he said he had searched the cave');
                 fwriteln('and found nothing inside it.');
                 swriteln('');
                 fwriteln('   However, Halder was lying.  He had, in fact, gone back');
                 fwriteln('to the Fox''s Den bar immediately after setting off.  And');
                 fwriteln('thus caused the death of his poor sister.');
                 moreprompt;
                 swriteln('');
                 fwriteln('   Turgon found out about this incident, and became enraged');
                 fwriteln('that a warrior under his training had done such a thing.');
                 fwriteln('The first moment Turgon got, he found Halder, and backed');
                 fwriteln('him into a corner, a Death Sword at his neck.  As Turgon');
                 fwriteln('was to make the killing blow, Barak, then the level one');
                 fwriteln('master, came up to them.');
                 swriteln('');
                 fwriteln('   `0"`2Whatcha doin''?`0" `2he asked, innocently snapping');
                 fwriteln('the sassafras gum in his mouth.');
                 swriteln('');
                 fwriteln('   Turgon turned to him, and then back to Halder.');
                 swriteln('');
                 fwriteln('   `%"`2No,`%" `2he said, `%"`2I will not kill you.  Instead,');
                 fwriteln('you will be ranked underneath Barak, and must take orders');
                 fwriteln('from him.`%"');
                 swriteln('');
                 fwriteln('   `2And that is why Halder, the rich child, cannot kill or');
                 fwriteln('or hurt the gentle Barak.');
                 moreprompt;
              end;
           'T':begin
                 sclrscr;
                 fwriteln('   `2My child, you seem interested in Barak.  Well, everyone');
                 fwriteln('is, but we really know little about him.  Perhaps some of the');
                 fwriteln('sages in another town might know.  But no one really knows');
                 fwriteln('where he comes from.  And we''re not quite sure if he does,');
                 fwriteln('either.');
                 moreprompt;
              end;
           'A':begin
                 sclrscr;
                 fwriteln('   `0It all really started on a warm summer day.  But it''s');
                 fwriteln('been very cold ever since.');
                 swriteln('');
                 fwriteln('   `2It was the big day at school.  Aragorn''s girlfriend,');
                 fwriteln('Tybet, had taken up with Olodrin.  And Aragorn had challenged');
                 fwriteln('the thief to a fight.  It was time.');
                 swriteln('');
                 fwriteln('   Aragorn circled ''round his opponent as Olodrin followed');
                 fwriteln('with his eyes.  The first punch was thrown, and Aragorn''s');
                 fwriteln('fist met Olodrin''s forehead.  Olodrin tried to throw a');
                 fwriteln('haymaker, but was stopped in mid-stride by Aragorn, who');
                 fwriteln('kicked him in the stomach.  With an "OOF!", Olodrin stumbled');
                 fwriteln('backward.  Aragorn followed with a swift kick to the head');
                 fwriteln('and Olodrin crumpled to the ground.  Aragorn knelt down next');
                 fwriteln('to him, and slowly withdrew his dagger, a present of his');
                 fwriteln('father''s.');
                 swriteln('');
                 fwriteln('   But before Aragorn could slice, a great THUD! was heard.');
                 fwriteln('A scream in unison, `@THE DRAGON`0!!!`2 was next.  Aragorn');
                 fwriteln('started heading in the direction of the crowd, but Olodrin');
                 fwriteln('was oblivious.  Tybet tripped and fell on her way down the');
                 fwriteln('hill to outrun the Dragon.`0"');
                 moreprompt;
                 swriteln('');
                 fwriteln('   Aragorn saw her crumpled body, and ran back to go get her,');
                 fwriteln('but as he reached her body, the Dragon was upon them.  ');
                 moreprompt;
                 swriteln('');
                 fwriteln('   Suddenly, the oddest sound came from the Dragon''s fire-');
                 fwriteln('breathing mouth.  A...  cry of pain?  It did an about-face,');
                 fwriteln('and tore back towards its cave, blood dripping from its tail.');
                 swriteln('');
                 fwriteln('   Olodrin slumped back onto the grass.  The dagger that was');
                 fwriteln('meant to end his life had saved the life of his would-be');
                 fwriteln('murderer.  ');
                 swriteln('');
                 fwriteln('   `0"`2Damn, that thing can sure run with half its tail');
                 fwriteln('draggin'' on the ground behind it.`0" `2he said weakly.');
                 swriteln('');
                 fwriteln('   `2Aragorn just sat down next to him, and held out his hand.');
                 fwriteln('Olodrin placed his in Aragorn''s.');
                 moreprompt;
                 swriteln('');
                 swriteln('');
                 fwriteln('   `0Now, of course, they''re both grown up, but they''re as');
                 fwriteln('close as that, still.  Oh, and Tybet?  She''s married to Prince');
                 fwriteln('Caspian now.  But that''s another story.');
                 moreprompt;
              end;
           'C':begin
                 sclrscr;
                 fwriteln('   `2Chance.  Now there''s a fine man.  And an even finer');
                 fwriteln('daughter, if I do say so myself.  But his story is sad, it');
                 fwriteln('makes one wonder how he can stay so happy.');
                 swriteln('');
                 fwriteln('   It dates back to the time of Replogle, the former leader');
                 fwriteln('-- or rather, level 12 leader -- of the realm.  Before he');
                 fwriteln('got eaten by the Dragon, that is.');
                 swriteln('');
                 fwriteln('   You see, Replogle had two sons, Jeffrey and Chance.  Both');
                 fwriteln('studied to be warriors.  But Jeffrey, oh, Jeffrey was a ladies''');
                 fwriteln('man, and he loved the women.  He also began a small gambling');
                 fwriteln('group in his father''s temple every Sunday.  And when Replogle');
                 fwriteln('heard of this, he kicked his son out of the house.  And his son');
                 fwriteln('ended up on the Innkeeper''s door.');
                 moreprompt;
                 swriteln('');
                 fwriteln('   Chance, being the good son, forgot about his scandalous brother,');
                 fwriteln('and worked his way to being an excellent fighter, and reached level');
                 fwriteln('nine in no time at all.');
                 swriteln('');
                 fwriteln('   Meanwhile, Jeffrey worked for the Innkeeper, and decided that what');
                 fwriteln('needed to be added to the Inn was a bar.  And since his father, the');
                 fwriteln('most honorable warrior in all the land, did not come to the Inn, he');
                 fwriteln('felt he would be safe running it.  And the bar flourished.  The');
                 fwriteln('Innkeeper earned more money than he would ever need, and in this');
                 fwriteln('manner, he helped his son, a young man called Turgon, through');
                 fwriteln('warrior training.  Now Turgon was the best fighter the realm');
                 fwriteln('had ever seen, better than Replogle.  And Replogle knew he had to');
                 fwriteln('prove his worth -- by going after the dragon.');
                 swriteln('');
                 fwriteln('   And he did... and so he perished.');
                 moreprompt;
                 swriteln('');
                 fwriteln('   Now Turgon owed a lot to Jeffrey, now called The Bartender, for');
                 fwriteln('helping him become the youngest level 12 warrior ever, and the');
                 fwriteln('youngest master ever.  So he granted Jeffrey one wish.  And Jeffrey,');
                 fwriteln('who''s hate for his brother was ever so strong, ordered Chance banned');
                 fwriteln('from the realm.');
                 swriteln('');
                 fwriteln('   Chance, with no other choice, packed up for the forest.  And');
                 fwriteln('even though he lived on berries and twigs for 3 years, he eventually');
                 fwriteln('came upon a wide clearing -- invisible from all angles, but something');
                 fwriteln('a horse might find quite easily.  And he began building, with whole');
                 fwriteln('trees, and using sap for cement.  But it has worked, and even though');
                 fwriteln('he cannot offer the same delicacies as Jeffrey''s place, Chance has');
                 fwriteln('a nice bar.... and a nice daughter!');
                 moreprompt;
              end;
           end;
           goto baja;




    end;


      IF (POS('EXI',caps(tempstr)) > 0) or (POS('BY',caps(tempstr)) > 0) or (POS('QUIT',caps(tempstr)) > 0)
      or (POS('L8R',caps(tempstr)) > 0) or (POS('CYA',caps(tempstr)) > 0) or
      (POS('SEEYA',caps(tempstr)) > 0) then begin
        exit;
      end;
      swriteln('');
      fwriteln('`2Sandtiger looks confused.');
    until (tempstr = 'EATME');
end;




procedure installnet;
 var data:text;
     t:array[1..30] of string;
     r,s,e:byte;
     tempstr,tempst,temps : string;
  begin
    r := 0;
    s := 0;
    assign(data,'sandbar.cfg');
    reset(data);
    readln(data,path);
    readln(data,nc);readln(data,hp);readln(data,sm);readln(data,ff);readln(data,uf);readln(data,gp);
    readln(data,df);readln(data,st);readln(data,ch);readln(data,fv);readln(data,ge);readln(data,ex);
    readln(data,ex);readln(data,sc);readln(data,cc);readln(data,hb);readln(data,sk);readln(data,fa);
    readln(data,ho);readln(data,di);readln(data,sysopsname);readln(data,reg);
    close(data);
    IF NOT FILEEXISTS(path+'3rdparty.dat') then begin
      writeln('Path NOT VERIFIED!');
      readkey;
      exit;
    end;
    assign(data,path+'3rdparty.dat');
    reset(data);
    repeat
      inc(s);
      readln(data,t[s]);
      IF (POS('SANDBAR',t[s]) > 0) and not (t[s][1] = ';') then begin
        clrscr;
        writeln('You''ve already installed Sandtiger''s Bar!');
        readkey;
        close(data);
        exit;
      end;
      IF NOT (t[s][1] = ';') then inc(r);
    until eof(data);
    close(data);
    IF R > 16 then begin
      clrscr;
      writeln('You currently have too many Lord Utils installed!');
      writeln;
      writeln('Please remove one (from the 3RDPARTY.DAT file in the LORD directory).');
      readkey;
      exit;
    end;
    assign(data,path+'3rdparty.dat');
    tempstr := '';
    tempst := paramstr(0);
{    IF (POS('sandbar ',paramstr(0)) > 0) then for r := 1 to pos('SANDBAR CONFIG',paramstr(0))-2
       do tempstr := tempstr + tempst;}
    IF (POS('SANDBAR.EXE',tempst) > 0) then for r := 1 to pos('SANDBAR.EXE',tempst)-2
       do tempstr := tempstr + tempst[r];
    rewrite(data);
    writeln(data,tempstr+'\'+'SANDBAR.EXE '+tempstr+' /n* *');
    writeln(data,'`0Sandtiger''s `2Bar`0!');
    for r := 1 to s do writeln(data,t[r]);
    close(data);
   { assign(data,'sbar.cfg');
    rewrite(data);
    writeln(data,'RBBS');
    writeln(data,tempstr+'\');
    writeln(data,'Sandtiger''s Bar');
    writeln(data,sysopsname);
    writeln(data,0);
    close(data);}
{    assign(data,'dorinfo1.def');
    rewrite(data);
    writeln(data,'Sandtiger''s Bar');
    writeln(data,'Some');
    writeln(data,'Caller');
    writeln(data,'COM0');
    writeln(data,'0 BAUD,N,8,1');
    writeln(data,'0');
    writeln(data,'DALTON');
    writeln(data,'');
    writeln(data,'Arden, NC');
    writeln(data,'1');
    writeln(data,'150');
    writeln(data,'61');
    writeln(data,'0');
    close(data);}
    writeln;
    writeln('`0Installed!');
    write('`2<`0MORE`2>');
    readkey;
  end;


function dispctype(l:shortint):string;
  begin
    IF (l = 1) then dispctype := 'Ace of Clubs'
    else dispctype := 'A'+chr(5);
  end;


function chkme(s:namestring):boolean;
  var errcode,tyl:integer;
  begin

    WHILE (POS('L',s) > 0) do
      S[pos('L',s)] := '1';
    IF (pos('1',s) = 0) and (pos('2',s) = 0) and (pos('3',s) = 0)
        and (pos('4',s) = 0) and (pos('5',s) = 0) and (pos('6',s) = 0)
         and (pos('7',s) = 0) and (pos('8',s) = 0) and (pos('9',s) = 0)
          and (pos('0',s) = 0) then begin
            chkme := false;
            exit;
          end;
    WHILE (POS('*',s) > 0) do
      S[pos('*',s)] := '1';
    WHILE (POS('-',s) > 0) do
      S[pos('-',s)] := '1';
    WHILE (POS('+',s) > 0) do
      S[pos('+',s)] := '1';
    WHILE (POS('/',s) > 0) do
      S[pos('/',s)] := '1';
    val(s,tyl,errcode);
    IF not (errcode = 0) then chkme := false else chkme := true;
  end;

procedure swrite(s:string);
 label DEVIL;
 var f,g,h: string;
     done:boolean;
     q:byte;
  begin
    done := false;
    IF NOT POS('`',s) > 0 then begin
      write(s);
      exit;
    end;
   repeat
    IF s[pos('`',s)+1] IN ['0','1','2','3','4','5','6','7','8','9','!','@','#','$','%'] then begin
       g := '';
       for q := 1 to POS('`',s)-1 do g := g + s[q];
       write(g);
       CASE s[POS('`',s)+1] of
       '1':textcolor(1);
       '2':textcolor(2);
       '3':textcolor(3);
       '4':textcolor(4);
       '5':textcolor(5);
       '6':textcolor(6);
       '7':textcolor(7);
       '8':textcolor(8);
       '9':textcolor(9);
       '0':textcolor(10);
       '!':textcolor(11);
       '@':textcolor(12);
       '#':textcolor(13);
       '$':textcolor(14);
       '%':textcolor(15);
       end;
       f := '';
       for q := (POS('`',s)+2) to length(s) do f := f + s[q];
       s := f;
       end;
   until POS('`',s) = 0;
   write(s);
  end;


procedure swriteln(s:string);
 label DEVIL;
 var f,g,h: string;
     done:boolean;
     q:byte;
  begin
    done := false;
    IF NOT POS('`',s) > 0 then begin
      writeln(s);
      exit;
    end;
   repeat
    IF s[pos('`',s)+1] IN ['0','1','2','3','4','5','6','7','8','9','!','@','#','$','%'] then begin
       g := '';
       for q := 1 to POS('`',s)-1 do g := g + s[q];
       write(g);
       CASE s[POS('`',s)+1] of
       '1':textcolor(1);
       '2':textcolor(2);
       '3':textcolor(3);
       '4':textcolor(4);
       '5':textcolor(5);
       '6':textcolor(6);
       '7':textcolor(7);
       '8':textcolor(8);
       '9':textcolor(9);
       '0':textcolor(10);
       '!':textcolor(11);
       '@':textcolor(12);
       '#':textcolor(13);
       '$':textcolor(14);
       '%':textcolor(15);
       end;
       f := '';
       for q := (POS('`',s)+2) to length(s) do f := f + s[q];
       s := f;
       end;
   until POS('`',s) = 0;
   writeln(s);
  end;

procedure extraconfig;
var data:text;
tempstr:string;
hymn:string;
r:longint;
errcode:integer;
ch2:char;
gamb,witc,epd,curse,mindfry,dwarf,aband,maxbet:namestring;
ctype:array[1..3] of shortint;
elim:array[1..3] of integer;
  begin
    IF NOT FILEEXISTS('sandbar2.cfg') then begin
      assign(data,'sandbar2.cfg');
      rewrite(data);
      writeln(data,'1000000');
      writeln(data,'5');
      writeln(data,'1');writeln(data,'1');writeln(data,'2');
      writeln(data,'2');
      writeln(data,'L*L*L*L*100');
      writeln(data,'L*L*L*L*500');
      writeln(data,'L*L*L*L*1000');
      writeln(data,'L*L*L*L*10000');
      writeln(data,'200');
      writeln(data,'150');
      writeln(data,'100');
      writeln(data,'3');
      close(data);
    end;
    assign(data,'sandbar2.cfg');
    reset(data);
    readln(data,maxbet);readln(data,gamb);readln(data,ctype[1]);
    readln(data,ctype[2]);readln(data,ctype[3]);readln(data,witc);
    readln(data,curse);readln(data,mindfry);readln(data,dwarf);
    readln(data,aband);
    for r := 1 to 3 do readln(data,elim[r]);
    readln(data,epd);
    close(data);
    repeat
      clrscr;
      swriteln('`91] `%Maximum Bet in Any Game`!    : `%'+maxbet);
      swriteln('`92] `%Max Times to Gamble/Visit  `!: `0'+gamb);
      swriteln('`93] `%Card Display Type for Elim.`!: `0'+dispctype(ctype[1]));
      swriteln('`94] `%Card Display Type for BJ   `!: `0'+dispctype(ctype[2]));
      swriteln('`95] `%Card Display Type for Poker`!: `0'+dispctype(ctype[3]));
      swriteln('`96] `%Max Times to Witch/Visit   `!: `0'+witc);
      swriteln('`97] `%BarCoin Cost / Curse       `!: `0'+curse);
      swriteln('`98] `%BarCoin Cost / Mind Fry    `!: `0'+mindfry);
      swriteln('`99] `%BarCoin Cost / Dwarf       `!: `0'+dwarf);
      swriteln('`90] `%BarCoin Cost / Abandonment `!: `0'+aband);
      str(elim[1],tempstr);
      swriteln('`9A] `%Elim. Winnings for 1st (%) `!: `0'+tempstr);
      str(elim[2],tempstr);
      swriteln('`9B] `%Elim. Winnings for 2nd (%) `!: `0'+tempstr);
      str(elim[3],tempstr);
      swriteln('`9C] `%Elim. Winnings for 3rd (%) `!: `0'+tempstr);
      swriteln('`9D] `%Entrances per Day!         `!: `0'+epd);
      writeln;
      swriteln('`!Pick Your Poison, or Q to Quit > ');
      ch2 := readkey;
      writeln;
      CASE UPCASE(ch2) of
      'Q':begin
            assign(data,'sandbar2.cfg');
            rewrite(data);
            writeln(data,maxbet);writeln(data,gamb);writeln(data,ctype[1]);
            writeln(data,ctype[2]);writeln(data,ctype[3]);writeln(data,witc);
            writeln(data,curse);writeln(data,mindfry);writeln(data,dwarf);
            writeln(data,aband);
            for r := 1 to 3 do writeln(data,elim[r]);
            writeln(data,epd);
            close(data);
            exit;
          end;
      '1':begin
              swriteln('`0This is the Maximum Bet in any game!');
              swriteln('`!Use `@L `!(capital) for the player''s level');
              swriteln('`2Use `@* `2for multiplication, `@/ `2for division, `@+ `!and `@- `!for add and sub!');
              swrite('`9] ');
              readln(hymn);
              IF chkme(hymn) and NOT (hymn = '') then maxbet := hymn;
            end;
      '2':begin
              swriteln('`0This is the Maximum Times anyone can gamble per visit!');
              swriteln('`00 will disable gambling.');
              swriteln('`!Use `@L `!(capital) for the player''s level');
              swriteln('`2Use `@* `2for multiplication, `@/ `2for division, `@+ `!and `@- `!for add and sub!');
              swrite('`9] ');
              readln(hymn);
              IF chkme(hymn) and NOT (hymn = '') then gamb := hymn;
            end;
      '3':IF CTYPE[1] = 1 then ctype[1] := 2 else ctype[1] := 1;
      '4':IF CTYPE[2] = 1 then ctype[2] := 2 else ctype[2] := 1;
      '5':IF ctype[3] = 1 then ctype[3] := 2 else ctype[3] := 1;
      '6':begin
              swriteln('`0This is the Maximum Times anyone can visit the old witch per visit!');
              swriteln('`0 will disable this option.');
              swriteln('`!Use `@L `!(capital) for the player''s level');
              swriteln('`2Use `@* `2for multiplication, `@/ `2for division, `@+ `!and `@- `!for add and sub!');
              swrite('`9] ');
              readln(hymn);
              IF chkme(hymn) and NOT (hymn = '') then witc := hymn;
            end;
      '7':begin
              swriteln('`0This is the cost (in BarCoins) to Curse someone.');
              swriteln('`!Use `@L `!(capital) for the player''s level');
              swriteln('`2Use `@* `2for multiplication, `@/ `2for division, `@+ `!and `@- `!for add and sub!');
              swrite('`9] ');
              readln(hymn);
              IF chkme(hymn) and NOT (hymn = '') then curse := hymn;
            end;
      '8':begin
              swriteln('`0This is the cost (in BarCoins) to Mind Fry someone.');
              swriteln('`!Use `@L `!(capital) for the player''s level');
              swriteln('`2Use `@* `2for multiplication, `@/ `2for division, `@+ `!and `@- `!for add and sub!');
              swrite('`9] ');
              readln(hymn);
              IF chkme(hymn) and NOT (hymn = '') then mindfry := hymn;
            end;
      '9':begin
              swriteln('`0This is the cost (in BarCoins) to Dwarf someone.');
              swriteln('`!Use `@L `!(capital) for the player''s level');
              swriteln('`2Use `@* `2for multiplication, `@/ `2for division, `@+ `!and `@- `!for add and sub!');
              swrite('`9] ');
              readln(hymn);
              IF chkme(hymn) and NOT (hymn = '') then dwarf := hymn;
            end;
      '0':begin
              swriteln('`0This is the cost (in BarCoins) to Abandon someone.');
              swriteln('`!Use `@L `!(capital) for the player''s level');
              swriteln('`2Use `@* `2for multiplication, `@/ `2for division, `@+ `!and `@- `!for add and sub!');
              swrite('`9] ');
              readln(hymn);
              IF chkme(hymn) and NOT (hymn = '') then aband := hymn;
            end;
      'A':begin
              swriteln('`0This is the percent of the original bet Elimination players will receive');
              swriteln('`0if they get first place.');
              swrite('`9] ');
              readln(hymn);
              val(hymn,r,errcode);
              IF (errcode = 0) and NOT (hymn = '') then elim[1] := r;
            end;
      'B':begin
              swriteln('`0This is the percent of the original bet Elimination players will receive');
              swriteln('`0if they get second place.');
              swrite('`9] ');
              readln(hymn);
              val(hymn,r,errcode);
              IF (errcode = 0) and NOT (hymn = '') then elim[2] := r;
            end;
      'C':begin
              swriteln('`0This is the percent of the original bet Elimination players will receive');
              swriteln('`0if they get third place.');
              swrite('`9] ');
              readln(hymn);
              val(hymn,r,errcode);
              IF (errcode = 0) and NOT (hymn = '') then elim[3] := r;
            end;
      'D':begin
              swriteln('`0This is the number of times a player may enter Sandtiger''s Bar per day,');
              swriteln('`0if he has not used up all his forest fights.');
              swriteln('`!Use `@L `!(capital) for the player''s level');
              swriteln('`2Use `@* `2for multiplication, `@/ `2for division, `@+ `!and `@- `!for add and sub!');
              swrite('`9] ');
              readln(hymn);
              IF chkme(hymn) and NOT (hymn = '') then epd := hymn;
          end;
          end;
   until (ch = '');
  end;






procedure config;
var data:text;
tempstr:string;
hymn:string;
ch2:char;
  begin
    IF NOT FILEEXISTS('sandbar.cfg') then begin
      assign(data,'sandbar.cfg');
      rewrite(data);
      writeln(data,'c:\lord\');
      writeln(data,'L*L*300');writeln(data,'L*L*L*L*300');writeln(data,'L*L*300');writeln(data,'L*L*L*L*500');
      writeln(data,'L*L*L*L*1000');writeln(data,'10');writeln(data,'L*L*L*L*300');writeln(data,'L*L*L*L*300');
      writeln(data,'L*L*300');writeln(data,'L*L*L*L*100');writeln(data,'L*L*300');writeln(data,'L*L*L*L*10');
      writeln(data,'L*L*L*L*3000');writeln(data,'L*L*L*L*700');writeln(data,'L*L*L*L*L*1000');
      writeln(data,'L*L*L*L*900');writeln(data,'L*L*L*L*1000');writeln(data,'L*L*L*L*L*10000');
      writeln(data,'L*L*L*L*10000');writeln(data,'L*L*L*L*10000');writeln(data,'Joseph Masters');writeln(data,'0');
      close(data);
    end;
    assign(data,'sandbar.cfg');
    reset(data);
    readln(data,path);
    readln(data,nc);readln(data,hp);readln(data,sm);readln(data,ff);readln(data,uf);readln(data,gp);
    readln(data,df);readln(data,st);readln(data,ch);readln(data,fv);readln(data,ge);readln(data,ex);
    readln(data,ex);readln(data,sc);readln(data,cc);readln(data,hb);readln(data,sk);readln(data,fa);
    readln(data,ho);readln(data,di);readln(data,sysopsname);readln(data,reg);
    close(data);
    repeat
      clrscr;
      swriteln('`91] `$Path to LORD files`!         : `%'+path);
      swriteln('`9!] `#Your Name                  `!: `%'+sysopsname);
      swriteln('`9@] `#Registration Number        `!: `%'+reg);
      swriteln('`92] `%BarCoin Cost of Name Change`!: `0'+nc);
      swriteln('`93] `%BarCoin Cost per Hit Point `!: `0'+hp);
      swriteln('`94] `%BarCoin Cost to See Master `!: `0'+sm);
      swriteln('`95] `%BarCoin Cost / Forest Fight`!: `0'+ff);
      swriteln('`96] `%BarCoin Cost / User Fight  `!: `0'+uf);
      swriteln('`97] `%BarCoins per Gold Piece    `!: `0'+gp);
      swriteln('`98] `%BarCoin Cost / Defense     `!: `0'+df);
      swriteln('`99] `%BarCoin Cost / Strength    `!: `0'+st);
      swriteln('`90] `%BarCoin Cost / Charm       `!: `0'+ch);
      swriteln('`9A] `%BarCoin Cost to Flirt Again`!: `0'+fv);
      swriteln('`9B] `%BarCoins to Die            `!: `0'+di);
      swriteln('`9C] `%BarCoin Cost / Gem         `!: `0'+ge);
      swriteln('`9D] `%BarCoin Cost / Exp Point   `!: `0'+ex);
      swriteln('`9E] `%BarCoin Cost For Sex Change`!: `0'+sc);
      swriteln('`9F] `%BarCoin Cost / Hear Bard   `!: `0'+hb);
      swriteln('`9G] `%BarCoin Cost / Class Change`!: `0'+cc);
      swriteln('`9H] `%BarCoin Cost / Skill Point `!: `0'+sk);
      swriteln('`9I] `%BarCoin Cost / Fairy       `!: `0'+fa);
      swriteln('`9J] `%BarCoin Cost / Horse       `!: `0'+ho);
      writeln;
      swriteln('`!Pick Your Poison, or Q to Quit > ');
      ch2 := readkey;
      writeln;
      CASE UPCASE(ch2) of
      '!':begin
            swriteln('`0This is the name that Sandtiger''s Bar is Registered To.');
              swrite('`9] ');
              readln(hymn);
              IF not (hymn = '') then sysopsname := hymn;
          end;
      '@':begin
            swriteln('`0This is your Registration Code!');
              swrite('`9] ');
              readln(hymn);
              IF not (hymn = '') then reg := hymn;
          end;
      'Q':begin
            assign(data,'sandbar.cfg');
            rewrite(data);
            writeln(data,path);
            writeln(data,nc);writeln(data,hp);writeln(data,sm);writeln(data,ff);writeln(data,uf);writeln(data,gp);
            writeln(data,df);writeln(data,st);writeln(data,ch);writeln(data,fv);writeln(data,ge);writeln(data,ex);
            writeln(data,ex);writeln(data,sc);writeln(data,cc);writeln(data,hb);writeln(data,sk);writeln(data,fa);
            writeln(data,ho);writeln(data,di);writeln(data,sysopsname);writeln(data,reg);
            close(data);
            exit;
          end;
      '1':begin
              swriteln('`0This is the path to your LORD directory!');
              swrite('`9] ');
              readln(hymn);
              IF not (hymn[length(hymn)] = '\') then hymn := hymn + '\';
              IF not (hymn = '\') then path := hymn;
            end;
      '2':begin
              swriteln('`2This is the cost of changing your name in LORD in BarCoins!');
              swriteln('`!Use `@L `!(capital) for the player''s level');
              swriteln('`2Use `@* `2for multiplication, `@/ `2for division, `@+ `!and `@- `!for add and sub!');
              swrite('`9] ');
              readln(hymn);
              IF NOT (hymn = '') then nc := hymn;
          end;
      '3':begin
              swriteln('`2This is the cost of one hit point in BarCoins!');
              swriteln('`!Use `@L `!(capital) for the player''s level');
              swriteln('`2Use `@* `2for multiplication, `@/ `2for division, `@+ `!and `@- `!for add and sub!');
              swrite('`9] ');
              readln(hymn);
              IF NOT (hymn = '') then hp := hymn;
          end;
      '4':begin
              swriteln('`2This is the cost to see the master again in BarCoins!');
              swriteln('`!Use `@L `!(capital) for the player''s level');
              swriteln('`2Use `@* `2for multiplication, `@/ `2for division, `@+ `!and `@- `!for add and sub!');
              swrite('`9] ');
              readln(hymn);
              IF NOT (hymn = '') then sm := hymn;
          end;
      '5':begin
              swriteln('`2This is the cost of one forest fight in BarCoins!');
              swriteln('`!Use `@L `!(capital) for the player''s level');
              swriteln('`2Use `@* `2for multiplication, `@/ `2for division, `@+ `!and `@- `!for add and sub!');
              swrite('`9] ');
              readln(hymn);
              IF NOT (hymn = '') then ff := hymn;
          end;
      '6':begin
              swriteln('`2This is the cost of one user fight in BarCoins!');
              swriteln('`!Use `@L `!(capital) for the player''s level');
              swriteln('`2Use `@* `2for multiplication, `@/ `2for division, `@+ `!and `@- `!for add and sub!');
              swrite('`9] ');
              readln(hymn);
              IF NOT (hymn = '') then uf := hymn;
          end;
      '7':begin
              swriteln('`2This is the Exchange Rate - How Many Gold Pieces to a BarCoin?');
              swriteln('`!Use `@L `!(capital) for the player''s level');
              swriteln('`2Use `@* `2for multiplication, `@/ `2for division, `@+ `!and `@- `!for add and sub!');
              swrite('`9] ');
              readln(hymn);
              IF NOT (hymn = '') then gp := hymn;
          end;
      '8':begin
              swriteln('`2This is the cost of one Defense Point in BarCoins');
              swriteln('`!Use `@L `!(capital) for the player''s level');
              swriteln('`2Use `@* `2for multiplication, `@/ `2for division, `@+ `!and `@- `!for add and sub!');
              swrite('`9] ');
              readln(hymn);
              IF NOT (hymn = '') then df := hymn;
          end;
      '9':begin
              swriteln('`2This is the cost of one Strength Point in BarCoins!');
              swriteln('`!Use `@L `!(capital) for the player''s level');
              swriteln('`2Use `@* `2for multiplication, `@/ `2for division, `@+ `!and `@- `!for add and sub!');
              swrite('`9] ');
              readln(hymn);
              IF NOT (hymn = '') then st := hymn;
          end;
      '0':begin
              swriteln('`2This is the cost of one Charm Point in BarCoins!');
              swriteln('`!Use `@L `!(capital) for the player''s level');
              swriteln('`2Use `@* `2for multiplication, `@/ `2for division, `@+ `!and `@- `!for add and sub!');
              swrite('`9] ');
              readln(hymn);
              IF NOT (hymn = '') then ch := hymn;
          end;
      'A':begin
              swriteln('`2This is the cost to flirt with Violet again in BarCoins!');
              swriteln('`!Use `@L `!(capital) for the player''s level');
              swriteln('`2Use `@* `2for multiplication, `@/ `2for division, `@+ `!and `@- `!for add and sub!');
              swrite('`9] ');
              readln(hymn);
              IF NOT (hymn = '') then fv := hymn;
          end;
      'B':begin
              swriteln('`2This is the cost to Die without penalty in BarCoins!');
              swriteln('`!Use `@L `!(capital) for the player''s level');
              swriteln('`2Use `@* `2for multiplication, `@/ `2for division, `@+ `!and `@- `!for add and sub!');
              swrite('`9] ');
              readln(hymn);
              IF NOT (hymn = '') then di := hymn;
          end;
      'C':begin
              swriteln('`2This is the cost of one Gem in BarCoins!');
              swriteln('`!Use `@L `!(capital) for the player''s level');
              swriteln('`2Use `@* `2for multiplication, `@/ `2for division, `@+ `!and `@- `!for add and sub!');
              swrite('`9] ');
              readln(hymn);
              IF NOT (hymn = '') then ge := hymn;
          end;
      'D':begin
              swriteln('`2This is the cost of one Experience Point in BarCoins!');
              swriteln('`!Use `@L `!(capital) for the player''s level');
              swriteln('`2Use `@* `2for multiplication, `@/ `2for division, `@+ `!and `@- `!for add and sub!');
              swrite('`9] ');
              readln(hymn);
              IF NOT (hymn = '') then ex := hymn;
          end;
      'E':begin
              swriteln('`2This is the cost to change your sex in BarCoins!');
              swriteln('`!Use `@L `!(capital) for the player''s level');
              swriteln('`2Use `@* `2for multiplication, `@/ `2for division, `@+ `!and `@- `!for add and sub!');
              swrite('`9] ');
              readln(hymn);
              IF NOT (hymn = '') then sc := hymn;
          end;
      'F':begin
              swriteln('`2This is the cost to hear the Bard Again in BarCoins!');
              swriteln('`!Use `@L `!(capital) for the player''s level');
              swriteln('`2Use `@* `2for multiplication, `@/ `2for division, `@+ `!and `@- `!for add and sub!');
              swrite('`9] ');
              readln(hymn);
              IF NOT (hymn = '') then hb := hymn;
          end;
      'G':begin
              swriteln('`2This is the cost to change your class in BarCoins!');
              swriteln('`!Use `@L `!(capital) for the player''s level');
              swriteln('`2Use `@* `2for multiplication, `@/ `2for division, `@+ `!and `@- `!for add and sub!');
              swrite('`9] ');
              readln(hymn);
              IF NOT (hymn = '') then cc := hymn;
          end;
      'H':begin
              swriteln('`2This is the cost of a Skill Point!');
              swriteln('`!Use `@L `!(capital) for the player''s level');
              swriteln('`2Use `@* `2for multiplication, `@/ `2for division, `@+ `!and `@- `!for add and sub!');
              swrite('`9] ');
              readln(hymn);
              IF NOT (hymn = '') then sk := hymn;
          end;
      'I':begin
              swriteln('`2This is the cost of a fairy in BarCoins!');
              swriteln('`!Use `@L `!(capital) for the player''s level');
              swriteln('`2Use `@* `2for multiplication, `@/ `2for division, `@+ `!and `@- `!for add and sub!');
              swrite('`9] ');
              readln(hymn);
              IF NOT (hymn = '') then fa := hymn;
          end;
      'J':begin
              swriteln('`2This is the cost of a horse in BarCoins!');
              swriteln('`!Use `@L `!(capital) for the player''s level');
              swriteln('`2Use `@* `2for multiplication, `@/ `2for division, `@+ `!and `@- `!for add and sub!');
              swrite('`9] ');
              readln(hymn);
              IF NOT (hymn = '') then ho := hymn;
          end;
      end;
   until (ch = '');
  end;





    function convert(anguish:string;level:byte):longint;
label a1,a2,a3;
var v,m:byte;
   tempstr,f,g,h:string;
   errcode:integer;
   valled:longint;
   realtemp: array[1..20] of char;
   realnum: array[1..20] of longint;
   times,divs,adds,subs:byte;
   yelp:boolean;
begin
    yelp := false;
    times := 0;
    divs := 0;
    adds := 0;
    subs := 0;
    a1:
           IF POS('L',anguish) > 0 then begin
               f := '';
               g := '';
               h := '';
               for v := 1 to (POS('L',anguish)-1) do f := f + anguish[v];
               for v := (POS('L',anguish)+1) to length(anguish) do h := h + anguish[v];
               str(level,tempstr);
               g := tempstr;
               anguish := f+g+h;
               goto a1;
           end;
    val(anguish,valled,errcode);
    m := 0;
    a2:
    inc(m);
         IF (POS('*',anguish) > 0) or (POS('+',anguish) > 0) or (POS('-',anguish) > 0) or (POS('/',anguish) > 0)then begin
               yelp := true;
               f := '';
               g := '';
               h := '';
               times := 0;
               divs := 0;
               adds := 0;
               subs := 0;
               IF (POS('*',anguish) > 0) then times := (POS('*',anguish));
               IF (POS('-',anguish) > 0) then subs := (POS('-',anguish));
               IF (POS('+',anguish) > 0) then adds := (POS('+',anguish));
               IF (POS('/',anguish) > 0) then divs := (POS('/',anguish));
               IF NOT (TIMES = 0) then begin
                  IF ((TIMES > subs) or (times = 0)) and ((TIMES > ADDS) or (adds = 0)) and ((TIMES > DIVS) or (DIVS > 0))
                  then begin
                      for v := 1 to (POS('*',anguish)-1) do f := f + anguish[v];
                      for v := (POS('*',anguish)+1) to length(anguish) do h := h + anguish[v];
                      val(f,realnum[m],errcode);
                      realtemp[m] := '*';
                      anguish := h;
                      goto a2;
                  end;
               end;
               IF (SUBS > 0) then begin
                  IF ((SUBS > times) or (timeS = 0)) and ((SUBS > ADDS) or (adds = 0)) and ((SUBS > DIVS) or (DIVS > 0))
                  then begin
                      for v := 1 to (POS('-',anguish)-1) do f := f + anguish[v];
                      for v := (POS('-',anguish)+1) to length(anguish) do h := h + anguish[v];
                      val(f,realnum[m],errcode);
                      realtemp[m] := '-';
                      anguish := h;
                      goto a2;
                  end;
               end;
               IF NOT (ADDS = 0) then begin
                  IF ((ADDS > timeS) or (timeS = 0)) and ((ADDS > subS) or (subs = 0)) and ((ADDS > DIVS) or (DIVS > 0))
                  then begin
                      for v := 1 to (POS('+',anguish)-1) do f := f + anguish[v];
                      for v := (POS('+',anguish)+1) to length(anguish) do h := h + anguish[v];
                      val(f,realnum[m],errcode);
                      realtemp[m] := '+';
                      anguish := h;
                      goto a2;
                  end;
               end;
               IF NOT (DIVS = 0) then begin
                  IF ((DIVS > subs) or (DIVS = 0)) and ((DIVS > ADDS) or (adds = 0)) and ((DIVS > times) or (times > 0))
                  then begin
                      for v := 1 to (POS('/',anguish)-1) do f := f + anguish[v];
                      for v := (POS('/',anguish)+1) to length(anguish) do h := h + anguish[v];
                      val(f,realnum[m],errcode);
                      realtemp[m] := '/';
                      anguish := h;
                      goto a2;
                  end;
               end;
         end;
               IF NOT YELP THEN GOTO A3;
               val(anguish,realnum[m],errcode);
               valled := realnum[1];
               for v := 2 to m do begin
                  IF realtemp[v-1] = '*' then valled := valled*realnum[v]
                  else IF realtemp[v-1] = '-' then valled := valled-realnum[v]
                  else IF realtemp[v-1] = '+' then valled := valled+realnum[v]
                  else IF realtemp[v-1] = '/' then valled := valled DIV realnum[v]
                  else valled := valled;
               end;

a3:
{writeln('V2: ',valled);
if negative then valled := valled-(valled+valled);}
IF VALLED < 0 then valled := -1*valled;
convert := valled;
end;











function fileexists(FNAME:string):boolean;
  var tfile:text;
      s: string;
  begin
    s := FSEARCH(FNAME,'');
    fileexists := s <> '';
  end;





procedure cfgin2;
  var data2,data:text;
      tempstr:string;
      y:byte;
  begin
    assign(data,'sandbar.cfg');
    reset(data);
    readln(data,path);
    readln(data,nc);readln(data,hp);readln(data,sm);readln(data,ff);readln(data,uf);readln(data,gp);
    readln(data,df);readln(data,st);readln(data,ch);readln(data,fv);readln(data,ge);readln(data,ex);
    readln(data,ex);readln(data,sc);readln(data,cc);readln(data,hb);readln(data,sk);readln(data,fa);
    readln(data,ho);readln(data,di);readln(data,sysopsname);readln(data,reg);
    str(ord(sysopsname[1])*ord(sysopsname[3])+ord(sysopsname[5]),tempstr);
    IF (tempstr=reg) then registered := true else registered := false;
    registered := true;
    close(data);
  end;


procedure uninstallnet(var spath:pathstring);
  var data:text;
    t: array[1..30] of string;
    r: byte;
    s,f: byte;
  begin
    assign(data,spath+'sandbar.cfg');
    reset(data);
    readln(data,path);
    readln(data,nc);readln(data,hp);readln(data,sm);readln(data,ff);readln(data,uf);readln(data,gp);
    readln(data,df);readln(data,st);readln(data,ch);readln(data,fv);readln(data,ge);readln(data,ex);
    readln(data,ex);readln(data,sc);readln(data,cc);readln(data,hb);readln(data,sk);readln(data,fa);
    readln(data,ho);readln(data,di);readln(data,sysopsname);readln(data,reg);
    close(data);
    assign(data,path+'3rdparty.dat');
    reset(data);
    s:=0;r:=0;f:=0;
    repeat
      inc(f);
      readln(data,t[f]);
      IF POS('SANDBAR',t[f]) > 0 then s := f;
    until eof(data);
    close(data);
    IF s = 0 then begin
      writeln('SANDBAR has not been installed yet!');
      swriteln('`2<`0MORE`2>');
      readkey;
      exit;
    end
    else begin
      writeln;
      swriteln('`2Uninstalled!');
      swriteln('`2<`0MORE`2>');
      readkey;
    end;
    assign(data,path+'3rdparty.dat');
    rewrite(data);
    for r := 1 to f do begin
      IF NOT (r = s) and not (r = s+1) then writeln(data,t[r]);
    end;
    close(data);
  end;


procedure configuration(var spath:pathstring);
  var ch:char;
  data:text;
  tempstr:string;
  begin
    repeat
    clrscr;
    swriteln('`%Sandtiger''s Bar -- `#The Freeware `@MOD `#for Lord!');
    writeln;
    IF FILEEXISTS(spath+'sandbar.cfg') then begin
      assign(data,spath+'sandbar.cfg');
    reset(data);
    readln(data,path);
    readln(data,nc);readln(data,hp);readln(data,sm);readln(data,ff);readln(data,uf);readln(data,gp);
    readln(data,df);readln(data,st);readln(data,ch);readln(data,fv);readln(data,ge);readln(data,ex);
    readln(data,ex);readln(data,sc);readln(data,cc);readln(data,hb);readln(data,sk);readln(data,fa);
    readln(data,ho);readln(data,di);readln(data,sysopsname);readln(data,reg);
    close(data);
    str(ord(sysopsname[1])*ord(sysopsname[3])+ord(sysopsname[5]),tempstr);
    IF (tempstr=reg) then registered := true else registered := false;
    registered := true;
    end;
    IF REGISTERED then swriteln('`%REGISTERED!') else swriteln('`%UNREGISTERED - Only a Call Away!');
    writeln('');
    swriteln('      `9(`#I`9)`0nstall Me Baby!');
    swriteln('      `9(`#G`9)`0eneral Configuration');
    swriteln('      `9(`#E`9)`0xtra Configuration');
    writeln;
    swriteln('      `9(`7U`9)`0ninstall Me :(');
    writeln;
    swriteln('      `9(`@Q`9)`0uit da CONFIG!');
    ch := readkey;
    CASE UPCASE(CH) of
      'G':config;
      'E':extraconfig;
      'I':begin
            IF NOT FILEEXISTS(spath+'sandbar.cfg') then begin
                writeln;
                swriteln('`2Not so fast, my man!  Do the <G>eneral Config thing first!');
                writeln;
                write('<MORE>');
                readkey;
            end
            else installnet;
          end;
      'U':begin
            IF NOT FILEEXISTS(spath+'sandbar.cfg') then begin
                writeln;
                swriteln('`2Not so fast, my man!  Do the <G>eneral Config thing first!');
                writeln;
                write('<MORE>');
                readkey;
            end
            else uninstallnet(spath);
          end;
      'Q':halt(0);
    end;
   until (ch = '');
  end;
end.