PAGE 60,132
TITLE ILRouter.EXE  InterLord Game Packet Routing Utility
; ----------------------------------------------------------------------
; Note: Version No. in Data section at Tags VERSION and M64END

;  Syntax      ILROUTER {nn}

;   where: {nn} is an optional BBS Link # to Encode (LC's ONLY!) i.e. 05

; Note: This program was written for InterLord v1.50 from G.A.C.
;       This program will ONLY work with WagonWheel Routing!
;       Packets with SENT Status are ignored
;       Attachments greater than 8kB are ignored
;       MAXimum Outbound Packet size is less than 12kB
;       Packets In Transit to LC may also Encode at Hub
;       Standard Mime Base-64 Encoding is used without Headers
;       All activity logged to ILR.LOG file

;   Copyright  (c) 1998   Ben Ritchey Jr., et al
;                         Propriety Licensed use only
;                            All rights reserved

; Note : Place .386 here for 32-bit Segments
               DOSSEG
               .MODEL  small
               .STACK  400h    ; 1kB
; Note : Place .386 here for 16-bit Segments
               .8086           ; Base Architecture
               INCLUDE macro.inc

; ----------------------------------------------------------------------
; Un-initialized Data
               .DATA?
OUTBUFF        DB      12288 DUP (?)  ; 12k .MSG File I/O Buffer
OUTBLEN        EQU     $-OUTBUFF
DATABUFF       DB      8192 DUP (?)  ; 8k Attach I/O Buffer
DATABLEN       EQU     $-DATABUFF

               PAGE
; ----------------------------------------------------------------------
; Data Variables - 59kB Max ( 64kB - .DATA? - .STACK )
               .DATA

; PassThru Buffer Area
PASSBUFF       Label   Byte    ; PassThru Buffer
PBADDR         DD      PASSBUFF  ; Far Ptr to Here!
PBDRIVE        DB      'd:\'     ; Cur Drive
PBPATH         DB      64 DUP(0)  ; Cur Path
PBFH           DW      0       ; File Handle
PBDTA          DW      0       ; Disk Transfer Addr
PBSDTA         DW      0       ; DTA Seg
PBFSA          DW      0
PBFH2          DW      0       ; Handle 1 if 2

DTAFIND        DB      30 DUP (?)  ; 256 Byte DTA
DTAFSPEC       DB      226 DUP (?)  ; Offset 30=FSpec

FSPECWC        DB      64 DUP(0)

RUNDS          DW      0       ; Data Seg
RUNES          DW      0       ; Extra Seg
PSPES          DW      0       ; PSP Seg
RUNSP          DW      0       ; Stack OFFSET

INT_SEG        DW      0       ; Interrupts x1k (#x4=Addr)
BIOS_SEG       DW      40h     ; ROM Bios RAM Data
SYS_SEG        DW      0F000h  ; ROM Bios System Code
VBUF_SEG       DW      0B800h  ; Video Buffer Addr
VBUF_MODE      DB      3       ; Video Mode
RESTFLAG       DB      0
VPAGE_LEN      DW      0       ; DOS Screen Bytes

KBSTAT         DW      0       ; Kybd Stat Flag

ROOT           DB      'd:\',0  ; Root Path
RC             DB      0       ; Return Code

STDRIVE        DB      'd:\'
STPATH         DB      63 DUP (32)
               DB      '$'

ILPTO          DB      'INTER-LORD LEAGUE tag'
ILPTOL         EQU     $-ILPTO
GPACKET        DB      'OUTBOUND\'
FPACKET        DB      'ILnnxxxx.tag ',0
CPACKL         EQU     $-GPACKET
               DB      '...$'
INTLMSG        DB      40 DUP(?)
PKTFS          DB      64 DUP(0),'$'
MAILPATH       DB      'd:'
MAILDIR        DB      63 DUP(0),'$'
INBDPATH       DB      'd:'
INBDDIR        DB      63 DUP(0),'$'
LOGPATH        DB      'd:'
LOGDIR         DB      63 DUP(0),'$'
NXTLOG         DW      0
LOGFH          DW      0
MSGID          DB      1,'MSGID: '
               DB      27 DUP(13)  ; 'Zone:Net/node x-(8)-x',Cr
MIDNXT         DW      0
NEWSUBJ        DB      '::ILR DATA: ILnnxxxx.tag',0,'... $'
OLDSUBJ        DB      '::ILR DATA: ILnn',0,'$'
ILCLEN         DW      0
AUTHMSG        DB      13,10,179,' '
AUTHTOD        DB      'mm/dd/yy hh:mm:ss $'
LLMSG          DB      'League '
LEAGUE         DB      'xxx'
               DB      '  BBS Link #'
LINKNO         DB      '00  '
BBSNAME        DB      49 DUP('$')
FSTLINK        DB      '00'
LINKLC         DB      '01'
LINECNT        DB      0       ; ASCII Line #, CrLf ends
LASTCNT        DW      0       ; Save DownCounter
LASTCFG        DW      0       ; CRLF Pos in Buffer +2
CHARCNT        DW      0       ; # Chars in String/Tot Bytes in .Msg File
PACKCNT        DW      0       ; Total Bytes in .LLL file
CODECNT        DW      0       ; # Chars Coded on Line

TERMMSG        DB      13,10, 'ILRouter terminated, RC=$'
RCNO           DB      '???'
               DB      13, 10, '$'
PKTFLAG        DB      0       ; 1 = At least one
BADFLAG        DB      0       ; 1 = Yes
M64LEN         DB      3       ; 0, 1, 2 or 3 Bytes to go
M64WORK        DB      4 DUP(0)
TOWORK         DB      37 DUP('$')
BIN_TOD        DB      4 DUP(0)
BIN_DATE       DB      6 DUP(0)
ILRSEQ         DB      0
ILRBIN         DB      4 DUP(0)  ; Bin ID
ILRALG         DB      ' '
ILRASC         DB      8 DUP(0)  ; ASCII ID
               DB      ' $'
; Crash = +2, Hold = +512, Kill/Sent = +128
ILRSTAT        DW      101h    ; .Msg Status @186 = Loc(256) + Pvt(1)
NEWLOG         DB      0       ; 1=Yes
BINDECIN       DB      0
BINDECOUT      DB      3 DUP('0')

               PAGE
; ----------------------------------------------------------------------
; Data Constants
               .CONST

BIOSVID        EQU     10h     ; BIOS Video Int
BIOSEQU        EQU     11h     ;  "   Equipment Flags
BIOSMEM        EQU     12h     ;  "   Memory Size
BIOSDSK        EQU     13h     ;  "   Floppy Disk
BIOSCOM        EQU     14h     ;  "   Communications
BIOSEXT        EQU     15h     ;  "   Extended
BIOSKBD        EQU     16h     ;  "   Keyboard
BIOSPRT        EQU     17h     ;  "   Printer
BIOSRTC        EQU     1Ah     ;  "   Real Time Clock
DOS            EQU     21h     ; DOS Sys Func Req Int

VERSION        DB      13,10,'ILRouter 1.4  Inter-LORD Game Packet Router '
               DB      '(IP) 1998 LinearNet & BJr$'
ILCONFIG       DB      'INTRLORD.CFG',0
WILDMSG        DB      '*.MSG',0
M64START       DB      '::ILR Note: Do NOT Edit this Data!',13
M64STL         EQU     $-M64START
M64END         DB      '--- ILRouter 1.4',13,0  ; Last 0b gets Ouput!
M64ENDL        EQU     $-M64END
M64TABLE       DB      'ABCDEFGHIJKLMNOPQRSTUVWXYZ'  ;  0-25
               DB      'abcdefghijklmnopqrstuvwxyz'  ; 26-51
               DB      '0123456789+/'  ; 52-63
M64PAD         DB      '===='
HEXTABLE       DB      '0123456789ABCDEF'

SYSERR         DB      13,10,'*** Operating System ERROR #',0,'$'
SYSEL          EQU     $-SYSERR-2
BADILC         DB      13,10,'*** Error : INTRLORD.CFG corrupt.$'
LOGMSG         DB      13,10,'*** Initializing Log File ILR.LOG.$'
NOPACKS        DB      'No Packets to route.$'
KFSFLAG        DB      ' KFS'
KSFLAG         DB      ' K/S'
PVTFLAG        DB      ' PVT'
ENCMSG         DB      'Encoding $'
DECMSG         DB      'Decoding $'
DONEMSG        DB      'Done. $'
BADMSG         DB      'Bad! (Invalid Format or Data) ',7,'$'
;CRASHMSG       DB      'Crash. $'
HOLDMSG        DB      'Hold. $'
LOGFS          DB      '\ILR.LOG'

PROCESS        DB      'ILROUTER.EXE',0
ZERO           DB      0
SPACE          DB      ' '
DOLLAR         DB      '$'
CRLF           DB      13,10

; Memory Map  ( Data Seg = .DATA + .DATA? + .STACK )
;     Seg Name :   HDR   +  PSP  +  Data  +  Code  =   Total
;    Max Alloc :    16   +  256  +  64kB  +  64kB  = 131,344
;   16 =Pages :     1   +   16  +  4096  +  4096  =   8,209
; ( also PSPSeg:0002 xWord = 1st Byte Unused RAM! )
PBPAGES        DW      8209

PATCH          DD      16 DUP(0FFh)  ; 64 Byte Patch

               PAGE
; ----------------------------------------------------------------------
; Mainline Code (Logic Stuff) - 64kB Max
               .CODE

START:         mov     ax,@data  ; Data Seg Addr
               mov     ds,ax
               mov     RUNDS,ax
               mov     es,ax     ; Extra Seg=Data
               mov     RUNES,ax

               cli             ; Stack Seg=Data (Top) 
               mov     ss,ax
               mov     sp,Offset STACK
               sti
               mov     RUNSP,sp

; Free extra RAM
               mov     ah,62h  ; Get PSP Seg
               int     DOS
               mov     PSPES,bx  ; 1st Seg/Page
               mov     es,bx

               mov     ax,RUNDS  ; Calculate ACTUAL Size  <==
               mov     bx,RUNSP  ; Convert Stack Ptr to Paras
               mov     cl,4
               shr     bx,cl   ;   to get Data + Stack (/16)
               inc     bx
               add     ax,bx   ; Add Stack Pages to DS (End of Pgm)
               mov     bx,es   ; Get Start of Program (PSP)
               sub     ax,bx   ; Subtract Start from End
               inc     ax      ; +1 for Ctl Blk
               mov     bx,ax   ; Now actual Seg/Page Size

;               mov     bx,PBPAGES  ; (to Plug Max No. Pages)
               xor     al,al
               mov     ah,4Ah  ; Re-Allocate
               int     DOS
               jnc     @F
               jmp     ERR_SET

; Verify DOS >= 5.0
@@:            @GET_VER
               cmp     al,5
               jge     @F
               mov     al,99
               mov     RC,al
               jmp     ERR_EXIT

@@:            @GET_DTA        ; PSP+80h=Cmd Args
               push    ds
               push    es
               mov     es,RUNES
               mov     di,Offset FSPECWC
               pop     ds      ; Store FSpec
               mov     si,bx
               mov     al,[si]
               cmp     al,1    ; Len=0 if No args
               jg      @F
               pop     ds      ; Restore ds!
               jmp     Short NOARGS
;               mov     RC,102  ; Syntax Error
;               jmp     ERR_EXIT

@@:            xor     ch,ch
               mov     cl,al
               dec     cl
               inc     si
               inc     si
               cld
               rep     movsb
               pop     ds

NOARGS:        mov     dx,Offset DTAFIND  ; Private DTA
               @SET_DTA

               PAGE
; ----------------------------------------------------------------------
; Re-entrant
RESTART:       mov     dx,Offset VERSION
               @PUT_STR

               @GET_DRV        ; Cur Drive
               mov     STDRIVE,ah

               @GET_CDI        ; Cur Path
               mov     ds,RUNDS
               mov     cx,63
               mov     si,Offset PBPATH
               mov     di,Offset STPATH
               cld
               rep     movsb

               mov     si,Offset PBDRIVE
               mov     di,Offset LOGPATH
               mov     cx,53
               cld
@@:            lodsb
               stosb
               cmp     Byte Ptr [si],0
               loopne  @B

               mov     si,Offset LOGFS
               mov     cx,4
               cld
               rep     movsw

               mov     dx,Offset LOGPATH  ; Open Log
               mov     ah,3Dh
               mov     al,2
               int     DOS
               jnc     GOLOG
               cmp     al,2    ; Not found Ok
               je      @F
               jmp     ERR_SET

@@:            mov     NEWLOG,1
               mov     dx,Offset LOGMSG
               @PUT_STR
               mov     ah,3Ch  ; Create it
               mov     cx,0
               mov     dx,Offset LOGPATH
               int     DOS
               jnc     GOLOG
               jmp     ERR_SET

GOLOG:         mov     LOGFH,ax
               mov     PBFH,0
               mov     bx,LOGFH  ; Set to EOF
               @APPENDF

               mov     dx,Offset ILCONFIG  ; Open INTRLORD.CFG
               xor     ax,ax
               @OPENF

               mov     dx,Offset DATABUFF
               mov     cx,DATABLEN
               mov     bx,PBFH
               @READF
               mov     ILCLEN,ax  ; Actual bytes

               mov     si,Offset DATABUFF
               mov     cx,ILCLEN
               dec     cx
               cld
LOOK1:         lodsw
               dec     si
               cmp     ax,Word Ptr CRLF
               je      CHKLINE
LOOKLP:        loop    LOOK1
DOBADILC:      mov     dx,Offset BADILC
               @PUT_STR
               mov     RC,13
               jmp     ERR_EXIT

CHKLINE:       inc     LINECNT
               inc     si
               dec     cx
               mov     LASTCNT,cx
               mov     LASTCFG,si

@@:            cmp     LINECNT,1  ; Actually does Line 2!
               jne     @F
               jmp     Short DONAME

@@:            cmp     LINECNT,6  ; Line 6 is League xxx
               jne     @F
               jmp     DOLEAGUE

@@:            cmp     LINECNT,7
               jne     @F
               jmp     DOLINKNO

@@:            cmp     LINECNT,8
               jne     @F
               jmp     DONODE

@@:            cmp     LINECNT,9
               jne     @F
               jmp     DOMAILDIR

@@:            cmp     LINECNT,11
               jne     @F
               jmp     DOCRASH

@@:            cmp     LINECNT,12
               jne     @F
               jmp     DOHOLD

@@:            cmp     LINECNT,13
               jne     @F
               jmp     DOERASE

@@:            cmp     LINECNT,16
               jne     NEXTILC
               jmp     DOINBDIR

NEXTILC:       mov     si,LASTCFG
               mov     cx,LASTCNT
               jmp     LOOKLP

DONAME:        add     si,11   ; Parse BBS Name
               push    si
               mov     CHARCNT,0
NXTNME:        cmp     Byte Ptr [si],13
               je      @F
               inc     si
               inc     CHARCNT
               jmp     NXTNME
@@:            pop     si
               cmp     CHARCNT,0
               je      NEXTILC
               cmp     CHARCNT,48  ; 1st 48 Chars of BBS Name
               jle     @F
               mov     CHARCNT,48
@@:            mov     di,Offset BBSNAME
               mov     cx,CHARCNT
               cld
               rep     movsb
@@:            jmp     NEXTILC

DOLEAGUE:      sub     si,5    ; League Tag (*** Must be 3 Chars! ***
               cmp     Byte Ptr [si-1],' '
               je      @F
               jmp     DOBADILC
@@:            lodsw
               and     ax,0DFDFh
               mov     Word Ptr LEAGUE,ax
               mov     Word Ptr ILPTO+18,ax
               mov     Word Ptr FPACKET+9,ax
               mov     Word Ptr NEWSUBJ+21,ax
               lodsb
               and     al,0DFh
               mov     Byte Ptr LEAGUE+2,al
               mov     Byte Ptr ILPTO+20,al
               mov     Byte Ptr FPACKET+11,al
               mov     Byte Ptr NEWSUBJ+23,al
               jmp     NEXTILC

DOLINKNO:      sub     si,3    ; BBS Link No. (1 or 2 Chars)
               mov     al,[si]
               mov     LINKNO+1,al
               dec     si
               cmp     Byte Ptr [si],' '
               je      @F
               mov     al,[si]
               mov     LINKNO,al
@@:            mov     ax,Word Ptr LINKNO
               mov     Word Ptr OLDSUBJ+14,ax  ; Inbound Val

               cmp     ax,Word Ptr LINKLC       ; League Coordinator?
               jne     ISLINK
               cmp     FSPECWC+1,0  ; Link Arg Spec'd?
               jne     @F
               mov     ax,'!!'  ; No, just Decode ...
               jmp     Short ISANY
@@:            mov     ax,Word Ptr FSPECWC  ; Set DownLink from Args
               jmp     Short ISANY

ISLINK:        mov     ax,Word Ptr LINKLC  ; WagonWheel! Set Uplink=LC
ISANY:         mov     Word Ptr FPACKET+2,ax
               mov     Word Ptr NEWSUBJ+14,ax
               jmp     NEXTILC

DONODE:        sub     si,3    ; Parse Zone:Net/Node
               mov     CHARCNT,0
NXTNOC:        dec     si
               cmp     Byte Ptr [si],10
               jne     @F
               jmp     DOBADILC
@@:            cmp     Byte Ptr [si],' '
               je      @F
               inc     CHARCNT
               jmp     NXTNOC
@@:            inc     si
               mov     di,Offset MSGID+8
               mov     cx,CHARCNT
               inc     cx
               cld
               rep     movsb
               mov     al,' '
               stosb
               mov     MIDNXT,di
               jmp     NEXTILC

DOMAILDIR:     sub     si,3    ; Parse NetMail Path
               mov     CHARCNT,0
NXTMDC:        dec     si
               cmp     Byte Ptr [si],10
               jne     @F
               jmp     DOBADILC
@@:            cmp     Byte Ptr [si],' '
               je      @F
               inc     CHARCNT
               jmp     NXTMDC
@@:            inc     si
               mov     di,Offset MAILPATH
               mov     cx,CHARCNT
               cld
               rep     movsb
               jmp     NEXTILC

DOCRASH:       sub     si,3    ; Parse Crash Status
               mov     CHARCNT,0
NXTCRC:        dec     si
               cmp     Byte Ptr [si],10
               jne     @F
               jmp     DOBADILC
@@:            cmp     Byte Ptr [si],' '
               je      @F
               inc     CHARCNT
               jmp     NXTCRC
@@:            inc     si
               cmp     Byte Ptr [si],'Y'
               jne     @F
;               or      ILRSTAT,2
@@:            jmp     NEXTILC

DOHOLD:        sub     si,3    ; Parse Hold Status
               mov     CHARCNT,0
NXTHLC:        dec     si
               cmp     Byte Ptr [si],10
               jne     @F
               jmp     DOBADILC
@@:            cmp     Byte Ptr [si],' '
               je      @F
               inc     CHARCNT
               jmp     NXTHLC
@@:            inc     si
               cmp     Byte Ptr [si],'Y'
               jne     @F
               or      ILRSTAT,512
;               and     ILRSTAT,0FFFDh  ; Crash OFF if Hold!
@@:            jmp     NEXTILC

DOERASE:       sub     si,3    ; Parse Kill/Sent Status
               mov     CHARCNT,0
NXTERC:        dec     si
               cmp     Byte Ptr [si],10
               jne     @F
               jmp     DOBADILC
@@:            cmp     Byte Ptr [si],' '
               je      @F
               inc     CHARCNT
               jmp     NXTERC
@@:            inc     si
               cmp     Byte Ptr [si],'Y'
               jne     @F
               or      ILRSTAT,128
@@:            jmp     NEXTILC

DOINBDIR:      sub     si,3    ; Parse INBound Dir then continue
               mov     CHARCNT,0
NXTIBC:        dec     si
               cmp     Byte Ptr [si],10
               jne     @F
               jmp     DOBADILC
@@:            cmp     Byte Ptr [si],' '
               je      @F
               inc     CHARCNT
               jmp     NXTIBC
@@:            inc     si
               mov     di,Offset INBDPATH
               mov     cx,CHARCNT
               cld
               rep     movsb

               mov     bx,PBFH  ; Close INTRLORD.CFG
               @CLOSEF
               mov     PBFH,0

               call    LOGAUTH
               cmp     NEWLOG,1
               jne     @F
               call    LOGOUT
@@:            @PUT_STR
               mov     dx,Offset LLMSG
               cmp     NEWLOG,1
               jne     @F
               call    LOGOUT
@@:            @PUT_STR

               mov     dl,MAILPATH  ; Drive ASCII
               and     dl,0DFh  ; Upper Case  :)
               sub     dl,65
               @CHG_DRV
               mov     dx,Offset MAILDIR
               @CHG_DIR

               mov     dx,Offset WILDMSG  ; Wildcard Mask
               mov     cx,20h  ; Attribute Arc/None (normal data)
               @FND_1ST

CHKNEXT:       cmp     ax,0    ; Only 0,18 Returns (18=No match)
               je      GONEXT
               jmp     ERR_EXIT        ; Cest Fini!

NEXTMSG:       @FND_NXT
               jmp     CHKNEXT

GONEXT:        mov     dx,Offset DTAFSPEC
               mov     al,0    ; R/O 1st
               @OPENF

               mov     dx,Offset OUTBUFF
               mov     cx,OUTBLEN
               mov     bx,PBFH
               @READF

               cmp     ax,OUTBLEN
               jl      @F
               mov     BADFLAG,1

@@:            mov     CHARCNT,ax
               mov     bx,PBFH
               @CLOSEF
               mov     PBFH,0

               cmp     BADFLAG,1
               jne     @F
               mov     BADFLAG,0
               jmp     SKIPMSG

@@:            mov     si,Offset OUTBUFF  ; From: To: Subj: Uppercase!
               mov     cx,144
               cld
CVUP:          cmp     Byte Ptr [si],'a'
               jb      @F
               cmp     Byte Ptr [si],'z'
               ja      @F
               and     Byte Ptr [si],0DFh
@@:            inc     si
               loop    CVUP

@@:            test    Word Ptr OUTBUFF+186,8  ; Already SENT ?
               jz      @F
               jmp     NEXTMSG  ; Skip if Sent

@@:            mov     si,Offset ILPTO  ; Chk From:
               mov     di,Offset OUTBUFF
               mov     cx,ILPTOL
               cld
               repz    cmpsb
               jz      @F
               jmp     SKIPMSG  ; No match

@@:            mov     si,Offset ILPTO  ; Chk To:
               mov     di,Offset OUTBUFF+36
               mov     cx,ILPTOL
               cld
               repz    cmpsb
               jz      @F
               jmp     SKIPMSG  ; No match

@@:            mov     si,Offset OLDSUBJ
               mov     di,Offset OUTBUFF+72
               mov     cx,16
               cld
               repz    cmpsb
               jnz     @F
               jmp     DECODE  ; We Encoded this one!

@@:            test    Word Ptr OUTBUFF+186,2
               jz      @F
;               jmp     SKIPMSG  ; Skip if Crash

@@:            mov     ax,Word Ptr OUTBUFF+186
               test    ax,16
               jnz     @F
               jmp     SKIPMSG  ; Skip if NOT Attach

@@:            mov     si,Offset OUTBUFF+144  ; Parse Subj:
               mov     cx,60
@@:            dec     si
               cmp     Byte Ptr [si],0
               jne     @F
               loop    @B
               jmp     SKIPMSG  ; Bad Subj

@@:            mov     LASTCFG,si  ; Save Ptr
               sub     si,20   ; Validate Subj:
               mov     di,si
               mov     si,Offset GPACKET
               mov     cx,13
               cld
               repz    cmpsb
               jz      @F
               jmp     SKIPMSG  ; No match

@@:            mov     si,LASTCFG  ; Packet ID xxxx
               sub     si,7
               cld
               lodsw
               mov     Word Ptr FPACKET+4,ax
               mov     Word Ptr NEWSUBJ+16,ax
               lodsw
               mov     Word Ptr FPACKET+6,ax
               mov     Word Ptr NEWSUBJ+18,ax

               mov     si,Offset PBDRIVE
               mov     di,Offset PKTFS
               mov     cx,63
               cld
@@:            lodsb           ; Build d:\Path for Pkt
               cmp     al,0
               je      @F
               stosb
               loop    @B
               mov     RC,10  ; Bad Env
               jmp     ERR_EXIT

@@:            cmp     Byte Ptr [di-1],'\'
               je      @F
               mov     al,'\'
               stosb
               dec     cx

@@:            mov     si,Offset GPACKET  ; add Path Suffix + Pkt FS
               cld
@@:            lodsb
               cmp     al,0
               je      @F
               stosb
               loop    @B
               mov     RC,10  ; Bad Env
               jmp     ERR_EXIT

@@:            mov     dx,Offset PKTFS  ; Open Packet
               mov     al,0    ; R/O
               @OPENF

               mov     dx,Offset DATABUFF  ; Read Max Bytes IN
               mov     cx,DATABLEN
               mov     bx,PBFH
               @READF

               cmp     ax,DATABLEN  ; Too Big?
               jl      @F
               mov     BADFLAG,1

@@:            mov     PACKCNT,ax
               inc     PACKCNT
               mov     bx,PBFH
               @CLOSEF
               mov     PBFH,0

               cmp     BADFLAG,1
               jne     ENCODE
               mov     BADFLAG,0  ; Yes, Skip too big

SKIPMSG:       jmp     NEXTMSG

ENCODE:        mov     PKTFLAG,1       ; Encode via Mime Base-64
               call    LOGAUTH
               call    LOGOUT
               @PUT_STR
               mov     dx,Offset ENCMSG
               call    LOGOUT
               @PUT_STR
               mov     dx,Offset NEWSUBJ+12
               call    LOGOUT
               @PUT_STR

               mov     ax,ILRSTAT  ; Force Status to our liking!
               mov     Word Ptr OUTBUFF+186,ax

;               and     Word Ptr OUTBUFF+186,0FFEFh  ; Turn OFF Attach Flag
;               or      Word Ptr OUTBUFF+186,128     ; Turn ON Kill/Sent

               mov     si,Offset OUTBUFF  ; FLAGS KFS?
               add     si,CHARCNT
               sub     si,5

               mov     ax,Word Ptr [si]
               cmp     ax,Word Ptr KFSFLAG
               jne     @F
               mov     ax,Word Ptr [si+2]
               cmp     ax,Word Ptr KFSFLAG+2
               jne     @F

               mov     ax,Word Ptr KSFLAG  ; Yes, Reset to K/S
               mov     Word Ptr [si],ax
               mov     ax,Word Ptr KSFLAG+2
               mov     Word Ptr [si+2],ax

               test    ILRSTAT,128  ; Kill/Sent?
               jnz     @F
               mov     ax,Word Ptr PVTFLAG  ; No, Reset to PVT
               mov     Word Ptr [si],ax
               mov     ax,Word Ptr PVTFLAG+2
               mov     Word Ptr [si+2],ax

@@:            mov     di,Offset OUTBUFF+72  ; Clear Subj
               xor     ax,ax
               mov     cx,36
               cld
               rep     stosw

               mov     di,Offset OUTBUFF+72  ; New Subj
               mov     si,Offset NEWSUBJ
               mov     cx,72
               cld
@@:            lodsb
               cmp     al,0
               je      @F
               stosb
               loop    @B

@@:            xor     ax,ax   ; Clear MSGID
               mov     Word Ptr ILRBIN,ax
               mov     Word Ptr ILRBIN+2,ax

               call    GET_TOD  ; Date & Time

               mov     al,BIN_DATE+5  ; Year 00-99
               add     ILRBIN,al
               mov     al,BIN_DATE+1  ; Month 1-12
               add     ILRBIN,al
               mov     al,BIN_DATE+2  ; Day 1-31
               add     ILRBIN,al

               mov     al,BIN_TOD  ; Hour 0-23
               add     ILRBIN+1,al
               mov     al,BIN_TOD+1  ; Minute 0-59
               add     ILRBIN+1,al
               mov     al,BIN_TOD+2  ; Seconds 0-59
               add     ILRBIN+1,al
               mov     al,BIN_TOD+3  ; Hund Secs 0-99
               add     ILRBIN+1,al

               mov     al,LINKNO+1
               and     al,0Fh
               add     ILRBIN+2,al
               mov     al,LINKNO
               and     al,0Fh
               mov     ah,al   ; Shift left x3 + valx2 (x10)
               mov     cl,3
               shl     al,cl
               add     al,ah
               add     al,ah
               add     ILRBIN+2,al

               mov     al,NEWSUBJ+16  ; ILord File Seq (Ascii 0000-9999)
               and     al,0Fh
               add     ILRBIN+2,al
               mov     al,NEWSUBJ+17
               and     al,0Fh
               add     ILRBIN+2,al
               mov     al,NEWSUBJ+18
               and     al,0Fh
               add     ILRBIN+2,al
               mov     al,NEWSUBJ+19
               and     al,0Fh
               add     ILRBIN+2,al

               inc     ILRSEQ  ; ILRouter Seq 0-255
               mov     al,ILRSEQ
               mov     ILRBIN+3,al

; Convert 4 Byte Binary ID to 8 Byte ASCII ID
               mov     bx,Offset HEXTABLE
               mov     cl,4

               mov     al,ILRBIN
               shr     al,cl
               xlat
               mov     ILRASC,al
               mov     al,ILRBIN
               and     al,0Fh
               xlat
               mov     ILRASC+1,al

               mov     al,ILRBIN+1
               shr     al,cl
               xlat
               mov     ILRASC+2,al
               mov     al,ILRBIN+1
               and     al,0Fh
               xlat
               mov     ILRASC+3,al

               mov     al,ILRBIN+2
               shr     al,cl
               xlat
               mov     ILRASC+4,al
               mov     al,ILRBIN+2
               and     al,0Fh
               xlat
               mov     ILRASC+5,al

               mov     al,ILRBIN+3
               shr     al,cl
               xlat
               mov     ILRASC+6,al
               mov     al,ILRBIN+3
               and     al,0Fh
               xlat
               mov     ILRASC+7,al

               mov     si,Offset ILRASC
               mov     di,MIDNXT
               mov     cx,4
               cld
               rep     movsw

; Add MSGID Kludge to end of .Msg

@@:            mov     di,Offset OUTBUFF
               add     di,CHARCNT
               dec     di
               mov     si,Offset MSGID
               mov     cx,34
               cld
               mov     al,13  ; Original Last Byte (Null EOF) now Cr
               stosb

@@:            lodsb
               stosb
               inc     CHARCNT
               cmp     al,13
               loopne  @B

               mov     si,Offset M64START  ; Mime Header
               mov     cx,M64STL
               add     CHARCNT,cx
               cld
               rep     movsb

               mov     CODECNT,0
               mov     M64LEN,3
               mov     si,Offset DATABUFF
               cld

NXTMIME:       lodsb
               dec     PACKCNT
               mov     cl,2    ; 1 of 4x6b in 3x8b
               mov     ch,al
               mov     bl,al
               shr     bl,cl
               xor     bh,bh
               mov     al,M64TABLE[bx]
               stosb
               inc     CHARCNT

               mov     cl,4    ; 2 of 4x6b in 3x8b
               shl     ch,cl
               and     ch,00110000b
               lodsb
               dec     PACKCNT
               mov     ah,al
               mov     bl,al
               shr     bl,cl
               or      bl,ch
               xor     bh,bh
               mov     al,M64TABLE[bx]
               stosb
               inc     CHARCNT
               cmp     M64LEN,1
               jg      @F
               jmp     LASTM64

@@:            mov     cl,2    ; 3 of 4x6b in 3x8b
               shl     ah,cl
               and     ah,00111100b
               lodsb
               dec     PACKCNT
               mov     ch,al
               mov     bl,al
               mov     cl,6
               shr     bl,cl
               or      bl,ah
               xor     bh,bh
               mov     al,M64TABLE[bx]
               stosb
               inc     CHARCNT
               cmp     M64LEN,2
               jg      @F
               jmp     Short LASTM64

@@:            mov     bl,ch   ; 4 of 4x6b in 3x8b
               and     bl,00111111b
               xor     bh,bh
               mov     al,M64TABLE[bx]
               stosb
               inc     CHARCNT

               add     CODECNT,4
               cmp     CODECNT,76
               jl      @F
               mov     al,13   ; End of Line at 76 Chars
               stosb
               inc     CHARCNT
               mov     CODECNT,0

@@:            cmp     PACKCNT,4  ; 3 Bytes Ok (Last Byte always Zero!)
               jge     GONXTM
               mov     Byte Ptr [si+2],0  ; 2 Bytes or less
               mov     M64LEN,2
               cmp     PACKCNT,3
               jge     GONXTM
               mov     Byte Ptr [si+1],0  ; 1 Byte or less
               mov     M64LEN,1
               cmp     PACKCNT,2
               jge     GONXTM

               mov     M64LEN,0  ; Did last perfect 4 in 3 :)
               jmp     Short LASTM64

GONXTM:        jmp     NXTMIME

LASTM64:       mov     al,'='
               stosb
               inc     CHARCNT
               cmp     M64LEN,2
               je      ENDM64
               stosb
               inc     CHARCNT
               cmp     M64LEN,1
               je      ENDM64
               stosb
               inc     CHARCNT
               stosb
               inc     CHARCNT

ENDM64:        mov     al,13
               stosb
               inc     CHARCNT

               mov     si,Offset M64END  ; Last Line in File
               mov     cx,M64ENDL        ; ( includes ASCIIZ Terminator )
               add     CHARCNT,cx
               cld
               rep     movsb

               mov     dx,Offset DTAFSPEC
               mov     al,2    ; R/W access
               @OPENF

               mov     dx,Offset OUTBUFF  ;*** Write out File
               mov     cx,CHARCNT
               mov     bx,PBFH
               @WRITEF

               mov     bx,PBFH
               @CLOSEF
               mov     PBFH,0

               mov     dx,Offset PKTFS  ; Delete Packet
               @DELETEF

               mov     dx,Offset ILRALG
               call    LOGOUT
               mov     dx,Offset ILRASC
               @PUT_STR

;               test    ILRSTAT,2
;               jz      @F
;               mov     dx,Offset CRASHMSG
;               call    LOGOUT
;               @PUT_STR
;               jmp     NEXTMSG

@@:            test    ILRSTAT,512
               jz      @F
               mov     dx,Offset HOLDMSG
               call    LOGOUT
               @PUT_STR
               jmp     NEXTMSG

@@:            mov     dx,Offset DONEMSG
               call    LOGOUT
               @PUT_STR
               jmp     NEXTMSG

DECODE:        mov     si,Offset OUTBUFF+144  ; Parse Subj:
               mov     cx,60
@@:            dec     si
               cmp     Byte Ptr [si],0
               jne     @F
               loop    @B
               jmp     SKIPMSG  ; Bad Subj

@@:            sub     si,7    ; Pkt ID xxxx
               cld
               lodsw
               mov     Word Ptr FPACKET+4,ax
               mov     Word Ptr NEWSUBJ+16,ax
               lodsw
               mov     Word Ptr FPACKET+6,ax
               mov     Word Ptr NEWSUBJ+18,ax

               mov     ax,Word Ptr FPACKET+2
               mov     Word Ptr FSTLINK,ax
               mov     ax,Word Ptr LINKNO
               mov     Word Ptr FPACKET+2,ax

               mov     si,Offset INBDPATH
               mov     di,Offset PKTFS
               mov     cx,63
               cld
@@:            lodsb           ; Build d:\Path for Inbound Pkt's
               cmp     al,0
               je      @F
               stosb
               loop    @B
               mov     RC,10  ; Bad Env
               jmp     ERR_EXIT

@@:            cmp     Byte Ptr [di-1],'\'
               je      @F
               mov     al,'\'
               stosb
               dec     cx

@@:            mov     si,Offset FPACKET  ; add Pkt FSpec
               cld
@@:            lodsb
               cmp     al,' '
               je      @F
               cmp     al,0
               je      @F
               stosb
               loop    @B
               mov     RC,10  ; Bad Env
               jmp     ERR_EXIT

@@:            mov     PKTFLAG,1
               call    LOGAUTH
               call    LOGOUT
               @PUT_STR
               mov     dx,Offset DECMSG
               call    LOGOUT
               @PUT_STR

               cmp     Word Ptr LINKNO,'10'
               je      @F
               jmp     Short NOTLC

@@:            mov     si,Offset OUTBUFF+190  ; Find x01'INTL ...'
               mov     ax,4901h  ; x01'I'
               mov     cx,1024  ; Max 1k
               cld
@@:            cmp     Word Ptr [si],ax  ; Hdr rec?
               je      @F
               inc     si
               loop    @B
               jmp     Short NOTLC  ; didn't find it :(

@@:            inc     si
               mov     ax,'NI'
               cmp     Word Ptr [si],ax
               je      @F
               jmp     Short NOTLC
@@:            add     si,2
               mov     ax,'LT'
               cmp     Word Ptr [si],ax
               je      @F
               jmp     Short NOTLC
@@:            add     si,2
               mov     al,' '
               cmp     Byte Ptr [si],al
               je      @F
               jmp     short NOTLC

@@:            inc     si      ; Skip Dest Node
               mov     cx,24
               cld
@@:            cmp     Byte Ptr [si],al  ; Orig Node char 1?
               je      @F
               inc     si
               loop    @B
               jmp     Short NOTLC  ; didn't find it :(

@@:            inc     si
               mov     di,Offset INTLMSG
               mov     cx,24  ; Max
               cld
@@:            lodsb
               cmp     al,' '
               je      @F
               cmp     al,31
               jle     @F
               stosb
               loop    @B
               jmp     Short NOTLC

@@:            mov     al,' '
               stosb
               mov     al,'$'
               stosb
               mov     dx,Offset INTLMSG  ; Zone:Net/Node (from)
               call    LOGOUT
               @PUT_STR

NOTLC:         mov     dx,Offset FPACKET  ; FName
               call    LOGOUT
               @PUT_STR

               mov     si,Offset OUTBUFF+190  ; Validate Hdr
               mov     ax,'::'
               mov     cx,CHARCNT
               sub     cx,190
@@:            cmp     Word Ptr [si],ax  ; Hdr rec?
               je      @F
               inc     si
               loop    @B
               mov     dx,Offset BADMSG
               call    LOGOUT
               @PUT_STR
               jmp     ENDDCD

@@:            mov     ax,si
               mov     cx,Offset OUTBUFF
               sub     ax,cx
               push    ax

               mov     di,Offset M64START
               mov     cx,M64STL
               cld
               repz    cmpsb
               jz      @F
               pop     ax
               mov     dx,Offset BADMSG
               call    LOGOUT
               @PUT_STR
               jmp     ENDDCD

@@:            mov     di,Offset DATABUFF  ; Decode Mime to Binary
               mov     PACKCNT,0
               pop     ax
               sub     CHARCNT,ax
               sub     CHARCNT,M64STL

NXTDCD:        cmp     CHARCNT,0
               jg      @F
               jmp     BADDCD
@@:            lodsb          ; Mime-64 to Binary 6-bit

               dec     CHARCNT
               cmp     al,13   ; End of Line?
               jne     NOTCR

               cmp     CHARCNT,0
               jg      @F
               jmp     BADDCD
@@:            lodsb           ; Skip C/R
               dec     CHARCNT

NOTCR:         call    M642BIN
               cmp     al,0FFh
               jne     @F
               jmp     BADDCD
@@:            mov     M64WORK,al  ; Char 1 x6 Bits

               cmp     CHARCNT,0
               jg      @F
               jmp     BADDCD
@@:            lodsb
               dec     CHARCNT

               call    M642BIN
               cmp     al,0FFh
               jne     @F
               jmp     BADDCD
@@:            mov     M64WORK+1,al  ; Char 2 x6 Bits

               cmp     CHARCNT,0
               jg      @F
               jmp     BADDCD
@@:            lodsb
               dec     CHARCNT

               call    M642BIN
               cmp     al,0FFh
               jne     @F
               jmp     BADDCD
@@:            mov     M64WORK+2,al  ; Char 3 x6 Bits

               cmp     CHARCNT,0
               jg      @F
               jmp     BADDCD
@@:            lodsb
               dec     CHARCNT

               call    M642BIN
               cmp     al,0FFh
               jne     @F
               jmp     BADDCD
@@:            mov     M64WORK+3,al  ; Char 4 x6 Bits

               cmp     M64WORK,64  ; Eof?
               jne     @F
               jmp     Short DCDOUT

@@:            mov     al,M64WORK  ; Do Char 1 of 3 in 4
               mov     cl,2
               shl     al,cl
               mov     ah,M64WORK+1
               mov     cl,4
               shr     ah,cl
               or      al,ah
               stosb
               inc     PACKCNT

               cmp     M64WORK+2,64  ; Eof?
               jne     @F
               jmp     Short DCDOUT

@@:            mov     al,M64WORK+1  ; Do Char 2 of 3 in 4
               and     al,00001111b
               mov     cl,4
               shl     al,cl
               mov     ah,M64WORK+2
               mov     cl,2
               shr     ah,cl
               or      al,ah
               stosb
               inc     PACKCNT

               cmp     M64WORK+3,64  ; Eof?
               jne     @F
               jmp     Short DCDOUT

@@:            mov     al,M64WORK+2  ; Do Char 3 of 3 in 4
               and     al,00000011b
               mov     cl,6
               shl     al,cl
               mov     ah,M64WORK+3
               or      al,ah
               stosb
               inc     PACKCNT

               jmp     NXTDCD  ; Next set of 4 Bytes

DCDOUT:        mov     dx,Offset PKTFS  ; Create/Trunc .LLL Pkt
               mov     cx,0    ; Attrib = Normal
               @CREATEF

               mov     dx,Offset DATABUFF
               mov     cx,PACKCNT
               mov     bx,PBFH
               @WRITEF

               mov     bx,PBFH
               @CLOSEF
               mov     PBFH,0

               mov     dx,Offset DTAFSPEC  ; Delete n.Msg
               @DELETEF

               mov     dx,Offset DONEMSG
               call    LOGOUT
               @PUT_STR
               jmp     Short ENDDCD

BADDCD:        mov     dx,Offset BADMSG  ; BAD Data/Abandon Output
               call    LOGOUT
               @PUT_STR

ENDDCD:        mov     ax,Word Ptr FSTLINK
               mov     Word Ptr FPACKET+2,ax
               jmp     NEXTMSG

               PAGE
; ----------------------------------------------------------------------
; Sub-routines

BINDEC1:       xor     ax,ax   ; Convert Bin x1 to ASCII x3
               xor     bx,bx
               mov     al,BINDECIN
               mov     cx,100  ; Hunds
               div     cl
               mov     bl,al
               mov     al,HEXTABLE[bx]
               mov     BINDECOUT,al
               mov     al,ah   ; Tens
               xor     ah,ah
               mov     cx,10
               div     cl
               mov     bl,al
               mov     al,HEXTABLE[bx]
               mov     BINDECOUT+1,al
               mov     bl,ah   ; Ones
               mov     al,HEXTABLE[bx]
               mov     BINDECOUT+2,al
               ret

LOGAUTH:       call    GET_TOD
               mov     al,BIN_DATE+1  ; Month
               mov     BINDECIN,al
               call    BINDEC1
               mov     ax,Word Ptr BINDECOUT+1
               mov     Word Ptr AUTHTOD,ax

               mov     al,BIN_DATE+2  ; Day
               mov     BINDECIN,al
               call    BINDEC1
               mov     ax,Word Ptr BINDECOUT+1
               mov     Word Ptr AUTHTOD+3,ax

               mov     al,BIN_DATE+5  ; Year
               mov     BINDECIN,al
               call    BINDEC1
               mov     ax,Word Ptr BINDECOUT+1
               mov     Word Ptr AUTHTOD+6,ax

               mov     al,BIN_TOD  ; Hour
               mov     BINDECIN,al
               call    BINDEC1
               mov     ax,Word Ptr BINDECOUT+1
               mov     Word Ptr AUTHTOD+9,ax

               mov     al,BIN_TOD+1  ; Minute
               mov     BINDECIN,al
               call    BINDEC1
               mov     ax,Word Ptr BINDECOUT+1
               mov     Word Ptr AUTHTOD+12,ax

               mov     al,BIN_TOD+2  ; Second
               mov     BINDECIN,al
               call    BINDEC1
               mov     ax,Word Ptr BINDECOUT+1
               mov     Word Ptr AUTHTOD+15,ax

               mov     dx,Offset AUTHMSG
               ret

LOGOUT:        xor     cx,cx  ; Log from [dx] thru '$' or Null
               mov     si,dx
@@:            cmp     Byte Ptr [si],'$'
               je      @F
               cmp     Byte Ptr [si],0
               je      @F
               inc     si
               inc     cx
               jmp     @B
@@:            cmp     cx,0
               jg      @F
               ret
@@:            mov     NXTLOG,dx
               mov     bx,LOGFH
               @WRITEF
               mov     dx,NXTLOG
               ret

GET_TOD:       mov     ah,2Ch
               int     DOS       
               mov     bx,OFFSET BIN_TOD ;Save TOD
               mov     [bx],ch    ; Hour
               mov     [bx+1],cl  ; Minute
               mov     [bx+2],dh  ; Seconds
               mov     [bx+3],dl  ; Hund/Sec

               mov     ah,2Ah  ; Get DOS Date
               int     DOS
               mov     bx,OFFSET BIN_DATE ;Save Bin Date
               mov     [bx],al  ; Dow (0-6, 0=Sun)
               mov     [bx+1],dh  ; MM (1-12)
               mov     [bx+2],dl  ; DD (1-31)
               mov     [bx+3],cx  ; YYYY (1980-2099)

@@:            cmp     cx,99  ; Year to Mod 100 (00-99)
               jle     @F
               sub     cx,100
               jmp     @B

@@:            mov     [bx+5],cl  ; YY (00-99)
               ret

M642BIN:       cmp     al,'A'
               jb      @F
               cmp     al,'Z'
               ja      @F
               sub     al,65
               ret
@@:            cmp     al,'a'
               jb      @F
               cmp     al,'z'
               ja      @F
               sub     al,71
               ret
@@:            cmp     al,'0'
               jb      @F
               cmp     al,'9'
               ja      @F
               add     al,4
               ret
@@:            cmp     al,'+'
               jne     @F
               mov     al,62
               ret
@@:            cmp     al,'/'
               jne     @F
               mov     al,63
               ret
@@:            cmp     al,'='
               jne     @F
               mov     al,64
               ret
@@:            mov     al,0FFh  ; Invalid Data!
               ret

               PAGE
; ----------------------------------------------------------------------
; Error Handler

ERR_SET:       mov     RC,al   ; Save Err #

ERR_EXIT:      mov     al,RC   ; Error #
               cmp     RC,0
               je      EXITP
               mov     dl,7    ; Beep if Error
               @PUT_CHR

; Exit to DOS
EXITP:         xor     ax,ax   ; Convert Bin RC to ASCII
               xor     bx,bx
               mov     al,RC
               mov     cx,100  ; Hunds
               div     cl
               mov     bl,al
               mov     al,HEXTABLE[bx]
               mov     RCNO,al
               mov     al,ah   ; Tens
               xor     ah,ah
               mov     cx,10
               div     cl
               mov     bl,al
               mov     al,HEXTABLE[bx]
               mov     RCNO+1,al
               mov     bl,ah   ; Ones
               mov     al,HEXTABLE[bx]
               mov     RCNO+2,al

               cmp     RCNO,'0'  ; Suppress Leading Zeroes
               jne     @F
               mov     ax,Word Ptr RCNO+1
               mov     Word Ptr RCNO,ax
               mov     RCNO+2,' '

@@:            cmp     RCNO,'0'
               jne     @F
               mov     al,RCNO+1
               mov     RCNO,al
               mov     RCNO+1,' '

@@:            cmp     RC,0    ; No Err?
               je      CLOSEM
               cmp     LOGFH,0  ; Log Error?
               je      CLOSEM

               mov     dx,Offset SYSERR  ; Log Error Code if >0
               mov     cx,SYSEL
               mov     bx,LOGFH
               @WRITEF

               mov     dx,Offset RCNO
               mov     cx,3
               mov     bx,LOGFH
               @WRITEF

               cmp     PBFSA,0
               je      CLOSEM
               mov     dx,PBFSA  ; Last FSpec Addr
               call    LOGOUT

CLOSEM:        cmp     PBFH,0
               je      @F
               mov     bx,PBFH  ; Close File 1
               mov     ah,3Eh
               int     DOS

@@:            cmp     PBFH2,0
               je      @F
               mov     bx,PBFH2  ; Close File 2
               mov     ah,3Eh
               int     DOS

@@:            cmp     LOGFH,0
               je      RSTPATH

               cmp     PKTFLAG,0
               je      LOGEOF
               mov     dx,Offset CRLF
               mov     cx,2
               mov     bx,LOGFH
               @WRITEF

LOGEOF:        mov     bx,LOGFH  ; Close Log
               mov     ah,3Eh
               int     DOS

RSTPATH:       cmp     PBDRIVE,'d'
               je      @F
               mov     dl,PBDRIVE
               sub     dl,65
               @CHG_DRV

@@:            cmp     PBPATH,0
               je      @F
               mov     dx,Offset PBPATH-1
               mov     ah,3Bh
               int     DOS

@@:            cmp     PKTFLAG,0
               jne     @F
               call    LOGAUTH  ; No Packets processed
               @PUT_STR
               mov     dx,Offset NOPACKS
               @PUT_STR

@@:            mov     dx,Offset TERMMSG  ; Term Msg
               @PUT_STR

               mov     dx,Offset RCNO  ; Display ErrorLevel
               @PUT_STR

               mov     al,RC   ; ErrorLevel
               mov     ah,4Ch
               int     DOS     ; Exit
               ret

               END     START   ; Start Addr!
;*** End of Program ***
