
unit DDIGMUN1;
{$F+}
interface
uses
 DOS,crt;
type
  FileName = DirStr;
  {$I ddigmrec.typ }
var
  OK,NewOK,ShareOk          : boolean;
  DDTasker             : byte;
  OnlinerFilenm,ChatFilenm,PlayerFilenm,GameFilePath,LordFilePath : FileName;
  OnlinerFile,ChatFile,PlayerFile      : File;
  HighRecNo  : longint;

Procedure Getfilepath;
Procedure Setfilepath;
Function  DateStamp : longInt;
Function  TimeStamp : longInt;
Procedure LockDataBase  (var F   : File; FileOff  :Longint;
                                         RecCount,RecLen : word);
Procedure UnLockDataBase(var F   : File; FileOff  :Longint;
                                         RecCount,RecLen : word);
Procedure Lock_Pause;
Procedure DD_Pause(t : integer);
Procedure OpenOnLiner(mode:word);
Procedure LockOnliner;
Procedure UnLockOnliner;
Procedure FindOnliner(var Online:OnlinerRec);
Procedure GetOnliner(var Online: OnlinerRec);
Procedure CloseOnliner;
Procedure PutOnliner(var Onliner : OnlinerRec);
Procedure OpenChat(mode:word);
Procedure InitChat(var Chat:ChatRec);
procedure PutChat(var Chat : ChatRec);
Procedure CloseChat;
procedure HighChatMark(var RecNo:longint);
procedure SeekChat(recno : longint);
procedure FindChat (var Chat:ChatRec);
Procedure DeleteChatFile;
Procedure OpenPlayer(mode:word);
Procedure ClosePlayer;
Procedure LockPlayer;
Procedure InitPlayer(var Player:PlayerRec);
procedure SeekPlayer(recno : longint);
procedure GetPlayer (recno : longint;var Player:PlayerRec);
procedure PutPlayer(recno:longint;var Player : PlayerRec);

implementation
{$I-,R-}

{$L DVAWARE.OBJ}

Procedure DV_Pause;   External;

Procedure TaDos_Sleep;
var
 Regs : Registers;
begin
 with Regs do
   Intr($28,Regs);
end;

Procedure TaWin_Pause;
var
 Regs : Registers;
begin
 with Regs do
 begin
   Ax := $1680;
   Intr($2F,Regs);
 end;
end;

function HiLong(Long : LongInt) : Word;
Inline(
  $5A/       {pop      dx    ; low word of long}
  $58);      {pop      ax    ; hi word of long}

function LowLong(Long : LongInt) : Word;
Inline(
  $5A/       {pop      dx    ; low word of long}
  $58/       {pop      ax    ; hi word of long}
  $89/$D0);  {mov      ax,dx ; return lo word as function result in Ax}

function LockFile (Handle : Word; RegionStart,RegionSize : LongInt) : Word;
var
 Regs : Registers;
 H,L,Minor : Word;
begin
 with Regs do
  begin
    Ax := $5C00;
    Bx := Handle;
    Cx := HiLong(RegionStart);
    Dx := LowLong(RegionStart);
    Si := HiLong(RegionSize);
    Di := LowLong(RegionSize);
    MsDos(Regs);
  end;
 if (Regs.Flags and FCarry = 0) then
   LockFile := 0
 else
   LockFile := Regs.Ax;
end;

function UnLockFile (Handle : Word; RegionStart,RegionSize : LongInt) : Word;
var
 Regs : Registers;
 H,L,Minor : Word;
begin
 with Regs do begin
  Ax := $5C01;
  Bx := Handle;
  Cx := HiLong(RegionStart);
  Dx := LowLong(RegionStart);
  Si := HiLong(RegionSize);
  Di := LowLong(RegionSize);
  MsDos(Regs);
 end;
 if (Regs.Flags and FCarry = 0) then
   UnLockFile := 0
 else
   UnLockFile := Regs.Ax;
end;

Procedure Getfilepath;
var
  P : PathStr;
  D : filename;
  N : NameStr;
  E : ExtStr;
  i,len : byte;
begin
  p := ParamStr(0);
  Fsplit(p,d,n,e);
  gamefilepath := d;
{ len:=length(gamefilepath);
  d:='';
  for i := len-4 to len do
    d:=d+gamefilepath[i];

  if d='LORD\' then
     Lordfilepath:=gamefilepath
  else
   begin
     for i := len-1 downto 1 do
       if gamefilepath[i] = '\' then
         break;
     d:=gamefilepath;
     delete(d,i,255);
     Lordfilepath:=d+'\';
   end;  }
end;

Procedure Setfilepath;
begin
 { These particular files are being forced into Lord so other ddigm kit}
 { doors can access them.                                              }

  Chatfilenm      := Lordfilepath+'DDCHAT.DAT';
  OnlinerFilenm   := Lordfilepath+'DDINIGM.DAT';
  PlayerFilenm    := Lordfilepath+'PLAYER.DAT';
end;

Function  DateStamp : longInt;
var
 dY,dM,dD,dW : word;
 L1,L2,L3,Stamp   : longint;
begin
  GetDate(dY,dM,dD,dW);
  L1 := dy;
  L2 := dm;
  L3 := dD;
  Stamp := L1*10000+L2*100+L3;
  DateStamp := Stamp;
end;

Function  TimeStamp : longInt;
var
 tH,tM,tS,tA : word;
 L1,L2,L3,Stamp   : longint;
begin
  GetTime(tH,tM,tS,tA);
  L1 := tH;
  L2 := tM;
  L3 := tS;
  Stamp := L1*3600+L2*60+L3;
  TimeStamp := Stamp;
end;

Procedure GetShare;    { See if share is present   }
var
 Regs : Registers;
begin
 with Regs do
  begin
    Ax := $1000;
    intr($2F,Regs);
  end;
  If (Regs.AL = $FF) then
     ShareOK := true            { share present }
  else
     ShareOK := false;
end;

Procedure Lock_Pause;
begin
  case DDTasker of
    1     : DV_Pause;
    2,4,5 : TaWin_Pause;
    3     : begin
             TaWin_Pause;
             TaDos_Sleep;
           end
   else
    TaDos_Sleep;
  end;
end;

Procedure LockDataBase;
var
  filelock,count : word;
  RegionStart,RegionSize,RecSize:longint;
begin
  If ShareOK then
    begin
      count := 0;
      Repeat
        inc(count);
        If count > 20001 then halt;
        RecSize := RecLen;
        RegionSize  := RecCount;
        RegionStart := RecSize * FileOff;
        RegionSize  := RecSize * RegionSize;
        filelock := LockFile(FileRec(F).handle,RegionStart,RegionSize);
        If filelock = $21 then
          If count mod 100 = 99 then
            Lock_Pause;
      Until filelock <> $21;
   end;
end;

Procedure UnLockDataBase;
var
 fileunlock : word;
 RegionStart,RegionSize,RecSize:longint;
begin
  If ShareOk then
    begin
      RecSize := RecLen;
      RegionSize  := RecCount;
      RegionStart := RecSize * FileOff;
      RegionSize  := RecSize * RegionSize;
      fileunlock := UnLockFile(FileRec(F).handle,RegionStart,RegionSize);
    end;
end;

Procedure DD_Pause(t : integer);
var
  k,m : integer;
begin
  k := t div 75;
  inc(k);
  for m := 1 to k do
    begin
      Lock_Pause;
      delay(20);
    end;
end;

Procedure InitOnliner(var Online:OnlinerRec);
begin
  FillChar(Online,SizeOf(OnlinerRec), 0);
end;

procedure OpenAnyFile(mode:word;var F :file;var FileNm:filename;RecLen : word );
var
  saveflag:byte;
  DirInfo: SearchRec;
  result,savemode : word;
begin
  savemode:=filemode;
  filemode:=mode;
  OK:=false;
  NewOK:=false;
  FillChar(F,SizeOf(F), 0);
  Assign (F,filenm);
  {$I-}  Reset(F,RecLen); {$I+}
  If IOresult <> 0 then
    begin
     FindFirst((filenm),AnyFile,DirInfo);
     if DosError<>0 then
       begin
         {$I-}  Rewrite(F,RecLen); {$I+}
         If IOresult = 0 then OK:=true;
         NewOK:=true;
       end;
   end
 else
  OK:=true;
  filemode:=savemode;
end;

Procedure OpenFile(mode : word;var F :file;var FileNm:filename;
                          RecLen : word);
var
 i:byte;
begin
 for i := 1 to 10 do
   begin
     OpenAnyFile(mode,F,Filenm,RecLen);
     if Ok then  break
     else
      dd_pause(755);
   end;
end;

Procedure OpenOnLiner(mode:word);
begin
  OpenFile(mode,OnlinerFile,OnlinerFilenm,sizeof(OnlinerRec));
end;

Procedure LockOnliner;
begin
  LockDataBase(OnlinerFile,0,1,SizeOf(OnlinerRec));
end;

Procedure UnLockOnliner;
begin
  UnLockDataBase(OnlinerFile,0,1,SizeOf(OnlinerRec));
  Lock_Pause;
end;

procedure FindOnliner(var Online:OnlinerRec);
var count : word;
begin
   OK:=false;
  InitOnliner(Online);
  {$I-} BlockRead(OnlinerFile,Online,1,count); {$I+}
  If count<>0 then OK:=true;
end;

Procedure GetOnliner(var Online: OnlinerRec);
begin
  OpenOnliner(64);
  If not OK then exit;
  LockOnliner;
  FindOnliner(Online);
  CloseOnliner;

end;

Procedure CloseOnliner;
begin
  Close(OnlinerFile);
end;

procedure PutOnliner(var Onliner : OnlinerRec);
var
  result : word;
begin
  OK:=false;
  {$I-}  Seek(OnlinerFile,0);{$I+}
  If IOresult <> 0 then exit;
  {$I-} BlockWrite (OnlinerFile,Onliner,1,result); {$I+}
  If IOresult=0 then Ok:=true;
end;

Procedure OpenChat;
begin
  OpenAnyFile(mode,ChatFile,ChatFileNm,sizeof(ChatRec));
end;

Procedure CloseChat;
begin
  Close(ChatFile);
end;

Procedure LockChat;
begin
  LockDataBase(ChatFile,0,1,SizeOf(ChatRec));
end;

Procedure UnLockChat;
begin
  UnLockDataBase(ChatFile,0,1,SizeOf(ChatRec));
  Lock_Pause;
end;

Procedure InitChat(var Chat:ChatRec);
begin
  FillChar(Chat,sizeof(ChatRec),0);
end;

procedure SeekChat;
begin
  OK:=true;
  {$I-}  Seek(ChatFile,recno);{$I+}
  If IOresult <> 0 then
    OK:=false;
end;

procedure FindChat;
var
 count : word;
begin
  OK:=false;
  InitChat(Chat);
  LockChat;
  {$I-} BlockRead(ChatFile,Chat,1,count); {$I+}
  If Ioresult=0 then
   if count<>0 then
     OK:=true;
  UnLockChat;
end;

procedure PutChat(var Chat : ChatRec);
var
  result : word;
begin
   OK:=false;

  {$I-}  Seek(ChatFile,FileSize(ChatFile));{$I+}
  If IOresult <> 0 then exit;
  LockChat;
  {$I-} BlockWrite (ChatFile,Chat,1,result); {$I+}
  if ioresult=0 then Ok:=true;
  UnLockChat;

end;

procedure HighChatMark;
begin
  recno:=0;
  OpenChat(64);
  if Not Ok then exit;
  recno:=FileSize(ChatFile);
  CloseChat;
end;

Procedure DeleteChatFile;
var
  Chat:ChatRec;
begin
  FillChar(ChatFile,SizeOf(ChatFile), 0);
  Assign (ChatFile,Chatfilenm);
  {$I-}  Reset(ChatFile,Sizeof(ChatRec)); {$I+}
  If IOresult <> 0 then exit;
  Close(ChatFile);
  {$I-}  Erase(ChatFile); {$I+}
end;

procedure OpenPlayerFile(mode:word);
var
  saveflag:byte;
  DirInfo: SearchRec;
  Player: PlayerRec;
  result,savemode : word;
begin
  savemode:=filemode;
  filemode:=mode;
  Ok:=false;
  FillChar(PlayerFile,SizeOf(PlayerFile), 0);
  Assign (PlayerFile,Playerfilenm);
  {$I-}  Reset(PlayerFile,Sizeof(PlayerRec)); {$I+}
  If IOresult <> 0 then
     begin
       filemode:=savemode;
       exit;
     end
 else
  Ok:=true;
  filemode:=savemode;

end;

Procedure OpenPlayer(mode:word);
var
 i:byte;
begin
 for i := 1 to 10 do
   begin
     OpenPlayerFile(mode);
     if OK then break
     else
       dd_pause(755);
   end;
end;

Procedure ClosePlayer;
begin
  Close(PlayerFile);
end;

Procedure LockPlayer;
begin
  LockDataBase(PlayerFile,0,1,SizeOf(PlayerRec));
end;

Procedure UnLockPlayer;
begin
  UnLockDataBase(PlayerFile,0,1,SizeOf(PlayerRec));
  Lock_Pause;
end;

Procedure InitPlayer(var Player:PlayerRec);
begin
  FillChar(Player,sizeof(PlayerRec),0);
end;

procedure SeekPlayer;
begin
  OK:=true;
  {$I-}  Seek(PlayerFile,recno);{$I+}
  If IOresult <> 0 then OK:=false;
end;

procedure FindPlayer (var Player:PlayerRec);
var
  count:word;
begin
  OK:=true;
  InitPlayer(Player);
  LockPlayer;
  {$I-} BlockRead(PlayerFile,Player,1,count); {$I+}
  UnLockPlayer;
  if count=0 then OK:=false;
end;

procedure GetPlayer (recno : longint;var Player:PlayerRec);
var
  count:word;
begin
  SeekPlayer(recno);
  If OK then
    FindPlayer(Player);
end;

procedure PutPlayer(recno:longint;var Player : PlayerRec);
var
  result : word;
begin
  OK:=false;
  {$I-}  Seek(PlayerFile,recno);{$I+}
  If IOresult <> 0 then exit;
  LockPlayer;
  {$I-} BlockWrite (PlayerFile,Player,1,result); {$I+}
  if IOResult=0 then OK:=true;
  UnLockPlayer;
end;

begin
  GetShare;
end.