unit allpas;
interface
uses dos,crt,bcshare;


type
 adaptertype= (MDA,CGA,EGAMono,EGAColor);
 datetype=string[6];
 screentype= array[1..4000] of byte;
 screenptr=^screentype;
var
  DOS_Major,DOS_Minor : Word;
  hexon: boolean;
  screen1: screenptr;
  x,y: integer;


{Most of these were written by Seth A. Robinson, a few swiped from swag,
and the ones at the end are from Scott Baker's library.}

function param_check(s: string): boolean;
{Checks if a certain parm was entered in the commandline, returns yes or
no.}

function num_of_num(ev: string): integer;
{returns number of numbers in a string}

Function DirExist(st_Dir : string) : Boolean;
{does dir exist?}

function nice_date : string;
function nice_time : string;
{these are easy ways to put the date or time into a string}

function match(s1, s2: string) : integer;
{like POS, but only checks from start, not inside of string}

procedure add_text(line, file_name: string);
{appends a text line to a file, if it doesn't exist, it creates it}

function get_word(s: string; num: integer): string;
{returns a one word of a string by number, left to right}

function reverse(st: string):string;
{returns a reversed string}

Procedure MakeDir(Target : String);
{makes a dir, will make multiple dirs at a time if needed}

function exist(file_name: string): boolean;
{does file exist?}

procedure delete_file(fn: string);
{deletes a file, will not error if it doesn't exit}

procedure trim(fn:string;n1:longint);
{trims a text file down to number given.  It trims from the top}

function lmon(money: longint): string;
{puts comma's in y our longint and returns as a string}

function LZz(w : longint) : String;
{converts ints to string without commas}

function get_dir(s: string): string;
{put the name of the .EXE file with .EXE as the string, and returns the
directory the current program is being run from}

function spad(name:string; num:longint): string;
procedure pad(var name:string; num:longint);
{both add spaces to a string to make it a certain length}

function color_pad(hol: string; num:integer): string;
{Same as above, but takes out color codes while doing the math}

function front_pad(var name:string; num:longint): string;
{Adds spaces to beginning of string to make certain length}

function lxx(st:string):longint;
{returns a string back as a longint - will be 0 if no #'s are in it}

function seth_wait(time_to_wait:longint): longint;
{waiting by clock - 100 is one second, but it's not that precise}

procedure truncate_string(var s: string;len: integer);
{shops a string down to a certain length}

function up_string(name: string) : string;
{returns string as all caps}

function write_error(nu: integer) : string;
{give it an error #, and it returns what the problem is}

procedure replace(this,that: string; var inthis: string;all: boolean);
{replaces all instances of 'this' in string with 'that'}

procedure beep;
{beeps a random weird noise, usually to give feedback on checking something
when you don't want to mess with the screen}

function real_length(name: string) : string;
{returns a string with all ` codes stripped out}

procedure strip_danger(var s: string);
{strips out all ` codes that are NOT standard color codes, run this on all
player string input, it allows colors, just nothing else}

function center(f1: string; tot: integer): string;
{returns a centered string (pads spaces on both sides until length meets
integer}

{the following are pretty much in everyones library}

function ssexist(name,filename: string) : boolean;
{Checks if a @#<name> exists in a file, used in my text database system}

function ssextract(name,filename,new_name: string) : boolean;
{extracts a @#<name> to another text file - on this and above, don't put
the @#, it's added}

function va(n: integer): string;
function wva(n: word): string;
function lva(n: longint): string;
function tf(d: boolean) : string;
function rva(n: real): string;
function stu(s: string): string;
function locase(c: char): char;
function stl(s: string): string;
function namestr(s: string): string;
function date_man: datetype;
function bitcheck(n: word; b: byte): boolean;
procedure setbit(var n: word; b: byte);
procedure resetbit(var n: word; b: byte);
procedure copyfile(f1,f2: string);
function GetHandle(var F : File) : Word;

function DosVer(var Minor : Word) : Word;
function LockFile(Handle : Word; FilePosition,FileLength : LongInt) : Word;
procedure unlock_file(file_name:string);

function dec2hex(w: integer) : string;
function UnLockFile(Handle : Word; FilePosition,FileLength : LongInt) : Word;
procedure get_access_hard(file_name:string);

function RetryFile(Handle,Wait,Retry : Word) : Word;
function hex(i: byte): string;
procedure HexFilt(var s: string);
procedure HexToDec(var s: string);
procedure cursorblock;
procedure cursorw;
function screenaddress: word;
procedure savescreen;
procedure restorescreen;
function hex2dec(what:string) : integer;
function getvst(s:string;b:byte):string;
procedure setmode(modenumber: byte);
procedure set43lines;
procedure set25lines;
procedure strip_end_spaces(var name: string);
function isega: boolean;
function queryadaptertype: adaptertype;
function determinepoints: integer;
procedure cursoron;
procedure cursoroff;


implementation


       function LZz(w : longint) : String;
var
  s : String;
begin
  Str(w,s);
  LZz := s;
end;

procedure add_text(line, file_name: string);
var hh: text;
begin;
assigntxtfile(hh, file_name);
if exist(file_name) then append(hh) else rewrite(hh);
writeln(hh, line);
close(hh);
end;

function ssexist(name,filename: string) : boolean;
var
ji : text;
oo: string;
begin;
if exist(filename) then
 begin;
 assigntxtfile(ji, filename);
 reset(ji);
 name := up_string(name);
 repeat;
 readln(ji, oo);
 if pos('@#'+name,up_string(oo)) <> 0 then
  begin;
  close(ji);
  ssexist := true;
  exit;
  end;

 until eof(ji);
  close(ji);
  exit;
 end;
ssexist := false;
end;

function ssextract(name,filename,new_name: string) : boolean;
var
ji,je : text;
oo: string;
begin;
if exist(filename) then
 begin;
 assigntxtfile(ji, filename);
 reset(ji);
 name := up_string(name);
 repeat;
 readln(ji, oo);
 if pos('@#'+name,up_string(oo)) <> 0 then
  begin;
  assigntxtfile(je, new_name);
  rewrite(je);
  repeat;
  readln(ji,oo);
  if pos('@#',oo) = 0 then
  writeln(je, oo);
  until pos('@#',oo) <> 0;

  close(ji);
  close(je);
  ssextract := true;
  exit;
  end;

 until eof(ji);
  close(ji);
  ssextract := false;
 exit;
 end;
end;


function center(f1: string; tot: integer): string;
var
n1,n2,n3: integer;
f2: string;
begin;
n1 := (tot - length(real_length(f1))) div 2;
f2 := '';
pad(f2, n1);

center := f2+f1+f2;

end;
procedure strip_danger(var s: string);
label hoot,finit;
var
s1: string;
h: integer;
begin;
s1 := '';
h := 1;
if s = '' then goto finit;
repeat;

if s[h] <> '`' then s1 := s1 + s[h] else
  begin;

  if s[h+1] <> '1' then if s[h+1] <> '2' then if s[h+1] <> '3' then
  if s[h+1] <> '4' then if s[h+1] <> '5' then if s[h+1] <> '6' then
  if s[h+1] <> '7' then if s[h+1] <> '8' then if s[h+1] <> '9' then
  if s[h+1] <> '0' then if s[h+1] <> '!' then if s[h+1] <> '@' then
  if s[h+1] <> '#' then if s[h+1] <> '$' then if s[h+1] <> '%' then
  begin;
  inc(h);
  goto hoot;
  end;

  s1 := s1 + s[h];

  end;
hoot:
inc(h);
until h > length(s);
s := s1;

finit:
end;



function lxx(st:string):longint;
var who: integer;
lk,lj: longint;
nego: boolean;
begin;
nego := false;
for lk := 1 to length(st) do
if st[lk] = '-' then begin;
nego := true;
delete(st,lk,1);
end;

val(st,lk,who);
lxx := lk;
if nego then
lxx := (lk - (lk+lk));
end;

function match(s1, s2: string) : integer;
var
j: integer;
begin;
s1 := up_string(s1);
s2 := up_string(s2);

for j := 1 to length(s1) do
begin;
if s2[j] = s1[j] then match := 1 else
begin;
match := 0;
exit;
end;

end;


end;


 function LeadingZero(w : Word) : String;
var
  s : String;
begin
  Str(w:0,s);
  if Length(s) = 1 then
    s := '0' + s;
  LeadingZero := s;
end;

function nice_date : string;
var
  y, m, d, dow : Word;
begin;
     GetDate(y,m,d,dow);
nice_date := leadingzero(m)+ '/'+leadingzero(d)+'/'+leadingzero(y);
end;

function nice_time: string;
   var
  h, m, s, hund : Word;
begin
  GetTime(h,m,s,hund);
  nice_time := LeadingZero(h)+':'+
          LeadingZero(m)+':'+LeadingZero(s);
          end;



procedure unlock_file(file_name:string);
var
ar: text;
i: integer;
begin;
file_name[length(file_name)] := 'X';
delete_file(file_name);
end;


Function DirExist(st_Dir : string) : Boolean;
Var
fi_temp: text;
begin
  assigntxtfile(fi_Temp, (st_Dir + '\TEST.TST'));
{$I-}
rewrite(fi_temp);
if ioresult <> 0 then begin;
direxist := false;
{$I+}
exit;
end;
{$I+}
close(fi_temp);
delete_file((st_Dir + '\TEST.TST'));

direxist := true;

end; { DirExist. }

Procedure MakeDir(Target : String);
Var
  Slash : Array[1..20] of Integer;

  i,
  count   : Integer;
  dir,
  home,
  tempdir : String;

begin
  { sample directory below to make }
  Dir := Target;
  { add slash at end if not given }
  if Dir[Length(Dir)] <> '\' then
    Dir := Dir + '\';
  { if colon where normally is change to that drive }
  if Dir[2] = ':' then
    ChDir(Copy(Dir, 1, 2))
  else
  { assume current drive (and directory) }
  begin
    GetDir(0, Home);
    if Dir[1] <> '\' then
      Dir := Home + '\' + Dir
    else
      Dir := Home + Dir;
  end;

  Count := 0;
  { search directory For slashed and Record them }
  For i := 1 to Length(Dir) do
  begin
    if Dir[i] = '\' then
    begin
      Inc(Count);
      Slash[Count] := i;
    end;
  end;
  { For each step of the way, change to the directory }
  { if get error, assume it doesn't exist - make it }
  { then change to it }
  For i := 2 to Count do
  begin
    TempDir := Copy(Dir, 1, Slash[i] - 1);
    {$I-}
    ChDir(TempDir);
    if IOResult <> 0 then
    begin
      MkDir(TempDir);
      ChDir(TempDir);
    end;
  end;
    ChDir(Home);
  
end;

procedure get_access_hard(file_name:string);
var
ar: file;
i: integer;
begin;
file_name[length(file_name)] := 'X';
if exist(file_name) then begin;
  i := 1;
  repeat;
  seth_wait(10);
  inc(i);
  if i = 15 then delete_file(file_name);
  until (not exist(file_name));
  end;

  assign(ar, file_name);
  rewrite(ar);
  close(ar);
end;








procedure truncate_string(var s: string;len: integer);
var
h: integer;
l: string;
begin;
L := '';
if length(real_length(s)) <= len then exit;
for h := 1 to 255 do
 begin;
 l := l + s[h];
 if length(real_length(l)) >= len then
  begin;
  s := l;
  exit;
  end;
 end;

end;

function color_pad(hol: string; num:integer): string;
begin;
pad(hol,num+(length(hol)-length(real_length(hol))));
truncate_string(hol, num);
color_pad := hol;

end;



procedure replace(this,that: string; var inthis: string;all: boolean);
var
i,k,p: integer;
h: string;
found: boolean;
label start,skip,foundit;
begin;
start:
h := '';
inthis := inthis +' ';
if pos(up_string(this),up_string(inthis)) = 0 then exit;
for i := 0 to length(inthis)-1 do
begin;
found := true;

for k := 1 to length (this) do
begin;
if upcase(inthis[i+k]) <> upcase(this[k]) then goto skip;
end;
if found = true then goto foundit;
skip:
end;
foundit:
p := i+1;
delete(inthis, p, length(this));
for i := 1 to length(inthis) do
begin;
if i = (p) then h := h +that;

h := h +inthis[i];
end;
delete(h,length(h),1);
inthis := h;
if all then goto start;
end;
function tf(d: boolean) : string;
begin;
  if d then tf := 'TRUE' else tf := 'FALSE';
end;
  procedure pad(var name:string; num:longint);
begin;
repeat;
if length(name) >= num then exit;
name := name +' ';
until 4 > 8;
end;
function front_pad(var name:string; num:longint): string;
begin;
repeat;
if length(name) >= num then begin;

exit;
front_pad := name;
end;
name := ' '+name;
until 4 > 8;
front_pad := name;

end;

  function spad(name:string; num:longint): string;
begin;
repeat;
if length(name) >= num then
  begin;
  exit;
  spad := name;

   end;
name := name +' ';
until 4 > 8;
spad := name;

end;


function write_error(nu: integer) : string;
begin;

write_error := 'Unknown Error';
if nu =  1 then write_error := 'Invalid function number';
if nu =  2 then write_error := 'File not found';
if nu =  3 then write_error := 'Path not found';
if nu =  4 then write_error := 'Too many open files';
if nu =  5 then write_error := 'File access denied';
if nu =  6 then write_error := 'Invalid file handle';
if nu = 12 then write_error := 'Invalid file access code';
if nu = 15 then write_error := 'Invalid drive number';
if nu = 16 then write_error := 'Cannot remove current directory';
if nu = 17 then write_error := 'Cannot rename across drives';
if nu = 18 then write_error := 'No more files';
if nu =100 then write_error := 'Disk read error';
if nu =101 then write_error := 'Disk write error';
if nu =102 then write_error := 'File not assigned';
if nu =103 then write_error := 'File not open';
if nu =104 then write_error := 'File not open for input';
if nu =105 then write_error := 'File not open for output';
if nu =106 then write_error := 'Invalid numeric format';
if nu =150 then write_error := 'Disk is write-protected';
if nu =151 then write_error := 'Bad drive request struct length';
if nu =152 then write_error := 'Drive not ready';
if nu =154 then write_error := 'CRC error in data';
if nu =156 then write_error := 'Disk seek error';
if nu =157 then write_error := 'Unknown media type';
if nu =158 then write_error := 'Sector Not Found';
if nu =159 then write_error := 'Printer out of paper';
if nu =160 then write_error := 'Device write fault';
if nu =161 then write_error := 'Device read fault';
if nu =162 then write_error := 'Hardware failure';
if nu =163 then write_error := 'Strange Ass Error?! (unknown)';

if nu =200 then write_error := 'Division by zero';
if nu =201 then write_error := 'Range check error';
if nu =202 then write_error := 'Stack overflow error';
if nu =203 then write_error := 'Heap overflow error';
if nu =204 then write_error := 'Invalid pointer operation';
if nu =205 then write_error := 'Floating point overflow';
if nu =206 then write_error := 'Floating point underflow';
if nu =207 then write_error := 'Invalid floating point operation';
if nu =208 then write_error := 'Overlay manager not installed';
if nu =209 then write_error := 'Overlay file read error';
if nu =210 then write_error := 'Object not initialized';
if nu =211 then write_error := 'Call to abstract method';
if nu =212 then write_error := 'Stream registration error';
if nu =213 then write_error := 'Collection index out of range';
if nu =214 then write_error := 'Collection overflow error';
if nu =215 then write_error := 'Arithmetic overflow error';
if nu =216 then write_error := 'General Protection fault';
if nu =255 then write_error := 'Control Break Exit';

end;

 procedure WriteHexWord(w: word);
const
 hexChars: array [0..$F] of Char =
   '0123456789ABCDEF';
begin
 Write(hexChars[Hi(w) shr 4],
       hexChars[Hi(w) and $F],
       hexChars[Lo(w) shr 4],
       hexChars[Lo(w) and $F]);
end;

function dec2hex(w: integer) : string;
const
hex : array[0..15] of char = '0123456789ABCDEF';
var
h: string[4];
begin;
h[0] := char(4);
h[1] := hex[(W SHR 12)AND $0F];
h[2] := hex[(W SHR 8) AND $0F];
h[3] := hex[(W SHR 4) AND $0F];
h[4] := hex[(W) AND $0F];
dec2hex := h;
end;
 {$F+}

            procedure beep;
  var
  times,timer,o,e,step: longint;

  begin;
  o := random(2000)+50;
  e := random(2000)+50;
  step := random(30)+2;
  times := 0;
  timer := random(20)+20;
  repeat;
  sound(o);
  if o < e then
  inc(o,step)
  else dec(o, step);
  delay(10);
  nosound;
  inc(times);
  until times > timer;
  end;



function lmon(money: longint): string;
var
ho: string;
k,c: integer;
lmon1: string;
mo: longint;
quit: boolean;
begin;
quit := false;
lmon := lzz(money);
if length(lzz(money)) < 4 then exit;
ho := lzz(money);

k := length(ho);
c := 0;
lmon1 := '';
repeat;
lmon1 := lmon1 + ho[k];
dec(k);
inc(c);
if c = 3 then begin;
if k > 0 then begin;
lmon1 := lmon1 + ',';
 c := 0;
 end;
 end;

 if k = 0 then quit := true;
until quit = true;


lmon := reverse(lmon1);
end;

  function real_length(name: string) : string;

 var
ho: string;
i: integer;
label done;
begin;
ho := '';
for i := 1 to length(name) do
 begin;
 if name[i] <> '`' then ho := ho +name[i];
 if name[i] = '`' then inc(i);
 if i > length(name) then goto done;
 end;
done:
real_length := ho;
end;

function param_check(s: string): boolean;
var I: integer;
begin;
param_check := false;
for i := 1 to paramcount do
begin;
if up_string(s) = up_string(paramstr(i)) then
 begin;
 param_check := true;
 exit;
 end;
end;
end;

          function get_dir(s: string): string;
var s1: string;
begin;
s1 := ParamStr(0);

Delete(s1,Length(ParamStr(0)) - (length(s)-1),length(s)+1);
if s1[length(s1)] <> '\' then s1 := s1 +'\';
get_dir := s1;

end;


                         procedure strip_beginning_spaces(var s: string);
var I: integer;
label done,doit;
begin;

if s = '' then goto done;

for I := 1 to length(s) do
begin;
if s[i] <> ' ' then goto doit;
end;
goto done;
doit:
repeat;
if s[1] <> ' ' then goto done else
begin;
delete(s,1,1);
end;
until length(s) = 1;

done:
s := s;
end;



          function getvst(s:string;b:byte):string;
var
  v : string;
begin
  inc(b); v := '';
  while (b<=length(s)) and (s[b]<>#32) do
    begin
      v := v+s[b];
      inc(b);
    end;
  getvst := v;
end;

              function FileExists(FileName: string)
  : Boolean;
 var
  f: file;
begin
  {$I-}
  Assign(f, FileName);
  Reset(f);
  Close(f);
  {$I+}
  FileExists := (IOResult = 0) and
   (FileName <> '');
end;


     function hex2dec(what:string) : integer;
var
  i,rslt : integer;
begin
  rslt := 0;
  for i := 1 to length(what) do
    begin
      rslt := rslt shl 4;
      if what[i]<'A'
        then rslt := rslt+(ord(what[i])-$30)
        else rslt := rslt+(ord(what[i])-55);
    end;
  hex2dec := rslt;
end;


procedure seth_read_time(var realtime1:longint);
  var
    h, m, s, hund : Word;
    h1, m1, s1, hund1,realtime : longint;
begin;
 GetTime(h,m,s,hund);   h1 := h; m1 := m; s1 := s;
  hund1 := hund; realtime := (((h1*60)*60)*100);
  realtime := realtime + ((m1*60)*100); realtime := realtime + (s1*100);
  realtime := realtime + (hund1); realtime1 := realtime;
end;

function seth_wait(time_to_wait:longint): longint;
    var
    realtime,goal: longint;
begin;
  seth_read_time(Realtime);

 if time_to_wait > 0 then
 begin;
  goal := realtime+time_to_wait;
    repeat;
     seth_read_time(realtime);
    until realtime > goal;
 end;
seth_wait := realtime;
end;
function hex(i: byte): string;
const
 ss: string='0123456789ABCDEF';
var
 hibyte,lobyte: byte;
begin;
 hibyte:=i div 16;
 lobyte:=i-((i div 16)*16);
 hex:=ss[hibyte+1]+ss[lobyte+1];
end;

procedure HexFilt(var s: string);
var
 s2,s3: string;
 numst: string;
 r: real;
 a,b: integer;
 e: integer;
 d: longint;
 c: array[1..4] of byte absolute d;
begin;
 s:=s+#13;
 s2:='';
 numst:='';
 for a:=1 to length(S) do begin;
  if s[a] in ['0'..'9'] then numst:=numst+s[a] else begin;
   if (numst<>'') then begin;
    val(numst,r,b);
    str(r:0:0,s3);
    val(s3,r,b);
    e:=a-1;
    b:=0;
    repeat
     e:=e+1;
     if upcase(s[e])='H' then b:=1;
    until (s[e]=' ') or (e>=length(s)) or (s[e]=#13) or (s[e]=#10);
    if (r<2000000000) and (b=0) then begin;
     d:=trunc(r);
     numst:=hex(c[4])+hex(c[3])+hex(c[2])+hex(c[1]);
     while (length(numst)>0) and (numst[1]='0') do delete(numst,1,1);
     if (length(numst)=0) or (not (numst[1] in ['0'..'9'])) then numst:='0'+numst;
     numst:=numst+'h';
    end;
    s2:=s2+numst;
    numst:='';
   end;
   s2:=s2+s[a];
  end;
 end;
 delete(s2,length(s2),1);
 s:=s2;
end;

procedure HexToDec(var s: string);
const
 ss: string ='0123456789ABCDEF';
var
 d: longint;
 c: array[1..4] of byte absolute d;
begin;
 if length(s)=0 then exit;
 if upcase(s[length(s)])<>'H' then exit;
 if not (s[1] in ['0'..'9']) then exit;
 delete(s,length(s),1);
 if length(s)=0 then exit;
 while length(s)<8 do s:='0'+s;
 c[1]:=(pos(upcase(s[8]),ss)-1)+(pos(upcase(s[7]),ss)-1)*16;
 c[2]:=(pos(upcase(s[6]),ss)-1)+(pos(upcase(s[5]),ss)-1)*16;
 c[3]:=(pos(upcase(s[4]),ss)-1)+(pos(upcase(s[3]),ss)-1)*16;
 c[4]:=(pos(upcase(s[2]),ss)-1)+(pos(upcase(s[1]),ss)-1)*16;
 str(d,s);
end;

procedure delete_file(fn: string);
var
 f: file;
begin;
{$I-}
if exist(fn) then begin;
 assign(f,fn);
 erase(f);
{$I+}
end;
end;

function va(n: integer): string;
var
 v: string;
begin;
 str(n,v);
 if hexon then hexfilt(v);
 va:=v;
end;
function up_string(name:string):string;
var i: integer;
begin;
for i := 1 to length(name) do
name[i] := upcase(name[i]);
up_string := name;

end;


function wva(n: word): string;
var
 v: string;
begin;
 str(n,v);
 if hexon then hexfilt(v);
 wva:=v;
end;

function lva(n: longint): string;
var
 v: string;
begin;
 str(n,v);
 if hexon then hexfilt(v);
 lva:=v;
end;

function rva(n: real): string;
var
 v: string;
begin;
 str(n:0:0,v);
 if hexon then hexfilt(v);
 rva:=v;
end;

function stu(s: string): string;
var
 a: integer;
begin;
 for a:=1 to length(s) do s[a]:=upcase(s[a]);
 stu:=s;
end;

function locase(c: char): char;
begin;
 if (c>='A') and (c<='Z') then c:=chr(ord(c)+32);
 locase:=c;
end;

function stl(s: string): string;
var
 a: integer;
begin;
 for a:=1 to length(s) do s[a]:=locase(s[a]);
 stl:=s;
end;

Function exist(file_name: string): boolean;
var
 f: text;
 b: boolean;
begin;
 assigntxtfile(f,file_name);
 {$I-} reset(f); {$I+}
 if ioresult<>0 then b:=false else b:=true;
 if b then close(f);
 exist:=b;
end;

function namestr(s: string): string;
var
 a: integer;
begin;
 s:=stl(s);
 if length(s)>2 then begin;
  s[1]:=upcase(s[1]);
  for a:=1 to length(s) do begin;
   if (s[a] in ['.',' ',',',':',';','-','_','(',')']) and (a+1<length(s)) then s[a+1]:=upcase(s[a+1]);
  end;
 end;
 namestr:=s;
end;

procedure setmode(modenumber: byte);
var
 regs: registers;
begin;
 regs.ah:=0;
 regs.al:=modenumber;
 intr($10,regs);
end;

procedure set43lines;
var
 regs: registers;
begin;
 regs.ax:=$1112;
 regs.bx:=0;
 intr($10,regs);
 mem[$40:$87]:=mem[$40:$87] or $01;
 regs.ax:=$100;
 regs.bx:=0;
 regs.cx:=$0600;
 intr($10,regs);
end;

procedure set25lines;
var
 regs: registers;
begin;
 regs.ax:=$1111;
 regs.bx:=0;
 intr($10,regs);
 mem[$40:$87]:=mem[$40:$87] or $01;
 regs.ax:=$100;
 regs.bx:=0;
 regs.cx:=$0C00;
 intr($10,regs);
end;

function isega: boolean;
var
 regs: registers;
begin;
 regs.ah:=$12;
 regs.bx:=$10;
 intr($10,regs);
 if regs.bx=$10 then isega:=false else isega:=true;
end;

function QueryAdapterType: Adaptertype;
var
 regs: registers;
 code: byte;
begin;
 if isega then begin;
  regs.ah:=$12;
  regs.bx:=$10;
  intr($10,regs);
  if (regs.bh=0) then queryadaptertype:=egacolor else queryadaptertype:=egamono;
 end else begin;
  intr($11,regs);
  code:=(regs.al and $30) shr 4;
  case code of
   1: queryadaptertype:=cga;
   2: queryadaptertype:=cga;
   3: queryadaptertype:=mda;
  else queryadaptertype:=cga;
  end;
 end;
end;

procedure cursoroff;
var
 regs: registers;
begin;
 regs.ax:=$0100;
 regs.cx:=$2000;
 intr($10,regs);
end;

function determinepoints: integer;
var
 regs: registers;
begin;
 case queryadaptertype of
  cga: determinepoints:=8;
  mda: determinepoints:=14;
  egamono, egacolor: begin;
                      regs.ax:=$1130;
                      regs.bx:=0;
                      intr($10,regs);
                      determinepoints:=regs.cx;
                     end;
 end;
end;

procedure cursoron;
var
 regs: registers;
begin;
 regs.ax:=$0100;
 regs.ch:=determinepoints-2;
 regs.cl:=determinepoints-1;
 intr($10,regs);
end;

procedure cursorblock;
var
 regs: registers;
begin;
 regs.ax:=$0100;
 regs.ch:=1;
 regs.cl:=determinepoints-1;
 intr($10,regs);
end;
procedure cursorw;
var
 regs: registers;
begin;
 regs.ax:=$0100;
 regs.ch:=2;
 regs.cl:=determinepoints-1;
 intr($10,regs);
end;


function screenaddress: word;
begin;
 case queryadaptertype of
  cga: screenaddress:=$B800;
  mda: screenaddress:=$b000;
  egamono: screenaddress:=$b000;
  egacolor: screenaddress:=$b800;
 end;
end;

procedure savescreen;
var
 sc1: byte absolute $b000:0;
 sc2: byte absolute $b800:0;
begin;
 if screenaddress=$b000 then move(sc1,screen1^,4000);
 if screenaddress=$b800 then move(sc2,screen1^,4000);
 x:=wherex;
 y:=wherey;
end;

procedure restorescreen;
var
 sc1: byte absolute $b800:0;
 sc2: byte absolute $b000:0;
begin;
 if screenaddress=$b000 then move(screen1^, sc2,4000);
 if screenaddress=$b800 then move(screen1^, sc1,4000);
 gotoxy(x,y);
end;

function date_man: datetype;
var
 d,m,y,dow: word;
 s,s2: string[6];
begin;
 getdate(y,m,d,dow);
 y:=y-1900;
 s:=va(m);
 if length(s)=1 then s:='0'+s;
 s2:=va(d);
 if length(s2)=1 then s2:='0'+s2;
 s:=s+s2;
 s2:=va(y);
 if length(s2)=1 then s2:='0'+s2;
 s:=s+s2;
 date_man:=s;
end;

function bitcheck(n: word; b: byte): boolean;
var
 a,c: integer;
begin;
 a:=2;
 for c:=1 to b do a:=a*2;
 if (a and n)<>0 then bitcheck:=true else bitcheck:=false;
end;

procedure setbit(var n: word; b: byte);
var
 a,c: integer;
begin;
 a:=2;
 for c:=1 to b do a:=a*2;
 n:=(a or n);
end;

procedure resetbit(var n: word; b: byte);
var
 a,c: integer;
begin;
 a:=2;
 for c:=1 to b do a:=a*2;
 a:= not a;
 n:=(a and n);
end;

procedure copyfile(f1,f2: string);
var
 fi1,fi2: file;
 numread, numwritten: word;
 buf: array[1..2048] of char;
j: integer;
begin;
 assign(fi1,f1);
 j := 0;
 repeat;
inc(j);
 {$I-}
 reset(fi1,1);
 until (io_error = 0) or (j > 100);
 {$I+}
 j := 0;

repeat;
inc(j);
{$I-}

 assign(fi2,f2);
 until (io_error = 0) or (j > 100);
 {$I+}

 rewrite(fi2,1);
 repeat;
  blockread(fi1,buf,sizeof(buf),numread);
  blockwrite(fi2,buf,numread,numwritten);
 until (numread=0) or (numwritten<>numread);
 close(fi1);
 close(fi2);
end;

{$I-}        {  <<<============ Turn off I/O checking }

function HiLong(Long : LongInt) : Word;
Inline(
  $5A/       {pop      dx    ; low word of long}
  $58);      {pop      ax    ; hi word of long}

function LowLong(Long : LongInt) : Word;
Inline(
  $5A/       {pop      dx    ; low word of long}
  $58/       {pop      ax    ; hi word of long}
  $89/$D0);  {mov      ax,dx ; return lo word as function result in Ax}

function GetHandle(var F : File) : Word;
var
 Handle : Word absolute F;
begin
 GetHandle := Handle;
end;

function DosVer(var Minor : Word) : Word;
var
 Reg : Registers;
Begin
 with Reg do begin
   Ax := $3000;
   MsDos(Reg);
   DosVer := Al;
   Minor  := Ah;
 end;
end;

function LockFile(Handle : Word; FilePosition,FileLength : LongInt) : Word;
var
 Reg : Registers;
 H,L,Minor : Word;
begin
 if DOS_Major < 3 then begin
  LockFile := 1;
  Exit;
 end;
 with Reg do begin
  Ax := $5C00; {DOS call 5Ch}
  Bx := Handle;
  Cx := HiLong(FilePosition);
  Dx := LowLong(FilePosition);
  Si := HiLong(FileLength);
  Di := LowLong(FileLength);
  MsDos(Reg);
  if ((Flags and 1) <> 0) then LockFile := Ax else LockFile := 0;
 end;
end;

function UnLockFile(Handle : Word; FilePosition,FileLength : LongInt) : Word;
var
 Reg : Registers;
 H,L,Minor : Word;
begin
 if DOS_Major < 3 then begin
  UnLockFile := 1;
  Exit;
 end;
 with Reg do begin
  Ax := $5C01; {DOS call 5Ch, subfunction 1}
  Bx := Handle;
  Cx := HiLong(FilePosition);
  Dx := LowLong(FilePosition);
  Si := HiLong(FileLength);
  Di := LowLong(FileLength);
  MsDos(Reg);
  if ((Flags and 1) <> 0) then UnLockFile := Ax else UnLockFile := 0;
 end;
end;

function RetryFile(Handle,Wait,Retry : Word) : Word;
var
  Reg : Registers;
begin
 if DOS_Major < 3 then begin
  RetryFile := 1;
  Exit;
 end;
 with Reg do begin
   Ax := $440B;
   Bx := Handle;
   Cx := Wait;
   Dx := Retry;
   MsDos(Reg);
   if ((Flags and 1) <> 0) then RetryFile := Ax else RetryFile := 0;
 end;
end;


procedure strip_end_spaces(var name: string);
var count: integer;
label done;
begin;
count := length(name);
repeat;
if name[count] = ' ' then delete(name,length(name),1) else goto done;
if name = '' then goto done;
if name = ' ' then goto done;
until count < length(name);
done:
name := name;
end;

function reverse(st: string):string;
var
j: string;
k: integer;
begin;
j := '';
k := length(st);
repeat;
j := j + st[k];
dec(k);
until k = 0;
reverse := j;
end;


procedure trim(fn:string;n1:longint);

var
f,g: text; h: string; old_size: longint;
hold: string;

label pass;
begin;
dec(n1,2);
if exist(fn) then
   begin;
    assigntxtfile(f, fn);  reset(f);
    old_size := 0;
     repeat;
      readln(f, hold);
      inc(old_size);
     until eof(f);
    close(f);
    if old_size < n1 then exit;
    old_size := old_size - n1;
    assigntxtfile(f, fn);  reset(f);
    assigntxtfile(g, 'NANA.TMP');
    rewrite(g);
     repeat;
      readln(f, h);
      if old_size > 0 then dec(old_size);
      if old_size = 0 then begin;
      writeln(g, h);
     end;
    until eof(f);
 pass:
    close(f);
    close(g);
    delete_file(fn);
    copyfile('NANA.TMP',fn);
    delete_file('NANA.TMP');
  end;

end;

function num_of_num(ev: string): integer;
var
o,l : integer;
begin;
l := 0;
for o := 1 to length (ev) do
  begin;
   case ev[o] of
'0'..'9': inc(l);
     end;

  end;
num_of_num := l;
end;

 {$F+}

function get_word(s: string; num: integer): string;
var
i: integer;
word: integer;
space: boolean;
res: string;
begin;
space := false;
word := 1;
strip_beginning_spaces(s);
strip_end_spaces(s);
s := s +' ';
res := '';
if num < 1 then exit;
for i := 1 to length(s) do
  begin;
  if s[i] <> ' ' then
    begin;
    res := res + s[i];
    if space then inc(word);
    space := false;
    end else

    begin;
    if space = false then
      begin;
      space := true;
        if word = num then
    if space then
    begin;
    get_word := res;
    exit;
    end;
    res := '';
      end;
    end;


  end;
  get_word := '';

end;


begin;
 DOS_Major := DosVer(DOS_Minor);
 hexon:=false;
  new(screen1);
end.