/************************************************************************/
/*                                                                      */
/*              Script to archive the FtpServer log files               */
/*                                                                      */
/*   Depending on what Setup options you have chosen, FtpServer writes  */
/*   up to three log files, whose default names are FTPTRANS.LOG,       */
/*   FTPUSERS.LOG, and COMMON.LOG.  This script moves those three       */
/*   files, with renaming, to the 'LOGS' subdirectory.  It will not     */
/*   attempt to move nonexistent files, so it will work even if you     */
/*   have enabled only a subset of the available logging options.       */
/*   It will also work if you have changed the log file names.          */
/*                                                                      */
/*   Note, however, that the destination directory for the archived     */
/*   files is hard-coded.  If you want to use a different directory,    */
/*   you will have to modify line 71 of this script.  If you want the   */
/*   three log files to go to three different directories, or some      */
/*   similar variant, you will have to modify the code.                 */
/*                                                                      */
/*   Programmer:      P. Moylan                                         */
/*   Last modified:   15 June 2003                                      */
/*                                                                      */
/*   Installation:                                                      */
/*      Put this file in the same directory as FTPD.INI (normally       */
/*      the main FtpServer directory).  Alternatively, create a         */
/*      program object whose working directory is the directory that    */
/*      contains FTPD.INI.                                              */
/*                                                                      */
/*   Usage:    MoveLog        (with no parameters)                      */
/*                                                                      */
/*   This, however, is for a single execution.  To make this script     */
/*   really useful you should arrange to run it periodically, using     */
/*   any of the cron-like utilities for OS/2.  My own approach is to    */
/*   create a program object for this file, and use the 'schedule'      */
/*   feature of DragText to run it on the first day of every month.     */
/*                                                                      */
/************************************************************************/

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

call MoveLogFile 'TransLogName', 'FTPTRANS.LOG', 'T'
call MoveLogFile 'UserLogName', 'FTPUSERS.LOG', 'U'
call MoveLogFile 'CommonLogName', 'COMMON.LOG', 'C'
EXIT 0

/****************************************************************/

MoveLogFile: PROCEDURE

    /* Move one log file.  */

    PARSE ARG keyname, default, prefix

    INIfile = 'FTPD.INI'
    fname = SysIni(INIfile, '$SYS', keyname)
    IF fname = 'ERROR:' THEN fname = default
    CALL MoveFile fname, prefix
    RETURN

/****************************************************************/

MoveFile: PROCEDURE

    /* Move one file.  */

    PARSE ARG srcfile, prefix

    IF STREAM(srcfile, 'C', 'QUERY EXISTS') \= '' THEN DO
        dstfile = prefix||DATE('S')||'.log'
        '@RENAME 'srcfile' 'dstfile
        '@MOVE 'dstfile 'logs >nul'
    END /* do */
    RETURN

