UNIT NlMan;
{ͻ}
{ Nodelist Manager                              Last changed: 02.03.97  SA }
{                                                                          }
{                         (C) Copyright 1989-97 by                         }
{       Dan Wulff, Jens Sandalgaard, Steen Christensen & Sren Ager        }
{                                                                          }
{ This source may not be given to anybody, without the written permission  }
{ from The Portal Team.                                                    }
{ͼ}
{$I POPDEFS.INC}

INTERFACE

USES Use32;

PROCEDURE NodeListManager;

IMPLEMENTATION

USES OpCrt, OpString, OpWindow, OpEdit, OpEntry, OpCmd, OpField, OpFrame,
     OpMenu, OpKey, OpSelect, OpRoot,
     Globals, NodeList, Display, Input, KeyBoard, MailUtil, OproUtil, InterCom,
     Util, Resource, PoPTypes;

  PROCEDURE ShowFlags(ASP: AbstractSelectorPtr); far;
  VAR
    s : STRING;
  BEGIN
    WITH nodelistentry DO
    BEGIN
      IF Flags AND 1<>0 THEN s:='Hub ' ELSE s:='';
      IF Flags AND 2<>0 THEN s:=s+'Host ';
      IF Flags AND 4<>0 THEN s:=s+'RC ';
      IF Flags AND 8<>0 THEN s:=s+'Zone Gate ';
      IF Flags AND 16<>0 THEN s:=s+'Crash ';
    END;
    FastWrite(Pad(s,30),18,19,Cfg.Color[2].FieldColor);
  END;

  PROCEDURE NodeListManager;
  VAR
    Adr         : TFidoAddress;
    ExitCommand : WORD;
    m           : TPoPMenu;
    oldnl       : NodeListRecType;
    esr         : TPoPEntryScreen;
    FuncKeyWin  : windowptr;

    FUNCTION nodechanged : Boolean;
    VAR
      b : Boolean;
      i : Integer;
      o : ARRAY[1..1000] OF Char ABSOLUTE oldnl;
      n : ARRAY[1..1000] OF Char ABSOLUTE nodelistentry;
    BEGIN
      b:=False;
      i:=0;
      REPEAT
        Inc(i);
        b:=(o[i]<>n[i]);
      UNTIL b OR (i=SizeOf(NodeListRecType));
      nodechanged:=b;
    END;

    PROCEDURE checkedit;
    BEGIN
      IF nodechanged THEN
      BEGIN
        IF Confirm('Changes not saved, save >','Y',8) THEN
          WriteNode(nodelistentry);
      END;
    END;

    PROCEDURE DeleteNode;
    VAR
      WaitWin : PWait;
      i:LONGINT;
      buf:ARRAY[1..10240] OF CHAR;
      oldnp,test,ps:INTEGER;
      f:FILE;
      EndFlag:BOOLEAN;
    BEGIN
      IF Confirm('Delete current node','N',8) THEN
      BEGIN
        New(WaitWin, Init(9, 2, 'Deleting current node'));
        CASE Cfg.NodeListTyp OF
          NewNodeListType : BEGIN
            ASSIGN(f,Cfg.NodeList+'NODELIST.DAT'); FileMode:=ShareRW+ShareDenyW;
            RESET(f,SizeOf(NewNodeList));
            ps:=SizeOf(NewNodeList);
          END;
        END;
        EndFlag:=FALSE;
        OldNP:=NodePos;
        SEEK(f,NodePos+1);
        WHILE NOT EndFlag DO
        BEGIN
          i:=FilePos(f);
          BLOCKREAD(f,buf,10240 DIV ps,test);
          EndFlag:=EOF(f);
          SEEK(f,i-1);
          BLOCKWRITE(f,buf,test);
          WaitWin^.Animate;
        END;
        SEEK(f,FILESIZE(f)-1);TRUNCATE(f);
        CLOSE(f);
        CASE Cfg.NodeListTyp OF
          NewNodeListType : BEGIN
            ASSIGN(f,Cfg.NodeList+'NODELIST.IDX'); FileMode:=ShareRW+ShareDenyW;
            RESET(f,SizeOf(NewNodeListIndex));
            ps:=SizeOf(NewNodeListIndex);
          END;
        END;
        SEEK(f,NodePos+1);
        EndFlag:=FALSE;
        WHILE NOT EndFlag DO
        BEGIN
          i:=FilePos(f);
          BLOCKREAD(f,buf,10240 DIV ps,test);
          EndFlag:=EOF(f);
          SEEK(f,i-1);
          BLOCKWRITE(f,buf,test);
          WaitWin^.Animate;
        END;
        SEEK(f,FILESIZE(f)-1);TRUNCATE(f);
        CLOSE(f);
        DeAllocateNodeListIndex;
        InitialiseNodeList(Cfg.NodeList,Cfg.NodeListTyp);
        NodePos:=OldNP;
        IF NOT FindPreviousNode(NodeListEntry) THEN
          FindNextNode(NodeListEntry);
        oldnl:=NodeListEntry;
        Dispose(WaitWin, Done);
        Esr.Draw;
      END;
    END;

    PROCEDURE CreateNode;
    TYPE
      BufType=ARRAY[1..2048] OF CHAR;
    VAR
      i,j     : Integer;
      LastCmd,
      key     : Word;
      nodf    : FILE;
      buf     : ^BufType;
      WaitWin : PWait;
    BEGIN
      GetMenu(MnuNLInsNode,3,m);
      m.ProcessMenu(Key, LastCmd);
      IF LastCmd<>ccQuit THEN
      BEGIN
        New(Buf);
        New(WaitWin, Init(8, 3, 'Making room for nodelist entry'));
        IF Key=1 THEN j:=0 ELSE j:=1;
        CASE Cfg.NodeListTyp OF
          NewNodeListType : BEGIN
            ASSIGN(nodf,Cfg.NodeList+'NODELIST.DAT'); FileMode:=ShareRW+ShareDenyW;
            RESET(nodf,SizeOf(NewNodeList));
          END;
        END;
        FOR i:=FileSize(nodf)-1 DOWNTO NodePos+j DO
        BEGIN
          Seek(nodf,i);
          BLOCKREAD(nodf,buf^,1);
          BLOCKWRITE(nodf,buf^,1);
          WaitWin^.Animate;
        END;
        CLOSE(nodf);
        WRITELN;
        CASE Cfg.NodeListTyp OF
          NewNodeListType : BEGIN
            ASSIGN(nodf,Cfg.NodeList+'NODELIST.IDX'); FileMode:=ShareRW+ShareDenyW;
            RESET(nodf,SizeOf(NewNodeListIndex));
          END;
        END;
        FOR i:=FileSize(nodf)-1 DOWNTO NodePos+j DO
        BEGIN
          Seek(nodf,i);
          BLOCKREAD(nodf,buf^,1);
          BLOCKWRITE(nodf,buf^,1);
          WaitWin^.Animate;
        END;
        CLOSE(nodf);
        IF j=1 THEN INC(NodePos);
        Dispose(Buf);
        FillChar(NodeListEntry,SizeOf(NodeListEntry),0);
        DeAllocateNodeListIndex;
        InitialiseNodeList(Cfg.NodeList,Cfg.NodeListTyp);
        Dispose(WaitWin, Done);
      END;
    END;

    PROCEDURE Search_Node;
    VAR
      SearchAdr : TFidoAddress;
      ExitCommand     : WORD;
      i : Integer;

      PROCEDURE InitMenu;
      BEGIN
        GetMenu(MNUNlSearchOpt,3,m);
        IF NOT (NOT Cfg.NLCompiler.UseFidoUserLst) AND
               (Cfg.NodeListTyp=NewNodeListType) THEN m.protectitem(4);
        IF Cfg.NodelistTyp=Version7 THEN
        BEGIN
          m.protectItem(2);
          m.protectItem(3);
          m.protectItem(4);
        END;
      END;

      PROCEDURE search_for_node(CONST title: s40);
      LABEL
        SearchForSysOp;
      VAR
        f : TBufTextFile;
        Break, Found : Boolean;
        temp2 : WindowPtr;
        WaitWin : PWait;
        ss : STRING;
        s : S40;

        PROCEDURE showwait;
        BEGIN
          New(WaitWin, Init(10, 4, 'Searching. Hit ESC to interrupt'));
        END;

      BEGIN
        s:='';
        IF InputString(18,8,30,30,3,'Search by '+title,title+' : ',s) THEN
        BEGIN
          showwait;
          Found:=False;
          s:=StUpCase(s);
          IF StUpCase(title)<>'SYSOP NAME' THEN
          BEGIN
SearchForSysOp:
            FindFirstNode(nodelistentry);
            REPEAT
              Break:=GotESC;
              IF Pos(s, StUpCase(nodelistentry.SysOpName)) > 0 THEN
              BEGIN
                oldnl:=nodelistentry;
                Dispose(WaitWin, Done);
                esr.Draw;
                Found:=NOT Confirm('Data found. Search for more','Y',10);
                ShowWait;
              END;
              WaitWin^.Animate;
            UNTIL Break OR Found OR NOT FindNextNode(nodelistentry);
          END ELSE
          BEGIN
            IF Cfg.NodeListTyp=NewNodeListType THEN
            BEGIN
              s:=StUpCase(s);
              Break:=False;
              IF f.Init(Cfg.NodeList+'FIDOUSER.LST', SOpenRead, Max64k(MaxAvail-1024)) THEN
              BEGIN
                WHILE NOT f.EoF AND NOT Break AND NOT Found DO
                BEGIN
                  f.ReadLn(ss);
                  Break:=GotESC;
                  IF POS(s,StUpCase(ss))>0 THEN
                  BEGIN
                    Dispose(WaitWin, Done);
                    MyWin(Temp2,3,5,77,7,3,'SysOp name',True);
                    Temp2^.wFastText(ss,1,1);
                    Found:=NOT Confirm('Data found. Search for more','Y',10);
                    KillWindow(Temp2);
                    ShowWait;
                  END;
                  WaitWin^.Animate;
                END;
                f.Done;
              END;
            END ELSE
            BEGIN
              GOTO SearchForSysOp;
            END;
          END;
          Dispose(WaitWin, Done);
          IF NOT ((StUpCase(title)='SYSOP NAME') AND
                  (Cfg.NodeListTyp=NewNodeListType)) THEN
          BEGIN
            IF NOT Found OR Break THEN
            BEGIN
              Call.Zone:=OldNl.Adr.Zone;
              Call.Net:=OldNl.Adr.Net;
              Call.Node:=OldNl.Adr.Node;
              Call.Point:=OldNl.Adr.Point;
              IF FindNode(Call,nodelistentry) THEN
              BEGIN
                esr.Draw;
                oldnl:=nodelistentry;
              END;
            END;
          END ELSE
          BEGIN
            IF Found THEN
            BEGIN
              i:=60;
              WHILE ss[i]<>' ' DO
                DEC(i);
              s:=COPY(ss,i+1,60);
              IF GetAdressFromStr(s,Call) AND FindNode(Call,NodelistEntry) THEN
              BEGIN
                esr.Draw;
                oldnl:=nodelistentry;
              END;
            END;
          END;
        END;
      END;

    BEGIN
      checkedit;
      InitMenu;
      m.Process;
      i:=m.MenuChoice;
      m.Erase;
      IF m.GetLastCommand<>ccQuit THEN
      BEGIN
        CASE i OF
          1 : BEGIN               (* address *)
                FillChar(SearchAdr, SizeOf(SearchAdr), 0);
                SearchAdr.Zone:=NodeListEntry.Adr.Zone;
                SearchAdr.Net:=NodeListEntry.Adr.Net;
                IF GetAddress(6,3,SearchAdr,1501) THEN
                BEGIN
                  IF FindNode(SearchAdr,nodelistentry) THEN oldnl:=nodelistentry ELSE
                  BEGIN
                    SearchAdr:=OldNl.Adr;
                    FindNode(SearchAdr,nodelistentry);
                  END;
                  ESR.draw;
                END;
              END;
          2 : search_for_node('System name');
          3 : search_for_node('Misc. info');
          4 : search_for_node('SysOp name');
        END;
      END;
      m.Done;
    END;

  BEGIN
{$IFNDEF PoPLite}
    FillChar(Call, SizeOf(Call), 0);
    IF Not SetInterCom(ICNLMan,Call,False) THEN Exit;
    IF (NodeListPathStr<>'') OR (Cfg.NodelistTyp=Version7) THEN
    BEGIN
      MyWin(FuncKeyWin,1,ScreenHeight-1,80,ScreenHeight,2,'',False);
      WITH Cfg.Color[2],FuncKeyWin^ DO
      BEGIN
        wFastWrite('                F2=Delete node  F3=Create new   F4=Save Node  F5=Search         ',1,1,HighLightColor);
        wFastWrite('F6=Host         F7=RC           F8=Zone gate    F9=Hub        F10=Crash         ',2,1,HighLightColor);
      END;
      Adr:=Cfg.Addresses[Cfg.MainAdrNum];
      IF FindNode(Adr,nodelistentry) THEN oldnl:=nodelistentry ELSE
      BEGIN
        Adr.Point:=0;
        IF FindNode(Adr,nodelistentry) THEN oldnl:=nodelistentry ELSE
          IF FindFirstNode(NodeListEntry) THEN oldnl:=nodelistentry;
      END;
      GetEsr(EsrNLManager,2,esr);
      Esr.SetScreenUpdateProc(ShowFlags);
      WITH esr,nodelistentry DO
      BEGIN
        EntryCommands.AddCommand(ccUser0,1,F10,0);
        EntryCommands.AddCommand(ccNextRec,1,PgDn,0);
        EntryCommands.AddCommand(ccPrevRec,1,PgUp,0);
        FOR ExitCommand:=0 TO 7 DO
          EntryCommands.addcommand(ccUser2+ExitCommand,1,WORD(256*(60+ExitCommand)),0);
        exitcommand:=ccUser0;
        Draw;
        REPEAT
          IF exitcommand IN [ccUser0,ccUser3..ccUser9,ccPrevRec,ccNextRec] THEN
          BEGIN
            TextAttr:=cfg.color[2].TextColor;
          END;
          Process;
          exitcommand:=GetLastCommand;
          CASE ExitCommand OF
            ccUser2 : IF Cfg.NodeListTyp=NewNodeListType THEN DeleteNode;
            ccUser3 : IF Cfg.NodeListTyp=NewNodeListType THEN CreateNode;
            ccUser4 : IF Cfg.NodeListTyp=NewNodeListType THEN
                      BEGIN
                        IF WriteNode(nodelistentry) THEN oldnl:=nodelistentry;
                      END;
            ccUser5 : search_node;
            ccUser6 : IF Cfg.NodeListTyp=NewNodeListType THEN Flags:=Flags XOR 2;
            ccUser7 : IF Cfg.NodeListTyp=NewNodeListType THEN Flags:=Flags XOR 4;
            ccUser8 : IF Cfg.NodeListTyp=NewNodeListType THEN Flags:=Flags XOR 8;
            ccUser9 : IF Cfg.NodeListTyp=NewNodeListType THEN Flags:=Flags XOR 1;
            ccUser0 : IF Cfg.NodeListTyp=NewNodeListType THEN Flags:=Flags XOR 16;
            ccPrevRec : BEGIN
                          IF Cfg.NodeListTyp=NewNodeListType THEN checkedit;
                          IF NOT FindPreviousNode(nodelistentry) THEN
                          BEGIN
                            Write(#7);
                            nodelistentry:=oldnl;
                          END ELSE
                            oldnl:=nodelistentry;
                        END;
            ccNextRec : BEGIN
                          IF Cfg.NodeListTyp=NewNodeListType THEN checkedit;
                          IF NOT FindNextNode(nodelistentry) THEN
                          BEGIN
                            Write(#7);
                            nodelistentry:=oldnl;
                          END ELSE
                            oldnl:=nodelistentry;
                        END;
          END;
          IF Cfg.NodeListTyp=NewNodeListType THEN
            IF exitcommand IN [ccNextRec,ccPrevRec,ccquit] THEN checkedit;
        UNTIL ExitCommand=ccquit;
      END;
      Esr.Done;
      KillWindow(FuncKeyWin);
      DeAllocateNodeListIndex;
      InitialiseNodeList(Cfg.NodeList,Cfg.NodeListTyp);
    END;
{$ENDIF}
  END;

END.
