/********************************************************************
 * Ezycom structures V1.48g0 29/11/96
 * by Peter Davies
 *
 * These structures may ONLY be used in accordance with those
 * agreements laid out in the Official Ezycom Structures.
 * Peter Davies takes no responsibility whatsoever
 * for the correctness of these structures.
 *
 * If, you find any faults please notify us of them.
 *
 * Please refer to the pascal structures for more explanation, before
 * querying us
 *
 ********************************************************************/

#ifndef EZYCOMH

#define EZYCOMH

#define  word    unsigned short
#define  byte    unsigned char
#define  longint signed   long int
#define  sword	 signed   short

#define  EZYVER "1.48"
#define  VERSIONHIGH 1
#define  VERSIONLOW 48
#define  PRODNAME "Ezycom"
#define  COPYRIGHT "Peter Davies"
#define  COPYRIGHTYEAR "1992-1996"
#define  MAXFREE  1275
#define  USERFREE 121
#define  CONSTANTFILEFREESPACE 439
#define  MAXNODES 256
#define  MAXAKA 32
#define  MAXMESSALL 1536
#define  MAXMESS    MAXMESSALL
#define  MAXBAUDREC 22
#define  FLTMAXSIZE  2048   //      maximum size of a file description

/****** Take Note ********************************************************
Boolean can be defined as a Char value under C or as an enum with a
true/false value under C++ (if compiled with enum to char switch)
**************************************************************************/
/* typedef char Boolean; */

/* Swapping Types : 0=None, 1=Ems, 2=Xms, 3=Disk, 4=EmsXms, 5=XmsEms */

/* The following can also be defined as enum under C++ */

typedef unsigned char AskType;        // 0=yes,1=no,2=ask default yes,
                                      // 3=ask default no
typedef unsigned char PhoneType;      // 0=business,1=data,2=nophone

typedef unsigned char MsgType;

#define mtLocal     0
#define mtNetMail   1
#define mtEchoMail  2
#define mtPassThru  3
#define mtWaitThru  4
#define mtAllMail   5
#define mtInternet  6
#define mtNews      7
#define mtFax       8

typedef unsigned char MsgKindsType;   // 0=public,1=private,2=both
typedef unsigned char ShowFileSizeType; // 0=nosize,1=bytes,2=kilobytes
typedef char MaxStr[256];
typedef char UserString[36];
typedef char FileStr[13];    // max length of a FileName
typedef char DomainStr[21];  // domain string
typedef char AreaTagStr[76];
typedef char Str3[4];
typedef char Str4[5];
typedef char Str8[9];
typedef char Str12[13];
typedef char Str23[24];
typedef char Str30[31];
typedef char Str72[73];
typedef char Str128[129];
typedef unsigned char FlagType[4];
typedef unsigned char GroupType[4];

typedef struct DateTime {
   word  Year,
	      Month,
	      Day,
	      Hour,
	      Min,
   		Sec;
} DateTime;

typedef struct SecurityType {
  word      Security;
  FlagType  OnFlags,
            OffFlags;
} SecurityType;

typedef struct DateRecord {
  word      Year;
  byte      Month,
            Day;
} DateRecord;

typedef struct NetRecord {
  word      Zone,
            Net,
            Node,
            Point;
} NetRecord;

typedef struct Net5DRecord {
  word       Zone,
             Net,
             Node,
             Point;
  DomainStr  Domain;
} Net5DRecord;


/**********************************************************

  FileName:    <configrec.userbasepath>USERS.BBS

  Description: Users File
	             Records in parrallel with USERSEXT.BBS

  Limitations: 65000 records (users) maximum

	attribute
	  Bit 0 : Deleted
	      1 : Clear Screen
	      2 : More Prompt
	      3 : Ansi Capable
	      4 : Don't Kill User
	      5 : File Points Ignore
	      6 : Full Screen Ed
	      7 : Quiet Mode

	attribute2
	  Bit 0 : Ignore File Ratios
	      1 : Extended IBM Characters
	      2 : On = MMDDYY Off = DDMMYY
	      3 : Ignore Paging Hours
	      4 : Exclude User
	      5 : Avatar Capable
	      6 : Ignore Menu Time Restrictions
	      7 : Ignore Message Ratios

	attribute3
	  Bit 0 : Do Not Sound Page
	      1 : Page on Logon
	      2 : Hold Mailbox
	      3 : Use Combined Mailbox
	      4 : Gender (Off = Male, On = Female)
        5 : Guest Account
	    6-7 : [Reserved]

	attribute4
		Bit 0-7 [Reserved]

**********************************************************/

  typedef struct UsersRecord {
    UserString  Name,
                Alias;
    char        Password[16];
    word        Security;
    byte        Attribute,
                Attribute2,
                Attribute3,
                Attribute4;
    FlagType    Flags;
    char        DataPhone[15],
                VoicePhone[15];
  } UsersRecord;


/**********************************************************

  FileName:     <configrec.userbasepath>USERSEXT.BBS

  Description:  Extended Users Information
	             Records in parrallel with USERS.BBS

 **********************************************************/

  typedef struct UsersExtraRecord {
    char        Location[26];
		longint     LastTimeDate;    // DOS Packed Date/Time
    word        Credit,          // Users netmail credit
                Pending,         // Netmail cost pending export
                MsgsPosted,
                NoCalls,
                Uploads,
                TodayK,
                TimeUsed,
                Downloads;
    longint     UploadsK,
                DownloadsK;
    char        ScreenLength,
                LastPwdChange;
    word        TimeBanked,
                KsBanked,
                FilePoints;
    byte        QWKCompression,
                QWKDaysOld;
    char        Comment[41];     // Sysop/User Comment
    byte        Colour1_2,       // To retrieve the first colour & 15
                Colour3_4,       // To retrieve the second colour >> 4
                Colour5_6,
                Colour7_8,
                BKColour,
                SessionFailures;  // Number of Session Failures since last
                                  // successful logon
    Str8        TopMenu;          // User's Top Menu
    word        FilePointsGiven;  // Number of Filepoints credited since last logon
    DateRecord  DateOfBirth;
    GroupType   Groups;           // user's group setting (compressed)
    word        RegoDate,         // Start of Registration
                FirstDate,        // Date of First Logon
                LastFileDate;     // Last Time a New Files Search was done
    char        DefProtocol;      // Blank means no default protocol
    word        TimeLeft,         // Users remaining time for today
                FileArea,         // Last file area user used
                MessArea,         // Last message area user used
                QWKMaxMsgs,
                QWKMaxMsgsPerArea;
    sword       TodayBankWK;      // Kilobytes Withdrawn from Bank Today
                                  // Negative Numbers indicate Deposited
    UserString  ForwardTo;        // forward local mail to
    byte        TodayCalls;       // Times the user has called today
    sword       TodayBankWT;      // Time Withdrawn from Bank Today
                                  // Negative Numbers indicate Deposited
    byte        Language;         // users language
    word        EndRegoDate;      // End Registration Date
    longint     TotTimeUsed;      // Total Time Used by the User
                                  // since the last time this field was
                                  // reset.  Normally first logon
    char        LastBWPkt[4];     // name of last bw pkt extension
    char        ExtraSpace[USERFREE];
  } UsersExtraRecord;

/**********************************************************

  FileName:     <userbasepath>LASTCOMB.BBS

  Description:  Used be Ezycom for lastread & combined info

  Note:         This record adjusts when the number of
								conferences change (in steps of 16).
	              IE: 16 conferences takes up HALF of the
	              diskspace of 32 conferences

 **********************************************************/

  typedef struct UsersLastRecord {
    word        CombinedInfo;
    word        LastReadInfo[16];
  } UsersLastRecord;

/**********************************************************

  FileName:     <configrec.menupath>????????.MNU

  Description:  Menu Structure
	              Record 0 has a different record structure

  Mimimum    :    1 record
  Maximum    :  101 records


  Record 0 Structure

    typ     = HiLight Colour
    display = Menu Prompt
    colour  = Menu Prompt Colour

  all others are undefined

	securityattr
	  0 = Greater than/Equal to
	  1 = Greater than
	  2 = Less than/Equal to
	  3 = Less than
	  4 = Equal to
	  5 = Not Equal

  attribute                            Record 0 Attribute
    Bit 0 : Test Ratio K               Bit 0 : Enter Redraws
				1 : Test Message/Call Ratio
        2 : Automatic Option
	      3 : Test Ratio Files
	      4 : Local Keyboard Only
        5 : Remote Only
      6-15: [ Reserved ]

 **********************************************************/

  typedef struct MenuRecord {
    word          Typ;
    SecurityType  Security;
    word          MaxSecurity;
    char          Display[91];
    char          HotKey;
    char          MiscData[91];
    byte          Colour,
                  TimeOnline,
                  TimeLeft;
    word          TimeStart,
                  TimeEnd;        // Hours is "* 100"
    longint       MinBaudRate,
                  MaxBaudRate;
    word          FilePoints;
    byte          Age;
    word          Attribute;
    byte          Node[32];
    char          GenderAccess;    // M=Male F=Female B=Both
    char          PadTo384Bytes[134];
  } MenuRecord;

/**********************************************************

  FileName:    PROTOCOL.EZY

  Description: Protocol Record Structure

  Size       : 60 records

	attribute
	  Bit 0 : enable/disable
	      1 : batch protocol
	      2 : [ Reserved ]
	      3 : both directions
	      4 : up/down
	      5 : bidirectional
            6-7 : [ Reserved ]

 **********************************************************/

  typedef struct ProtocolRecord {
    char      Name[16];
    char      ActiveKey;
    byte      Attribute;
    char      LogFileName[61],
              CtlFileName[61],
              DnCtlString[61],
              DnCmdString[101],
              UpCmdString[101],
              UpLogKeyWord[11],
              DnLogKeyWord[11],
              UpErrKeyWord[11],
              DnErrKeyWord[11],
              UpErr2KeyWord[11],
              DnErr2KeyWord[11],
              XferNameWordNum,
              XferCPSWordNum;
    word      Security;
    FlagType  Flags;
    byte      Efficiency;
  } ProtocolRecord;

/**********************************************************

  FileName     : CONFIG.EZY

  Description  : Configuration Record

  Size         : 1 record (6144 bytes)

  Last Revised : 25/12/92(pwd)

	printerport
	  0 = LPT1
	  1 = LPT2
	  2 = LPT3
		3 = COM1
	  4 = COM2
	  5 = COM3
	  6 = COM4

	autodetect
	  Bit 0 : Auto Detect ANSI
	      1 : ANSI Detect for NewUser
	      2 : Auto Detect IEMSI
	      3 : IEMSI Detect for NewUser
        4 : Auto Detect RIP
       5-7: [Reserved]

	configattr
    Bit 0 : Move Local Uploads
      1-15: [Reserved]

	multitasker
	      0 = Do Not Detect or Use Any MultiTasker
	      1 = Auto-Detect
        2 = Desqview
	      3 = Double DOS
	      4 = OS/2
        5 = MultiDOS Plus
        6 = Taskview
        7 = Topview
        8 = Windows Enhanced Mode
    9..255= [Reserved]

***********************************************************/

  typedef struct ConfigRecord {
    Str8          Version;
    char          FreeSpace01[77],       // unused
                  LogPath[61],
                  aTextPath[61],
                  aMenuPath[61],
                  aMnuRamPath[61],
                  NetmailPath[61],
                  NodelistPath[61],
                  MsgPath[61],
                  FilePath[61],
                  FreeSpace02[61],        // unused
                  BinkleyOutPath[61],
                  TempPath[61],
                  UserBasePath[61],
                  aAvatarPath[61],
                  aAscPath[61],
                  aAscLowPath[61],
                  FileMaint[61],
                  FileAttachPath[61],
                  SoundPath[61],
                  FastIndexPath[61],
                  SystemPwd[16],          // Password to Logon System
                  SysopPwd[16],           // Password to Keyboard
                  NewuserPwd[16];         // Password for Newuser
    Str8          NewTopMenu;             // NewUser TopMenu
    byte          NewUserGroups[4];
    char          InboundMail[61],
                  OutboundMail[61],
                  UploadPath[61],
                  SwapFile[61],
                  MultiPath[61],
                  Brackets[3];
    byte          InactivityTime,
                  MinMessCheck,
                  MaxLoginTime;
    word          FreeSpace03;            // unused
    byte          ShellSwap,              // boolean
                  HighBit,                //    "
                  DispPass,               //    "
                  AskLocalPass,           //    "
                  FastLogon,              //    "
                  SysopRemote,            //    "
                  PrinterLog,             //    "
                  Phone1Ask,              //    "
                  ColourAsk,              //    "
                  AliasAsk,               //    "
                  DOBAsk,                 //    "
                  PhoneForce,             //    "
                  Direct_Video,           //    "
                  Snow_Check,             //    "
                  FreeSpace04,            // unused
                  Screen_Blank,
                  OneWord;                // BOOLEAN
    AskType       CheckMail,
                  CheckFile,
                  AnsiAsk,
                  FullScreenAsk,
                  ClearAsk,
                  MoreAsk,
                  AvatarAsk,
                  ExtendAsk,
                  USDateAsk;
    byte          Phone2Ask;              // BOOLEAN
    char          PhoneFormat[15],
                  FreeSpace04a[61],
                  FreeSpace04b[61],
                  ShellPrompt[61],
                  Shell2Prompt[61],
                  EnterPrompt[61],
                  ChatPrompt[61],
                  ListPrompt[61],
                  F7KeyLineTop[80],
                  F7KeyLineBot[80],
                  FreeSpace05[84],        // unused
                  Chat2Prompt[61],
                  FreeSpace05a[61],
                  Freespace05b[61],
                  FreeSpace05c[61],
                  FreeSpace05d[61],
                  LoadPrompt[61],
                  FreeSpace05e[61],
                  FreeSpace05f[61];
    word          Security,
                  LogonSecurity;
    FlagType      Flags;
    byte          MinPassLength,
                  DispFWind,              //  Status Bar Colour  constant
                  DispBWind,              //  Status Bar Colour     "
                  DispPopupF,             //  Popup Forground       "
                  DispPopupBorder,        //  Popup Border          "
                  DispPopupB,             //  Popup Background      "
                  DispF;                  //  Foreground Colour     "
    word          FreeSpace06;            // Unused
    byte          PassLogons,
                  DOBLogon,
                  PrinterPort,
                  PassTries;
    char          TopMenu[9];
    word          IncomingCallStart,
                  IncomingCallEnd;
    word          WatchMess,              // constant
                  NetmailCredit;          // constant
    longint       AnsiMinBaud;
    word          SlowBaud,
                  MinLoginBaud,
                  LowSecurityStart,
                  LowSecurityEnd,
                  SlowStart,
                  SlowEnd;
    char          QuoteString[6],
                  FreeSpace09;            // Unused
    byte          OffHook;                // BOOLEAN
    word          ForceCrashMail,
                  OptionCrashMail,
                  NetmailFileAttach;
    byte          PopupHighlight;         // Popup Highlight Colour (constant)
    byte          GenderAsk;              // boolean
    byte          MaxPages,
                  MaxPageFiles,
                  PageLength;
    word          PageStart[7],
                  FreeSpace50,            // Unused
                  LocalFAttachSec,
                  SecToUploadMess,
                  SecToUpdateUsers,
                  ReadSecNewEcho,
                  WriteSecNewEcho,
                  SysopSecNewEcho,
                  SecReplyViaNetmail;
    AskType       NetmailKillSent;
    byte          SwapOnArchive,
                  FreeSpace11[9],         // Unused
                  PopupText;              // Popup Text Colour (constant)
    word          PageEnd[7];
    word          StartPeriod;
    byte          FreeSpace12[24];        // Unused
    word          FP_Upload;              //  File Points Upload Credit
    char          AltF[10][61],
                  CtrlF[10][41],
                  FreeSpace13[4];
    word          FP_Credit;              // Newuser Filepoints
    byte          Ks_Per_FP,              // Number of Kilobytes per FP
                  FreeSpace14,            // unused
                  Rego_Warn_1,
                  Rego_Warn_2,
                  FreeSpace15[2];         // Unused
    word          Min_Space_1;            //  constant
    word          FreeSpace14b;           // Unused
    byte          ScrHeight,              // boolean  (* 43/50 line mode *)
                  MsgTmpType,             // boolean  (True=MSGTMP False=MSGTMP.<node>)
                  SwapUpload,             // boolean
                  PhoneLogon,
                  CarrierDetect,          // (* Carrier Detect (Default=$80) *)
                  NewFilesHighlight,      // boolean;
                  Max_Descrip,
                  Min_Descrip;
    word          RequestReceipt;
    char          FreeSpace16[16];
    word          FP_Percent;             // Download Filepoints Credit
    byte          AutoDetect,
                  DispSecurityFile,       // boolean
                  AskForPageReason,       // boolean
                  DelIncompleteFiles,     // boolean
                  FreeSpace18,            // unused
                  SwapOnFeditView,        // constant
                  FreeSpace19[2],         // unused
                  PassChar;
    byte          LocalInactivity;        // boolean
    char          FreeSpace20,            // unused
                  LeftBracket[2],
                  RightBracket[2];
    word          IgnoreFP;               // Min Security to Ignore FPs
    byte          MenuMinAge,             // Minimum Age for Age Checks
                  FreeSpace22[231];        // unused
    word          ConfigAttr;
    byte          UserCol1_2,
                  UserCol3_4,
                  UserCol5_6,
                  UserCol7_8,
                  UserBKCol,
                  NewUserCol2,
                  ChStatCol,
                  GetEnterCol,
                  USDateForSysop,         // boolean
                  EzyOvrPath[61];
    UserString    DefaultUploader;
    byte          OvrEMS,                 // boolean;
                  SwapEzy,
                  FileSecPath[61],
                  FreeSpace24,            // unused
                  MultiTasker;
    char          FreeSpace24b[3];
    word          FileReqSec;
    char          FreeSpace24c[255],
                  ExternalEditor[61],
                  DefaultOrigin[51];
    char          FreeSpace25[32];
    word          UploadCredit;           //  Upload Credit Percentage
    char          FreeSpace[MAXFREE];
  } ConfigRecord;

/**********************************************************

       FileName:    CONSTANT.EZY

       Description: Constant Configuration Information
		    The three following definitions
		       constantrecord
		       constantfilefreespacetype
		       compressrecord
		    make up the complete CONSTANT.EZY file
		    As shown in "constantfilerecord"

	   scantossattr
	      bit 0 : Dupe Detection
	          1 : Kill Null Netmail
	          2 : Keep EchoArea Node Receipts
	          3 : Import Messages to Sysop
	          4 : Binkley Support
	          5 : Kill Bad Archives
	          6 : ArcMail 0.6 Compatability
	          7 : Binkley 5D Support
            8 : Make Binkley Hut,Cut,etc
            9 : Erase Netmail File Attaches
         10-15: [Reserved]

	   constantattr
	      bit 0 : Sysop Alias in Chat
	          1 : Auto Log Chat
	          2 : Display Full Message to User
                  3 : Do not delete outbound mail bundles with no .MSG
                  4 : On means do not use real name kludge line
                  5 : User can write messages to user of same name
                  6 : Users receive QWK messages that they posted
                  7 : Show Sysop Online
                  8 : Allow Taglines in BlueWave
                  9 : Show Colour in File Areas
                 10 : Copy files from cd before download
                 11 : Local uploads/downloads only allowed from/to floppy disk
                 12 : Keep Batch History
	       13-15: [Reserved]

	   unknownarea
	          0 : Kill Messages
	          1 : Make a New EchoMail Area
            2 : Make a New PassThru Area


        Last Revision: 29-1-95
 **********************************************************/

  typedef struct ConstantRecord {
    char          Version[9],
                  System[41];
    UserString    SysopName,
                  SysopAlias;
    char          SystemLocation[36],
                  Multiline;              // boolean, multiline operation
    word          MaxMess,                //  maximum usable message areas
                  MaxFile,                //  maximum usable file areas
                  WatchMess,              //  watchdog message area
                  PageMessBoard,          //  paging message board
                  BadPwdMsgBoard;         //  bad logon message board
    byte          MinTimeForCall;         //  minimum time to register call today
    longint       DupeTableMsgs;          //  number of messages in ezymail dupe table
    word          MaxCDCopyK;             //  Maximum Size of CD Copy Buffer
    byte          FPDispChars,
                  UpldrDispChars,
                  DnCntDispChars;
    word          ExpireWarning;
    word          ScanTossAttr,           //  ezymail scan/toss info
                  ConstantAttr,
                  MaxMsgsRescan;          //  Maximum msgs to rescan (0=disable)
    Str8          QWKFileName;            //  Unique QWK Mail FileName
    word          QWKMaxMail,             //  Maximum Msgs for QWK archive
                  QWKMsgBoard;            //  Bad QWK Message Board
    char          UserFileDisplay[101],
                  SysopFileDisplay[101];
    word          MaxDaysOldUpload;       //  Maximum days old an upload can be
    word          MaxFileGroups;          //  Maximum File Groups
    byte          MaxOldNewFileCheck;     //  Maximum days old for new files new
    byte          CallTermTime;           //  Call Terminator Time
    byte          QuoteString[6],         //  quote messsage string
                  SwapOnEzyMail,          //  ezymail swapping information
                  UnknownArea,            //  unknown new area tag action
                  SwapOnFEditView,        //  FEdit swapping information
                  SwapOnArchive;          //  Ezymaint swapping information
    word          MinSpaceUpload;         //  minimum space to upload
    byte          TextInputColour;        //  default text input colour
    word          BadMsgBoard;            //  Bad echomail msg board
    NetRecord     NetAddress[MAXAKA];
    char          Domain[21][MAXAKA];
    word          NetmailBoard[MAXAKA];
    char          NewAreaGroup[MAXAKA];
    word          NewAreaStMess[MAXAKA];   //  New area start msg board
    word          NewAreaTemplate[MAXAKA]; // Template area for new areas
    char          SysopPwd[16];            // Pascal String
    char          ExitWaitCallPwd[16];     // Pascal String
    word          MaxMsgGroups;
  } ConstantRecord;

  typedef struct CompressRecord {
    char          EchoUnarcCmd[10][13],
                  EchoUnarcPar[10][19],
                  EchoArcCmd[10][13],
                  EchoArcPar[10][19];
  } CompressRecord;

  typedef unsigned char  ConstantFileFreeSpaceType[CONSTANTFILEFREESPACE];

    //        (* the following constants are the starting positions in
    //           CONSTANT.EZY of where to find these structures *)

  #define  STARTOFCOMPRESS  (sizeof(ConstantRecord) + sizeof(ConstantFileFreeSpaceType))

  typedef struct ConstantFileRecord {
    ConstantRecord             Constant;
    ConstantFileFreeSpaceType  FreeSpace;
    CompressRecord             Compress;
  } ConstantFileRecord;



/*************************************************************

  Filename:     MODEM.EZY

  Description:  Holds Modem Configuration Information

                Sequence of Reading
                   System>Modem.<node>
                   Current>Modem.Ezy
                   System>Modem.Ezy

  Records:      1

  Last Revised: 2/8/94

**************************************************************/

  typedef struct ModemRecord {
    char       Description[21];
    word       ComPort;
    longint    MaxBaud;
    byte       LockedPort,                // boolean
               ExtendedFossil,            // boolean
               AutoAnswer;                // boolean
    char       InitResponse[11],
               RingString[11];
    byte       InitTries;
    char       InitString1[61],
               InitString2[61],
               BusyString[21],
               AnswerString[21],
               NoCarrierString[21],
               ConnectFax[16];
    word       ModemStart,
               ModemEnd;
    byte       ModemDelay,     
               AnswerDelay,    
               SendBreak,                 // boolean
               OffHook,                   // boolean
               ModemBusy; // Toggle DTR or ATH1  (boolean)
    word       ModemEfficiency[MAXBAUDREC];
    longint    ModemBaud[MAXBAUDREC];
    char       ModemConnect[MAXBAUDREC][21];
    char       FreeSpace[167];
  } ModemRecord;



/**********************************************************

       FileName:    LIMITS.EZY

       Description: User Security Limits Information

 **********************************************************/

  typedef struct LIMITSRECORD {
    char          Comment[21];            // Security Comment (ZStr)
    word          Security,               // Security level
                  Time,                   // Time limit per day
                  Limit[MAXBAUDREC];
    char          Ratio;                  // File Ratio
    word          Credit;                 // File Ratio Credit
    byte          RatioK;                 // Kilobyte Ratio
    word          CreditK,                // Kilobyte Ratio Credit
                  RegoDays,               // Registration in Days
                  CreditMess,             // PCR Credit
                  Mess,                   // PCR (%)
                  TimePerCall;            // Time limit per call   0=Disabled
    byte          CallsPerDay;            // Maximum Calls Per Day 0=Disabled
    word          MaxBankWK,              // Maximum Withdraw Kilobytes Bank
                  MaxBankWT,              // Maximum Withdraw Time Bank
                  MaxBankDK,              // Maximum Deposit Kilobytes Bank
                  MaxBankDT,              // Maximum Deposit Time Bank
                  MaxKBank,               // Maximum Allowable Kilobytes in Bank
                  MaxTBank;               // Maximum Allowable Time in Bank
    byte          FreeSpace[32];
  } LimitsRecord;

/**********************************************************

  FileName     : FILES.EZY

  Description  : Stores file area information

  Last Revised : 25/2/92(pwd)

  Records      : 1..65000

  Note         : FILEPATH.EZY must have the same amount
                 of records.

  attribute
    Bit 0 : keep files offline
        1 : offline allowed
        2 : sortby date
        3 : sortby alpha
        4 : master list
        5 : show in new files check
        6 : No Descriptions asked after Upload
        7 : show in ezymast master list

  attribute2
    Bit 0-7 : [Reserved]

  convert
        0 = none
        1 = zip
        2 = lzh
        3 = arj
        4 = pak
        5 = arc
        6 = zoo
        7 = sqz
        8 = rar
    9-255 = [ Reserved ]

 **********************************************************/

  typedef struct FilesEzyRecord {
    char          Name[31];
    byte          Attribute,
                  Attribute2,
                  Convert;
    byte          FileGroup,
                  AltGroups[3];
    byte          MinimumAge;
    word          UpFileArea,
                  AreaPath;               // relates to FILEPATH.EZY
                  SecurityType  ListSecurity,
                  UpSecurity,
                  SysSecurity;
    word          NumDaysToDel,
                  NumArrivalDaysToDel,
                  NumDaysLastDownload,
                  FileIdxPos;
    char          FreeSpace[47];
  } FilesEzyRecord;

/***********************************************************

       Filename:     <systempath>FILES.IDX

       Description:  Used by Ezycom as an index into the
                     file areas.  Only used areas are stored
                     in here.  CRCs are calculated the same
                     as that for the fast message record.  Later
                     on, it is planned to provide serveral linked
                     lists, so you can traverse the index in
                     sorted orders.

                     The first Record is intentionally left
                     blank.  You should start reading from
                     the second record.

       Size:         1 -> ??? records

 ***********************************************************/

  typedef struct FileIdxRecord {
    word          RecNum;    /* 1 = Record 0 */
    longint       NameCrc;
    SecurityType  ListSecurity;
    byte          MinimumAge,
                  FileGroup;
    byte          AltGroups[3];
    byte          Attribute,
                  Attribute2;
    char          PadTo32Bytes[9];
  } FileIdxRecord;

/***********************************************************

       Filename:     <systempath>FILEGRP.BBS

       Description:  Used by Ezycom as to store group information.

                     The first Record is intentionally left
                     blank.  You should start reading from
                     the second record.

       Size:         1 -> ??? records

 ***********************************************************/

  typedef struct FileGroupRecord {
    char          Name[31]; /* C String */
    SecurityType  AccessSecurity;
    byte          MinimumAge;
    char          FreeSpace[6];
  } FileGroupRecord;


/**********************************************************

  FileName     : FILEPATH.EZY

  Description  : Stores information about where to get
                 the files

  Records      : 1..65000

  Note         : FILES.EZY must have the same amount
                 of records.

  Last Revised : 26/12/94(pwd)

  Attribute
    Bit 0 : CD Rom Path
        1 : File Displayed as Not Enough Security
        2 : Free Downloads
        3 : Auto Adopt Files?
       4-7: [Reserved]

***********************************************************/

  typedef struct FilePathRecord {
    char          FilePath[61],
                  FilesBBS[61];
    byte          KsPerFP;
    SecurityType  Security;
    word          UploadArea;
    byte          Password[9],
                  MinimumAge,
                  Attribute,
                  CDRomStack,
                  FreeSpace[109];
  } FilePathRecord;

/**********************************************************

  FileName     : FILESEC.EZY

  Description  : Stores individual (wildcard) file security

  Records      : 1->infinite  (sorted)

  Last Revised : 25/2/92(pwd)

  Attribute
       Bit 0 : [Reserved]
           1 : File Displayed as Not Enough Security
           2 : Free Download
         3-7 : [Reserved]

 **********************************************************/

  typedef struct FileSecRecord {
    char         FileName[13];
    SecurityType Security;
    char         Password[9];
    byte         MinimumAge,
                 Attribute;
  } FileSecRecord;

/**********************************************************

  FileName     : filebase path\FLCOUNT.BBS

  Description  : Stores number of files in each file area
                 (does not include comment lines)

  Records      : 1..65000
                 Always the same as FILES.EZY + FILEPATH.EZY

  Last Revised : 25/2/92(pwd)

  Sharing      : Always use DENYNONE + READWRITE

 **********************************************************/

  /*  Each record contains a word (2 bytes) which stores the
      amount of files in each file area.

      When reading the information, just seek to the
      appropriate record and read the 2 bytes

      When updating the count, lock the 2 bytes, then read
      it, then increate/decrease the amount, then write it
      back, and then release the lock. */


/**********************************************************

  FileName     : FLHXXXXX.BBS

  Description  : Stores file list information

  Last Revised : 25/2/92(pwd)

  Sharing      : Always use DENYNONE + READWRITE

  attribute 
    Bit 0 : checked
        1 : nokill
        2 : offline
        3 : [Reserved]
        4 : private
        5 : deleted
      6-7 : [Reserved] 

  attribute2 
   bit 0-7: [Reserved] 

 **********************************************************/

  typedef struct FileLineRecord {
    longint       FltStart;               // start of info in FLTXXXXX.BBS
    word          FltLength;              // length including null termiantor
    byte          Attribute;
    char          FileName[13];           // if the length of FileName is 0,
                                          // then it is a comment
    word          FilePath;               // pointer to filepath.ezy for path
                                          // of file 0= do not know where the 
                                          // file is 
    longint       FSize;                  // size of the actual file
    word          FDate,                  // date of the actual file
                  ArrivalDate,            // date the file arrived on the system
                  Downloads,
                  DownloadDate;           // last time the file was downloaded
                                          // if (downloads = 0) then
                                          //  this field is invalid
    byte          Attribute2;
    UserString    Uploader;
    byte          FreeSpace[57];
  } FileLineRecord;

/**********************************************************

  FileName     : FLTXXXXX.BBS

  Description  : Stores file list description information

  Last Revised : 25/2/92(pwd)

 **********************************************************/

   #define  FLTMAXSIZE  2048            // maximum size of a file description


  /* The FLTXXXXX.BBS has contains a null terminated string.

     It is either a comment, or a file description.  The description
     or comment can be upto FTLMAXSIZE in length.

     A comment maybe only 1 line long, and may NOT contain line feeds
     or carriage returns.

     A description can be any number of lines long, and may contain
     carriage returns, but may NOT contain line feeds (waste space)

     When writing to the description file, the file MUST be opened
     in DENYWRITE + READWRITE.  When reading from it, it MUST
     be opened in DENYNONE + READONLY */


/**********************************************************

  FileName     : EZYDOWN.<node>

  Description  : Stores Batch Download Information

  Last Revised : 20/3/93(pwd)

 **********************************************************/

  typedef struct PreDownloadRecord {
    char        FileName[13],
                LocationFile[65];       // path to file
    longint     FSize;                  // KiloBytes
    byte        FreeDown;               // boolean
    longint     TimeToDown;             // Seconds
    byte        CDRomFile,              // boolean
                CDStack,
                Deleted;                // boolean
    char        PadTo128Bytes;
  } PreDownloadRecord;

/**********************************************************

  FileName     : EZYUP.<node>

  Description  : Stores Pre Upload Descriptions

  Last Revised : 25/2/92(pwd)

 **********************************************************/

  typedef struct PreUploadRecord {
    char	     FileName[13],
	             Description[FLTMAXSIZE + 1];
  } PreUploadRecord;

/**********************************************************

  FileName     : <configrec.userbasepath>MAINTDN.BBS

  Description  : Stores Information for download counts
                 and file points credit.

  Last Revised : 20/1/96(pwd)

 **********************************************************/

  typedef struct MaintenanceRecord {
    char        FileName[13];
    longint     FileSize;
    word        FilePoint;
    longint     DownloaderCRC32;
  } MaintenanceRecord;

  
/**********************************************************

  FileName     : <configrec.userbasepath>MAINTUSR.BBS

  Description  : Stores Information for file points credit.

  Last Revised : 20/1/96(pwd)

 **********************************************************/

  typedef struct FilePointsMaintenanceRecord {
    word        FilePoints;
    UserString  Uploader;    
  } FilePointsMaintenanceRecord;

/**********************************************************

  FileName     :  FFPTR.BBS

  Description  :  Index Pointer File for the Fast Find Index

  Last Revised :  25/2/94(pwd)

  Format       :  Files with First Character #0 through to #64
                  start at Position 0 in FFIDX.BBS

                  [730] is all new files after the last sort
                  [729] is all files with a first letter after
                        'Z' (besides new files)
                  [1..728] is files that start with A#0 through
                        to Z#255
                  eg: AA is 2, AB is 3, ZZ is 727, ZY is 726

                  A value of 0x0FFFFFFFF (-1) in any position
                  indicates no files are present for that
                  position.

**********************************************************/

  typedef longint  FastPointerRecord[730];

/**********************************************************

  FileName     : FFIDX.BBS

  Description  : Index File of all files available for download

  Last Revised : 1/2/94 (pwd)

  Records      : 0..Infinite

  To add a file to the fast find index, just add an extra
  record to the end of this file.  File sharing should be
  DENYNONE + READWRITE

  attribute;
    Bit 0 : Deleted
       1-7: [Reserved]

 **********************************************************/

  typedef struct FastIndexRecord {
    FileStr     Name;
    word        FilePath;               // FILEPATH.EZY 1 ->
    byte        Attribute;
    longint     FileSize;
  } FastIndexRecord;

/**********************************************************

  FileName      : <multipath>ONLINE.BBS

  Description   : Used by Ezycom to store online information

  Minimum Size  : 1 Record
  Maximum Size  : 250 Records

  Last Revised  : 1/2/94 (pwd)

  Notes         : While in a door, it is possible to give
                  Ezycom more information about the door.
                  This can be done by creating a file called
                  <systempath>USERDOES.<node>.

	When Ezycom is waiting for a call from a particular node,
  information can be displayed in the who's online list.
  By making a simple 1 line text file in <systempath>NODEINFO.<node>

  status
      0 = Active
      1 = [Reserved]
      2 = Downloading
      3 = Uploading
      4 = [Reserved]
      5 = Message Browsing
      6 = Door
      7 = Chat with Sysop
      8 = Chat with Other Users Channel 000
      ...................................
    207 = Chat with Other Users Channel 199 (200 channels)
    208 = 252 [Reserved]
    253 = Node Not Active in Any Way
    254 = User Logging On
    255 = Waiting for Caller

  attribute : byte;
    Bit 0 : Quiet Do Not Disturb
      1-7 : [Reserved] 

 **********************************************************/

  typedef struct OnlineRecord {
    UserString   Name,
                 Alias;
    byte         Status,
                 Attribute;
    longint      Baud;
    byte         Location[26];
    longint      LastTimeUpdated;        // This field should always be updated
                                        // when the record is modified in ANY 
                                        // way by the user online. 
    char         FreeSpace[20];
  } OnlineRecord;

/**********************************************************

  FileName:     <multipath>MESSNODE.<node>

  Description:  Used by Ezycom for conferencing

  Minimum Size: 0 Records (Maybe not present!)
  Maximum Size: Unlimited

  Sharing:
       Writing: Denynone + WriteOnly
       Reading: Denyall + ReadWrite (Truncate after read)

 **********************************************************/

  typedef struct MultiMessageRecord {
    UserString   From;
    word         FromNode;
    char         Message[81];
    byte         PrivateMsg;             // boolean
  } MultiMessageRecord;

/**********************************************************

  FileName:     <userbase>BESTSTAT.BBS

  Description:  Used by Ezycom to store best user stats

  Minimum Size: 0 Records (Maybe not present!)
  Maximum Size: 200 Records

 **********************************************************/

  typedef struct BestUserRecord {
    UserString    BestName[7];	       // BestName[1] is for BestMessages
                                       // BestName[2] is for BestCalls
                                       // .....
                                       // BestName[7] is for BestDownK
    word          BestMessages,
                  BestCalls,
                  BestUps,
                  BestDns,
                  BestFPs;
    longint       BestUpK,
                  BestDownK;
  } BestUserRecord;

/**********************************************************

  FileName:     <msgpath>\AREA<(<area>-1)/100+1>\MH<area>.BBS
                eg: \ezy\msgbase\area1\mh00001.bbs     for area 1
                eg: \ezy\msgbase\area10\mh01001.bbs    for area 1001
                eg: \ezy\msgbase\area100\mh10001.bbs   for area 10001

  Description:  Used by Ezycom to store message header

  msgattr,
    Bit 0 : Deleted
        1 : Netmail pending export
        2 : [Reserved]
        3 : Private
        4 : Received
        5 : Echomail pending export
        6 : Locally generated msg
        7 : Do not kill message 

  netattr,
    Bit 0 : Kill/sent
        1 : Sent
        2 : File Attach
        3 : Crash
        4 : File Req
        5 : Request Receipt
        6 : Audit Request
        7 : Is a Return Receipt 

   extattr   : byte;
     Bit 0-7 : [Reserved] 

 **********************************************************/

  typedef struct MsgHdrRecord {
    word          PrevReply,
                  NextReply;                // 0 = No Reply Chain
    longint       StartPosition,            // Physical Start Position in
                                            // MSGT???.BBS
                  MessageLength;            // Message Length including
                                            // Null Terminator
    NetRecord     DestNet,
                  OrigNet;
    word          Cost;
    byte          MsgAttr,
                  NetAttr,
                  ExtAttr;
    longint       PostTimeDate,             // DOS Format Packed DateTime
                  RecvTimeDate;             // DOS Format Packed DateTime
    UserString    WhoTo,
                  WhoFrom;
    char          Subject[73];
  } MsgHdrRecord;

/**********************************************************

  FileName:     <msgpath>\AREA<<area-1>/100+1>\MT<area>.BBS
                eg: \ezy\msgbase\area1\mt00001.bbs     for area 1
                eg: \ezy\msgbase\area10\mt01001.bbs    for area 1001
                eg: \ezy\msgbase\area100\mt10001.bbs   for area 10001

  Description:  Used by Ezycom to store message text

 **********************************************************/

   /* Message Text

          Each text part of the message starts at 'startposition',
     and continues on until a NULL terminator is found, or end
     of file is reached (shouldn't happen, but just in case).
     Each message is contained of plain text, with 0x08D
     terminators for wrapped lines or 0x0D terminators for hard
     carriage returns.  No line of text should exceed 79 characters
     excluding the terminator */

/**********************************************************

  FileName:     <msgpath>MSGFAST.BBS

  Description:  Used by Ezycom for mail checks

 **********************************************************/

  typedef struct MsgFastRecord {
    longint      WhoTo;		       // standard 32 Bit CRC on whoto in
                                       // MH???.BBS Username is CRCd in
                                       // UPPERCASE, and does not include
                                       // null terminator or length byte
    word         MsgBoard,
                 MsgNumber;
  } MsgFastRecord;

/**********************************************************

  FileName:     <msgpath>MSGEXPRT.BBS

  Description:  Used by Ezycom to tell EzyNet/EzyMail whether
                an area needs scanning or not

 **********************************************************/

  typedef unsigned char  NeedScanRecord[MAXMESS];    // boolean;

/**********************************************************

  FileName:     <msgpath>MSGREPLY.BBS

  Description:  Used by MsgComp/EzyLink to tell it which
                conference(s) need reply chain
                linking

 **********************************************************/

  typedef unsigned char  NeedReplyType[MAXMESS];     // boolean;

/**********************************************************

  FileName:     <msgpath>MSGCOUNT.BBS

  Description:  Used by Ezycom and Utilities for
                message area counting.
                Reading the number of records of
                MHxxx.BBS gives the same effect as
                reading the conferences count.

 **********************************************************/

  typedef unsigned int  MsgAreaCountType[MAXMESS];

/**********************************************************

  FileName:     <msgpath>MSGDLTD.BBS

  Description:  May or may not exist
                Lists all the deleted messages on the
                system.  MSGCOMP deletes the file since
                it packs all the deleted messages.

 **********************************************************/

  typedef struct MsgDeletedRecord {
    word	      MsgBoard,
	              MsgNumber;
  } MsgDeletedRecord;

/**********************************************************

  FileName:     <systempath>MESSAGES.EZY

  Description:  Used by Ezycom to store message areas

  Size:         1536 records

  attribute
    Bit 0 : Allow Aliases
        1 : Use Alias
        2 : Use Alias, Ask for Aliases
        3 : [Reserved]
        4 : Combined Area Access
        5 : Local File attaches
        6 : Keep Private Bit on Incoming EchoMail
        7 : Security *)

  attribute2
    Bit 0 : Show Seenby Lines
        1 : Forced Mail Check
        2 : Tiny Seenbys
        3-4 [Reserved]
        5 : Areafix Info Visible
        6 : Initial Combined Area Access
        7 : Do Not Use in Template *)

  attribute3
       0-7: [Reserved]
 **********************************************************/

  typedef struct MessageRecord {
    char          Name[31];
    AreaTagStr    AreaTag;
    char          QWKName[13];
    MsgType       Typ;
    MsgKindsType  MsgKinds;
    byte          Attribute,
                  Attribute2,
                  Attribute3,
                  DaysKill,
                  RecvKill;
    word          CountKill,
                  KilobyteKill;
    SecurityType  ReadSecurity,
                  WriteSecurity,
                  SysopSecurity;
    byte          MinimumAge;
    char          OriginLine[51];
    byte          OriginAddress,
                  SeenBy[MAXAKA/8];
    char          AreaGroup;
    byte          MessGroup,
                  AltGroups[3];
    byte          EchomailFeed,             // 0=No Uplink
                  DestNodes[MAXNODES/8];    // Nodes  1 to  8 - DestNode[1]
                                            // Nodes  9 to 16 - DestNode[2]
                                            // Nodes 17 to 24 - DestNode[3]
    word          MsgIdxPos;                // Position in Messages.Idx
    byte          ArrivalKill;
    char          FreeSpace[13];
  } MessageRecord;

/***********************************************************

  Filename:     <systempath>MESSAGES.IDX

  Description:  Used by Ezycom as an index into the
                message areas.  Only used areas are stored
                in here.  CRCs are calculated the same
                as that for the fast message record.  Later
                on, it is planned to provide serveral linked
                lists, so you can traverse the index in
                sorted orders.

                The first Record is intentionally left
                blank.  You should start reading from
                the second record.

  Size:         1 -> ??? records

 **********************************************************/

  typedef struct MessageIdxRecord {
    word          RecNum;
    longint       NameCRC,
                  AreaTagCRC,
                  QWKNameRCR;
    MsgType       Typ;
    SecurityType  ReadSecurity,
                  WriteSecurity;
    byte          MinimumAge;
    char          AreaGroup;
    byte          MessGroup,
                  AltGroups[3];
    byte          Attribute,
                  Attribute2,
                  Attribute3;
    char          PadTo64Bytes[20];
  } MessageIdxRecord;

/***********************************************************

       Filename:     <systempath>MSGGRP.BBS

       Description:  Used by Ezycom as to store group information.

                     The first Record is intentionally left
                     blank.  You should start reading from
                     the second record.

       Size:         1 -> ??? records

 ***********************************************************/

  typedef struct MessageGroupRecord {
    char          Name[31]; /* C String */
    SecurityType  AccessSecurity;
    byte          MinimumAge;
    char          FreeSpace;
  } MessageGroupRecord;

/**********************************************************

    FileName:     <systempath>ECHOMGR.EZY

    Description:  Used by Ezycom to store node information

    Last Update:  1/5/95

    Size:         256 records

    compress
      0 = Compress to ZIP
      1 = Compress to LZH
      2 = Compress to ARJ
      3 = Compress to ARC
      4 = Compress to PAK
      5 = Compress to ZOO
      6 = Compress to SQZ
      7 = Compress to RAR

    attribute  
      Bit 0 : Node Active
          1 : Crash Mail
          2 : Hold Mail
          3 : Can Create New Echos
          4 : Add to Export on New Echo
          5 : Can Delete/Rename Areas
          6 : Direct Mail (Off=Routed Mail)
	  7 : Allow 2D Security)

    sendpkttype
          0 = Type 2
          1 = Type 2+
        2-255 [Reserved]

 **********************************************************/

  typedef struct EchoMgrRecord {
    NetRecord     DestNet;
    DomainStr     Domain;
    word          RedirectTo;
    GroupType     Groups;                      // compressed groups A thru Z
    byte          Compress,
                  Attribute;
    char          PasswordTo[21],
                  PasswordFr[21];
    byte          DaysHold,
                  SendPktType;
    word          MaxPktSize,
                  MaxArcKSize;
    char          AreaList[65],                // Z String
                  PktPassword[9],              // Z String
                  LastExt[4],                  // Z String
                  FreeSpace[29];
  } EchoMgrRecord;

/**********************************************************

  FileName:     EVENTS.EZY (multinode file)

  Description:  Used by Ezycom to store event information

  Minimum Size: 1 record
  Maximum Size: 65000 records

  attribute   
    Bit 0 : Enabled

  days        
    Bit 0 : Sunday
        1 : Monday
            ...
        6 : Saturday
        7 : [ Reserved ] 

 **********************************************************/

  typedef struct EventRecord {
    byte         Attribute;
    word         StartTime;             // Hi Byte=Hour,Low Byte=Min
    byte         Errorlevel,
                 Days;
    word         LastTimeRun;
  } EventRecord;

/**********************************************************

  FileName:    <systempath>TODAY.BBS
               <systempath>YESTER.BBS

  Last Update: 1/2/94

  Description: Used by Ezycom to today's/yesterday's callers

  didwhat
    Bit 0 : (N) NewUser
        1 : (U) Upload
        2 : (D) Download
        3 : (R) Read Mail
        4 : (S) Sent Mail
        5 : (O) Outside
        6 : (C) Chat to Sysop and/or User
        7 : (P) Paged 

 **********************************************************/

  typedef struct OnTodayRecord {
    byte         Line;
    UserString   Name,
                 Alias;
    byte         Location[26];
    longint      BaudRate;
    word         LogonTime,
                 LogoffTime;
    byte         DidWhat,
                 freespace[20];
  } OnTodayRecord;

/**********************************************************

  FileName:    <systempath>TIME<node>.BBS

  Description: Used by Ezycom to store usage information

 **********************************************************/

  typedef struct UseageRecord {
    word         StartDate;
    longint      BusyPerHour[24],        // Minutes Used
                 BusyPerDay[7];           // Minutes Used
  } UseageRecord;

/**********************************************************

  FileName:    <systempath>MSGINFO.<node>

  Description: Used by Ezycom and Tide to interface to
               each other

	returnstatus
        0 = FSE Record Not Used
        1 = Message Saved
        2 = Message Aborted
        3 = User  Inactivity
        4 = User  Hungup
        5 = Sysop Hungup
    6-255 = Reserved 

  attribute    
    Bit 0 : Can Change Subject
        1 : Can Change Whoto
        2 : Can Change Private
        3 : Private Message
        4 : Is Message Forwarded (False = Quoted)
            (Providing MSGTMP.<node> exists)
        5 : Netmail Message
        6 : Avatar Capable (ANSI if not set)
        7 : EchoMail Message   

 **********************************************************/

  typedef struct FseRecord {
    UserString    WhoFrom; 	       // User Who wrote message
    NetRecord     OrigNet; 	       // From Net Address
    UserString    WhoTo;               // User Who message is to
    NetRecord     DestNet; 	       // To Net Address
    char          Subject[73];         // Subject of message
    byte          ReturnStatus,        // Return Status
                  Attribute;
    longint       BaudRate,	       // Effective Baudrate
                  LockedBaud;          // Locked Baudrate
    word          Comport;
    byte          ScreenLength;
    word          TimeLeft;
  } FseRecord;

/**********************************************************

  FileName:    <msgbasepath>MSGRSCAN.BBS

  Description: Used by EzyNet and EzyMail for Rescanning a
               Message Area for a particular node

 **********************************************************/

  typedef struct RescanRecord {
    word	NodeToRescan;
    word	MsgBoard;
  } RescanRecord;

/**********************************************************

  FileName:    <msgbasepath>MSGSTATS.BBS

  Description: Written by EzyMail for echomail statistics

 **********************************************************/

  typedef struct MsgStatsRecord {
    word     TossedBoard[MAXMESSALL],      // Number of Messages Tossed to Msg
                                           // Board
             ScannedBoard[MAXMESSALL];     // Number of Messages Tossed to Msg
                                           // Board
    longint  TossedNode[MAXNODES];         // Number of Messages Tossed to
                                           // EchoArea Node
  } MsgStatsRecord;

/**********************************************************

  FileName:    <systempath>EXITINFO.<node>

  Description: Used by Ezycom in Type 15 exits to return
               Used by Ezycom in Type 7 exits for door
                  information

  Last Revised : 16/1/94(pwd)

  dayofnextevent
    0 = Sunday
	     ..........
    6 = Saturday
    7 = NOEVENT 

  mtasker 
    Time Slice Routine to use
       0 = No Multitasker
       1 = [Reserved]
       2 = Desqview
       3 = Double DOS
	     4 = OS/2 or Windows
       5 = MultiDOS Plus
       6 = Windows 3.1
  7..255 = [Reserved] *)

  iemsi_req1
    Bit 0 : News
        1 : Mail
        2 : File
        3 : Clrscr
	      4 : Quiet
        5 : More
        6 : FSE
        7 : [Reserved] 

  iemsi_req2
    Bit 0-7 : [Reserved] 

  iemsi_prot
    Bit 0 : ZModem
	      1 : SEAlink
        2 : Kermit
        3 : ZedZap

  iemsi_crt
    0 = TTY
    1 = ANSI
    2 = AVT0+
    3 = VT100
    4 = VT52 *)

  iemsi_cap    
    Bit 0 : CHT
        1 : MNU
        2 : TAB
        3 : ASCII8 

 **********************************************************/

  typedef struct ExitInfoRecord {
    word              OldBaud;              // Effective Baud Rate
    word              OldLockedBaud;        // Speed between Modem/Modem
    byte              Comport;              // Comport 1 = Com1, etc
    word              Efficiency,           // Baud Rate efficiency
                      UserRecord;           // User Record Number (0=User1)

    UsersRecord       UserInfo;
    UsersExtraRecord  UserExtra;

    UserString        SysopName,
                      SysopAlias;
    char              System[41];
    word              DownloadLimit,        // Maximum Download Limit
                      TimeLimit,            // Daily Time Limit
                      TimeTakenEvent;       // Number of Minutes Taken from User
                                            // for Event
    longint           TimeCreated,          // Number of Seconds since Midnight
                      TimeOfNextEvent,      // Number of Seconds since Midnight
                      TimeTillNextEvent;    // Number of Seconds after Time Created
    byte              DayOfNextEvent,
                      ErrorlevelOfNextEvent, // Errorlevel to return from next
                                            // event
                      Ratio;                // File Ratio
    word              Credit;               // File Ratio Credit
    byte              RatioK;               // Kilobyte Ratio
    word              CreditK,              // Kilobyte Ratio Credit
                      RegoDays,             // Registration Days
                      CreditMess,           // Post Call Ratio Credit
                      Mess;                 // Post Call Ratio
    DateTime          LoginTimeDate;        // Login Datetime
    Str8              Stack[20];            // Menu Stack
    byte              StackPos;             // Menu Stack Position (0 = No Stack)
    Str8              CurMenu;              // Current Menu
    char              OldPassword[16];
    word              LimitRecNum;          // Limits Record Being Used
    byte              BaudRecNum,           // BaudRate Record Being Used
                      RipActive,            // boolean;
                      MaxPages,             // Maximum Pages
                      PagedSysop,           // Number of Times User has Paged Sysop
                      WantChat;             // boolean;
    longint           PageStart,
                      PageEnd;              // Number of Seconds since Midnight
    byte              PageLength,           // Page Length
                      EchoEntered,          // boolean
                      NetEntered,           // boolean
                      NextSysop;            // boolean
    word              InactivityTime;       // Seconds
    byte              ProtRecNum;           // Default Protocol Record Number
                                            // 0=NoDefault
    char              ProtName[16];         // Default Protocol Name
    char              DidWhat;              // Didwhat flag for Todays Callers
    char              PageReason[61];
    byte              MTasker,
                      IEmsi_Session,        // boolean;
                      IEmsi_Req1,
                      IEmsi_Req2,
                      IEmsi_ScrLen,         // Screen Length for current session
                                            // If NOIEMSI session, this is set to
                                            // the users screen length
                      IEmsi_Prot,
                      IEmsi_Crt,
                      IEmsi_Cap,
                      PageSound;            // boolean;
    longint           TimeConnect;          // time connected this call
    byte              ScreenOn;             // boolean - whether ezycom is
                                            // displaying the screen locally or not
    longint           Baud,                 // Effective Baudrate
                      LockedBaud;           // Speed between Computer/Modem
    byte              FreeSpace[86];
  } ExitInfoRecord;

  typedef struct SysInfoRecord {
    longint           CallCount;
    UserString        LastCaller;
    longint           FilesSizeK;             // Updated by EzyIDX -BUILD
    word              NewUsers,
                      NewFiles,
                      NewMessages;           // Does NOT include Inbound Echomail
    UserString        LastAlias;
    word              LastStartTime;         // The start of the last session by
                                             // a user
    char              ExtraSpace[80];
  } SysInfoRecord;

/**********************************************************

  FileName     : <nodelistpath>EZYINDEX.<nodelistnum>

  Description  : Stores Nodelist Information

  Min Size     : File Not Exist

  Max Size     : 65000 Records

  Last Revised : 3/1/94(pwd)

  Sharing      : Reading       - DenyNone + ReadOnly
                 Insert/Update - Never (EzyNode does it)

 **********************************************************/

  typedef struct NodeListRecord {
    byte    NodeListFile;
    longint Position;
    word    Zone,
            Net;
  } NodeListRecord;

/**********************************************************

  FileName     : <nodelistpath>EZYINDEX.00

  Description  : AkaIndex is a pointer to which EZYINDEX.<nodelist num>
                 is used for that Aka.

                 NodelistFileRecord holds information to a particular
                 nodelistfile.  (nodelistfile byte in nodelistrecord).

  Min Size     : AkaIndex + 1 NodelistFileRecord

  Max Size     : AkaIndex + 255 NodelistFileRecords

  Last Revised : 3/1/94(pwd)

  Sharing      : Reading       - DenyNone + ReadOnly
                 Insert/Update - Never (EzyNode does it)

 **********************************************************/

  typedef unsigned char  AkaIndex[MAXAKA];

  typedef struct NodeListFileRecord {
    byte      NodeListPath[80];
    DomainStr Domain;
  } NodeListFileRecord;

/**********************************************************

  FileName     : <nodelistpath>EZYINDEX.COS

  Description  : Lists all the phone number costing factors

  Min Size     : 1 Record (Default Cost)

  Max Size     : Unlimited

  Last Revised : 3/1/94(pwd)

  Sharing      : Reading       - DenyNone + ReadOnly
                 Insert/Update - Never (EzyNode does it)

 **********************************************************/

  typedef struct CostRecord {
    char  PhoneNum[26];
    word  Cost;
  } CostRecord;

/**********************************************************

  FileName     : <systempath>RUMOURS.BBS

  Description  : Stores Rumour Information

  Min Size     : File Not Exist

  Max Size     : 65000 Records

  Last Revised : 27/3/93(pwd)

  Sharing      : Reading       - DenyNone + ReadOnly
                 Insert/Update - DenyWrite + ReadWrite

 **********************************************************/

  typedef struct RumourRecord {
    char         UserInput[71],
                 Compiled[101];
    UserString   UserName;
    word         LastUpdate;
    char         FreeSpace[46];
  } RumourRecord;

/**********************************************************

  FileName     : <systempath>LANGUAGE.EZY

  Description  : Language Information Setup

  Min Size     : 1 Record

  Max Size     : 250 Records

  Last Revised : 7/1/94(pwd)

  Sharing      : Reading       - DenyNone + ReadOnly
                 Insert/Update - DenyWrite + ReadWrite


  Attribute
    Bit  0 : Default Language
      1-15 : [Reserved]

 **********************************************************/

  typedef struct LanguageRecord {
    char          LangName[9],       // Z String
                  Description[61],   // Z String
                  RipPath[61],       // Z String
                  AvtPath[61],       // Z String
                  AnsiPath[61],      // Z String
                  AscPath[61],       // Z String
                  AslPath[61],       // Z String
                  G1Path[61],        // Z String
                  G2Path[61],        // Z String
                  G3Path[61],        // Z String
                  MnuPath[61],       // Z String
                  Mnu2Path[61],      // Z String
                  QAPath[61];        // Z String
    SecurityType  Security;
    word          Attribute;
    char          FreeSpace[271];
  } LanguageRecord;

/***********************************************************

   Filename     : <systempath>DNBATCH.EZY

   Description  : Stores Download Batch of Terminated Sessions

   Min Size     : 1 Record

   Max Size     : Infinite Records

   Last Revised : 10/2/95(pwd)

   Sharing      : Reading       - DenyNone + ReadWrite
                  Delete/Insert - DenyNone + ReadWrite
                                  Lock Record 0 then proceed

   Record 0     : ForwardLink is a pointer to the first free
                  record
                  BackwardLink is a pointer to the start of the
                  list

**********************************************************/

  typedef struct DownloadBatchHistoryRecord {
      UserString         Username;
      word               DateAdded;
      PreDownloadRecord  BatchFile;
      char               PadTo192Bytes[18];
      longint            ForwardLink,
                         BackwardLink;
  } DownloadBatchHistoryRecord;

#endif
