DECLARE FUNCTION lbyte% (word%)
DECLARE FUNCTION hbyte% (word%)

REM CD drive door joke program..

REM $INCLUDE: 'qb.bi'

DIM SHARED InregsX AS RegTypeX
DIM SHARED OutregsX AS RegTypeX

DIM NumDrives AS INTEGER ' number of drives.
DIM DriveState(1 TO 26) AS INTEGER ' state of drive door.

DIM SHARED rh(26) AS STRING * 1 ' request header.
DIM SHARED cb(1) AS STRING * 1 ' command block.

DIM Length AS INTEGER
Length = 1 ' length of cb()

' get number of drives.
InregsX.AX = &H1500
InregsX.BX = &H0
InregsX.CX = &H0
CALL INTERRUPTX(&H2F, InregsX, OutregsX)
NumDrives = OutregsX.BX

' check number of drives.
IF NumDrives = 0 THEN END

' declare drive tables
DIM Temp1(1 TO NumDrives) AS STRING * 1
DIM Temp2(1 TO NumDrives * 5) AS STRING * 1
DIM Drives(1 TO NumDrives, 1 TO 2) AS INTEGER

' get drive list.
InregsX.AX = &H150D
InregsX.ES = VARSEG(Temp1(1))
InregsX.BX = VARPTR(Temp1(1))
CALL INTERRUPTX(&H2F, InregsX, OutregsX)
InregsX.AX = &H1501
InregsX.ES = VARSEG(Temp2(1))
InregsX.BX = VARPTR(Temp2(1))
CALL INTERRUPTX(&H2F, InregsX, OutregsX)

' store drive info.
FOR X = 1 TO NumDrives
   Drives(X, 1) = ASC(Temp1(X)) ' a=0, b=1, ..
   Drives(X, 2) = ASC(Temp2(1 + (X - 1) * 5))
NEXT X

' reset drive door state.
FOR X = 1 TO NumDrives
   DriveState(X) = Z
   Z = NOT Z
NEXT

' start door loop.
DO
   ' check for keyboard.
   IF INKEY$ <> "" THEN END

   ' loop through all cd-rom drives.
   FOR X = 1 TO NumDrives

      ' prepare the request header for a given command code.
      rh(1) = CHR$(26) ' length
      rh(2) = CHR$(Drives(X, 2)) ' drive device
      rh(3) = CHR$(12) ' command code 0Ch

      ' prepare the control block for a given subfunction of command code.
      IF DriveState(X) = 0 THEN ' check disk state
	 cb(1) = CHR$(0) ' function code 00h - eject disk
      ELSE
	 cb(1) = CHR$(5) ' function code 05h - close tray
      END IF

      ' update address of cb() in rh()
      rh(15) = CHR$(lbyte(VARPTR(cb(1)))) ' transfer address (dword) 0Eh
      rh(16) = CHR$(hbyte(VARPTR(cb(1))))
      rh(17) = CHR$(lbyte(VARSEG(cb(1))))
      rh(18) = CHR$(hbyte(VARSEG(cb(1))))
      rh(19) = CHR$(lbyte(Length)) ' number of transfer bytes (word) 12h
      rh(20) = CHR$(hbyte(Length))

      ' call ioctl
      InregsX.AX = &H1510
      InregsX.CX = Drives(X, 1) ' drive letter
      InregsX.ES = VARSEG(rh(1))
      InregsX.BX = VARPTR(rh(1))
      CALL INTERRUPTX(&H2F, InregsX, OutregsX)
  
      ' toggle disk state
      DriveState(X) = NOT DriveState(X)
   NEXT

   ' wait 5 seconds.
   T! = TIMER
   DO
      ' check for keyboard.
      IF INKEY$ <> "" THEN END

      ' check elapsed time.
      E! = TIMER - T!
      IF E! < 0! THEN E! = E! + 86400! ' (midnight)
      IF E! >= 5! THEN EXIT DO
   LOOP
LOOP
END

FUNCTION hbyte% (word%)
'Returns the high byte of a 2-byte number
'input:     word%               - 2-byte number (INTEGER)
'returns:   Function Value      - High byte or word%
IF word% >= 0 THEN
   hbyte% = word% \ 256
ELSE
   hbyte% = (65536 + word%) \ 256 ' increment twos-complement
END IF
END FUNCTION

FUNCTION lbyte% (word%)
'Returns the low byte of a 2-byte number
'input:     word%               - 2-byte number (INTEGER)
'returns:   Function Value      - Low byte or word%
IF word% >= 0 THEN
   lbyte% = word% MOD 256
ELSE
   lbyte% = (65536 + word%) MOD 256 ' increment twos-complement
END IF
END FUNCTION
