#!/usr/bin/python3

# coding: CP437

import sys
import os

appdir = os.path.dirname(sys.argv[0])
sys.path.append(appdir+os.sep+"pycrt")

from pycrt import *
import configparser
import xfilelist
import feedparser
import xmenulist
from xbox import *
import xinput
import base64
import textwrap
import re
import xdoor

bg = base64.b64decode( \
'G1swbRtbMW3axMHExMTExBtbMG3ExMTEG1sxbcQbWzBtxMQbWzFtxMQbWzBtxMTExMQbWzFtxMQb'+
'WzBtxMTEG1sxbcQbWzBtxMTExMTExMTExMTExMTExMTExMTExMTExMTExMTExMTExMTExMTExMTE'+
'xMTExMTBxMQbWzE7MzBtvxtbMG0NCiAgG1sxbUIbWzBtQlMbWzE7MzBtLy8bWzM3bVIbWzBtU1Mg'+
'G1sxbVIbWzBtZWFkZXINChtbMTszMG3AxMTExMTExMTExMTExMLExMTExMTEG1swbcTEG1sxOzMw'+
'bcTExBtbMG3EG1sxOzMwbcTExMQbWzBtxMLExMTExMTEG1sxOzMwbcTEG1swbcTExMQbWzE7MzBt'+
'xMQbWzBtxMQbWzE7MzBtxBtbMG3ExMTEG1sxOzMwbcQbWzBtxMTExMQbWzFtxBtbMG3EG1sxbcTE'+
'G1swbcTEwsQbWzFtxBtbMG3ExBtbMW3ExMTExNkbWzBtDQogICA6ICAgICAgICAgIBtbMTszMG06'+
'G1swbSAgICAgICAgICAgICAgIBtbMTszMG06G1swbSAgG1sxbcAbWzBtxBtbMW3EG1szMG3EG1sw'+
'bcQbWzE7MzBtxMTExMTExMTExMTExBtbMG3EG1sxOzMwbcQbWzM3bcQbWzBtxBtbMW2/G1swbSAg'+
'ICAgICAgICAgIBtbMTszMG06OhtbMG0NChtbMW3axMTBxMTExMQbWzBtxMTExBtbMW3ExBtbMG3E'+
'xMQbWzFtxMQbWzBtxBtbMW3ExMQbWzBtxMTEG1sxbcTEG1swbcTBxMQbWzFtxMTEG1swbcTExMTE'+
'xMTExMTExMTExMTExMTBxMTEG1sxOzMwbcTEG1swbcQbWzE7MzBtxMTExMTExMHExMTExMTExL8b'+
'WzBtDQobWzFtsxtbMG0NChtbMW2zG1swbQ0KtA0Ksw0KG1sxbbMbWzBtDQqzDQobWzE7MzBtsxtb'+
'MG0NChtbMW2zG1swbQ0Ksw0Ksw0KG1sxOzMwbbQbWzBtDQqzG1sxOzMwbQ0Ksw0KsxtbMG0NChtb'+
'MTszMG2zG1swbQ0KG1sxOzMwbbMbWzBtDQobWzE7MzBtwMTCxMTExMTExMTExBtbMG3EG1sxOzMw'+
'bcQbWzBtxMLExMTExBtbMTszMG3EG1swbcTExBtbMTszMG3EG1swbcTExMQbWzE7MzBtxMLEG1sw'+
'bcTExMQbWzE7MzBtxMTExMQbWzBtxMQbWzE7MzBtxMQbWzBtxMTEG1sxOzMwbcTExMQbWzM3bcQb'+
'WzMwbcQbWzBtxMTEG1sxbcTExBtbMG3EwsTExBtbMW3ExBtbMG3ExMTExBtbMW3ExMTE2RtbMG0N'+
'ChtbMW3axBtbMzBtxMTExMTExMTExMQbWzM3bcQbWzMwbcQbWzBtxBtbMW3BIPogICAgICAgICAg'+
'ICAgG1szMG06G1swbSAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIBtbMTszMG06G1swbQ0K'+
'wMRbICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAg'+
'ICAgICAgICAgICAgICAgICAgICBdvw==')



categories = []
feeds = []
ini = configparser.ConfigParser()
ini.read(appdir+pathsep+"feeds.ini")
dr = xdoor.door()
acs = 20
user = ""

def cleanhtml(raw_html):
  cleanr = re.compile('<.*?>')
  cleantext = re.sub(cleanr, '', raw_html)
  return cleantext

def drawbg(s):
  global bg
  write(colors[0]+colors[16])
  clrscr()
  os.write(1,bg)
  writexy(5,24,8,s)
  #"[ ENTER/select ][ Up/Down/Home/End ][ Left/back or exit ] XQTR/2019"
    
def saveini():
  with open(appdir+pathsep+"feeds.ini", 'w') as configfile:
    ini.write(configfile)

def delfeed(category,item):
  global ini
  ansibox(35,12,45,14,box12)
  delay(200)
  ansibox(29,10,52,15,box12)
  writexy(35,12,7,"Are you sure?")
  add = xinput.getyesno(38,13,15+7*16,15+7*16,8,True)
  if add == "yes":
    ini.remove_option(category, item)
    saveini()
  
def addfeed(category):
  global ini
  #savescreen()
  ansibox(35,12,45,14,box12)
  delay(200)
  ansibox(29,11,52,15,box12)
  delay(200)
  ansibox(20,10,60,16,box12)
  xinput.exit_keys = ["#up","#down","esc"]
  xinput.exit_code = ""
  writexy(22,11,7,"Title")
  swritexy(22,12,8,'░'*37)
  writexy(22,13,7,"Link")
  swritexy(22,14,8,'░'*37)
  
  add = ""
  state = 0
  title =""
  link="http://"
  while add != "yes" and add != "no":
    if state == 0:
      title=xinput.input(22,12,15+7*16,8,xinput.cs_www,37,100,'░',title)
      if xinput.exit_code == "#down" or xinput.exit_code == "#enter":
        state = 1
    elif state == 1:
      link=xinput.input(22,14,15+7*16,8,xinput.cs_www,37,100,'░',link)
      if xinput.exit_code == "#down" or xinput.exit_code == "#enter":
        state = 2
      elif xinput.exit_code == "#up":
        state = 0
    elif state == 2:
      writexy(30,15,7,"Are you sure?")
      add = xinput.getyesno(44,15,15+7*16,15+7*16,8,True)
      if xinput.exit_code == "#down":
        state = 0
      elif xinput.exit_code == "#up":
        state = 1
    writexy(30,15,7," "*20)
  if add == "yes" and link != "" and title != "":
    ini.set(category,title,link)
    saveini()
    ansibox(20,10,60,16,box12)
    writexy(22,12,15,"Feed saved. Thank you!");
    writexy(22,14,8,"Press a key to continue...")
    readkey()
  #restorescreen()

def getcategories():
  global categories
  global ini
  for section in ini.sections():
    categories.append(section)
    
def getfeeds(section):
  global feeds
  global ini
  feeds.clear()
  for name, value in ini.items(section):
    #feeds.append(name.replace("_"," "))
    feeds.append(name)
    
def getfeed(section,item):
  global user
  link = ini.get(section,item)
  NewsFeed = feedparser.parse(link)
  if len(NewsFeed.entries)>0:
    fl = open(appdir+os.sep+user+"temp.txt","w")
    fl.write("\n")
    for entry in NewsFeed.entries:
      date = " %d/%02d/%02d " % (entry.published_parsed.tm_year,\
      entry.published_parsed.tm_mon, \
      entry.published_parsed.tm_mday)
      title = entry.title
      link = entry.link
      
      fl.write("/="+date+"="*63+"\n")
      fl.write(" Title:\n")
      for l in textwrap.wrap(cleanhtml(entry.title), width=75):
        fl.write("  "+l+"\n")
      fl.write(" Link:\n")
      for l in textwrap.wrap(cleanhtml(entry.link), width=75):
        l = byte2str(l.encode(encoding='CP437',errors='ignore'))
        fl.write("  "+l+"\n")
      fl.write("- "*38+"\n")
      summ = textwrap.wrap(cleanhtml(entry.summary), width=75)
      for l in summ:
        l = byte2str(l.encode(encoding='CP437',errors='ignore'))
        fl.write("  "+l+"\n")
      fl.write("="*76+"/\n")
      fl.write("\n")
      fl.write("\n")
      
    fl.close()
    writexy(7,5,15," "+item+" ")
    if os.path.isfile(appdir+os.sep+user+"temp.txt"):
      xfilelist.exit_keys.append("#esc")
      xfilelist.viewtextfile(appdir+os.sep+user+"temp.txt",2,6,79,21)
    else:
      ansibox(30,9,50,12,box12)
      writexy(32,10,3,"No Data to display")
  else:
    ansibox(30,9,50,12,box12)
    writexy(32,10,3,"No Items!")
  drawbg("[ ENTER/select ][ Up/Down/Home/End ][ Left/back or exit ] XQTR/2019")

# main block of program

dr.cfg["usersec"]=0
dr.cfg["useralias"]=""
if len(sys.argv)>1:
  isdoor = dr.readdoor(sys.argv[1])
  if isdoor == "door32":
    user = dr.cfg["useralias"].strip()
    
  
drawbg("[ ENTER/select ][ Up/Down/Home/End ][ Left/back or exit ] XQTR/2019")
getcategories()
r = 0
while r != -1 and r !=-2:
  xmenulist.exit_keys.clear()
  xmenulist.exit_keys.append('#esc')
  r = xmenulist.menulist(categories,2,6,79,21,7*16,7,r)
  if xmenulist.exit_code == "#esc":
        r = -1
  if r >=0 and xmenulist.exit_code == "#enter":
    getfeeds(categories[r])
    rf=0
    if int(dr.cfg['usersec']) >= acs:
      drawbg("[ ENTER/select ][ Up/Down/Home/End ][ ESC/back ] CTRLA:Add CTRLD:Delete")
    else:
      drawbg("[ ENTER/select ][ Up/Down/Home/End ][ ESC/back ]                XQTR/2019")
    while rf != -1 and rf !=-2:
      xmenulist.exit_keys.clear()
      xmenulist.exit_keys=['#ctrla',"#esc","#ctrld"]
      rf = xmenulist.menulist(feeds,2,6,79,21,7*16,7,rf)
      if xmenulist.exit_code == "#ctrla":
        if int(dr.cfg['usersec']) >= acs:
          addfeed(categories[r])
      if xmenulist.exit_code == "#ctrld":
        if int(dr.cfg['usersec']) >= acs:
          delfeed(categories[r],feeds[rf])
      if xmenulist.exit_code == "#esc":
        rf = -1
      if xmenulist.exit_code == "#enter" and rf>=0:
        if int(dr.cfg['usersec']) >= acs:
          drawbg("[ ENTER/select ][ Up/Down/Home/End ][ ESC/back ] CTRLA:Add CTRLD:Delete")
        else:
          drawbg("[ ENTER/select ][ Up/Down/Home/End ][ ESC/back ]                XQTR/2019")
        #getfeed(categories[r],feeds[rf].replace(" ","_"))
        ansibox(30,10,50,14,box12)
        writexy(33,12,15,'Please wait...')
        getfeed(categories[r],feeds[rf])
      
if os.path.isfile(appdir+os.sep+user+"temp.txt"):
  os.remove(appdir+os.sep+user+"temp.txt")
clrscr()  
sys.exit(0)

