avatar_sets = 
{
    {"Default Set by APAM", "avatars"},
    {"Things by APAM", "things"}
}

export_bases = 
{
    -- "fsx/dat",
    -- "dove/2013"
}

require "scripts/avatar_lib"

function edit_avatar(avatar)
    local filename = bbs_get_data_path() .. "/avatar.tmp." .. math.floor(bbs_get_node())
    local file = io.open(filename, "w")
    local table = avatar:split("\n")

    for count = 1, 5 do
        file:write(table[count])
        if #table[count] < 10 then
            file:write("\n")
        end
    end
    file:write(table[6])
    file:close()

    bbs_edit_ansi(10, 6, filename)

    local file = io.open(filename, "r")
    local contents = file:read("*all")
    file:close()

    local ret = convert_bin_to_ansi(convert_ansi_to_bin(contents, false))

    os.remove(filename)
    return ret
end

function select_avatar(avatarset)
    local done = false
    local last_offset = 0
    while true do
        bbs_write_string("\027[2J")
        for y = 0, 1 do
            for x = 0, 5 do
                avatar = load_avatar_offset(avatarset, last_offset)
                if avatar == "" then
                    done = true
                    break
                end
                display_avatar_offset(avatar, y * 8 + 2, x * 13 + 3)
                bbs_write_string(string.format("\027[%d;%dH\027[1;37;40m%d", y * 8 + 8, x * 13 + 7, last_offset + 1))
                last_offset = last_offset + 1
            end
            if done == true then
                break
            end
        end
        bbs_write_string("\027[20;1H\027[0m")
        bbs_write_string("Select Avatar Number, (P) Previous Page, (N) for Next Page, (Q) Quit : ")
        local inp = bbs_read_string(2)
        
        if inp == "p" or inp == "P" then
            done = false
            last_offset = last_offset - 26
            if last_offset < 0 then
                last_offset = 0
            end
        elseif inp == "n" or inp == "N" then
            -- nothing
        elseif inp == "q" or inp == "Q" then
            return ""
        else
            local num = tonumber(inp)
            local selected = 0
            if num ~= nil then
                selected = num - 1
                if selected < 0 then
                    selected = 0
                end
            end
            return load_avatar_offset(avatarset, selected)
        end
    end
end

function choose_set() 
    bbs_write_string("\027[2J\027[1;1H")
    bbs_write_string("Available Sets to Choose From\r\n\r\n")
    for k, v in pairs(avatar_sets) do
        bbs_write_string(string.format("(%d) %s\r\n", k, v[1]))
    end
    bbs_write_string("\r\nYour Choice? ")
    local str = bbs_read_string(2)
    if str ~= nil then
        local selection = tonumber(str)
        if selection ~= nil then
            if avatar_sets[selection] ~= nil then
                return select_avatar(avatar_sets[selection][2])
            end
        end
    end
    return ""
end

if bbs_user_has_ansi() ~= true then
    bbs_write_string("\r\nSorry, avatars require ANSI support.\r\n")
    bbs_write_string("Press any key to continue...\r\n")
    bbs_getchar()
    return
end

local avatar = bbs_get_user_attribute("script_avatar_avatar", "")

if avatar == "" then
    avatar = load_avatar_offset("avatars", 0)
end

local has_saved = false

while true do
    bbs_write_string("\027[2J\027[1;1H")
    bbs_write_string("\027[1;37m\027[1;2HThis is YOU!")
    display_avatar_offset(avatar, 3, 3)
    bbs_write_string("\027[1;37m\027[10;2H(N) Select a new avatar")
    bbs_write_string("\027[11;2H(E) Edit current avatar")
    bbs_write_string("\027[12;2H(C) Clear avatar")
    bbs_write_string("\027[14;2H(I) Import (Upload) your avatar")
    bbs_write_string("\027[15;2H(X) Export (Download) your avatar")
    bbs_write_string("\027[17;2H(S) Save Changes")
    bbs_write_string("\027[18;2H(Q) Quit")

    local inp = bbs_getchar()
    if inp == "N" or inp == "n" then
        local sel = choose_set()
        if sel ~= "" then
            avatar = sel
        end
    elseif inp == "E" or inp == "e" then
        avatar = edit_avatar(avatar)
    elseif inp == "C" or inp == "c" then
        avatar = ""
    elseif inp == "S" or inp == "s" then
        has_saved = true
        bbs_set_user_attribute("script_avatar_avatar", avatar)
    elseif inp == "I" or inp == "i" then
        bbs_write_string("\027[2J\027[1;1H")

        local filenames = bbs_upload()

        if #filenames > 0 then
            local file = io.open(filenames[1], "rb")
            local bytes = {}
            for i = 1, 120 do
                local b = file:read(1)
                if b == nil or string.byte(b) == 0x1a then
                    bytes = nil
                    break;
                end
                bytes[i] = string.byte(b)
            end
            if bytes ~= nil then
                avatar = convert_bin_to_ansi(bytes)
            end
        end
    elseif inp == "X" or inp == "x" then
        bbs_write_string("\027[2J\027[1;1H")
        local avatar_remove_n = ""

        for i = 1, #avatar do
            if avatar:sub(i, i) ~= '\n' then
                avatar_remove_n = avatar_remove_n .. avatar:sub(i, i)
            end
        end

        local bindata = convert_ansi_to_bin(avatar_remove_n, true)
        local filename = bbs_get_data_path() .. "/avatar_export." .. math.floor(bbs_get_node()) .. ".bin"
        local file = io.open(filename, "wb")
        for i = 1, #bindata do
           file:write(string.char(bindata[i]))
        end
        file:close()
        bbs_download(filename)
        os.remove(filename)
    elseif inp == "Q" or inp == "q" then
        if has_saved == true then
            if avatar ~= "" then
                bbs_write_string("\027[20;2HSend your avatar over the net? (Y/N)")
            else 
                bbs_write_string("\027[20;2HDisable your avatar over the net? (Y/N)")
            end

            local ch = bbs_getchar()

            if ch == 'y' or ch == 'Y' then
                if avatar ~= "" then
                    for i = 1, #export_bases do
                        local avatar_remove_n = ""

                        for i = 1, #avatar do
                            if avatar:sub(i, i) ~= '\n' then
                                avatar_remove_n = avatar_remove_n .. avatar:sub(i, i)
                            end
                        end

                        local bindata = convert_ansi_to_bin(avatar_remove_n, false)
                        local stringdata = ""

                        for i = 1, #bindata do
                            stringdata = stringdata .. string.char(bindata[i])
                        end
                        export_message(export_bases[i], stringdata)
                    end
                else
                    for i = 1, #export_bases do
                        export_message(export_bases[i], "disabled")
                    end
                end
            end
        end
        return
    end
end

