/* YAK - Copyright (c) 1997 Timo Sirainen - read license.txt */

/* tossmsgs.c - Toss reply packets */

/* Todo: Hippo and OMEN formats */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <time.h>

#ifdef BIG_ENDIAN
/* Why does Linux define this even with intel CPU? Oh well.. */
#  undef BIG_ENDIAN
#  include "bluewave.h"
#  define BIG_ENDIAN
#else
#  include "bluewave.h"
#endif

#include "qwk.h"

#include "os.h"
#include "memory.h"
#include "userbase.h"
#include "download.h"
#include "filelist.h"
#include "ask_str.h"
#include "timeslic.h"
#include "crc32.h"
#include "threads.h"
#include "files.h"
#include "nodes.h"
#include "keyb.h"
#include "modem.h"
#include "output.h"
#include "mareas.h"
#include "fareas.h"
#include "logfile.h"
#include "messages.h"
#include "msg_jam.h"
#include "config.h"
#include "lastcall.h"
#include "bbs_func.h"
#include "setup.h"
#include "language.h"

/* Hex comparation for packer configuration */
int hexcmp(char *data, char *search)
{
    char hextable[] = "0123456789ABCDEF";
    char hexstr[100], *pstr;

    if (*search == '\0') return 0;

    /* Copy string -> hex string */
    pstr = hexstr;
    while (*data != '\0')
    {
        *pstr++ = hextable[(unsigned char) *data >> 4];
        *pstr++ = hextable[*data & 0x0f];
        data++;
    }
    *pstr = '\0';

    /* Compare strings */
    pstr = hexstr;
    while (*search != '\0')
    {
        if (*search != '?')
        {
            if (*search != *pstr) return 0;
        }
        else
        {
            if (*pstr == '\0') return 0;
        }
        search++; pstr++;
    }

    return 1;
}

int unpack_msgpacket(char *fname)
{
    unsigned errlvl;
    char str[256], execstr[256], old_path[MAX_PATH_LEN];
    PACKER_REC *packer;
    FILE *F;

    sprintf(str, "%s"SSLASH"upload"SSLASH"%s", hold_farea.path, fname);
    F = fopen(str, "rb");
    if (F == NULL)
    {
        output("\r\nFATAL: Can't open reply packet file!\r\n");
        write_log("Can't open reply packet %s", str);
        return 0;
    }

    packer = NULL;
    if (fread(str, 30, 1, F))
    {
        packer = firstpacker;
        while (packer != NULL)
        {
            if (hexcmp(str, packer->id))
            {
                break;
            }
            packer = packer->next;
        }
    }
    fclose(F);

    if (packer == NULL)
    {
        output(lang[LANG_UNKNOWN_PACKET]);
        write_log("Unknown packer in reply packet, first 30 bytes = '%s'", str);
        return 0;
    }

    getcwd(old_path, sizeof(old_path));
    change_dir(hold_farea.path);

    sprintf(str, "%s"SSLASH"upload"SSLASH"%s", hold_farea.path, fname);
    sprintf(execstr, packer->unpack, str);

    write_log("Command line: %s", execstr);
    printf("\nCommand line: %s\n", execstr);
#ifdef __linux__
    tty_old();
#endif
    errlvl = system(execstr);
#ifdef __linux__
    tty_raw();
#endif
    write_log("Errorlevel: %u (%x)", errlvl, errlvl);
    printf("\nErrorlevel: %u (%x)\n", errlvl, errlvl);

    remove(str);

    change_dir(old_path);

    return errlvl == 0;
}

int verify_receiver(void)
{
    int slen,first;
    char text[100];

    /* Redirect messages to "sysop" to real sysop */
    if (stricmp(msg_to,"SYSOP") == 0) strcpy(msg_to,sysop_name);

    /* If echo- or netmail area, quit. */
    if ((marea.flags & (MAREA_FLAG_ECHO|MAREA_FLAG_NETMAIL)) != 0) return 1;

    /* Check if user exists.. */
    first = 1;
    while (scan_user(msg_to) == 0)
    {
        if (!carr_det()) break;
        if (stricmp(msg_to,"All") == 0)
        {
            /* 'All' message */
            if (marea.flags & MAREA_FLAG_PUBLIC_MSGS) return 1;
            strcpy(text, lang[LANG_TOSS_NO_ALL_MSGS]);
        }
        else
        {
            strcpy(text, lang[LANG_TOSS_USER_NOT_EXIST]);
        }

        if (first)
        {
            /* Display receiver and subject, only once. */
            first = 0;
            output(lang[LANG_TOSS_SHOW_AREA]);
        }
        output(text);

        /* Ask receiver */
        if (!ask_string(lang[LANG_TOSS_ASK_RECEIVER], msg_to, sizeof(msg_to)-1, 0, NULL) || msg_to[0] == '\0') return 0;

        slen = strlen(msg_to)-1;
        if (msg_to[slen] == '?')
        {
            /* Show userbase */
            msg_to[slen] = '\0';
            userlist(msg_to);
        }
    }
    if (!first) outtext("\r\n");

    return 1;
}

int toss_bw_packet(char *fname)
{
    int Folc;
    FILE *Fupl,*Fpdq,*F;
    DUPE_REC dupe;
    UPL_HEADER uplhdr;
    UPL_REC uplrec;
    PDQ_HEADER pdqhdr;
    PDQ_REC pdqrec;
    NETADDR_REC *net;
    char *old_flags;
    unsigned long oldrec,rec;

    char tearline[30],str[256],addr[30],name[20],*strp;
    int replies,hdrlen,reclen,global,slen,num;

    write_log("Tossing Blue Wave reply packet");

    if (!unpack_msgpacket(fname))
    {
        output(lang[LANG_TOSS_CANT_UNPACK]);
        write_log("Could not unpack message packet '%s'",fname);
        return 0;
    }

    if (restrict_usage & NO_MESSAGES)
    {
        output("\r\nThread #%d restricts usage of message commands!\r\n",restrictive_thread(NO_MESSAGES));
        return 0;
    }

    tearline[0] = '\0';

    output("\r\n");

    oldrec = current_marea;
#ifdef __FILES_CASE_SENSITIVE__
    sprintf(str, "%s"SSLASH"%s.upl", hold_farea.path, msg_packet_id);
    if (search_ign_file(str) == NULL)
        Fupl = NULL;
    else
        Fupl = fopen(str, "rb");
#else
    sprintf(str, "%s"SSLASH"%s.upl", hold_farea.path, msg_packet_id);
    Fupl = fopen(str, "rb");
#endif
    if (Fupl != NULL)
    {
        if (fread(&uplhdr,sizeof(uplhdr),1,Fupl) == 1)
        {
            strp = (char *) uplhdr.vernum;
            while (*strp != '\0') *(strp++) += 10;

            if (uplhdr.reader_tear[0] != '\0')
            {
                /* Create tear line */
                if (uplhdr.vernum[0] != '\0')
                    sprintf(tearline,"%s v%s",uplhdr.reader_tear,uplhdr.vernum);
                else
                    sprintf(tearline,"%s v%d.%02d",uplhdr.reader_tear,uplhdr.reader_major,uplhdr.reader_minor);
                if (uplhdr.not_registered != 0)
                    strcat(tearline," [unreg]");
                else if (uplhdr.regnum[0] != '\0')
                    strcat(tearline," [reg]");
            }
            else
            {
                conv_macros(bw_tear, tearline);
            }

            hdrlen = uplhdr.upl_header_len==0 ? sizeof(UPL_HEADER) : uplhdr.upl_header_len;
            reclen = uplhdr.upl_rec_len==0 ? sizeof(UPL_REC) : uplhdr.upl_rec_len;

            fseek(Fupl,hdrlen,SEEK_SET);
            replies = 0;
            while (fread(&uplrec,reclen,1,Fupl) == 1)
            {
                /* Is reply inactive? */
                if ((uplrec.msg_attr & UPL_INACTIVE) == 0)
                {
                    /* Is duplicate? */
                    dupe.usercrc = crc32_block(usrsub.name,strlen(usrsub.name));
                    dupe.hdrcrc = crc32_block(&uplrec,sizeof(uplrec));
                    dupe.txtcrc = 0xffffffff; /* Unused.. */
                    if (check_dupe_msg(&dupe) == 1)
                    {
                        output(lang[LANG_TOSS_DUPE]);
                        write_log("Duplicate message. Deleted.");
                    }
                    else
                    {
                        /* Find area */
                        if (search_bwtag((char *) uplrec.echotag) == 1)
                        {
                            memcpy(&msg_area, &marea, sizeof(msg_area));
                            if (marea.flags & MAREA_FLAG_WRITE_RIGHTS)
                            {
                                /* Open area */
                                if (open_msgarea(marea.path,TYPE_JAM) == 1)
                                {
#ifdef __FILES_CASE_SENSITIVE__
                                    search_ign_file((char *) uplrec.filename);
#endif
                                    check_message_text((char *) uplrec.filename);

                                    strcpy(msg_from,usrsub.name);
                                    strcpy(msg_to,(char *) uplrec.to);
                                    strcpy(msg_subj,(char *) uplrec.subj);
                                    msg_zone = uplrec.destzone;
                                    msg_net = uplrec.destnet;
                                    msg_node = uplrec.destnode;
                                    msg_point = uplrec.destpoint;
                                    msg_date = uplrec.unix_date;
                                    msg_replyto = uplrec.replyto;

                                    msg_reply_kludge[0] = '\0';

                                    if (marea.flags & MAREA_FLAG_NETMAIL)
                                    {
                                        /* Get origin net */
                                        net = get_nearest_net(msg_zone,msg_net,msg_node,msg_point);
                                        sprintf(addr, "%u:%u/%u.%u", net->zone, net->net, net->node, net->point);
                                        strcpy(msg_orig_net, addr);

                                        if (strncmp((char *) uplrec.net_dest,"REPLY: ",7) == 0) strcpy(msg_reply_kludge,(char *) uplrec.net_dest+7);
                                        if (uplrec.destpoint != 0)
                                            sprintf(msg_dest_net,"%u:%u/%u.%u",uplrec.destzone,uplrec.destnet,uplrec.destnode,uplrec.destpoint);
                                        else
                                            sprintf(msg_dest_net,"%u:%u/%u",uplrec.destzone,uplrec.destnet,uplrec.destnode);
                                    }
                                    else
                                    {
                                        msg_orig_net[0] = '\0';
                                        msg_dest_net[0] = '\0';
                                    }

                                    if (marea.flags & MAREA_FLAG_ECHO)
                                    {
                                        net = firstnet; num = 1;
                                        while (net != NULL && num < marea.nodeaddr)
                                        {
                                            net = net->next; num++;
                                        }
                                        if (net == NULL) net = firstnet;
                                        if (net->point != 0)
                                            sprintf(addr, "%u:%u/%u.%u", net->zone, net->net, net->node, net->point);
                                        else
                                            sprintf(addr, "%u:%u/%u", net->zone, net->net, net->node);

                                        sprintf(str, "%s"SSLASH"%s", hold_farea.path, uplrec.filename);
                                        F = fopen(str, "a+b");
                                        if (F != NULL)
                                        {
                                            if (tearline[0] != '\0')
                                                fprintf(F,"\r\r--- %s\r",tearline);
                                            else
                                                fprintf(F,"\r\r---\r");
                                            sprintf(str," * Origin: %s",origin_line);
                                            str[79-strlen(addr)-3] = '\0';
                                            fprintf(F,"%s (%s)",str,addr);
                                            fclose(F);
                                        }
                                        if (strncmp((char *) uplrec.net_dest,"REPLY: ",7) == 0) strcpy(msg_reply_kludge,(char *) uplrec.net_dest+7);
                                    }
                                    sprintf(msg_msgid_kludge,"%s %08lx", addr, get_msgid());

                                    /* Character set convertion */
                                    sprintf(msg_charset_kludge, "CHARSET: %s", marea.charset->kludge);

                                    sprintf(str, "%s"SSLASH"%s", hold_farea.path, uplrec.filename);
                                    convert_file(str, marea.charset->outtable);
                                    convert_string(msg_from, marea.charset->outtable);
                                    convert_string(msg_to, marea.charset->outtable);
                                    convert_string(msg_subj, marea.charset->outtable);

                                    if (verify_receiver())
                                    {
                                        msg_flags = 0;
                                        sprintf(str, "%s"SSLASH"%s", hold_farea.path, uplrec.filename);
                                        if (msg_enter_msg(str) == 0)
                                        {
                                            output("Could not write message to message base in area '%s'\r\n",marea.name);
                                            write_log("Could not write message to message base in area '%s'",marea.name);
                                        }
                                        else
                                        {
                                            output(lang[LANG_TOSS_AREA]);
                                            write_log("Written message to area '%s'",marea.name);
                                            str[0] = NODETEXT_MSGWRITTEN;
                                            sprintf(str+1,"%u;@X0F%s viesti #%u: %s -> %s",current_marea,marea.name,msg_messages,msg_from,msg_to);
                                            send_nodetext(str,0);
                                            user.MsgsWritten++;
                                            current_lastrec.done_flags |= DONE_WRITE;
                                            add_dupe_msg(&dupe);
                                        }
                                    }
                                    sprintf(str, "%s"SSLASH"%s", hold_farea.path, uplrec.filename);
#ifdef __FILES_CASE_SENSITIVE__
                                    if (search_ign_file(str) != NULL)
#endif
                                        remove(str);
                                }
                                else
                                {
                                    output("Error opening area '%s'\r\n",marea.name);
                                    write_log("Error opening area '%s'",marea.name);
                                }
                            }
                            else
                            {
                                output(lang[LANG_TOSS_NO_RIGHTS]);
                                write_log("No write rights to area '%s'",marea.name);
                            }
                        }
                        else
                        {
                            output(lang[LANG_TOSS_AREA_NOT_FOUND], (char *) uplrec.echotag);
                            write_log("Area not found: '%s'",(char *) uplrec.echotag);
                        }
                    }
                }
                else
                {
                    write_log("Inactive message uploaded %s -> %s",uplrec.from,uplrec.to);
                }

                replies++;
                fseek(Fupl,hdrlen+reclen*replies,SEEK_SET);
            }
        }
        fclose(Fupl);
        sprintf(str, "%s"SSLASH"%s.upl", hold_farea.path, msg_packet_id);
#ifdef __FILES_CASE_SENSITIVE__
        if (search_ign_file(str) != NULL)
#endif
            remove(str);
    }
    else
    {
        output(lang[LANG_TOSS_INVALID_PKT], "Blue Wave");
        write_log("'%s.upl' not found from reply packet", msg_packet_id);
    }

    /* .pdq file in packet */
    sprintf(name, "%s"SSLASH"%s.pdq", hold_farea.path, msg_packet_id);
#ifdef __linux__
    if (search_ign_file(name) != NULL) Fpdq = fopen(name, "rb"); else Fpdq = NULL;
#else
    Fpdq = fopen(name, "rb");
#endif
    if (Fpdq != NULL)
    {
        output(lang[LANG_TOSS_OFFLINE_CONFIG]);
        write_log(".PDQ file uploaded");
        if (fread(&pdqhdr,sizeof(pdqhdr),1,Fpdq) && pdqhdr.flags & PDQ_AREA_CHANGES)
        {
            old_flags = (char *) _malloc(msg_areas);
            for (rec=1; rec<=msg_areas; rec++)
            {
                if (!read_marea_record(rec)) continue;
                old_flags[rec] = (marea_rec->flags & MAREA_FLAG_SELECTED) > 0;
                if ((marea_rec->flags & MAREA_FLAG_FORCED) == 0) marea_rec->flags &= ~MAREA_FLAG_SELECTED;
            }
            
            while (fread(&pdqrec,sizeof(pdqrec),1,Fpdq))
            {
                if (!search_bwtag((char *) pdqrec.echotag))
                {
                    output(lang[LANG_OFFCFG_NO_AREA], pdqrec.echotag);
                }
                else
                {
                    memcpy(&msg_area, &marea, sizeof(msg_area));
                    if (!old_flags[current_marea])
                        output(lang[LANG_OFFCFG_ADD]);
                    else
                        old_flags[current_marea] = 2;
                    marea_rec->flags |= MAREA_FLAG_SELECTED;
                }
            }

            for (rec=0; rec<msg_areas; rec++)
            {
                if (old_flags[rec] == 1)
                {
                    if (!read_marea_record(rec)) continue;
                    memcpy(&msg_area, &marea, sizeof(msg_area));
                    output(lang[LANG_OFFCFG_DROP]);
                }
            }

            _free(old_flags);
        }
        else
        {
            output(lang[LANG_OFFCFG_NO_CHANGES]);
        }
        fclose(Fpdq);
        remove(name);
    }

    /* .olc file in packet */
    sprintf(name, "%s"SSLASH"%s.olc", hold_farea.path, msg_packet_id);
#ifdef __linux__
    if (search_ign_file(name) != NULL)
        Folc = FileOpen(name, O_RDONLY | O_BINARY, SH_DENYNO);
    else
        Folc = -1;
#else
    Folc = FileOpen(name, O_RDONLY | O_BINARY, SH_DENYNO);
#endif
    if (Folc != -1)
    {
        output(lang[LANG_TOSS_OFFLINE_CONFIG]);
        write_log(".OLC file uploaded");

        old_flags = (char *) _malloc(msg_areas);
        for (rec=1; rec<=msg_areas; rec++)
        {
            if (!read_marea_record(rec)) continue;
            old_flags[rec] = (marea_rec->flags & MAREA_FLAG_SELECTED) > 0;
            if ((marea_rec->flags & MAREA_FLAG_FORCED) == 0) marea_rec->flags &= ~MAREA_FLAG_SELECTED;
        }

        global = 0;
        while (_fgets(str,sizeof(str),Folc) != NULL)
        {
            if (str[0] == '\0') continue; /* Empty */

            /* Strip all leading spaces */
            slen = strlen(str);
            while (slen > 0 && (str[slen-1] == ' ' || str[slen-1] == 9)) slen--;
            str[slen] = '\0';

            /* Strip all  */
            strp = str;
            while (*strp == ' ' || *strp == 9) strp++;

            if (*strp == '\0') continue; /* Empty */

            if (*strp == '[')
            {
                strp[strlen(strp)-1] = '\0';
                if (!search_bwtag(strp+1))
                {
                    if (stricmp(strp+1,"Global Mail Host Configuration") == 0 || stricmp(strp+1,"Global Mail Host Information") == 0)
                    {
                        global = 1;
                    }
                    else
                    {
                        output(lang[LANG_OFFCFG_NO_AREA], strp+1);
                    }
                }
                else
                {
                    memcpy(&msg_area, &marea, sizeof(msg_area));
                    global = 0;

                    if (!old_flags[current_marea])
                        output(lang[LANG_OFFCFG_ADD]);
                    else
                        old_flags[current_marea] = 2;
                    marea_rec->flags |= MAREA_FLAG_SELECTED;
                }
            }
            else
            {
                if (global)
                {
                    /* Check from global settings */
                    if (strnicmp(strp,"AreaChanges",11) == 0)
                    {
                        strp = strchr(strp,'=');
                        if (strp != NULL)
                        {
                            strp++;
                            while (*strp == ' ' || *strp == 9) strp++;
                            if (toupper(*strp) != 'Y' && toupper(*strp) != 'T' && (toupper(*strp) != 'O' || toupper(*(strp+1)) != 'N'))
                            {
                                /* No area changes, nothing to do */
                                break;
                            }
                        }
                    }
                }
            }
        }

        /* Display all areas which went off */
        for (rec=0; rec<msg_areas; rec++)
        {
            if (old_flags[rec] == 1)
            {
                if (!read_marea_record(rec)) continue;
                memcpy(&msg_area, &marea, sizeof(msg_area));
                if (marea.flags & MAREA_FLAG_FORCED)
                    output(lang[LANG_OFFCFG_NO_FORCED]);
                else
                    output(lang[LANG_OFFCFG_DROP]);
            }
        }

        _free(old_flags);
        FileClose(Folc);
        remove(name);
    }
    read_marea_record(oldrec);
    memcpy(&msg_area, &marea, sizeof(msg_area));
    open_msgarea(marea.path, TYPE_JAM);

    return 1;
}

char *getstr(char *str, char size)
{
    int num;

    str[size] = '\0';
    for (num=size-1; num>=0; num--)
    {
        if (str[num] != ' ' && str[num] != '\0')
        {
            str[num+1] = '\0';
            break;
        }
    }
    return str;
}

int toss_qwk_packet(char *fname)
{
    int Fmsg;
    FILE *F;
    QWK_REC qwk;
    DUPE_REC dupe;
    char str[256],outstr[128],addr[30],*strp;
    unsigned short zone,net,node,point;
    unsigned nro,pos,wpos,num;
    unsigned long oldrec,blocks;
    struct tm tim;
    NETADDR_REC *netn;

    write_log("Tossing QWK reply packet");

    if (!unpack_msgpacket(fname))
    {
        output(lang[LANG_TOSS_CANT_UNPACK]);
        write_log("Could not unpack message packet '%s'",fname);
        return 0;
    }

    output("\r\n");

    oldrec = current_marea;
    sprintf(str, "%s"SSLASH"%s.msg", hold_farea.path, msg_packet_id);
    Fmsg = FileOpenIgn(str, O_RDONLY | O_BINARY, SH_DENYNO);
    if (Fmsg == -1)
    {
        output(lang[LANG_TOSS_INVALID_PKT], "QWK");
        write_log("'%s.msg' not found from reply packet", msg_packet_id);
    }
    else
    {
        if (FileRead(Fmsg,&qwk,sizeof(qwk)) != sizeof(qwk))
        {
            output("\r\nError! Could not read QWK reply packet header\r\n", msg_packet_id);
            write_log("Could not read packet header from file '%s.msg'", msg_packet_id);
        }
        else
        {
            while (FileRead(Fmsg,&qwk,sizeof(qwk)) == sizeof(qwk))
            {
                if (qwk.active == 225)
                {
                    /* Is duplicate? */
                    dupe.usercrc = crc32_block(usrsub.name,strlen(usrsub.name));
                    dupe.hdrcrc = crc32_block(&qwk,sizeof(qwk));
                    dupe.txtcrc = 0xffffffff; /* Unused.. */
                    if (check_dupe_msg(&dupe) == 1)
                    {
                        output(lang[LANG_TOSS_DUPE]);
                        write_log("Duplicate message. Deleted.");
                    }
                    else
                    {
                        if (search_areanum(qwk.conf))
                        {
                            memcpy(&msg_area, &marea, sizeof(msg_area));
                            if (marea.flags & MAREA_FLAG_WRITE_RIGHTS)
                            {
                                /* Open area */
                                if (!open_msgarea(marea.path,TYPE_JAM))
                                {
                                    output("Error opening area '%s'\r\n",marea.name);
                                    write_log("Error opening area '%s'",marea.name);
                                }
                                else
                                {
                                    memcpy(str,qwk.blocks,6); getstr(str,6);
                                    blocks = atol(str);

                                    /* Reply text */
                                    sprintf(str, "%s"SSLASH"msgtmp", hold_farea.path);
                                    F = fopen(str, "w+b");
                                    if (F == NULL)
                                    {
                                        output("FATAL: Could not create file '%s'! Could not toss replies!\r\n", str);
                                        write_log("Could not create file '%s'. Could not toss replies!", str);
                                        return 0;
                                    }

                                    while (blocks > 2)
                                    {
                                        if (FileRead(Fmsg,str,128) <= 0) break;
                                        wpos = 0;
                                        for (nro=0; nro<128; nro++)
                                        {
                                            if ((unsigned char) str[nro] == 227)
                                            {
                                                outstr[wpos] = 13;
                                                wpos++;
                                                outstr[wpos] = 10;
                                            }
                                            else
                                            {
                                                outstr[wpos] = str[nro];
                                            }
                                            wpos++;
                                        }
                                        fwrite(outstr,1,wpos,F);
                                        blocks--;
                                    }

                                    /* And the last block.. Also removes all the spaces. */
                                    if (FileRead(Fmsg,str,128) == 128)
                                    {
                                        for (pos=127; pos>0; pos--)
                                        {
                                            if ((str[pos] != ' ') && (str[pos] != 0))
                                            {
                                                wpos = 0;
                                                for (nro=0; nro<=pos; nro++)
                                                {
                                                    if ((unsigned char) str[nro] == 227)
                                                    {
                                                        outstr[wpos] = 13;
                                                        wpos++;
                                                        outstr[wpos] = 10;
                                                    }
                                                    else
                                                    {
                                                        outstr[wpos] = str[nro];
                                                    }
                                                    wpos++;
                                                }
                                                fwrite(outstr,1,wpos,F);
                                                break;
                                            }
                                        }
                                    }
                                    fclose(F);

                                    strcpy(msg_from,usrsub.name);
                                    /*memcpy(msg_from,qwk.mfrom,25); getstr(msg_from,25);*/
                                    memcpy(msg_to,qwk.mto,25); getstr(msg_to,25);
                                    memcpy(msg_subj,qwk.subj,25); getstr(msg_subj,25);
                                    memset(&tim,0,sizeof(tim));

                                    tim.tm_mday = (qwk.date[3]-'0')*10 + (qwk.date[4]-'0');
                                    tim.tm_mon = (qwk.date[0]-'0')*10 + (qwk.date[1]-'0')-1;
                                    tim.tm_year = (qwk.date[6]-'0')*10 + (qwk.date[7]-'0');
                                    tim.tm_hour = (qwk.time[0]-'0')*10 + (qwk.time[1]-'0');
                                    tim.tm_min = (qwk.time[3]-'0')*10 + (qwk.time[4]-'0');
                                    tim.tm_sec = 0;
                                    msg_date = mktime(&tim);

                                    memcpy(str,qwk.reply,8); getstr(str,8);
                                    msg_replyto = atol(str);
                                    msg_reply_kludge[0] = '\0';

                                    if (marea.flags & MAREA_FLAG_NETMAIL)
                                    {
                                        /* Try to take destination from subject */
                                        strp = strchr(msg_subj,' ');
                                        if (strp != NULL) *strp = '\0';
                                        if (!str2addr(msg_subj,&zone,&net,&node,&point))
                                        {
                                            /* Ask destination */
                                            addr[0] = '\0';
                                            output(lang[LANG_TOSS_NETMSG_HDR]);
                                            do
                                            {
                                                if (!ask_string(lang[LANG_TOSS_NETMSG_ASK], addr, 23, 0, NULL)) return 0;
                                            } while (str2addr(addr,&zone,&net,&node,&point) == 0);
                                            output("\r\n");
                                        }
                                        else
                                        {
                                            if (strp == NULL)
                                                msg_subj[0] = '\0';
                                            else
                                                memmove(msg_subj,strp,strlen(strp)+1);
                                        }

                                        netn = get_nearest_net(zone,net,node,point);
                                        sprintf(addr, "%u:%u/%u.%u", netn->zone, netn->net, netn->node, netn->point);
                                        strcpy(msg_orig_net,addr);
                                        sprintf(msg_dest_net,"%u:%u/%u.%u",zone,net,node,point);
                                    }
                                    else
                                    {
                                        msg_orig_net[0] = '\0';
                                        msg_dest_net[0] = '\0';
                                    }

                                    if (marea.flags & MAREA_FLAG_ECHO)
                                    {
                                        netn = firstnet; num = 1;
                                        while (netn != NULL && num < marea.nodeaddr)
                                        {
                                            netn = netn->next; num++;
                                        }
                                        if (netn == NULL) netn = firstnet;
                                        if (netn->point != 0)
                                            sprintf(addr, "%u:%u/%u.%u", netn->zone, netn->net, netn->node, netn->point);
                                        else
                                            sprintf(addr, "%u:%u/%u", netn->zone, netn->net, netn->node);

                                        sprintf(str, "%s"SSLASH"msgtmp", hold_farea.path);
                                        F = fopen(str, "a+b");
                                        if (F != NULL)
                                        {
                                            conv_macros(qwk_tear, str);
                                            fprintf(F,"\r--- %s\r", str);
                                            sprintf(str," * Origin: %s", origin_line);
                                            str[79-strlen(addr)-3] = '\0';
                                            fprintf(F,"%s (%s)", str, addr);
                                            fclose(F);
                                        }
                                    }
                                    sprintf(msg_msgid_kludge, "%s %08lx", addr, get_msgid());
                                    msg_reply_kludge[0] = '\0';
                                    //strcpy(msg_reply_kludge,jostain);

                                    /* Character set convertion */
                                    sprintf(msg_charset_kludge, "CHARSET: %s", marea.charset->kludge);

                                    sprintf(str, "%s"SSLASH"msgtmp", hold_farea.path);
                                    convert_file(str, marea.charset->outtable);
                                    convert_string(msg_from, marea.charset->outtable);
                                    convert_string(msg_to, marea.charset->outtable);
                                    convert_string(msg_subj, marea.charset->outtable);

                                    if (verify_receiver())
                                    {
                                        msg_flags = 0;
                                        sprintf(str, "%s"SSLASH"msgtmp", hold_farea.path);
                                        if (msg_enter_msg(str) == 0)
                                        {
                                            output("Could not write message to message base in area @MAREA_NAME@\r\n");
                                            write_log("Could not write message to message base in area @MAREA_NAME@");
                                        }
                                        else
                                        {
                                            output(lang[LANG_TOSS_AREA]);
                                            write_log("Written message to area %s",marea.name);
                                            str[0] = NODETEXT_MSGWRITTEN;
                                            sprintf(str+1,"%u;@X0F%s viesti #%u: %s -> %s",current_marea,marea.name,msg_messages,msg_from,msg_to);
                                            send_nodetext(str,0);
                                            user.MsgsWritten++;
                                            current_lastrec.done_flags |= DONE_WRITE;
                                            add_dupe_msg(&dupe);
                                        }
                                    }
                                    sprintf(str, "%s"SSLASH"msgtmp", hold_farea.path);
                                    remove(str);
                                }
                            }
                            else
                            {
                                output(lang[LANG_TOSS_NO_RIGHTS]);
                                write_log("No write rights to area %s", marea.name);
                            }
                        }
                        else
                        {
                            sprintf(str, "%u", qwk.conf);
                            output(lang[LANG_TOSS_AREA_NOT_FOUND], str);
                            write_log("Area %u not found\r\n", qwk.conf);
                        }
                    }
                }
            }
        }
        FileClose(Fmsg);

        sprintf(str, "%s.msg", msg_packet_id);
#ifdef __FILES_CASE_SENSITIVE__
        if (search_ign_file(str) != NULL)
#endif
            remove(str);
    }
    read_marea_record(oldrec);
    memcpy(&msg_area, &marea, sizeof(msg_area));
    open_msgarea(marea.path, TYPE_JAM);

    return 1;
}
