#include "modem.h"
#include "output.h"
#include "userbase.h"
#include "timeslic.h"
#include "bbs_func.h"

unsigned char mdm_waiting;
int reqx, reqy; /* Response to esc[2n command */

int mdm_getch(void)
{
    unsigned char hitch;
    int num;

    reqx = reqy = 0;
    if (hCom == 0) return 0;

    inactivity = 0; told_inactivity = 0;
    if (mdm_waiting)
    {
        hitch = mdm_waiting;
        mdm_waiting = 0;
        return hitch;
    }

    hitch = mdm_charin();
    if (hitch == 27)
    {
        /* Got ESC */
        if (!wait_modem()) return 27;

        /* More text to come. */
        hitch = mdm_charin();
        if (hitch == '[')
        {
            if (!wait_modem()) return 27;
            hitch = mdm_charin();

            if (hitch >= '0' && hitch <= '9')
            {
                num = 0;
                while (hitch >= '0' && hitch <= '9')
                {
                    num = num*10+hitch-'0';
                    if (!wait_modem()) return 27;
                    hitch = mdm_charin();
                }

                if (hitch == 'n')
                {
                    /* This might be esc[0n response to esc[5n request */
                    if (num == 0)
                    {
                        /* ANSI X3.64 emulation detected. */
                        user.Emulation = USER_EMULATION_ANSI_X364;
                        mdm_waiting = 254;
                        return 0;
                    }
                }

                if (hitch == ';')
                {
                    /* This might be esc[yy;xxR .. response to esc[6n
                    request */
                    reqy = num; num = 0;

                    if (!wait_modem()) return 27;
                    hitch = mdm_charin();

                    while (hitch >= '0' && hitch <= '9')
                    {
                        num = num*10+hitch-'0';
                        if (!wait_modem()) return 27;
                        hitch = mdm_charin();
                    }
                    reqx = num;
                    if (hitch == 'R')
                    {
                        /* ANSI detected */
                        if (user.Emulation != USER_EMULATION_ANSI_X364)
                            user.Emulation = USER_EMULATION_ANSI;
                    }
                    else
                    {
                        /* Some weird code sent to me .. */
                        reqx = reqy = 0;
                    }
                    mdm_waiting = 254;
                    return 0;
                }

                if (hitch == '~')
                {
                    switch (num)
                    {
                        case 1:
                            /* Home */
                            mdm_waiting = 'G';
                            return 0;
                        case 2:
                            /* Insert */
                            mdm_waiting = 'R';
                            return 0;
                        case 3:
                            /* Delete */
                            mdm_waiting = 'S';
                            return 0;
                        case 4:
                            /* End */
                            mdm_waiting = 'O';
                            return 0;
                        case 5:
                            /* PgUp */
                            mdm_waiting = 'I';
                            return 0;
                        case 6:
                            /* PgDn */
                            mdm_waiting = 'Q';
                            return 0;
                    }
                }

                return 27;
            }

            switch (hitch)
            {
                case '?':
                    mdm_waiting = 254;

                    /* Get chr */
                    if (!wait_modem()) return 0;
                    hitch = mdm_charin();
                    if (hitch == 'c') goto __ok;

                    /* Wait for ';' */
                    if (!wait_modem()) return 0;
                    hitch = mdm_charin();
                    if (hitch == 'c') goto __ok;
                    if (hitch != ';') return 0;

                    /* Get chr */
                    if (!wait_modem()) return 0;
                    hitch = mdm_charin();
                    if (hitch == 'c') goto __ok;

                    /* Wait for 'c' */
                    if (!wait_modem()) return 0;
                    hitch = mdm_charin();
                    if (hitch != 'c') return 0;

                    /* ANSI X3.64 detected */
                __ok:
                    user.Emulation = USER_EMULATION_ANSI_X364;
                    return 0;
                case 'A':
                    /* Cursor up */
                    mdm_waiting = 'H';
                    return 0;
                case 'B':
                    /* Down */
                    mdm_waiting = 'P';
                    return 0;
                case 'C':
                    /* Right */
                    mdm_waiting = 'M';
                    return 0;
                case 'D':
                    /* Left */
                    mdm_waiting = 'K';
                    return 0;
                case 'H':
                    /* Home */
                    mdm_waiting = 'G';
                    return 0;
                case 'K':
                    /* End */
                    mdm_waiting = 'O';
                    return 0;
            }
        }
    }
    if (user.Attrib1 & USER_ATTRIB_VT100_KEYB)
    {
        if (hitch == 127)
            hitch = 8;
        else if (hitch == 8)
            hitch = 127;
    }
    else if (logging && hitch == 127)
        hitch = 8;

    return chr_in[hitch];
}
