#ifndef __MEMORY_H
#define __MEMORY_H

#ifdef DEBUG_MALLOC
void *mem_alloc(unsigned size, char *fname, unsigned long linenum);
void *mem_free(void *ptr, char *fname, unsigned long linenum);
void mem_init(void);
void mem_deinit(void);
#  define _malloc(a) mem_alloc(a, __FILE__, __LINE__)
#  define _free(a) mem_free(a, __FILE__, __LINE__)
#  define _meminit() mem_init()
#  define _memdeinit() mem_deinit()
#else
#  include <malloc.h>
#  define _malloc(a) malloc(a)
#  define _free(a) free(a)
#  define _meminit()
#  define _memdeinit()
#endif

#endif
