CC = cc

# Required options
CFLAGS = -c -fpack-struct

# All warnings on
CFLAGS += -Wall

# Optimizations
CFLAGS += -O3 -m386 -fomit-frame-pointer

# Debugging
#CFLAGS += -g

# malloc() debugging. Slows up but log shows if allocated memory wasn't ever
# deallocated (internal smodem still has these..).
CFLAGS += -DDEBUG_MALLOC

# Use buildin SModem
CFLAGS += -DBUILDIN_SMODEM

# Define these if you don't have strchr() or strstr() functions
#-DWANT_STRCHR -DWANT_STRSTR

# Linker
LD = cc
LFLAGS =

OBJS = ask_str.o bbs.o bbs_func.o buildfb.o config.o chat.o crc32.o download.o fareas.o filelist.o files.o fsearch.o fsed.o getdescs.o grabmsgs.o keyb_lnx.o language.o lastcall.o logfile.o mareas.o modem.o mdm_lnx.o memory.o menutype.o messages.o msg_jam.o new_user.o nodes.o os.o output.o quote.o setup.o showfile.o threads.o timeslic.o toplist.o tossmsgs.o upload.o userbase.o waitcall.o smodem/smodem.o smodem/mslp.o smodem/terminal.o

.SUFFIXES: .cpp .o

.c.o:
	$(CC) $(CFLAGS) -c $<

all: ../bbs

../bbs: $(OBJS)
	$(LD) $(LFLAGS) $(OBJS) -o ../bbs
	rm -f /usr/local/bin/bbs
	install ../bbs /usr/local/bin -g bbs -o bbs -m 0770

output.o: version.h
language.o: language.h
