/* YAK - Copyright (c) 1997 Timo Sirainen - read license.txt */

/* buildfb.c - Build filebase indexes */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>

#include "os.h"
#include "memory.h"
#include "fareas.h"
#include "fsearch.h"
#include "files.h"
#include "config.h"

static int Fdat;
static int Fidx;

int build_database(char *path, int fbbs)
{
    int Fdes,lastpos;
    char fname[256],tmp[256],*desc,*data,*strp,*strp2,writenul;
    unsigned long fpos;
    FILEBASE_REC fbase;
    struct stat statbuf;
    struct tm tim;

    /* Open description file */
    Fdes = FileOpen(path, O_RDONLY | O_BINARY, SH_DENYNO);
    if (Fdes == -1) return 1;

    /* Read files */
    data = (char *) _malloc(8192); fname[0] = '\0';
    fpos = (unsigned long) -1; writenul = 0; lastpos = -1;
    while (_fgets(data,8192,Fdes) != NULL)
    {
        desc = strchr(data,' ');
        if (desc != NULL) *desc++ = '\0';
        if (desc != data && data[0] != '\0')
        {
            if (fbbs == 2 && (stat(data,&statbuf) != 0 || ISDIR(statbuf)))
            {
                /* INDEX used, don't add any directories or files that don't
                 exist */
                continue;
            }

            if (writenul)
            {
                /* End description to nul.. */
                FileWrite(Fdat, "", 1);
                writenul = 0;
            }

            if (desc != NULL)
            {
                while (*desc == ' ') desc++;
                lastpos = (int) (data-desc);
            }
            else
            {
                lastpos = -1;
            }

            if (fname[0] != '\0')
            {
                fpos = FileSeek(Fidx,0,SEEK_CUR);
                fbase.NextRec = fpos+sizeof(fbase)+strlen(fname)+1;
                if (!FileWrite(Fidx,&fbase,sizeof(fbase)))
                {
                    printf("Could not write to .idx file\n");
                    FileClose(Fdes);
                    return 0;
                }
                if (!FileWrite(Fidx,fname,strlen(fname)+1))
                {
                    printf("Could not write to .idx\n");
                    FileClose(Fdes);
                    return 0;
                }
            }

            sprintf(fname,"%s"SSLASH"%s",getcwd(tmp,sizeof(tmp)),data);
            memset(&fbase,0,sizeof(fbase));

            if (desc == NULL) strp = NULL; else strp = strstr(desc,"@_LINK=");
            if (strp == NULL)
            {
                /* File name */
                strcpy(tmp,fname);
            }
            else
            {
                /* Link to a file */
                strp2 = strchr(strp+7,'@');
                if (strp2 == NULL || *(strp2-1) != '_')
                {
                    /* File name */
                    strcpy(tmp,fname);
                }
                else
                {
                    *(strp2-1) = '\0';
                    strcpy(tmp,strp+7);
                    *(strp2-1) = '_';
                }
            }

#ifdef __FILES_CASE_SENSITIVE__
            if (stat(tmp,&statbuf) != 0)
            {
                strp = strrchr(tmp, SLASH);
                if (strp == NULL) strp = tmp; else strp++;

                /* Not found, try lowercase.. */
                strlwr(strp);
                if (stat(tmp,&statbuf) != 0)
                {
                    /* Try uppercase.. */
                    strupr(strp);
                    if (stat(tmp,&statbuf) != 0)
                    {
                        /* Ok, need to scan whole directory to find it.. */
                        search_ign_file(strp);
                    }
                }
            }
#endif

            if (stat(tmp,&statbuf) == 0)
            {
                fbase.FileDate = statbuf.st_mtime;
                fbase.Size = statbuf.st_size;
            }
            else
            {
                /* File is offline */
                fbase.Flags = FBASE_FLAGS_OFFLINE;
            }

            fbase.Downloads = 0;
            if (desc != NULL)
            {
                if (*desc == '/') fbase.Flags |= FBASE_FLAGS_PRIVATE;

                /* Get upload date */
                strp = strstr(desc,"@_ULDATE=");
                if (strp != NULL)
                {
                    memset(&tim,0,sizeof(tim));
                    strp += 9;
                    tim.tm_mday = (*strp++ - '0')*10;
                    tim.tm_mday += *strp++ - '0';
                    tim.tm_mon = (*strp++ - '0')*10;
                    tim.tm_mon += *strp++ - '0'-1;
                    tim.tm_year = (*strp++ - '0')*10;
                    tim.tm_year += *strp++ - '0';
                    fbase.UlDate = mktime(&tim);
                }

                /* Get number of downloads */
                strp = strstr(desc,"@_DOWNS=");
                if (strp != NULL)
                {
                    strp += 8;
                    while (*strp >= '0' && *strp <= '9')
                    {
                        fbase.Downloads = (unsigned short) (fbase.Downloads*10 + *strp-'0');
                        strp++;
                    }
                }
            }

            fbase.Ptr = FileSeek(Fdat,0,SEEK_CUR);
            fbase.PrevRec = fpos;
            fbase.NextRec = 0;

            if (desc == NULL)
            {
                desc = data;
                data[0] = '\0';
            }

            /* Write description */
            if (desc[0] != '\0' || (fbbs != 1))
            {
                if (FileWrite(Fdat,desc,strlen(desc) + 1-(fbbs == 1)) == 0)
                {
                    printf("Could not write to .dat\n");
                    FileClose(Fdes);
                    return 0;
                }
            }
            writenul = 1;
        }
        else if ((fbbs == 1) && desc != NULL)
        {
            /* files.bbs - get next description.. */
            while (*desc == ' ') desc++;
            if ((int) (data-desc) == lastpos || *desc == '>')
            {
                /* Write description */
                FileWrite(Fdat, " ", 1);
                if (FileWrite(Fdat, desc, strlen(desc)) == 0)
                {
                    printf("Could not write to .dat\n");
                    FileClose(Fdes);
                    return 0;
                }
            }
        }
    }

    if (writenul)
    {
        /* End description to nul.. */
        FileWrite(Fdat, "", 1);
        writenul = 0;
    }

    _free(data);
    FileClose(Fdes);

    if (fname[0] != '\0')
    {
        fbase.NextRec = FileSeek(Fidx,0,SEEK_CUR)+sizeof(fbase)+strlen(fname)+1;
        if (!FileWrite(Fidx,&fbase,sizeof(fbase)))
        {
            printf("Could not write to .idx\n");
            FileClose(Fdes);
            return 0;
        }
        if (!FileWrite(Fidx,fname,strlen(fname)+1))
        {
            printf("Could not write to .idx\n");
            FileClose(Fdes);
            return 0;
        }
    }

    return 1;
}

static char curpath[256];
static int maxnext;

int read_directory(char *path, int subdir, int firstnext)
{
    DIR *dirp;
    struct dirent *direntp;
    struct stat statbuf;
    FILE *F;
    char *strp;
    int found, areaput;

    /* Change to subdir.. */
    if (chdir(path) != 0)
    {
        printf("Couldn't change to directory '%s'\n",path);
        return 0;
    }

    printf("Scanning directory: %s\n",getcwd(curpath,sizeof(curpath)));

    strp = "descript.ion"; found = 0;
#ifdef __FILES_CASE_SENSITIVE__
    if (search_ign_file(strp) != NULL)
#else
    if (stat(strp,&statbuf) == 0)
#endif
    {
        /* descript.ion found - use it. */
        build_database(strp,0);
        found = 1;
    }

    if (!found)
    {
        /* descript.ion not found, check files.bbs */
        strp = "files.bbs"; found = 0;
#ifdef __FILES_CASE_SENSITIVE__
        if (search_ign_file(strp) != NULL)
#else
        if (stat(strp,&statbuf) == 0)
#endif
        {
            /* files.bbs found - use it. */
            build_database(strp,1);
            found = 1;
        }
    }

    strp = "INDEX"; found = 0;
#ifdef __FILES_CASE_SENSITIVE__
    if (search_ign_file(strp) != NULL)
#else
    if (stat(strp,&statbuf) == 0)
#endif
    {
        /* INDEX found - use it. */
        build_database(strp,2);
        found = 1;
    }

    /* Open directory */
    dirp = opendir(".");
    if (dirp == NULL)
    {
        chdir("..");
        return 0;
    }

    areaput = 0;
    for (;;)
    {
        /* Read directory */
        direntp = readdir(dirp);
        if (direntp == NULL) break;

        if (stat(direntp->d_name,&statbuf) != 0)
        {
            getcwd(curpath,sizeof(curpath));
            continue;
        }
        if (direntp->d_name[0] == '.' &&
            (direntp->d_name[1] == '\0' || (direntp->d_name[1] == '.' && direntp->d_name[2] == '\0')))
        {
            /* Do nothing to . and .. directories */
            continue;
        }
#ifdef ISLNK
        if (ISLNK(statbuf))
        {
            /*printf("Link file '%s'\n",direntp->d_name);
            exit(1);*/
            continue; /* Don't do anything to links */
        }
#endif
        if (ISDIR(statbuf))
        {
            /* Subdir.. */
            if (firstnext != 0)
            {
                /* Add area to fareas.bbs */
                if ((path[0] != '.' || path[1] != '\0') && !areaput)
                {
                    F = fopen(fareas_bbs, "a+t");
                    fprintf(F,"  %-27s %-23s %7u %7u all     sysop   D\n", curpath, direntp->d_name, subdir, firstnext);
                    fclose(F);
                    areaput = 1;
                }
                if (maxnext < firstnext) maxnext = firstnext;
                maxnext++;
            }
            read_directory(direntp->d_name, firstnext, maxnext);
            printf("Back in: %s\n",path);
        }

        if (found)
        {
            /* Already got files from files.bbs or descript.ion.. */
            continue;
        }

        /* Add files without description. */

    }

    closedir(dirp);
    chdir("..");

    if (firstnext != 0)
    {
        /* Add area to fareas.bbs */
        F = fopen(fareas_bbs, "a+t");
        fprintf(F,"  %-27s %-23s %7u 0 all     sysop   D\n", curpath, direntp->d_name, subdir);
        fclose(F);
    }
    return 1;
}

/* bbs buildfb [filebase name] [path to start reading] [<first subarea> <first jumparea>] */
int build_filebase(int argc, char *argv[])
{
    unsigned area;
    char fname[256], old_path[MAX_PATH_LEN];
    struct stat statbuf;

    /* Read file areas */
    init_fareas(1);

    /* Create filebase.idx */
    if (argc == 2)
        sprintf(fname, "%s"SSLASH"%s.idx", data_path, filebase_name);
    else
        sprintf(fname, "%s"SSLASH "%s.idx", data_path, argv[2]);
    Fidx = FileCreate(fname, CREATE_MODE);
    if (Fidx == -1)
    {
        printf("Can't create '%s'\n",fname);
        return 1;
    }

    /* Create filebase.dat */
    if (argc == 2)
        sprintf(fname, "%s"SSLASH"%s.dat", data_path, filebase_name);
    else
        sprintf(fname, "%s"SSLASH"%s.dat", data_path, argv[2]);
    Fdat = FileCreate(fname, CREATE_MODE);
    if (Fdat == -1)
    {
        printf("Can't create '%s'\n",fname);
        FileClose(Fidx);
        return 1;
    }
    FileMode(Fidx,O_BINARY);
    if (!FileLock(Fidx))
    {
        printf("Can't lock file '%s'\n",fname);
        FileClose(Fidx);
        FileClose(Fidx);
        return 1;
    }
    FileMode(Fdat,O_BINARY);
    if (!FileLock(Fdat))
    {
        printf("Can't lock file filebase .dat file\n");
        FileClose(Fidx);
        FileClose(Fidx);
        return 1;
    }

    getcwd(old_path, sizeof(old_path));
    /* Scan directories */
    if (argc < 4)
    {
        area = 1;
        for (; read_farea_record(area) != 0; area++)
        {
            if (farea.flags & FAREA_FLAG_DATABASE_AREA) continue;

            if (stat(farea.path,&statbuf) != 0 || chdir(farea.path) != 0)
            {
                printf("Could not change to directory '%s'\n",farea.path);
            }
            else
            {
                printf("Scanning directory '%s'\n",farea.path);
                if (!build_database("descript.ion",0)) break;
                chdir(old_path);
            }
        }
    }
    else
    {
        /* Recursively scan directory structure */
        if (chdir(argv[3]) != 0)
        {
            printf("Could not change to directory '%s'\n",argv[3]);
        }
        else
        {
            if (argc == 6)
            {
                area = atoi(argv[4]); maxnext = atoi(argv[5]);
            }
            else
            {
                area = 0; maxnext = 0;
            }
            read_directory(".",area,maxnext);
            chdir(old_path);
        }
    }

    /* Close configs */
    deinit_fareas();
    FileClose(Fidx);
    FileClose(Fdat);

    return 0;
}

/* Join filebases together */
int join_filebase(int argc, char *argv[])
{
    char tmp[1024];
    unsigned long idxstart,datstart,pos;
    int forigidx,forigdat;
    int fjoinidx,fjoindat;
    int arg,readed;
    FILEBASE_REC baserec;

    if (argc < 3)
    {
        printf("Usage: bbs joinfb <original filebase> <filebase to join, ...>\n");
        return 1;
    }

    /* Open original files */
    sprintf(tmp,"%s"SSLASH"%s.idx", data_path, argv[2]);
    forigidx = FileOpen(tmp, O_RDWR | O_BINARY, SH_DENYWR);
    if (forigidx == -1)
    {
        printf("Couldn't create file '%s'\n",tmp);
        return 2;
    }

    sprintf(tmp, "%s"SSLASH"%s.dat", data_path, argv[2]);
    forigdat = FileOpen(tmp, O_RDWR | O_BINARY, SH_DENYWR);
    if (forigdat == -1)
    {
        printf("Couldn't create file '%s'\n",tmp);
        return 2;
    }

    /* Lock it. */
    if (!FileLock(forigidx))
    {
        printf("Can't lock file %s.idx", argv[2]);
        return 2;
    }
    if (!FileLock(forigdat))
    {
        printf("Can't lock file %s.dat", argv[2]);
        return 2;
    }

    for (arg=3; arg<argc; arg++)
    {
        printf("Joining filebase '%s' to '%s'\n",argv[arg],argv[2]);

        /* Open filebase to join */
        sprintf(tmp,"%s"SSLASH"%s.idx", data_path, argv[arg]);
        fjoinidx = FileOpen(tmp, O_RDONLY | O_BINARY, SH_DENYNO);
        if (fjoinidx == -1)
        {
            printf("Couldn't open file '%s'\n",tmp);
            continue;
        }

        sprintf(tmp,"%s"SSLASH"%s.dat", data_path, argv[arg]);
        fjoindat = FileOpen(tmp, O_RDONLY | O_BINARY, SH_DENYNO);
        if (fjoindat == -1)
        {
            printf("Couldn't open file '%s'\n",tmp);
            continue;
        }

        /* Update last record to point to next file record */
        idxstart = FileSeek(forigidx, 0, SEEK_END);
        datstart = FileSeek(forigdat, 0, SEEK_END);

        /* Copy .idx file */
        pos = 0;
        for (;;)
        {
            /* Read record */
            FileSeek(fjoinidx, pos, SEEK_SET);
            if (FileRead(fjoinidx, &baserec, sizeof(baserec)) != sizeof(baserec)) break;
            tmp[FileRead(fjoinidx, tmp, sizeof(tmp)-1)] = '\0';

            pos = baserec.NextRec;

            /* Update file positions */
            baserec.Ptr += datstart;
            baserec.PrevRec += idxstart;
            baserec.NextRec += idxstart;

            /* Write it. */
            FileWrite(forigidx, &baserec, sizeof(baserec));
            FileWrite(forigidx, tmp, strlen(tmp)+1);
        }

        /* Copy .dat file */
        for (;;)
        {
            readed = FileRead(fjoindat, tmp, sizeof(tmp));
            if (readed == 0) break;

            if (FileWrite(forigdat, tmp, readed) != readed)
            {
                printf("Couldn't write to file '%s.dat'\n",argv[2]);
                break;
            }
        }

        FileClose(fjoinidx);
        FileClose(fjoindat);
    }

    FileClose(forigidx);
    FileClose(forigdat);

    return 0;
}
