/*Copyright (C) 1998 Darren Braun
 * 
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 *   Any comments or questions can be directed to darren@theboard.dyn.ml.org
 */

/*tbserver.c - Server for The Board*/

#include <headers.h>
#include <tbserver.h>



/*Global Variables*/

key_t k_yn;
key_t k_ask;
key_t k_who;
key_t k_chat;
key_t k_page;
int qid_yn;
int qid_ask;
int qid_who;
int qid_chat;
int qid_page;
int l_yn;
int l_ask;
int l_who;
int l_chat;
int l_page;


struct msg_yn s_yn;
struct msg_ask s_ask;
struct msg_who s_who;
struct msg_chat s_chat;
struct msg_page s_page;

struct user_dat user;
struct user_stat user2;



void tbs_shutdown(int sig){
   msgctl(qid_yn,IPC_RMID, NULL);
   msgctl(qid_ask,IPC_RMID, NULL);
   msgctl(qid_who,IPC_RMID, NULL);
   msgctl(qid_chat,IPC_RMID, NULL);
   msgctl(qid_page,IPC_RMID, NULL);
   exit(1);
}


int main(void)
{
   int a, quit = 0, found = 0, sysopin = 0, sysopa = 0;
   char temp[80], temp2[80], home_dir[80], udat_file[80], udat_file2[80];
   FILE *fp_user, *fp_user2, *fp_log;
   make_daemon();
   signal(SIGTERM,tbs_shutdown);
   strcpy(s_who.ttyS1, "Internet Connection");
   strcpy(s_who.ttyS2, "Accepting Connections");
   strcpy(s_who.ttyS3, "Accepting Connections");
   strcpy(s_who.tty1, "Accepting Connections - Local");
   strcpy(s_who.tty2, "Accepting Connections - Local");
   strcpy(s_who.tty3, "Accepting Connections - Local");
   strcpy(s_who.tty4, "Accepting Connections - Local");
   strcpy(s_who.tty5, "Accepting Connections - Local");
   strcpy(s_who.tty6, "Accepting Connections - Local");
   strcpy(s_who.tty7, "Accepting Connections - Local");
   strcpy(s_who.tty8, "Accepting Connections - Local");
   strcpy(s_who.ttyp0, "Accepting Connections - Telnet");
   strcpy(s_who.ttyp1, "Accepting Connections - Telnet");
   strcpy(s_who.ttyp2, "Accepting Connections - Telnet");
   strcpy(s_who.ttyp3, "Accepting Connections - Telnet");
   strcpy(s_who.ttyp4, "Accepting Connections - Telnet");
   strcpy(s_who.ttyp5, "Accepting Connections - Telnet");
   strcpy(s_who.ttyp6, "Accepting Connections - Telnet");
   strcpy(s_who.ttyp7, "Accepting Connections - Telnet");
   strcpy(s_who.ttyp8, "Accepting Connections - Telnet");
   strcpy(s_who.ttyp9, "Accepting Connections - Telnet");
   strcpy(s_who.ttyS1_act, "");
   strcpy(s_who.ttyS2_act, "");
   strcpy(s_who.ttyS3_act, "");
   strcpy(s_who.tty1_act, "");
   strcpy(s_who.tty2_act, "");
   strcpy(s_who.tty3_act, "");
   strcpy(s_who.tty4_act, "");
   strcpy(s_who.tty5_act, "");
   strcpy(s_who.tty6_act, "");
   strcpy(s_who.tty7_act, "");
   strcpy(s_who.tty8_act, "");
   strcpy(s_who.ttyp0_act, "");
   strcpy(s_who.ttyp1_act, "");
   strcpy(s_who.ttyp2_act, "");
   strcpy(s_who.ttyp3_act, "");
   strcpy(s_who.ttyp4_act, "");
   strcpy(s_who.ttyp5_act, "");
   strcpy(s_who.ttyp6_act, "");
   strcpy(s_who.ttyp7_act, "");
   strcpy(s_who.ttyp8_act, "");
   strcpy(s_who.ttyp9_act, "");
   k_yn = ftok(ROOT_DIR, 'a');
   k_ask = ftok(ROOT_DIR, 'b');
   k_who = ftok(ROOT_DIR, 'c');
   k_chat = ftok(ROOT_DIR, 'd');
   k_page = ftok(ROOT_DIR, 'e');
   qid_yn = msgget(k_yn, IPC_CREAT | 0666);
   qid_ask = msgget(k_ask, IPC_CREAT | 0666);
   qid_who = msgget(k_who, IPC_CREAT | 0666);
   qid_chat = msgget(k_chat, IPC_CREAT | 0666);
   qid_page = msgget(k_page, IPC_CREAT | 0666);
   l_yn = (sizeof(s_yn) - sizeof(long));
   l_ask = (sizeof(s_ask) - sizeof(long));
   l_who = (sizeof(s_who) - sizeof(long));
   l_chat = (sizeof(s_chat) - sizeof(long));
   l_page = (sizeof(s_page) - sizeof(long));
   while(!quit){
      msgrcv(qid_ask, (struct msgbuf *)&s_ask, l_ask, 0, 0);
      if(s_ask.req == 1){
	 s_who.mtype = s_ask.mtype;
	 msgsnd(qid_who, (struct msgbuf *)&s_who, l_who, 0);
      }
      else if(s_ask.req == 2){
	 switch(s_ask.mtype){
	  case 1:
	    strcpy(s_who.ttyS1, s_ask.name);
	    strcpy(s_who.ttyS1_act, s_ask.activity);
	    break;
	  case 2:
	    strcpy(s_who.ttyS2, s_ask.name);
	    strcpy(s_who.ttyS2_act, s_ask.activity);
	    break;
	  case 3:
	    strcpy(s_who.ttyS3, s_ask.name);
	    strcpy(s_who.ttyS3_act, s_ask.activity);
	    break;
	  case 4:
	    strcpy(s_who.tty1, s_ask.name);
	    strcpy(s_who.tty1_act, s_ask.activity);
	    break;
	  case 5:
	    strcpy(s_who.tty2, s_ask.name);
	    strcpy(s_who.tty2_act, s_ask.activity);
	    break;
	  case 6:
	    strcpy(s_who.tty3, s_ask.name);
	    strcpy(s_who.tty3_act, s_ask.activity);
	    break;
	  case 7:
	    strcpy(s_who.tty4, s_ask.name);
	    strcpy(s_who.tty4_act, s_ask.activity);
	    break;
 	  case 8:
	    strcpy(s_who.tty5, s_ask.name);
	    strcpy(s_who.tty5_act, s_ask.activity);
	    break;
	  case 9:
	    strcpy(s_who.tty6, s_ask.name);
	    strcpy(s_who.tty6_act, s_ask.activity);
	    break;
	  case 10:
	    strcpy(s_who.tty7, s_ask.name);
	    strcpy(s_who.tty7_act, s_ask.activity);
	    break;
	  case 11:
	    strcpy(s_who.tty8, s_ask.name);
	    strcpy(s_who.tty8_act, s_ask.activity);
	    break;
	  case 12:
	    strcpy(s_who.ttyp0, s_ask.name);
	    strcpy(s_who.ttyp0_act, s_ask.activity);
	    break;
	  case 13:
	    strcpy(s_who.ttyp1, s_ask.name);
	    strcpy(s_who.ttyp1_act, s_ask.activity);
	    break;
	  case 14:
	    strcpy(s_who.ttyp2, s_ask.name);
	    strcpy(s_who.ttyp2_act, s_ask.activity);
	    break;
	  case 15:
	    strcpy(s_who.ttyp3, s_ask.name);
	    strcpy(s_who.ttyp3_act, s_ask.activity);
	    break;
	  case 16:
	    strcpy(s_who.ttyp4, s_ask.name);
	    strcpy(s_who.ttyp4_act, s_ask.activity);
	    break;
	  case 17:
	    strcpy(s_who.ttyp5, s_ask.name);
	    strcpy(s_who.ttyp5_act, s_ask.activity);
	    break;
	  case 18:
	    strcpy(s_who.ttyp6, s_ask.name);
	    strcpy(s_who.ttyp6_act, s_ask.activity);
	    break;
	  case 19:
	    strcpy(s_who.ttyp7, s_ask.name);
	    strcpy(s_who.ttyp7_act, s_ask.activity);
	    break;
	  case 20:
	    strcpy(s_who.ttyp8, s_ask.name);
	    strcpy(s_who.ttyp8_act, s_ask.activity);
	    break;
	  case 21:
	    strcpy(s_who.ttyp9, s_ask.name);
	    strcpy(s_who.ttyp9_act, s_ask.activity);
	    break;
	  case 1000:
	    sysopin = 1;
	    break;
	  default:
	    break;
	 }
      }
      else if(s_ask.req == 3){
	 switch(s_ask.mtype){
	  case 1:
	    strcpy(s_who.ttyS1, "Internet Connection");
	    strcpy(s_who.ttyS1_act, "");
	    break;
	  case 2:
	    strcpy(s_who.ttyS2, "Accepting Connections");
	    strcpy(s_who.ttyS2_act, "");
	    break;
	  case 3:
	    strcpy(s_who.ttyS3, "Accepting Connections");
	    strcpy(s_who.ttyS3_act, "");
	    break;
	  case 4:
	    strcpy(s_who.tty1, "Accepting Connections - Local");
	    strcpy(s_who.tty1_act, "");
	    break;
	  case 5:
	    strcpy(s_who.tty2, "Accepting Connections - Local");
	    strcpy(s_who.tty2_act, "");
	    break;
	  case 6:
	    strcpy(s_who.tty3, "Accepting Connections - Local");
	    strcpy(s_who.tty3_act, "");
	    break;
	  case 7:
	    strcpy(s_who.tty4, "Accepting Connections - Local");
	    strcpy(s_who.tty4_act, "");
	    break;
	  case 8:
	    strcpy(s_who.tty5, "Accepting Connections - Local");
	    strcpy(s_who.tty5_act, "");
	    break;
	  case 9:
	    strcpy(s_who.tty6, "Accepting Connections - Local");
	    strcpy(s_who.tty6_act, "");
	    break;
	  case 10:
	    strcpy(s_who.tty7, "Accepting Connections - Local");
	    strcpy(s_who.tty7_act, "");
	    break;
	  case 11:
	    strcpy(s_who.tty8, "Accepting Connections - Local");
	    strcpy(s_who.tty8_act, "");
	    break;
	  case 12:
	    strcpy(s_who.ttyp0, "Accepting Connections - Telnet");
	    strcpy(s_who.ttyp0_act, "");
	    break;
	  case 13:
	    strcpy(s_who.ttyp1, "Accepting Connections - Telnet");
	    strcpy(s_who.ttyp1_act, "");
	    break;
	  case 14:
	    strcpy(s_who.ttyp2, "Accepting Connections - Telnet");
	    strcpy(s_who.ttyp2_act, "");
	    break;
	  case 15:
	    strcpy(s_who.ttyp3, "Accepting Connections - Telnet");
	    strcpy(s_who.ttyp3_act, "");
	    break;
	  case 16:
	    strcpy(s_who.ttyp4, "Accepting Connections - Telnet");
	    strcpy(s_who.ttyp4_act, "");
	    break;
	  case 17:
	    strcpy(s_who.ttyp5, "Accepting Connections - Telnet");
	    strcpy(s_who.ttyp5_act, "");
	    break;
	  case 18:
	    strcpy(s_who.ttyp6, "Accepting Connections - Telnet");
	    strcpy(s_who.ttyp6_act, "");
	    break;
	  case 19:
	    strcpy(s_who.ttyp7, "Accepting Connections - Telnet");
	    strcpy(s_who.ttyp7_act, "");
	    break;
	  case 20:
	    strcpy(s_who.ttyp8, "Accepting Connections - Telnet");
	    strcpy(s_who.ttyp8_act, "");
	    break;
	  case 21:
	    strcpy(s_who.ttyp9, "Accepting Connections - Telnet");
	    strcpy(s_who.ttyp9_act, "");
	    break;
	  case 1000:
	    sysopin = 0;
	    sysopa = 0;
	    break;
	  default:
	    break;
	 }
      }
      else if(s_ask.req == 4){
	 found = 0;
	 if(!(strcmp(s_who.ttyS1, s_ask.name))){
	    found = 1;
	 }
	 else if(!(strcmp(s_who.ttyS2, s_ask.name))){
	    found = 1;
	 }
	 else if(!(strcmp(s_who.ttyS3, s_ask.name))){
	    found = 1;
	 }
	 else if(!(strcmp(s_who.tty1, s_ask.name))){
	    found = 1;
	 }
	 else if(!(strcmp(s_who.tty2, s_ask.name))){
	    found = 1;
	 }
	 else if(!(strcmp(s_who.tty3, s_ask.name))){
	    found = 1;
	 }
	 else if(!(strcmp(s_who.tty4, s_ask.name))){
	    found = 1;
	 }
	 else if(!(strcmp(s_who.tty5, s_ask.name))){
	    found = 1;
	 }
	 else if(!(strcmp(s_who.tty6, s_ask.name))){
	    found = 1;
	 }
	 else if(!(strcmp(s_who.tty7, s_ask.name))){
	    found = 1;
	 }
	 else if(!(strcmp(s_who.tty8, s_ask.name))){
	    found = 1;
	 }
	 else if(!(strcmp(s_who.ttyp0, s_ask.name))){
	    found = 1;
	 }
	 else if(!(strcmp(s_who.ttyp1, s_ask.name))){
	    found = 1;
	 }
	 else if(!(strcmp(s_who.ttyp2, s_ask.name))){
	    found = 1;
	 }
	 else if(!(strcmp(s_who.ttyp3, s_ask.name))){
	    found = 1;
	 }
	 else if(!(strcmp(s_who.ttyp4, s_ask.name))){
	    found = 1;
	 }
	 else if(!(strcmp(s_who.ttyp5, s_ask.name))){
	    found = 1;
	 }
	 else if(!(strcmp(s_who.ttyp6, s_ask.name))){
	    found = 1;
	 }
	 else if(!(strcmp(s_who.ttyp7, s_ask.name))){
	    found = 1;
	 }
	 else if(!(strcmp(s_who.ttyp8, s_ask.name))){
	    found = 1;
	 }
	 else if(!(strcmp(s_who.ttyp9, s_ask.name))){
	    found = 1;
	 }
	 if(found == 1 && strcmp(s_ask.name, "guest")){
	    s_yn.mtype = s_ask.mtype;
	    s_yn.yn = 0;
	    msgsnd(qid_yn, (struct msgbuf *)&s_yn, l_yn, 0);
	 }
	 else{
	    s_yn.mtype = s_ask.mtype;
	    s_yn.yn = 0;
	    msgsnd(qid_yn, (struct msgbuf *)&s_yn, l_yn, 0);
	 }
      }
      else if(s_ask.req == 5){
	 strcpy(s_chat.message, s_ask.message);
	 if((strcmp(s_who.ttyS1, "Internet Connection")) && s_ask.mtype != 1){
	    s_chat.mtype = 1;
	    msgsnd(qid_chat, (struct msgbuf *)&s_chat, l_chat, 0);
	 }
	 if((strcmp(s_who.ttyS2, "Accepting Connections")) && s_ask.mtype != 2){
	    s_chat.mtype = 2;
	    msgsnd(qid_chat, (struct msgbuf *)&s_chat, l_chat, 0);
	 }
	 if((strcmp(s_who.ttyS3, "Accepting Connections")) && s_ask.mtype != 3){
	    s_chat.mtype = 3;
	    msgsnd(qid_chat, (struct msgbuf *)&s_chat, l_chat, 0);
	 }
	 if((strcmp(s_who.tty1, "Accepting Connections - Local")) && s_ask.mtype != 4){
	    s_chat.mtype = 4;
	    msgsnd(qid_chat, (struct msgbuf *)&s_chat, l_chat, 0);
	 }
	 if((strcmp(s_who.tty2, "Accepting Connections - Local")) && s_ask.mtype != 5){
	    s_chat.mtype = 5;
	    msgsnd(qid_chat, (struct msgbuf *)&s_chat, l_chat, 0);
	 }
	 if((strcmp(s_who.tty3, "Accepting Connections - Local")) && s_ask.mtype != 6){
	    s_chat.mtype = 6;
	    msgsnd(qid_chat, (struct msgbuf *)&s_chat, l_chat, 0);
	 }
	 if((strcmp(s_who.tty4, "Accepting Connections - Local")) && s_ask.mtype != 7){
	    s_chat.mtype = 7;
	    msgsnd(qid_chat, (struct msgbuf *)&s_chat, l_chat, 0);
	 }
	 if((strcmp(s_who.tty5, "Accepting Connections - Local")) && s_ask.mtype != 8){
	    s_chat.mtype = 8;
	    msgsnd(qid_chat, (struct msgbuf *)&s_chat, l_chat, 0);
	 }
	 if((strcmp(s_who.tty6, "Accepting Connections - Local")) && s_ask.mtype != 9){
	    s_chat.mtype = 9;
	    msgsnd(qid_chat, (struct msgbuf *)&s_chat, l_chat, 0);
	 }
	 if((strcmp(s_who.tty7, "Accepting Connections - Local")) && s_ask.mtype != 10){
	    s_chat.mtype = 10;
	    msgsnd(qid_chat, (struct msgbuf *)&s_chat, l_chat, 0);
	 }
	 if((strcmp(s_who.tty8, "Accepting Connections - Local")) && s_ask.mtype != 11){
	    s_chat.mtype = 11;
	    msgsnd(qid_chat, (struct msgbuf *)&s_chat, l_chat, 0);
	 }
	 if((strcmp(s_who.ttyp0, "Accepting Connections - Telnet")) && s_ask.mtype != 12){
	    s_chat.mtype = 12;
	    msgsnd(qid_chat, (struct msgbuf *)&s_chat, l_chat, 0);
	 }
	 if((strcmp(s_who.ttyp1, "Accepting Connections - Telnet")) && s_ask.mtype != 13){
	    s_chat.mtype = 13;
	    msgsnd(qid_chat, (struct msgbuf *)&s_chat, l_chat, 0);
	 }
	 if((strcmp(s_who.ttyp2, "Accepting Connections - Telnet")) && s_ask.mtype != 14){
	    s_chat.mtype = 14;
	    msgsnd(qid_chat, (struct msgbuf *)&s_chat, l_chat, 0);
	 }
	 if((strcmp(s_who.ttyp3, "Accepting Connections - Telnet")) && s_ask.mtype != 15){
	    s_chat.mtype = 15;
	    msgsnd(qid_chat, (struct msgbuf *)&s_chat, l_chat, 0);
	 }
	 if((strcmp(s_who.ttyp4, "Accepting Connections - Telnet")) && s_ask.mtype != 16){
	    s_chat.mtype = 16;
	    msgsnd(qid_chat, (struct msgbuf *)&s_chat, l_chat, 0);
	 }
	 if((strcmp(s_who.ttyp5, "Accepting Connections - Telnet")) && s_ask.mtype != 17){
	    s_chat.mtype = 17;
	    msgsnd(qid_chat, (struct msgbuf *)&s_chat, l_chat, 0);
	 }
	 if((strcmp(s_who.ttyp6, "Accepting Connections - Telnet")) && s_ask.mtype != 18){
	    s_chat.mtype = 18;
	    msgsnd(qid_chat, (struct msgbuf *)&s_chat, l_chat, 0);
	 }
	 if((strcmp(s_who.ttyp7, "Accepting Connections - Telnet")) && s_ask.mtype != 19){
	    s_chat.mtype = 19;
	    msgsnd(qid_chat, (struct msgbuf *)&s_chat, l_chat, 0);
	 }
	 if((strcmp(s_who.ttyp8, "Accepting Connections - Telnet")) && s_ask.mtype != 20){
	    s_chat.mtype = 20;
	    msgsnd(qid_chat, (struct msgbuf *)&s_chat, l_chat, 0);
	 }
	 if((strcmp(s_who.ttyp9, "Accepting Connections - Telnet")) && s_ask.mtype != 21){
	    s_chat.mtype = 21;
	    msgsnd(qid_chat, (struct msgbuf *)&s_chat, l_chat, 0);
	 }
	 if( sysopin == 1 && s_ask.mtype != 1000){
	    s_chat.mtype = 1000;
	    msgsnd(qid_chat, (struct msgbuf *)&s_chat, l_chat, 0);
	 }
	 
      }
      else if(s_ask.req == 6){
	 switch(s_ask.mtype){
	  case 1:
	    strcpy(s_who.ttyS1_act, s_ask.activity);
	    break;
	  case 2:
	    strcpy(s_who.ttyS2_act, s_ask.activity);
	    break;
	  case 3:
	    strcpy(s_who.ttyS3_act, s_ask.activity);
	    break;
	  case 4:
	    strcpy(s_who.tty1_act, s_ask.activity);
	    break;
	  case 5:
	    strcpy(s_who.tty2_act, s_ask.activity);
	    break;
	  case 6:
	    strcpy(s_who.tty3_act, s_ask.activity);
	    break;
	  case 7:
	    strcpy(s_who.tty4_act, s_ask.activity);
	    break;
 	  case 8:
	    strcpy(s_who.tty5_act, s_ask.activity);
	    break;
	  case 9:
	    strcpy(s_who.tty6_act, s_ask.activity);
	    break;
	  case 10:
	    strcpy(s_who.tty7_act, s_ask.activity);
	    break;
	  case 11:
	    strcpy(s_who.tty8_act, s_ask.activity);
	    break;
	  case 12:
	    strcpy(s_who.ttyp0_act, s_ask.activity);
	    break;
	  case 13:
	    strcpy(s_who.ttyp1_act, s_ask.activity);
	    break;
	  case 14:
	    strcpy(s_who.ttyp2_act, s_ask.activity);
	    break;
	  case 15:
	    strcpy(s_who.ttyp3_act, s_ask.activity);
	    break;
	  case 16:
	    strcpy(s_who.ttyp4_act, s_ask.activity);
	    break;
	  case 17:
	    strcpy(s_who.ttyp5_act, s_ask.activity);
	    break;
	  case 18:
	    strcpy(s_who.ttyp6_act, s_ask.activity);
	    break;
	  case 19:
	    strcpy(s_who.ttyp7_act, s_ask.activity);
	    break;
	  case 20:
	    strcpy(s_who.ttyp8_act, s_ask.activity);
	    break;
	  case 21:
	    strcpy(s_who.ttyp9_act, s_ask.activity);
	    break;
	  default:
	    break;
	 }
      }
      else if(s_ask.req == 7){
	 if(sysopa){
	    s_yn.mtype = s_ask.mtype;
	    s_yn.yn = 1;
	    msgsnd(qid_yn, (struct msgbuf *)&s_yn, l_yn, 0);
	 }
	 else{
	    s_yn.mtype = s_ask.mtype;
	    s_yn.yn = 0;
	    msgsnd(qid_yn, (struct msgbuf *)&s_yn, l_yn, 0);
	 }
      }
      else if(s_ask.req == 8){
	 switch(s_ask.mtype){
	  case 1000:
	    sysopa = 1;
	    break;
	  default:
	    break;
	 }
      }
      else if(s_ask.req == 9){
	 switch(s_ask.mtype){
	  case 1000:
	    sysopa = 0;
	    break;
	  default:
	    break;
	 }
      }
   }
   
   return 0;
}



int make_daemon()
{
   pid_t p;
   p = fork();
   if (p < 0){
      return -1;
   }
   else if (p > 0){
      sleep(1);
      exit(0);
   }
   + setsid();
   return  0;
}


