/*Copyright (C) 1998 Darren Braun
 * 
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 *   Any comments or questions can be directed to darren@theboard.dyn.ml.org
 */

/*box.c - functions to draw an ansi box on the screen*/

#include "headers.h"

int box_3d(int x, int y, int x_len, int y_len, int color, int in_out)
{
   int a, b;
   char bg_color;
   char l_color;
   char r_color;
   switch(color){
    case 0:{
       /*No Color*/
       r_color = '0';
       l_color = '0';
       bg_color = '0';
       break;
    }
    case 1:{
       /*Blue*/
       if(in_out){
	  r_color = '9';
	  l_color = '0';
       }
       else{
	  r_color = '0';
	  l_color = '9';
       }
       bg_color = '1';
       break;
    }
    case 2:{
       /*Green*/
       if(in_out){
	  r_color = 'A';
	  l_color = '0';
       }
       else{
	  r_color = '0';
	  l_color = 'A';
       }
       bg_color = '2';
       break;
    }
    case 3:{
       /*Cyan*/
       if(in_out){
	  r_color = 'B';
	  l_color = '0';
       }
       else{
	  r_color = '0';
	  l_color = 'B';
       }
       bg_color = '3';
       break;
    }
    case 4:{
       /*Red*/
       if(in_out){
	  r_color = 'C';
	  l_color = '0';
       }
       else{
	  r_color = '0';
	  l_color = 'C';
       }
       bg_color = '4';
       break;
    }
    case 5:{
       /*Purple*/
       if(in_out){
	  r_color = 'D';
	  l_color = '0';
       }
       else{
	  r_color = '0';
	  l_color = 'D';
       }
       bg_color = '5';
       break;
    }
    case 6:{
       /*Yellow*/
       if(in_out){
	  r_color = 'E';
	  l_color = '0';
       }
       else{
	  r_color = '0';
	  l_color = 'E';
       }
       bg_color = '6';
       break;
    }
    case 7:{
       /*White*/
       if(in_out){
	  r_color = 'F';
	  l_color = '0';
       }
       else{
	  r_color = '0';
	  l_color = 'F';
       }
       bg_color = '7';
       break;
    }
    default:{
       r_color = '7';
       l_color = '7';
       bg_color = '0';
       break;
    }
   }
   ansipos(x, y);
   putcolor(bg_color, l_color);
   printf("%c", asc1);
   for(a = 1;a <= (x_len - 2); a++){
      printf("%c", asc5);
   }
   putcolor(bg_color, r_color);
   printf("%c", asc2);
   ansipos(x, (y + 1));
   for(a = 1;a <= (y_len - 2); a++){
      putcolor(bg_color, l_color);
      printf("%c", asc6);
      for(b = 1;b <= (x_len - 2); b++){
	 printf(" ");
      }
      putcolor(bg_color, r_color);
      printf("%c", asc6);
      ansipos(x, (y + a + 1));
   }
   putcolor(bg_color, l_color);
   printf("%c", asc3);
   putcolor(bg_color, r_color);
   for(a = 1;a <= (x_len - 2); a++){
      printf("%c", asc5);
   }
   printf("%c", asc4);
   return 0;
}

int box_norm(int x, int y, int x_len, int y_len, int fg, int bg)
{
   int a, b;
   int bg_color;
   int l_color;
   int r_color;
   ansipos(x, y);
   putcolor(bg, fg);
   printf("%c", asc1);
   for(a = 1;a <= (x_len - 2); a++){
      printf("%c", asc5);
   }
   printf("%c", asc2);
   ansipos(x, (y + 1));
   for(a = 1;a <= (y_len - 2); a++){
      printf("%c", asc6);
      for(b = 1;b <= (x_len - 2); b++){
	 printf(" ");
      }
      printf("%c", asc6);
      ansipos(x, (y + a + 1));
   }
   printf("%c", asc3);
   for(a = 1;a <= (x_len - 2); a++){
      printf("%c", asc5);
   }
   printf("%c", asc4);
   return 0;
}

