#include <stdio.h>
#include <pwd.h>
#define FILENAME "etc/games/makematch.list"

struct qs {
	char *q;
	char *a;
	};

struct qs q_sex = {"Are you Male or Female", "MF"};
struct qs q_gay = {"Are you Straight, Gay or Bisexual", "SGB"};
struct qs q_age = {"How old are you", NULL};
struct qs qlist[] = {
	{"Do you consider yourself atheletic", "YN"},
	{"How attractive do you consider yourself on a scale from 1 to 5 (best)"
		,"12345"},
	{"Are you a vegetarian", "YN"},
	{"Are you an Introvert or an Extrovert", "IE"},
	{"Do you prefer Rock, Classical, or Jazz music", "RCJ"},
	{"Do you enjoy dancing", "YN"},
	{"Do you prefer Cats or Dogs as pets", "CD"},
	{"Do you enjoy movies", "YN"},
	{"Do you enjoy spectator sports", "YN"},
	{"Are you on a diet", "YN"},
	{"Do you like the outdoors", "YN"},
	{"Do you remember your dreams", "YN"},
	{"Are you politically Liberal or Conservative", "LC"},
	{"Have you ever shoplifted", "YN"},
	{"Are you usually Late or Early for appointments", "LE"},
	{"Would you like a long term relationship","YN"},
	{"Do you like to be alone", "YN"},
	{"Are you Tall or Short", "TS"},
	{"Do you enjoy travelling", "YN"},
	{"Do you smoke", "YN"},
	{"Were your parents separated or divorced", "YN"},
	{"Are you prefer Large, Midsized or Small cars", "LMS"},
	{"Do you write poetry", "YN"},
	{"Do you enjoy spending money", "YN"},
	{"Are you strongly religious", "YN"},
	{"Do you get along well with most people", "YN"},
	{"Are you unusually nervous around strangers", "YN"},
	{"Do you like the dark","YN"},
	{"Do you usually sleep on your Back, Left-side, Right-side or Stomach",
		"BLRS"},
	{"Do you often contribute to charity", "YN"},
	{"Do you consider yourself an intellectual", "YN"},
	{"Do you like opera", "YN"},
	{"Which do you prefer: Rain, Snow, Thunder or Windstorms", "RSTW"},
	{"Do you snore", "YN"},
	{"Do you like dressing up", "YN"},
	{"Do you spell well", "YN"},
	{"Do you have more than two credit cards", "YN"},
	{"Do you often work overtime", "YN"},
	{"Do you have lots of friends", "YN"},
	{"Do you have a poor self image", "YN"},
	{"Are you more interested in Art, Business, sCience or sPorts ",
		"ABCP"},
	{"Can you touch your toes", "YN"},
	{"Do you enjoy shopping", "YN"},
	{"Do you wear glasses or contact lenses", "YN"},
	{"Would you rather shop for Cloths, Records, Books or Food", "CRBF"},
	{"Do you enjoy winter sports", "YN"},
	{"Can you swim", "YN"},
	{"Do you believe opposites attract", "YN"},
	{NULL,NULL}};

struct ff {
	char name[9];
	char sex;
	char sexmask;
	int age;
	int score;
	};

main()
{
struct ff me;
int gay, i;
struct qs *q;
FILE *fp;
int fd;
char myname[9] ,tmp[30];
struct passwd *pent, *getpwuid();

	pent = getpwuid(getuid());
	strncpy(myname,pent->pw_name,8);
	sprintf(tmp,"%s/%s",HOME,FILENAME);
	if ((fp=fopen(tmp,"r")) == NULL)
	{
		printf("cannot open file %s\n",tmp);
		exit(1);
	}

	while (fread(&me,sizeof(me),1,fp) == 1)
	{
		if (strcmp(me.name,myname)==0)
		{
			findmatch(fp,&me);
			exit(0);
		}
	}

	strcpy(me.name,myname);
	me.sex = ask(&q_sex)+1;
	gay = ask(&q_gay);
	if (gay == 0)
		me.sexmask = 3-me.sex;
	else if (gay == 1)
		me.sexmask = me.sex;
	else
		me.sexmask = 3;

	me.age = ask(&q_age);

	me.score = 0;
	for (i = 0; myname[i] != '\0'; i++)
		me.score += myname[i];
	for (q = qlist; q->q != NULL; q++)
		me.score += ask(q);

        sprintf(tmp,"%s/%s",HOME,FILENAME);
	if ((fd = open(tmp,2)) < 0)
	{
		printf("Can't write file\n");
		exit(1);
	}
	lseek(fd,0L,2);
	write(fd,&me,sizeof(me));
	close(fd);
	findmatch(fp,&me);
}

findmatch(fp,me)
FILE *fp;
struct ff *me;
{
struct ff him;
int bscore[5];
char bname[5][9];
char tname[9];
int score;
int i,t,da;

	for (i = 0; i < 5; i++)
		bscore[i] = -1;

	printf("seeking match...\n");
	sleep(10);
	rewind(fp);
	while (fread(&him,sizeof(him),1,fp) == 1)
	{
		da = him.age - me->age;
		if ((him.sex & me->sexmask) && (me->sex & him.sexmask) &&
			da > -9 && da < 9 && strcmp(him.name,me->name))
		{
			score = him.score - me->score;
			if (score < 0) score = -score;
			score = 100 - (score % 101);
			for (i = 0; i < 5; i++)
			{
				if (score > bscore[i])
				{
					strcpy(tname,bname[i]);
					strcpy(bname[i],him.name);
					strcpy(him.name,tname);
					t = bscore[i];
					bscore[i] = score;
					score = t;
				}
			}
		}
	}

	if (bscore[0] < 0)
		printf("No match found.  Try later.\n");
	else
	{
		printf("Best matches so far:\n");
		for(i=0; i<5; i++)
		    if (bscore[i] >= 0)
			printf("  %d: %s rated %d%%\n",i+1,bname[i],bscore[i]);
	}
}

int ask(q)
struct qs *q;
{
int ch,cx,n;
char *p, *strchr();

	if (q->a)
		for (;;)
		{
			printf("%s [%s]? ",q->q,q->a);
			if ((ch=getchar()) == '\n') continue;
			while ((cx=getchar()) != '\n' && cx != EOF)
				;
			if (cx == EOF) exit(1);
			if (ch >= 'a' && ch <= 'z')
				ch = ch - 'a' + 'A';
			if ((p=strchr(q->a,ch)) != NULL)
				return(p - q->a);
		}
	else
	{
		printf("%s? ",q->q);
		n = 0;
		while ((ch=getchar()) != '\n' && ch != EOF)
			if (ch >= '0' && ch <= '9')
				n = n*10 + ch - '0';
		if (ch == EOF) exit(1);
		return(n);
	}
}
