/*
	Schrodinger's Box Haven  code version -0.1 alpha
        Copyright (C) 1994, Gordon Chan

	You can do whatever ya want with this code as long as you leave this
        copyright & disclaimer intact.  You can hack it up all you want, etc...
        No guarantees.

	Send comments, flames, bug reports, etc ... to
		au233@freenet.carleton.ca  <---- (preferred address for now)
		gjc@achilles.net
		gchan@ccs.carleton.ca
*/


/* Here's the copyrights & disclaimers from the Opium Den and unixCB codes */

/* Opium Den */
/*
  val's haven code v -0.85

        Copyright (C) 1994 Joel Ward

        Warranty:
                Don't blame me for anything.

        You can do whatever the fuck you want with this code as long as you
don't remove this copyright/disclaimer notice.
*/

/* unixCB */
/*
  
  cbd.c
  
  "cbd.c" is the main code for the CB simulator.
  
  Copyright (c) 1992, Gary Grossman.  All rights reserved.
  Send comments and questions to: garyg@soda.berkeley.edu
  
  */

#include <stdio.h>
#include <time.h>

#include "who_finger_lists.h"
#include "linked_lists.h"
#include "misc_commands.h"
#include "chat.h"
#include "security.h"


void who (user, args)
	struct user *user;
	char *args;
{
	struct user *u;
	char temp[20];
	int number;

	number = 0;

	for (u = firstuser; u; u = u->next) { 
		write_user (user->desc, who_is_at_line(u, user->sec_level) );
		number++;
	}

	sprintf (temp, "   %d users found.\r\n", number);
	write_user (user->desc, temp);

	return;
}


void finger (user, args)
	struct user *user;
	char *args;
{
	struct user *u;
	char temp[100];
	int number;

	number = 0;
	for (u = firstuser; u; u = u->next) { 
		if(is_user(u, Ftyping)) {
		  sprintf (temp, " %d  %s/%s\r\n", u->desc, u->name, u->description);
		  write_user (user->desc, temp);
		  number++;
		}
	}
	if (!number)
	  write_user (user->desc, " Nobody's typing\r\n");
        else {
	  sprintf (temp, "   %d users found.\r\n", number);
	  write_user (user->desc, temp);
	}
	return;
}


char *who_is_at_line (user, security)
	struct user *user;
	int security;
{
	static char user_line [100];
	time_t present_time;
	
	present_time = time(NULL);
	user_line [0] = '\0';

	if (security >= COSYSOP)  
		sprintf (user_line, "   %3d  %d  %-*s %-*s %-5s %s \r\n",
				user->desc, user->sec_level,
				NAMEMAX, user->name,
				CHANNELMAX, user->channel->name,
				convert_time (present_time - user->idletime),
				user->site);
	else
		sprintf (user_line, "   %3d %-*s %-*s %-5s %s\r\n",
				user->desc,
				NAMEMAX, user->name,
				CHANNELMAX, user->channel->name,
				convert_time (present_time - user->idletime),
				user->site);
	return user_line;
}


void personal_stats (user, text)
	struct user *user;
	char *text;
{
	struct user *u;
	char temp[120];
	int count;

	*temp = '\0';

	count = 0;
	if (user->gags) {
		write_user (user->desc, "You have gagged:\r\n");
		for (u = firstuser; u; u = u->next)
			if (testbit (user->gags, u->desc-1) ) {
				sprintf (temp, "   %3d  %-*s\r\n", u->desc,
				  NAMEMAX, u->name);
				write_user (user->desc, temp);
				count++;
			}
		if (!count)
			write_user (user->desc, "   Nobody.\r\n");
	} else
		write_user (user->desc, "You are not gagging anyone.\r\n");	

	count = 0;
	if (user->reverse_gags) {
		write_user (user->desc, "You have reverse-gagged:\r\n");
		for (u = firstuser; u; u = u->next)
			if (testbit (user->reverse_gags, u->desc-1) ) {
				sprintf (temp, "   %3d  %-*s\r\n", u->desc,
				  NAMEMAX, u->name);
				write_user (user->desc, temp);
				count++;
			}
		if (!count)
			write_user (user->desc, "   Nobody.\r\n");
	} else
		write_user (user->desc, "You are not reverse-gagging anyone.\r\n");

	count = 0;
	write_user (user->desc, "You haved been gagged by:\r\n");
	for (u = firstuser; u; u = u->next) 
		if (u->gags)
			if (testbit (u->gags, user->desc-1) ) {
				sprintf (temp, "   %3d  %-*s\r\n", u->desc,
				  NAMEMAX, u->name);
				write_user (user->desc, temp);
				count++;
			}
	if (!count)
		write_user (user->desc, "   Nobody.\r\n");

	count = 0;
	write_user (user->desc, "You have been reversed gagged by:\r\n");
	for (u = firstuser; u; u = u->next)
		if (u->reverse_gags)
			if (testbit (u->reverse_gags, user->desc-1) ) {
				sprintf (temp, "   %3d  %-*s\r\n", u->desc,
				  NAMEMAX, u->name);
				write_user (user->desc, temp);
				count++;
			}
	if (!count)
		write_user (user->desc, "   Nobody.\r\n");

}


void show_uptime (user, text)
	struct user *user;
	char *text;
{
	char temp[80];
	time_t present_time;

	present_time = time(NULL);
		
	sprintf (temp, ">> This place has been up for %s.\r\n", 
	  convert_time (present_time-start_time) ); 
	write_user (user->desc, temp);
	return;
}
