/*##########################################################################*/
/*    'killt' alte User-Eintraege in database    			    */
/*##########################################################################*/

#undef CONVERT

#include "prototypes.h"

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <fcntl.h>

#include "../mbox.h"
#include "../mbox.msg"
#include "../s_global.h"

#undef R_DEBUG
#undef S_DEBUG
#undef DEBUG
#undef VIEW
#undef B_DEBUG



unsigned char INP[LOW_STRING],OUT[LOW_STRING],
ORGANIZATION[STRING],UUCPID2[STRING];
int ID=0,ATTENTIONS=0;
extern unsigned char HOME[];


int EXPIRE_DAYS	=400;       /* user-expire-zeit in TAGEN */
int ALWAYS_EXPIRE_MAIL =1;  /* auch leere exprie-mails als sysop's */
extern int sw_muell_on;
extern int sw_muell_voll;



#include <time.h>
#include <pwd.h>
#include <string.h>

#ifdef STERMIOS
#ifdef _SINIX             
#include <curses.h>       /* SINIX SVR4.1 prefers this instead of <termcap.h> */
#else 
#ifndef _SCO
#include <termcap.h>
#else
#include <curses.h>	  /* UNIX SVR4.2 prefers this instead of <termcap.h> */
			  /* As does SCO 3.2.4.3 ... */
#endif
#endif
#endif

#ifndef UNSIGNED
#if !defined(_MINIX) || defined(_ESTDIO)
#define UNSIGNED unsigned
#else
#define UNSIGNED
#endif
#endif


/*define TOL08_MSG	"Wait a moment"*/

#undef _MBOX

#ifdef _MBOX
#define EXTERN
#include "mbox.h"
#else
/*define VERSION "Tools.C"*/
#define CR 13
#define TOL01_MSG	"Sonntag"
#define TOL02_MSG	"Montag"
#define TOL03_MSG	"Dienstag"
#define TOL04_MSG	"Mittwoch"
#define TOL05_MSG	"Donnerstag"
#define TOL06_MSG	"Freitag"
#define TOL07_MSG	"Samstag"
/* #define TOL08_MSG	"Momentchen"*/
#endif
#ifdef STRING
#undef STRING
#endif

#ifdef LONGSTRING
#undef LONGSTRING
#endif

#define STRING 81
#define LONGSTRING 256
FILE *fd2,*fd3;





unsigned char *leer2punkt(s)
unsigned char s[];
{
  static unsigned char b[STRING];
  int j = 0 ;
  
for (j=0;j<=(strlen(s));j++)
{
 b[j]=s[j];
 if (b[j]==32) b[j]=46;
}
 b[j]='\0';
  	     
  return (UNSIGNED char *) (b);
}


unsigned char *leer2strich(s)
unsigned char s[];
{
  static unsigned char b[STRING];
  int j = 0 ;
  
for (j=0;j<=(strlen(s));j++)
{
 b[j]=s[j];
 if (b[j]==32) b[j]=95;  /* ' ' -> '_' */
}
 b[j]='\0';
  	     
  return (UNSIGNED char *) (b);
}



int FileTest(name)
unsigned char name[];
{
 FILE *fd;
 int i=0;
 if ((fd=fopen(name,"r"))!=NULL)
  {
   i=1; fclose(fd);
  }
 return(i);
}


/*   This function returns the date as a (long). */   
time_t dateconv(d)
UNSIGNED char d[];
{
  char s[STRING];
  int a, b, i;
  struct tm  *t;  
static  time_t l;
  
#ifdef DEBUG
 printf("\ndate:(%s)",d);
#endif 
  time(&l);
  t=gmtime(&l);
  strcpy(s, (char *) strcopy(d, 0, 1));
  a = atoi(s);
  strcpy(s, (char *) strcopy(d, 3, 4));
  b = atoi(s);
  strcpy(s, (char *) strcopy(d, 6, 9));
  i=atoi(s);
  if (i>1800)  i=i-1900;
  
  a=t->tm_mday+1-a;
  b=t->tm_mon+1-b;
  i=t->tm_year-i;
  l=(i*365)+(a)+(b*30);
#ifdef DEBUG  
printf("d:(%d), m:(%d), i:(%d),l(%d)",a,b,i,l); fflush(stdout);  
#endif

  return ( l);
  
}



/* Test ob User name in BBS ist und gibt vollen Namen zurueck*/
void conv()
{
  int fd;
  struct userdaten DUMMY;
  size_t dummy = sizeof(DUMMY);
  char s[4*STRING];
  int sum=0,sum_anz;

#if defined(_ESTDIO) || !defined(_SYS7)
  setbuf(stdout, NULL);
  setbuf(stdin, NULL);
#endif
    
sprintf(s,"%s/tmp/expire.%d",HOME,getpid());
if ((fd2=fopen(s,"w"))==NULL)
{
  printf("\nCan't write to (%s)\n",s);
  exit(-2); 
}
sprintf(s,"%s/tmp/expire.attention.%d",HOME,getpid());
if ((fd3=fopen(s,"w"))==NULL)
{
  printf("\nCan't write to (%s)\n",s);
  exit(-2); 
}
fprintf(fd3,"\n\n\n\n++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++");
fprintf(fd3,"\n+ warning/remove during invalid user                                       +");
fprintf(fd3,"\n++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++\n\n");
if (sw_muell_voll==0)
fprintf(fd3,"\nstatus name          lev  id city                 street             nick    \n          %-15.15s %-15.15s %-10.10s","phone1","phone2","birthday");
else 
fprintf(fd3,"\nstatus name          lev  id city                 street             nick  ");



#ifdef VIEW
printf("\n----\n%s  %s\n+++++++++++++expire-daemon++++++++++\nfollowing users are expired (expire.days=%d):",mydate(0),mytime(0),EXPIRE_DAYS);
printf("\n%-20.20s %-3.3s  %-30.30s  %s","user-name"," id ",
	       "  city","lastlogin");
#endif

fprintf(fd2,"\n\n%s   %s\n+++++++++++++expire-daemon++++++++++\nfollowing users are expired (expire.days=%d):",mydate(0),mytime(0),EXPIRE_DAYS);
fprintf(fd2,"\n%-20.20s %-3.3s  %-30.30s  %s","user-name"," id ",
	       "  city","  lastlogin     rm");
#ifdef R_DEBUG
  printf("\nmuell=(%d), muell-voll(%d)",sw_muell_on,sw_muell_voll);
#endif

LMORE:
  fd  = open(INP,O_RDONLY);
  if (fd == -1) {
	nerror("update_usr.c",61, "update_usr.c", "Can't read", INP);
	exit(-1);
  }
  sum_anz=0;

  while (read(fd, (UNSIGNED char *) &DUMMY, dummy) == dummy) 
  {          		
     if (
           ((!sw_muell_on)&&(ID<DUMMY.id))     
            &&
           (!(time_diff(DUMMY.lastlog)>EXPIRE_DAYS) ) 
        )
     {
#ifdef DEBUG 
       printf(" #1 ");
#endif     
        ID=DUMMY.id;  
        /* wenn User nichts/muell eingegeben hat && kein gast/sysop ist ;-)*/
        
        if 
        (
         (
         (MuellTest(0,DUMMY.wohnort))||(MuellTest(0,DUMMY.name))||
         (MuellTest(1,DUMMY.nick))||(MuellTest(0,DUMMY.strasse))||
          ( 
                 
            (
             (MuellTest(0,DUMMY.telefon1))||(MuellTest(0,DUMMY.telefon2))
              ||(MuellTest(0,DUMMY.geburtsdatum))
            )
             &&(sw_muell_voll==0)  /* !!!!!!!!! */
          )
         )
         &&(DUMMY.id>2)&&(DUMMY.level<7)
        )
        {
#ifdef VIEW        
         printf("\n%-6.6s %-14.14s %d  %03d %-20.20s %-20.20s %-7.7s\n      %-15.15s %-15.15s %-10.10s",";-)",
          DUMMY.name,DUMMY.level,DUMMY.id,DUMMY.wohnort,DUMMY.strasse,DUMMY.nick,
          DUMMY.telefon1,DUMMY.telefon2,DUMMY.geburtsdatum
          );
#endif         

         
         /* und verwarnt wurde, wird er geloescht */
         if (DUMMY.level>0)
         {
          if (sw_muell_voll==0)
          {
           fprintf(fd3,"\n%-6.6s %-14.14s %d  %03d %-20.20s %-20.20s %-7.7s\n          %-15.15s %-15.15s %-10.10s",
            "dec.",DUMMY.name,DUMMY.level,DUMMY.id,DUMMY.wohnort,
             DUMMY.strasse,sstrings(DUMMY.nick),DUMMY.telefon1,DUMMY.telefon2,DUMMY.geburtsdatum);
          } else
          {  
           fprintf(fd3,"\n%-6.6s %-14.14s %d  %03d %-20.20s %-20.20s %-7.7s",
            "dec.",DUMMY.name,DUMMY.level,DUMMY.id,DUMMY.wohnort,
             DUMMY.strasse,sstrings(DUMMY.nick));  
          }   
          DUMMY.level--;ATTENTIONS++;
          Save_User(&DUMMY);
          Verwarnung(&DUMMY);
          close(fd);
          goto LMORE;
         } else
         {
#ifdef VIEW	
   	  printf("\n%-20.20s (%03d)  %-30.30s  %s",DUMMY.name,DUMMY.id,
	       DUMMY.wohnort,DUMMY.lastlog);
#endif	       
	  fprintf(fd2,"\n%-20.20s (%03d)  %-30.30s  %s",DUMMY.name,DUMMY.id,
	       DUMMY.wohnort,DUMMY.lastlog);
          fprintf(fd3,"\n%-6.6s %-14.14s %d  %03d %-20.20s %-20.20s","clear",DUMMY.name,DUMMY.level,DUMMY.id,DUMMY.wohnort,DUMMY.strasse);	  
	  user_loeschen(DUMMY.id);
	  
	  sleep(3);
	  sum++;
	  close(fd);
	  goto LMORE;
         } 
        }
        
     }   
                	 
	if ((time_diff(DUMMY.lastlog)>EXPIRE_DAYS)&&(DUMMY.id>2))
	{
#ifdef VIEW	
	 printf("\n%-20.20s (%03d)  %-30.30s  %s",DUMMY.name,DUMMY.id,
	       DUMMY.wohnort,DUMMY.lastlog);
#endif	       
	 fprintf(fd2,"\n%-20.20s (%03d)  %-30.30s  %s",DUMMY.name,DUMMY.id,
	       DUMMY.wohnort,DUMMY.lastlog);
	 user_loeschen(DUMMY.id);
	 sleep(3);
	 sum++;
	 close(fd);
	 goto LMORE;
 	}
 	sum_anz++;
  }
#ifdef VIEW  
  printf("\n---\nnumber of expired user: %d\n",sum);
#endif
  fprintf(fd2,"\n---\nnumber of expired user: %d\nnumber of user (total): %d",
        sum,sum_anz-sum);
  fprintf(fd3,"\n---\nnumber of warnings (for user): %d\n",
        ATTENTIONS);        
  close(fd);
  fclose(fd2);fclose(fd3);
  if ((sum)||(ALWAYS_EXPIRE_MAIL))
   {
     if(sum)
     {
      sprintf(s,"cat %s/tmp/expire.%d >> %s/etc/log/expire.user.log",
          (char *) HOME,getpid(),(char *) HOME);
      system(s);
      sprintf(s,"chmod og+r %s/etc/log/expire.user.log",(char *) HOME);
      system(s);      
     }
     sprintf(s,"cat %s/tmp/expire.attention.%d >> %s/tmp/expire.%d",
          HOME,getpid(),HOME,getpid());
     system(s);
     ExpireLogMail(sum)  ;
   }
}




void do_expire()
{
  SetMain();
  SetMain2();
  
  if (EXPIRE_DAYS<7) 
  {
   printf("\nEXPIRE_DAYS must been >=7 days!\n");
   return;
  }
  
  setgid(GUEST_GID);setuid(GUEST_GID);  

  
  chdir(HOME);
  if (FileTest(UDBASE) )
   {
      sprintf(INP,"%s/%s",HOME,UDBASE);
      /*
      sprintf(OUT,"%s/tmp/aliases.bbs",HOME); 
      */
#ifdef VIEW      
      printf("\nInput-Userbase: %s\n",INP); 
#endif      
      conv();
   } else 
   {
    printf("\nSTOP:user-base (%s) not found\n",UDBASE);
   }

Bye();  
}




int time_diff(date)
unsigned char *date;
{
static time_t oldtime;
oldtime=dateconv(date);  /* ret-time in day  */
return(oldtime);
}



/* #SC - Cut a part out of a string [st].

   [v] describes the first position in [st], [b] stands for the last
   position. 

   This function returns the part between [v] and [b] as a string. */

UNSIGNED char *strcopy(st, v, b)
UNSIGNED char st[];
int v, b;
{
  static UNSIGNED char s[STRING];

  int i = 0, j;

#ifdef _PROFILE
  profile( "strcopy()" );
#endif
 
  if(b > STRING) b = STRING;

  for (j = v; j <= b; j++) {
	s[i] = st[j];
	i++;
  }
  s[i] = '\0';

  return (UNSIGNED char *) s;
}





void user_loeschen(id)
int id;
{
  int fd;
  int gd;
  struct userdaten DUMMY, LOOSER;
  UNSIGNED char t[STRING],s[STRING];
  long ll = -1L;
  size_t dummy = sizeof(DUMMY);
  int uid = -1;

  chdir(HOME); 
	
  maybe_locked(UDBASE, "r"); mblock(UDBASE);
  fd = open(UDBASE, O_RDONLY);
  if (fd == -1) {
	printf("\nuser_list.c 259  - user-loeschen, Can't read (%s)\n", UDBASE);
	exit(-1);
  }
  while (read(fd, (UNSIGNED char *) &DUMMY, dummy) == dummy) {
	if (uid == DUMMY.id) {
		ll = lseek(fd, 0L, SEEK_CUR) - dummy;
	}
	else{
		if (DUMMY.id == id) {
			ll = lseek(fd, 0L, SEEK_CUR) - dummy;
			strcpy(s,DUMMY.name);
		}
	}
  }
  
  lseek(fd, ll, SEEK_SET);
  read(fd, (UNSIGNED char *) &LOOSER, sizeof(LOOSER));
  close(fd);
  mbunlock(UDBASE);
  if (ll == -1L) return;

  maybe_locked(UDBASE, "r"); mblock(UDBASE);
  fd = open(UDBASE, O_RDONLY);
  if (fd == -1) {
	printf("\nuser-list, 490, loeschen(), Can't read (%s)", UDBASE);
	exit(-1);
  }
  sprintf(s, "%s/%dbase", TMP, getpid());

  gd = open(s, O_WRONLY | O_CREAT);
  if (gd == -1) {
	printf("\nuser-list, 321, loeschen(), Can't create (%s)", s);
	exit(-1);
  }
  while (read(fd, (UNSIGNED char *) &DUMMY, dummy) == dummy) {
	if (DUMMY.id != LOOSER.id) {
		write(gd, (UNSIGNED char *) &DUMMY, dummy);
	}
  }
  close(gd);
  close(fd);
   
  
  
  
  sprintf(t,"chmod og+r %s",s);
  if (system(t)!=0) err(t);

  sprintf(t,"chmod +rw %s",s);
  if (system(t)!=0) err(t);
  
  sprintf(t, "mv %s %s", s, UDBASE);
  system(t);

  unlink(s);
  mbunlock(UDBASE);
  sprintf(s, "rm -rf %s/usr/%c/%d", HOME, LOOSER.name[0], LOOSER.id);
  system(s);
#ifdef VIEW  
  printf("  ..ok");
#endif  
fprintf(fd2,"  ..ok");
}



/* #MO - Lock a file [path]. */

void mblock( path )
UNSIGNED char path[];
{
  FILE *fp;
  UNSIGNED char s[STRING];

  sprintf(s, "%s.LCK", path); 


  fp = fopen( s, "w" );
  if(fp != NULL){
	fputs(VERSION, fp);
	fclose(fp);
  }
  
}





/* #MU - Unlock a file [path]. */

void mbunlock( path )
UNSIGNED char path[];
{
  UNSIGNED char s[STRING];
  
  chdir(HOME);
  sprintf(s, "%s.LCK", path); 


  unlink(s);
}




/* #ML - Check whether a file [name] is locked or simply doesn't exist.

   [mode] shouldn't be used!

   This function returns 0 if a file is locked and -1 if file doesn't
   exist. */
 
int maybe_locked(name, mode)
UNSIGNED char name[], mode[];
{
  FILE *fp;
  int i = 0;
  UNSIGNED char s[STRING];

#ifdef _PROFILE
  profile( "mytime()" );
#endif

  chdir(HOME);
  sprintf(s, "%s.LCK", name);


  TRY_TWICE:

  fp = NULL;

  do {
	if(fp != NULL) fclose(fp);
	fp = fopen(s, "r");
	i++;
	if (fp != NULL) {
		if(i == 1) printf("%c%s ", CR, TOL08_MSG);
		printf(".");
		sleep(1);
	}
  } while ((i < 20) && (fp != 0));

  if(fp != 0){
	fclose(fp);
	
	mbunlock(name);  /* <--- DAS IST NATUERLICH NICHT KORREKT !!! */
	goto TRY_TWICE;  /* <--- DAS AUCH NICHT !!! ABER ES FUNXT ;-) */
	nerror("tools.c", 566, "maybe_locked", "File locked", name);	
	exit( -1 );
  }

  i = 0;

  do {
	fp = fopen(name, "r");	/* "r" => "mode", aber VORSICHT ! */
	i++;
	if (fp == NULL) {
		if(i == 1) printf("%c%s ", CR, TOL08_MSG);	
		printf(".");
		sync();
		sleep(3);
	}
  } while ((i < 5) && (fp == NULL));

  if (fp == NULL) return -1;

  fclose(fp);
  return 0;
}




/* #MT - Get the time.

   [mode]  ->  0 = hh:mm:ss
               1 = hh:mm

   This function returns a time string. */

UNSIGNED char *mytime(mode)
int mode;
{
  struct tm *tp;
  time_t tt;

  static UNSIGNED char s[STRING];


#ifdef _PROFILE
  profile( "mytime()" );
#endif

  time(&tt);
  tp = localtime(&tt);
  sprintf(s, "%2.2d:%2.2d:%2.2d", (unsigned int ) tp->tm_hour, (unsigned int ) tp->tm_min, 
    (unsigned int ) tp->tm_sec);

  if (mode == 1) s[5] = '\0';

  return (UNSIGNED char *) s;
}



UNSIGNED char *mydate(mode)
int mode;
{
  struct tm *tp;
  time_t tt;
  UNSIGNED char wt[8][11];

  static UNSIGNED char s[STRING];

#ifdef _PROFILE
  profile( "mydate()" );
#endif

  strcpy(wt[0], "Sonntag");
  strcpy(wt[1], "Montag");
  strcpy(wt[2], "Dienstag");
  strcpy(wt[3], "Mittwoch");
  strcpy(wt[4], "Donnerstag");
  strcpy(wt[5], "Freitag");
  strcpy(wt[6], "Samstag");
  time(&tt);
  tzset();
  tp = localtime(&tt);
  if (mode == 0) {
	sprintf(s, "%2.2d.%2.2d.%4.4d", (unsigned int) tp->tm_mday, (unsigned int)tp->tm_mon + TZS, 
	(unsigned int) (1900 + tp->tm_year));
  }
  if (mode == 1) {
	sprintf(s, "%2.2d.%2.2d.%2.2d", (unsigned int)tp->tm_mday, (unsigned int) (tp->tm_mon + TZS), 
	(unsigned int)tp->tm_year);
  }
  if (mode == 2) {
	sprintf(s, "%s", wt[tp->tm_wday]);
  }
  if (mode == 3) {
	if((tp->tm_wday == 0) || (tp->tm_wday == 6))
		strcpy(s, (UNSIGNED char *) wt[tp->tm_wday]);

	else
		s[0] = '\0';
  }
  return (UNSIGNED char *) s;
}



void ExpireLogMail(user_anz)
int user_anz;
{
  FILE *fd,*ff,*fp;
  time_t timer,k;


  UNSIGNED char s[2*STRING];
  UNSIGNED char t[STRING];




	time(&timer); k=time(0);
        sprintf(s,"%s/tmp/expire.mail.%d",HOME,getpid());
        if ((ff=fopen(s,"w"))==NULL)
        {
          printf("\nCan't write to (%s)\n",s);      
          exit(-1);
        }        
        

        fprintf(ff, "Path:  %s!bbs\n",UUCPID2);	
        fprintf(ff, "From:  TBBS_LOG-DAEMON@%s (TBBS_LOG-DAEMON)\n",UUCPID2);	
/*	fprintf(ff, "Sender: TBBS_EXPIRE-DAEMON@%s\n", UUCPID2); */
	fprintf(ff, "Organization: %s\n", ORGANIZATION);
        fprintf(ff, "To: %s\n",ZPOSTMASTER);        	
        fprintf(ff, "Subject: %d %s, warnings: %d\n",user_anz,BBSMD01e_MSG,ATTENTIONS);

        fprintf(ff, "X-Mailer: bbs.update %s (user_exp)\n",  PATCHLEVEL);	
    if (!gethostname(&s[0],STRING))
    {
     k=time(0);
     fprintf(ff,"Received: by \"%s\"  %s \nMessage-ID: <%d.%d@%s>\n\n",
     	s,BBSMD_VERSION,
       (int ) getpid(), (int ) k,UUCPID2);
    }
	
	fputs("\n", ff);

       fprintf(ff, "%s\n    %d %s\n    %d %s\n%s",BBSMD03k_MSG, user_anz,BBSMD01e_MSG,
         ATTENTIONS,BBSMD01m_MSG, BBSMD05_MSG);
        
        sprintf(s,"%s/tmp/expire.%d",HOME,getpid());
        if ((fd=fopen(s,"r"))==NULL)
        {
          printf("\nCan't read (%s)\n",s);      
          exit(-1);
        }        
        while (fgets(s,STRING,fd)!=NULL)
        {
        fprintf(ff,"%s",s);
        }
         
	fclose(ff);
	fclose(fd);
        sprintf(t,"%s/tmp/expire.mail.%d",HOME,getpid());
        sprintf(s,"%s -t -oi", SYSTEM_MAIL);
        if ((fp = popen(s, "w")) == NULL)
         {
            printf("\n\7Can't open pipe to Mailer .%s!\n",SYSTEM_MAIL);
            return;
         }
        fd=fopen(t,"r");
        while(fgets(s,STRING,fd)!=NULL)
        {
          fprintf(fp,"%s",s);
        }
        fclose(fd); fclose(fp);                        
	
	unlink( t );
	sprintf(t,"%s/tmp/expire.%d",HOME,getpid());
	unlink(t); 

}

void Bye()
{
unsigned char s[STRING];

        sprintf(s,"%s/tmp/expire.mail.%d",HOME,getpid());
	unlink( s );
	sprintf(s,"%s/tmp/expire.%d",HOME,getpid());
	unlink(s); 
	sprintf(s,"%s/tmp/expire.attention.%d",HOME,getpid());
	unlink(s); 	
} 

void SetMain2()
{
char s[STRING];
int i;

strcpy(ORGANIZATION,sstrings(GRead("organisation"))); 
strcpy(UUCPID2,sstrings(GRead("domain1"))); 
for (i=0; i<STRING; i++)
{
 if ((UUCPID2[i]==SPACE)||(UUCPID2[i]==CR)) UUCPID2[i]=0;
}
strcpy(s,sstrings(GRead("expire.days"))); 
EXPIRE_DAYS=atoi(s);

}

int Max(a)
int *a[128];
{
int i,j=0;

 for (i=0; i<128; i++) 
 {
   if (i!=SPACE)
   {
    if (a[i]>j) j= (int) a[i];
   }
 }
 return((int )j);
}



/* wandelt alle Zeilchen in Grossbuchstaben */
unsigned char *touppers(s)
unsigned char s[];
{
  static unsigned char b[STRING];
  int j = 0 ;
    
    for (j=0;j<=(strlen(s));j++)
    {
     b[j]=s[j];
     if ((b[j]>64)&&(b[j]<91)) b[j]=b[j]+32;
    }
 b[j]=0;
       
       
return (UNSIGNED char *) (b);
}
         



int MuellTest(mode,zeile)
int mode;
unsigned char *zeile;
{
int a[128];
unsigned char s[2*STRING];
int i;
FILE *fdd=NULL;
int muell=0;


#ifdef DEBUG
  printf(" MuellTest(%d,%s)... ",mode,zeile);
#endif

 for (i=0; i<128; i++) a[i]=0;
 strcpy(s,sstrings(zeile));
 
#ifdef DEBUG
  printf(" n.strings() ");
#endif
   
 if ((strlen(s)<3)&&(mode!=1)) muell=1;
 else
 {
    for (i=0; i<strlen(s); i++)  a[s[i]]++;
    if (Max(&a)>MAX_MUELL_CHAR) muell=2;
 }
 
#ifdef DEBUG
   printf(" n.max ");
#endif

 if (muell==0)
 {
  sprintf(s,"%s/etc/list.postfach.muell",HOME);
  if ((fdd=fopen(s,"r"))!=NULL)
  {
   while ((strpos("============================",s)==NULL)&&(fgets(s,STRING,fdd)!=NULL));
   
   while ((fgets(s,STRING,fdd)!=NULL)&&(muell==0))
   {
    if (strlen(s)>2)
    {   
    strcpy(s,sstrings(s));
    s[strlen(s)-2]=0;

     if (strpos(s,touppers(zeile)) !=0) muell=1;
     
#ifdef S_DEBUG
  if (muell==1)
   {
    printf("\nmuell=(%s), zeile=(%s) ",s,zeile);  fflush(stdout); sleep(2);
   }
#endif      
    }
   }
   fclose(fdd);
  }
 }
#ifdef R_DEBUG
   printf("\nzeile=(%s) ->muell=(%d)",zeile,muell);  fflush(stdout);
#endif 
fclose(fdd);

#ifdef DEBUG
  printf("...done ");
#endif
  

return(muell);
}




int Verwarnung(DUMMY)
struct userdaten *DUMMY;
{
  FILE *fd,*ff;
  time_t timer,k;

  UNSIGNED char s[2*STRING];
  UNSIGNED char t[STRING];



	time(&timer); k=time(0);
        sprintf(s,"%s/tmp/expire.usr.%d",HOME,getpid());
        if ((ff=fopen(s,"w"))==NULL)
        {
          printf("\nCan't write to (%s)\n",s);      
          exit(-1);
        }        
        
        fprintf(ff, "From: TBBS_LOG-DAEMON@%s (TBBS_LOG-DAEMON)\n",UUCPID2,UUCPID2);	
	fprintf(ff, "Organization: %s\n", ORGANIZATION);
        fprintf(ff, "Subject: %s %d\n",BBSMD01l_MSG,DUMMY->level);
        fprintf(ff, "To: %s@%s\n",leer2punkt(DUMMY->name),UUCPID2);
        fprintf(ff, "X-Mailer: bbs.update %s (user_exp)\n",  PATCHLEVEL);	
    if (!gethostname(&s[0],STRING))
    {
     k=time(0);
     fprintf(ff,"Received: by \"%s\"  %s \nMessage-ID: <%d.%d@%s>\n\n",
     	s,BBSMD_VERSION,
       (int) getpid(),(int) k,UUCPID2);
    }
	
	fputs("\n", ff);
	
	
/*---------------- daemon say..... -----------------------*/	
	fputs("\n-----------------------expire-daemon say:----------------------------------", ff);
        fputs("\nno valid entrys were found in user-base",ff);
	fputs("\n-----------------------invalid entrys follows------------------------------\n\n", ff);                	
        if (MuellTest(0,DUMMY->wohnort))
        {
          fprintf(ff,"invalid-\"city\"-entry:  (format: zip-code city)\n  city:%s\n\n",DUMMY->wohnort);
        }
        if (MuellTest(0,DUMMY->name))
        {
          fprintf(ff,"invalid-\"name\"-entry:\n  name:%s\n\n",DUMMY->name);
        }        
        
        if (MuellTest(1,DUMMY->nick))
        {
          fprintf(ff,"invalid-\"nickname\"-entry: \n  nick:%s\n\n",DUMMY->nick);
        }        
        if (MuellTest(0,DUMMY->strasse))
        {
          fprintf(ff,"invalid-\"street\"-entry: \n  street:%s\n\n",DUMMY->strasse);
        }        
        
        
        if (MuellTest(0,DUMMY->telefon1))
        {
          fprintf(ff,"invalid-\"phone1\"-entry:\n  phone1:%s\n\n",DUMMY->telefon1);
        }        
        
        if (MuellTest(0,DUMMY->telefon2))
        {
          fprintf(ff,"invalid-\"phone2\"-entry: \n  phone2:%s\n\n",DUMMY->telefon2);
        }        
        
        if (MuellTest(0,DUMMY->geburtsdatum))
        {
          fprintf(ff,"invalid-\"birtday\"-entry: \n  birtday:%s\n\n",DUMMY->geburtsdatum);
        }        
        
	fputs("-------------------------------------------------------------------------\n", ff);        
/*--------------------------------------------------------*/        

        sprintf(s,"%s/etc/mail/invalid.entry.txt",HOME);
        if ((fd=fopen(s,"r"))==NULL)
        {
          printf("\nCan't read (%s)\n",s);      
          exit(-1);
        }        
        while (fgets(s,STRING,fd)!=NULL)
        {
        fprintf(ff,"%s",s);
        }
         
	fclose(ff);
	fclose(fd);
        sprintf(t,"%s/tmp/expire.usr.%d",HOME,getpid());
        MailTo(t,leer2punkt(DUMMY->name)),
	
	unlink( t );
	sleep(10);
  return((int ) 0);
}



void Save_User(LOOSER)
struct userdaten *LOOSER;
{
  int fd;
  int gd;
  struct userdaten DUMMY;
  UNSIGNED char t[STRING],s[STRING];
  size_t dummy = sizeof(DUMMY);

  chdir(HOME); 
	
  maybe_locked(UDBASE, "r"); mblock(UDBASE);
  fd = open(UDBASE, O_RDONLY);
  if (fd == -1) {
	printf("\nuser_list.c 259  - user-loeschen, Can't read (%s)\n", UDBASE);
	exit(-1);
  }
  sprintf(s, "%s/%dbase", TMP, getpid());

  gd = open(s, O_WRONLY | O_CREAT);
  if (gd == -1) {
	printf("\nuser-list, 321, loeschen(), Can't create (%s)", s);
	exit(-1);
  }
  
  while (read(fd, (UNSIGNED char *) &DUMMY, dummy) == dummy) {
	if (LOOSER->id == DUMMY.id) {
		DUMMY.level--;
#ifdef VIEW 
/*		printf("\nDEC()"); fflush(stdout);*/
#endif	
		write(gd, (UNSIGNED char *) &DUMMY, dummy);
	}
	else{
	   write(gd, (UNSIGNED char *) &DUMMY, dummy);
	}
  }
  
  close(gd);
  close(fd);

  sprintf(s, "%s/%dbase", TMP, getpid());
    
  sprintf(t,"chmod og+r %s",s);
  if (system(t)!=0) err(t);
  
  sprintf(t,"chmod +rw %s",s);
  if (system(t)!=0) err(t);


  sprintf(t, "mv %s %s", s, UDBASE);
  system(t);

  unlink(s);
  mbunlock(UDBASE);
}
