/*##########################################################################*/
/*    erstellt alias-Eintrag fuer smail-alias-file  			    */
/*##########################################################################*/

#undef CONVERT

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <stdio.h>
#include <fcntl.h>
#include <stdlib.h>
#include "prototypes.h"

#include "../mbox.h"
#include "../mbox.msg"
#include "../s_global.h"
#include "../usr.list/defs.h"
#include "../language.h"


#ifndef _USE_SHARED_MEM
 static struct L_TYP l_entry[MAX_LANGUAGE_ENTRY];     
#else 
#include <sys/ipc.h>
#include <sys/shm.h>
 static struct L_TYP *l_entry,*entry_top; 
 static int mem_id;   			
 static struct shmid_ds sh_buf;
#endif


/* check, wieviel user in der landesprache oneline sind */
int UsrLogonTest(lang)
int lang;
{
#ifdef _USE_SHARED_MEM

      if (((mem_id=shmget(L_KEY+lang,
           (sizeof(struct L_TYP)*MAX_LANGUAGE_ENTRY ),
               IPC_EXCL | L_PERM))<0)!=0)
      {
         return(0);  /* keine User oneline, segment nicht existent! */
      }
      entry_top=(struct L_TYP *) shmat(mem_id,0,0);
      shmctl(mem_id, IPC_STAT, &sh_buf);
      if (sh_buf.shm_nattch==1)
      {
       shmctl(mem_id, IPC_RMID, &sh_buf);
       return(0);
      } else return (sh_buf.shm_nattch-1);
#endif      
                                  
}





void do_clean()
{
  SetMain();
  chdir(HOME);
  printf("\ndo_clean...\n");
#ifdef _USE_SHARED_MEM
  if ((!UsrLogonTest(1))&&(!UsrLogonTest(2))&&(!UsrLogonTest(3))&&(!UsrLogonTest(4)))
   { /* kein User in keiner ist Online */
    printf("\nclear tmp-dir's...." );
    MakeTmpClean();
    exit(0);
   } else 
   {
    printf("\nwarning: there are user oneline -> STOP: Can't make tmp-dir's clean!\n");
    exit(-4);
   }
#else
   printf("\7\nInvalid args: \nclean-option: shared-memory-support disable (not elf-support by system)!\n");
#endif

  printf("...done\n");  
}




void MakeTmpClean()
{
char s[3*STRING];

  sprintf(s,"rm -rf %s/tmp/*",HOME);
  system(s);
}