{ OCT 97 - Release Notes                                         }
{ Writes Errors to ERROR.LOG                                     }

Unit ErrorLog;

Interface

Uses Dos, Dates, Data;

function ErrorString(ErrorNumber : Byte) : String;
procedure LogError(Buffer : String);

Implementation

function ErrorString(ErrorNumber : Byte) : String;
var
  Strgs : string;
begin
  Str(ErrorNumber, Strgs);
  Case ErrorNumber of
   $00 : ErrorString := 'OK';
   $02 : ErrorString := 'File not found';
   $03 : ErrorString := 'Path not found';
   $04 : ErrorString := 'To many open Files';
   $05 : ErrorString := 'Access denied';
   $06 : ErrorString := 'Invalid file handle';
   $07 : ErrorString := 'Memory blocks invalid';
   $08 : ErrorString := 'Not enough memory';
   $09 : ErrorString := 'Memory blocks invalid';
   $0A : ErrorString := 'Invalid environment';
   $0B : ErrorString := 'Invalid format';
   $0C : ErrorString := 'Invalid file Access code';
   $0F : ErrorString := 'Invalid drive number';
   $10 : ErrorString := 'Cannot remove current directory';
   $11 : ErrorString := 'Cannot rename across drives';
   $12 : ErrorString := 'No more files';
   $13 : ErrorString := 'Disk write protected';
   $15 : ErrorString := 'Drive not ready';
   $16 : ErrorString := 'Bad command';
   $17 : ErrorString := 'Data error on disk';
   $19 : ErrorString := 'Seek error';
   $1A : ErrorString := 'Bad media';
   $1B : ErrorString := 'Sector not found';
   $1D : ErrorString := 'Unable to write to disk';
   $1E : ErrorString := 'Unable to read from disk';
   $20 : ErrorString := 'File sharing error';
   $21 : ErrorString := 'File locking error';
   $23 : ErrorString := 'No free FCBs';
   $24 : ErrorString := 'File sharing buffer full';
   $35 : ErrorString := 'Bad network patch';
   $36 : ErrorString := 'Network busy';
   $37 : ErrorString := 'Device does not exist';
   $39 : ErrorString := 'Hardware error';
   $64 : ErrorString := 'Disk read error';
   $65 : ErrorString := 'Disk write error';
   $66 : ErrorString := 'File not assigned';
   $67 : ErrorString := 'File not open';
   $68 : ErrorString := 'File not open for input';
   $69 : ErrorString := 'File not open for output';
  Else
    ErrorString := ' ('+ Strgs + ')unKown Error';
  end; { Case End }
end;

procedure LogError(Buffer : String);
Var
  Log : Text;
begin
  Assign(Log, BBSCfg.ErrFile);
  {$I-} append(Log); {$I+}
  If IOResult <> 0 then
    begin
      Rewrite(Log);
      WriteLn(Log,'LOG CREATED ', Today);
      Writeln(Log);
    end;
  if not Errored then
    begin
      Writeln(log,'>>>>>>>>>>>>>>>>>> SYSTEM & ERROR LOG <<<<<<<<<<<<<<<<<<<');
      Errored := True;
    end;
  Writeln(Log, Buffer);
  Close(Log);
end;
end.