{ OCT 97 - Release Notes                                         }
{ This Unit is used to create DORINF00.DEF file                  }
{ I think this written to be used instead of the one in DOOR.PAS }

Unit DorDef;

interface

Uses Crt, Data, Lib, ErrorLog, WaitTix;

procedure DorInfo(NODE : BYTE);

implementation

(* ------------------------------------------------------------------------ *)
(*  Creates DORINFO00.DEF File                                              *)
(* ------------------------------------------------------------------------ *)
procedure DorInfo(NODE : BYTE);
Var
  OutFile : Text;
  Strgs,
  Fname   : String;
begin
  Str(NODE, Strgs);
  Fname := 'DORINFO' + Strgs + '.DEF';
  Assign(OutFile, Fname);
  {$I-} Rewrite(OutFile); {$I+}
  FileError := IOResult;
  If FileError <> 0 then
    begin
      LogError('Unable To Create Door File : ' + Fname + ' - ' + ErrorString(FileError));
      If Local then
        begin
          Writeln('Unable To Crate Door File : ',Fname);
          Wait(300);
        end;
    end
  Else
    begin
      Writeln(OutFile, BBSCfg.BBSName);
      Writeln(OutFile, BBSCfg.SysopFirst);
      Writeln(OutFile, BBSCfg.SysopSec);
      If Local then
        begin
          Writeln(OutFile,'COM0');
        end
      Else
        begin
          Writeln(OutFile,'COM1');
        end;
      If Local then
        begin
          Writeln(OutFile, 0,' BAUD,N,8,1');
        end
      Else
        begin
          Writeln(OutFile,ActualBaud,' BAUD,N,8,1');
        end;
      If Local then
        begin
          Writeln(OutFile,0);
        end
      Else
        begin
          Writeln(OutFile,ActualBaud);
        end;
      Writeln(OutFile, UserInfo.UserName);
      Writeln(OutFile, ' ');
      Writeln(OutFile, UserInfo.UserTown);
      Writeln(OutFile, UserInfo.UserColour);
      Writeln(OutFile, UserInfo.UserLevel);
      Writeln(OutFile, TimeLeft);
      Close(OutFile);
    end;
end;

end.
