#include <ctype.h>
#include <signal.h>
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <syslog.h>
#include <sys/time.h>
#include <sys/types.h>
#include <termios.h>
#include <unistd.h>
#include "os.h"
#include "modem.h"
#include "output.h"
#include "varlist.h"

#define LOGLEVEL_INFO  LOG_INFO
#define LOGLEVEL_ERROR LOG_INFO

#define J_LEFT   0
#define J_RIGHT  1

int ansi = 0;

extern void timed_out();

extern int online, node, remote;
extern vmodem *modem, *spymodem;

extern varlist list;

static char *log_buffer = NULL;
char initstring[256], *out_buf = NULL;
int device_delay, timeout;
int spying = 0;
char yes_key = 'y', no_key = 'n', mark_key = 'm', quit_key = 'q';
char cont_key = 'c', unmark_key = 'u';

void flush()
{
  modem -> flush();
}

int read_char() 
{
#if 0
  return modem -> read_char();   
#else
  fd_set rdfd;
  int max_fd, ret, fd, timeout, timeouts = 0;
  char c;
  struct timeval tv;
  
  if(remote)
    timeout = number("timeout");
  
  for(;;) {
    FD_ZERO(&rdfd);
    FD_SET(modem -> fd, &rdfd);
    max_fd = modem -> fd;
  
    tv.tv_sec = 1; /* I WOULD LIKE TO EAT YOUR FOOT! */
    tv.tv_usec = 0;    
    
    if(spymodem) {
      FD_SET(spymodem -> fd, &rdfd);
      if(spymodem -> fd > max_fd)
        max_fd = spymodem -> fd;
    }
    
    if(remote)
      ret = select(max_fd + 1, &rdfd, NULL, NULL, &tv);
    else
      ret = select(max_fd + 1, &rdfd, NULL, NULL, NULL);
    
    if(ret == -1 && errno == EINTR)
      continue;
    
    if(ret == 0) {
      timeouts++;
      if(timeouts >= timeout)
        timed_out();
      else
        continue;
    }
    
    if(FD_ISSET(modem -> fd, &rdfd))
      fd = modem -> fd;
      
    if(spymodem && FD_ISSET(spymodem -> fd, &rdfd))
      fd = spymodem -> fd;    

    if(!read(fd, &c, 1))
      raise(SIGHUP);
    return c;
  } 
#endif
}

void detect_ansi()
{
  char buf[20];
  int t;
  
  t = 0;
  while(modem -> poll(100) && t < 20)
    buf[t++] = read_char();
  
  if(t == 0)
    return;
    
  buf[t] = 0;
  dprintf(">terminal ID: ", buf); 
  for(t = 0;t < strlen(buf);t++) {
    if(iscntrl(buf[t]))
      dprintf("[%d]", buf[t]);
    else
      dprintf("%c", buf[t]);
  } 
  dprintf("\n");
  
  if(strchr(buf, 'c'))
    ansi = 1;
}

void output_raw(char c)
{
  if(spymodem)
    spymodem -> raw(c);
  modem -> raw(c);
}

int output_raw(char *string)
{
  if(spymodem)
    spymodem -> raw(string);
  return modem -> raw(string);
}

int voutput_raw(char *fmt, ...)
{
  va_list args;
  va_start(args, fmt);
  vsprintf(out_buf, fmt, args);
  va_end(args);
  return output_raw(out_buf);
}

int output_cooked(char *string)
{
  cook(string);
  return output_raw(out_buf);
}
	 
int cook(char *string, varlist *vlist = NULL)
{
  static int width = 0, justify;
  int t, l, n = 0, v, sl, tmp;
  char c, o, var_name[80], buf[16], j, *s, fill;
  variable *var;

  if(out_buf == NULL)
    out_buf = (char *)malloc(1024);
   
  if(vlist == NULL)
    vlist = &list;

  l = strlen(string);
   
  for(t = 0;t < l && n < 1023;t++) {
    c = string[t];
     
    if(c == '\\' /* || c == '@' */) {
      t++;
      if(t == l)
        out_buf[n++] = c;
      else { 
        o = c;
	c = string[t];
        if(c == 'c')
	  //n += sprintf(out_buf + n, ansi ? "\033[0m\033[2J\033[H" : "\n\n");
          n += sprintf(out_buf + n, ansi ? "\033[2J\033[H" : "\n\n");
        else if(c == 'n')
	  out_buf[n++] = 10;
	else if(c == 't')
	  n += sprintf(out_buf + n, "        ");
	else if(c == '\n') {
	  out_buf[n++] = o;
	  out_buf[n++] = 10;
	}
	else if(c == '\\' || c == '@' || c == '$')
	  out_buf[n++] = c;
	else {
	  out_buf[n++] = o;
	  out_buf[n++] = c;
	}
      }
    }
    else if(c == '$') {
      v = 0;
      t++;
      if(t == l) {
	out_buf[n++] = '$';
	break;
      }
       
      while((var_name[v++] = string[t]) != '$' && v <= 80 && t < l)
	t++;
       
      var_name[--v] = 0;
      
      if(isdigit(*var_name) && v > 1) {
	s = var_name;
	while(isdigit(*s))
	  s++;
        j = *s;
	*s++ = 0;
	fill = *s++;
	width = atoi(var_name);
        var = (*vlist)[s];
	if(j == 'l')
	  justify = J_LEFT;
	else if(j == 'r')
	  justify = J_RIGHT;
	else
	  width = 0;
      }	 
      else 
        var = (*vlist)[var_name];
      
      if(var == NULL)
        n += sprintf(out_buf + n, "$%s$", var_name);
      else if(var -> get_type() == STRING)
   	s = var -> get_s();
      else {
	sprintf(buf, "%d", var -> get_i());
	s = buf;
      }
       
      if(var) {
	if(!width)
	  n += sprintf(out_buf + n, "%s", s);
	else if(justify == J_LEFT)
	  while(width--)
	    out_buf[n++] = *s ? *s++ : fill;
	else if(justify == J_RIGHT) {
	  n += width;
	  tmp = n;
	  sl = strlen(s);
	  while(width--)
	    out_buf[--n] = sl ? s[--sl] : fill; 
          n = tmp;
	}
        width = 0;
      }
    }
    else if(c == '\n')
      out_buf[n++] = 10;
    else if(c != '\r')
      out_buf[n++] = c;
  }
  
  out_buf[n] = 0;
  return n;
}

int ansi_length(char *s)
{
  int n = 0;

  while(*s) {
    if(*s == '\033') {
      do {
        s++;
      } while((isdigit(*s) || *s == ';' || *s == '[') && *s);
    }
    else 
      s++, n++; 
  }
   
  return n;
}

#if 0
void ansi_clip(char *s, int n)
{
  int t = 0;

  while(*s && t < n) {
    if(*s == '\033')
      do { s++; } while((isdigit(*s) || *s == ';' || *s == '[') && *s);
    else
      s++, t++;
  }
  
  *s = 0;
}
#endif

void kill_line(int length)
{
  int t;

  if(ansi)
    voutput_raw("\033[%dD\033[K", length);
  else {
    for(t = 0;t < length;t++)
      output_raw('\010');
    for(t = 0;t < length;t++)
      output_raw(' ');
    for(t = 0;t < length;t++)
      output_raw('\010');
  }
}

int input_alpha(char *buf, int l, char hidden)
{
  static int first = 1;
  int n = 0;
  char c;
  *buf = 0;
   
  extern void detect_ansi(); 
   
  for(;;) {
    c = read_char();    
    switch(c) {
      case 27:
        if(first) {
          first = 0;
          detect_ansi();
        }
      break;
    
      case 127:
      case 8:
        if(n) {
	  output_raw("\010 \010");
	  buf[--n] = 0;
	}
      break;
       
      case 13:
        return n;
      break;
       
      default:
        if(!iscntrl(c) && n < l) {
	  buf[n++] = c;
	  buf[n] = 0;
	  output_raw(hidden ? '.' : c);
	}
      break;
    }
  } 
   
}

int input_num(int def)
{
  int n = 0;
  char c, buf[10];
  *buf = 0;
   
  for(;;) {
    c = read_char();    
    switch(c) {
      case 127:
      case 8:
        if(n) {
	  output_raw("\010 \010");
	  buf[--n] = 0;
	}
      break;
       
      case 13:
        return n ? atoi(buf) : def;
      break;
       
      default:
        if(isdigit(c) && n < 10) {
	  buf[n++] = c;
	  buf[n] = 0;
	  output_raw(c);
	}
      break;
    }
  } 

}

int noyes()
{
  return tolower(read_char()) == yes_key;
}

int yesno()
{
  return tolower(read_char()) != no_key;
}
   
void init_log()
{
  log_buffer = (char *)malloc(1024);
  openlog("bb", 0, LOG_USER);  
}

void close_log()
{
  closelog();  
}

void log(char *fmt, ...)
{
  if(log_buffer == NULL)
    return;
   
  va_list args;
   
  va_start(args, fmt);
  vsprintf(log_buffer, fmt, args);
  va_end(args);
   
  syslog(LOGLEVEL_INFO, "%d %s", node, log_buffer);
}

void log_args(char *fmt, va_list args)
{
  if(log_buffer == NULL)
    return;

  vsprintf(log_buffer, fmt, args);
  syslog(LOGLEVEL_ERROR, "%d %s", node, log_buffer);
}
