/* setenv.c - implement setenv() and unsetenv() with just putenv()
 *
 * $Id: setenv.c,v 1.1 2001/11/02 15:58:49 ivarch Exp $
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

int setenv (const char * name, const char * value, int overwrite) {
  char * buf;
  int ret;

  if (!overwrite) {
    if (getenv (name)) return (0);
  }

  buf = malloc (strlen (name) + strlen (value) + 2);
  if (!buf) return (-1);

  sprintf (buf, "%s=%s", name, value);
  ret = putenv (buf);
  free (buf);
  return (ret);
}

void unsetenv (const char * name) {
  putenv (name);
}

/* EOF $Id: setenv.c,v 1.1 2001/11/02 15:58:49 ivarch Exp $ */
