/* stripattr.c - convert a string to plain text
 *
 * $Id: stripattr.c,v 1.1.1.1 1999/12/02 20:03:27 ivarch Exp $
 */

#include "mstring.h"


/* Strip all attributes from "str", leaving it as plain text.
 */
void mstripattr (char * str) {
  int r = 0, w = 0;

  if (!str) return;

  while (str[r] != 0) {
    if (miscntl(str[r])) {
      mtribval (str, &r);
    } else {
      str[w] = str[r];
      r ++;
      w ++;
    }
  }

  str[w] = 0;
}

/* EOF */
