/* status.c - return LDB information on a menu entry
 *
 * $Id: status.c,v 1.1.1.1 1999/12/02 20:03:22 ivarch Exp $
 */

#include "ldb.h"
#include "menu.h"


/* Return a bitfield composed of MENU_ITEM_* for the menu entry "entry",
 * reading from LDB file "ldbfile"; entry->filename's mtime is "t".
 */
int menu_status (menuentry_t * entry, char * ldbfile, unsigned long t) {
  struct LDB l;
  int a;

  if ((!entry) || (!ldbfile) || (!entry->filename)) return (0);

  if (entry->status & MENU_STATUS_NOLAST) return (MENU_ITEM_NOLDB);

  ldb_read (ldbfile, entry->filename, &l);

  if (l.last_accessed == 0) return (MENU_ITEM_NOLDB);

  a = 0;
  if (l.last_accessed >= t) {
    if (!l.at_end) a = MENU_ITEM_MODIFIED;
  } else a = MENU_ITEM_MODIFIED;

  if (l.sub_status == 1) a |= MENU_ITEM_SKIP1;
  else if (l.sub_status == 2) a |= MENU_ITEM_SKIP2;

  return (a);
}

/* EOF */
