/* bbs.h - header file for BBS functions
 *
 * $Id: bbs.h,v 1.3 2000/07/31 11:03:46 ivarch Exp $
 */

#ifndef _MT_BBS_H
#define _MT_BBS_H

#ifndef _MT_VIEWMENU_H
#include "viewmenu.h"
#endif	/* _MT_VIEWMENU_H */

enum {			/* list of config file key types */
  CF_BOOLEAN,			/* (char) boolean - YES (1) or NO (0) */
  CF_INTEGER,			/* (long) integer */
  CF_FILENAME,			/* (char *) string with no whitespace */
  CF_STRING			/* (char *) string with whitespace */
};

typedef struct {		/* information about config file keys */
  char * key_name;			/* key name */
  int key_type;				/* type (one of the enums above) */
  char * strval;			/* default value */
  long value;				/* default value (non-string) */
} bbs_cf_t;

typedef struct uo_info {	/* user information structure */
  char username[16];			/* username */
  char nameline[42];			/* nameline */
  char keypath[64];			/* keypath */
  char action[256];			/* action */
  char location[128];			/* location */
  long idle;				/* idle time */
  long login;				/* time connected for */
  int bold;				/* if entry is in bold */
  int me;				/* if entry is self */
  int admin;				/* if entry is an admin */
  int internal;				/* if entry is an internal */
} uo_info_t;

extern char * current_user;			/* current username */
extern char * home_dir;				/* user's home directory */
extern char * proc_title;			/* current process title */
extern int proc_title_len;			/* length of process title */

int cf_load (char *, bbs_cf_t *);		/* load config file */
char * cf_str (char *);				/* read config value */
long cf_int (char *);				/* read config value */
int cf_bool (char *);				/* read config value */

void udb_load (void);				/* load user database */
void udb_save (void);				/* save user database */

int bbs_is_sysop (char *);		/* return 1 if user is a sysop */

void bbs_special_menu (menudata_t, menuentry_t *, int);		/* [ESC] */
void bbs_options_menu (menudata_t, menuentry_t *, int);		/* [ESC][O] */

#endif	/* _MT_BBS_H */

/* EOF */
