/* catchup.c - mark a file as "read up to date"
 *
 * $Id: catchup.c,v 1.1.1.1 1999/12/02 20:02:07 ivarch Exp $
 */

#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>
#include <unistd.h>
#include "viewmenu.h"
#include "viewfile.h"


/* Mark the file in menu entry "e" as having been read up to date.
 */
void menuview_catchup (menudata_t data, menuentry_t * e) {
  struct RF_Data p;
  struct LDB d;
  struct stat sb;
  long i;

  if (!e) return;
  if (!e->filename) return;
  if (stat (e->filename, &sb)) return;

  i = menu_status (e, data->ldbfile, sb.st_mtime);
  i &= (MENU_ITEM_NOLDB | MENU_ITEM_MODIFIED);
  if (i == 0) return;			/* file already up to date */

  memset (&d, 0, sizeof (d));

  ldb_read (data->ldbfile, e->filename, &d);

  strcpy (d.realname, d.filename);
  p.ldb_entry = &d;
  p.line_pos = 0;
  p.last_scanned = 0;
  rf_fudge_linescan (&p, e->filename);

  d.current_line = p.num_lines;

  for (i = d.current_line - 1; i >= 0; i --) {
    if (p.line_pos[i].type == MFILE_LINE_DATESTAMP) {
      d.last_datestamp = p.line_pos[i].datestamp;
      d.datestamp_line = i;
      break;
    }
  }

  d.at_end = 1;
  ldb_write (data->ldbfile, &d);

  free (p.line_pos);
}

/* EOF */
