/* help.c - display online help
 *
 * $Id: help.c,v 1.2 2001/10/11 13:59:00 ivarch Exp $
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include "viewfile.h"


/* View the online help for the file viewer if possible.
 */
void rf_view_help (rf_data_t data) {
  struct LDB d;
  char * tmp;
  int fd;
  static char * help = "\
\n\
                             \035CB\035Cc\035R                    \n\
                             \035CB\035Cc\035B\035R  File Viewer Help  \n\
                             \035CB\035Cc\035R                    \n\
\n\
The following keys may be pressed in the file viewer (although some may be\n\
inactive depending on file permissions):\n\
\n\
                \035CB\035Cc\035B\035R               Simple Movement               \n\
\n\
    [\035BSPACE\035b],                              [\035B-\035b], [\035BB\035b],\n\
[\035BPAGE DOWN\035b],                             [\035BPAGE UP\035b],\n\
    [\035BRIGHT\035b]: \035CCForward one screenful\035CA          [\035BLEFT\035b]: \035CCBack one screenful\n\
     [\035BDOWN\035b]: \035CCForward one line\035CA                 [\035BUP\035b]: \035CCBack one line\n\
        [\035B]\035b]: \035CCForward to next datestamp\035CA         [\035B[\035b]: \035CCBack to last datestamp\n\
\n\
        [\035BC\035b]: \035CCForward one screenful \035CY(\035B*\035b)\035CA    [\035BRETURN\035b]: \035CCForward one line \035CY(\035B*\035b)\035CA\n\
\n\
  [\035B^A\035b], [\035B0\035b],                              [\035B$\035b], [\035BZ\035b],\n\
     [\035BHOME\035b]: \035CCMove to start of file\035CA     [\035B^E\035b], [\035BEND\035b]: \035CCMove to end of file\n\
\n\
  \035CY(\035B*\035b)\035CA - exit if already at end of file\n\
\n\
                \035CB\035Cc\035B\035R       Viewer Manipulation / Searching       \n\
\n\
        [\035B/\035b]: \035CCSearch forwards\035CA                   [\035B\\\035b]: \035CCSearch backwards\n\
        [\035BI\035b]: \035CCIndex file\035CA                        [\035BG\035b]: \035CCGo to line in file\n\
\n\
                \035CB\035Cc\035B\035R                   Editing                   \n\
\n\
        [\035BA\035b]: \035CCAdd entry to file\035CA                 [\035BE\035b]: \035CCAdd using \035B$EDITOR\035b \035CY(\035BI\035b)\035CA\n\
     [\035B.\035b][\035BD\035b]: \035CCDelete entry from file\035CA         [\035B.\035b][\035BA\035b]: \035CCDirectly edit whole file\n\
        [\035BK\035b]: \035CCCopy chunk of file\035CA             [\035B.\035b][\035BE\035b]: \035CCEdit using \035B$EDITOR\035b \035CY(\035BI\035b)\035CA\n\
\n\
  \035CY(\035BI\035b)\035CA - users with shell accounts only\n\
\n\
                \035CB\035Cc\035B\035R                    Other                    \n\
\n\
       [\035B^L\035b]: \035CCRedraw the screen\035CA                 [\035BQ\035b]: \035CCExit file immediately\n\
        [\035BM\035b]: \035CCMail file to self\035CA                 [\035B?\035b]: \035CCView this help\n\
\n\
Press [\035BQ\035b] now to return to the file viewer.\n\
\n";

  if (data->flags & MENU_STATUS_BARINFO) return;

  tmp = (char *) malloc (strlen (P_tmpdir) + 32);
  if (!tmp) return;
  strcpy (tmp, P_tmpdir);
  strcat (tmp, "/mviewXXXXXX");
  fd = mkstemp (tmp);
  if (fd < 0) return;
  write (fd, help, strlen (help));
  close (fd);

  memset (&d, 0, sizeof (d));
  strcpy (d.realname, tmp);
  strcpy (d.filename, tmp);

  read_file (&d, "Help", MENU_STATUS_BARINFO | MENU_STATUS_READONLY, 0);

  remove (d.realname);
  rf_redraw = 1;

  free (tmp);
}

/* EOF */
