/* pending.c - clear pending actions
 *
 * $Id: pending.c,v 1.1.1.1 1999/12/02 20:01:17 ivarch Exp $
 */

#include "Internal.h"


/* Clear all pending actions for "vt" by doing them.
 *
 * The return value is nonzero on error.
 */
int vt100_clear_pending (vt_info vt) {
  long try;
  int r;

  if (!vt) return (-1);

  for (try = 1; try < VT_ACTION_MAX; try *= 2) {
    if (!(vt->pending & try)) continue;
    vt->pending -= try;
    r = vt100_do_action (vt, try);
    if (r < 0) return (-1);
  }

  return (0);
}

/* EOF */
