/* callback.c - functions manipulating callbacks
 *
 * $Id: callback.c,v 1.1.1.1 1999/12/02 20:00:56 ivarch Exp $
 */

#include "Internal.h"


/* Set the terminal response output function for "vt" to "func", in case it
 * needs to be changed after the terminal has been created.
 *
 * If "func" is 0, terminal response is disabled.
 *
 * Returns nonzero on error.
 */
int vt100_outcall_set (vt_info vt, vt_outcall func) {
  if (!vt) return (1);
  vt->output_function = func;
  return (0);
}


/* Set the callback function for "vt" to "func". Note that the pointer and
 * mask are not changed - use vt100_callback_{ptr,mask} to set these.
 *
 * If "func" is 0, all callbacks are disabled.
 *
 * Returns nonzero on error.
 */
int vt100_callback_set (vt_info vt, vt_callback func) {
  if (!vt) return (1);
  vt->callback_function = func;
  return (0);
}


/* Set the private pointer to be passed to "vt"'s callback function to "ptr".
 *
 * Returns nonzero on error.
 */
int vt100_callback_ptr (vt_info vt, void * ptr) {
  if (!vt) return (1);
  vt->callback_pointer = ptr;
  return (0);
}


/* Set the callback mask for "vt" to "mask". This means that the callback
 * function may be called for any of the events whose bit is set in "mask".
 *
 * For example, calling with mask = VT_ACTION_CR | VT_ACTION_LF would
 * cause the callback function to be called just before either a carriage
 * return or a linefeed is processed.
 *
 * Returns nonzero on error.
 */
int vt100_callback_mask (vt_info vt, long mask) {
  if (!vt) return (1);
  vt->callback_mask = mask;
  return (0);
}

/* EOF */
