/* menu.c - special BBS menus
 *
 * $Id: menu.c,v 1.5 2001/11/13 10:23:50 ivarch Exp $
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif	/* HAVE_CONFIG_H */
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <time.h>
#include "bbs.h"
#include "mstring.h"
#include "terminal.h"
#include "viewfile.h"
#include "hook.h"
#include "u2u.h"


extern int menuview_depth;
extern int menuview_abort;
extern int menuview_rescan_now;
extern int rf_viewing_messages;
extern int uo_idle_on;
extern char * logout_reason;

void bbs_users_on (menudata_t);
extern int mview_edit_file (char *, long, int, char *, char *);
extern int hook_check_ban (char *);
extern void examine_user (char *);

extern time_t u2u__last_checked;


/* Deal with key "key" being pressed in the [ESCAPE] menu.
 */
void bbs_special_menu (menudata_t data, menuentry_t * e, int key) {
  char buf[MENUVIEW_BUFLEN + 1];
  char action[1024];
  char keypath[64];
  struct LDB l;
  char * ptr;
  char * a;

  ptr = 0;
  action[0] = 0;
  bbs_hook (HOOK_GET_ACTION, &ptr, 0);
  if (ptr) strncpy (action, ptr, sizeof (action) - 1);

  ptr = 0;
  keypath[0] = 0;
  bbs_hook (HOOK_GET_KEYPATH, &ptr, 0);
  if (ptr) strncpy (keypath, ptr, sizeof (keypath) - 1);

  switch (key) {

    case 'G' :				/* [G] - go to main menu */
      menuview_exitup = 1;
      break;

    case 'Z' :				/* [Z] - shell out */
      strcpy (buf, data->file);
      strcpy (data->file, menuview_files[menuview_depth - 2]);
      menuview_shell (data);
      strcpy (data->file, buf);
      data->quit = MENUQUIT_QUIT;
      break;

    case 'O':				/* [O] - options menu */
      read_menu (cf_str ("options"), cf_str ("ldb"), keypath,
                 "Options", MENUFLAG_SUB | MENUFLAG_SPECIAL);
      if (menuview_exitup == 0) data->quit = MENUQUIT_QUIT;
      break;

    case 'X' :				/* [X] - exit BBS */
      logout_reason = "You have logged out.";
      menuview_exitup = 1;
      menuview_abort = 1;
      break;

    case 'U' :				/* [U] - list of users on */
      uo_idle_on = 0;
      bbs_users_on (data);
      break;

    case 'I' :				/* [I] - list of users on */
      uo_idle_on = 1;
      bbs_users_on (data);
      break;

    case 'S' :				/* [S] - send message */
      bbs_hook (HOOK_SET_ACTION, "Send Message", 0);
      bbs_hook (HOOK_SET_KEYPATH, "", 0);
      a = u2u_get_recipients ();
      if (a) {
        u2u_send_to (a);
        free (a);
      }
      if (menuview_exitup == 0) data->quit = MENUQUIT_QUIT;
      break; 

    case 'R' :				/* [R] - read messages */
      sprintf (buf, "%s/%s", cf_str ("u2u"), current_user);
      ldb_read (cf_str ("ldb"), buf, &l);
      strcpy (l.realname, buf);

      bbs_hook (HOOK_SET_ACTION, "Reading ",
                "Messages [\035BESC\035b][\035BR\035b]");
      bbs_hook (HOOK_SET_KEYPATH, "", 0);

      rf_viewing_messages = 1;
      do_read_file (&l, "Messages [\035BESC\035b][\035BR\035b]",
                    MENU_STATUS_DELETE | MENU_STATUS_BARLOG, 0);
      rf_viewing_messages = 0;

      ldb_write (cf_str ("ldb"), &l);
      u2u__last_checked = time (0) + 2;
      if (menuview_exitup == 0) data->quit = MENUQUIT_QUIT;
      break;

    case 'E' :				/* [E] - examine user */
      bbs_hook (HOOK_SET_ACTION, "Examine User", 0);
      bbs_hook (HOOK_SET_KEYPATH, "", 0);
      examine_user (0);
      break;

    case 'Y' :				/* [Y] - examine self */
      examine_user (current_user);
      break;
  }

  bbs_hook (HOOK_SET_ACTION, 0, action);
  bbs_hook (HOOK_SET_KEYPATH, keypath, 0);
}


/* Deal with key "key" being pressed in the [ESC][O] menu.
 */
void bbs_options_menu (menudata_t data, menuentry_t * e, int key) {
  char buf[MENUVIEW_BUFLEN + 1];
  FILE * fptr;
  char * a;
  int n;

  switch (key) {

    case 'N' :				/* [N] - set nameline */
      if (hook_check_ban ("N")) {
        t_goto (0, t_rows - 1);
        t_clrtoeol ();
        t_centre ("\035R  *** You are banned from "
                  "changing your nameline ***  \035r");
        sleep (2);
      } else {
        a = getenv ("MVIEW_NAMELINE");
        if (!a) a = "";
        strcpy (buf, a);
        while (t_input ("Nameline (40 chars max): ", buf, 41) == 1) ;
        buf[40] = 0;
        if (buf[0] == 0) break;
        setenv ("MVIEW_NAMELINE", buf, 1);
        udb_save ();
        menuview_rescan_now = 1;
      }
      rf_redraw = 1;
      break;

    case 'X' :				/* [X] - toggle X-rating option */
      a = getenv ("BBS_XWARN");
      if (!a) a = "0";
      setenv ("BBS_XWARN", (strcmp (a, "1") == 0) ? "0" : "1", 1);
      udb_save ();
      menuview_rescan_now = 1;
      rf_redraw = 1;
      break;

    case 'U':				/* [U] - change users-on update time */
      a = getenv ("BBS_USERS_ON_TIME");
      if (!a) a = "30";
      if (strlen (a) == 0) a = "30";
      n = atoi (a) + 5;
      if (n > 60) n -= 60;
      n -= (n % 5);
      if (n < 5) n = 5;
      sprintf (buf, "%d", n);
      setenv ("BBS_USERS_ON_TIME", buf, 1);
      udb_save ();
      menuview_rescan_now = 1;
      rf_redraw = 1;
      break;

    case 'S' :				/* [S] - toggle [SPACE] = [C] option */
      a = getenv ("BBS_SPACE_EXIT");
      if (!a) a = "0";
      setenv ("BBS_SPACE_EXIT", (strcmp (a, "1") == 0) ? "0" : "1", 1);
      udb_save ();
      menuview_rescan_now = 1;
      rf_redraw = 1;
      break;

    case 'F' :				/* [F] - edit "Friends List" */
      fptr = fopen (cf_str ("friends"), "r");
      if (!fptr) {					/* create file */
        fptr = fopen (cf_str ("friends"), "w");
        if (!fptr) return;
        fchmod (fileno (fptr), S_IRUSR | S_IWUSR | S_IRGRP | S_IWGRP);
      }
      fclose (fptr);
      mview_edit_file (cf_str ("friends"), 0, 0, "Friends List",
"The users named in this file will be highlighted in the Users On listing.\n"
"\n"
"Note that anything following a \035B#\035b on a line will be ignored.\n");
      rf_redraw = 1;
      break;

    case 'M' :				/* [M] - change new message action */
      a = getenv ("BBS_MESSAGES");
      if (!a) a = "read";
      if (!strcmp (a, "read")) a = "beep";
      else if (!strcmp (a, "beep")) a = "ignore";
      else a = "read";
      setenv ("BBS_MESSAGES", a, 1);
      udb_save ();
      menuview_rescan_now = 1;
      rf_redraw = 1;
      break;

    case 'C' :				/* [C] - change colour options */
      a = getenv ("BBS_COLOUR");
      if (!a) a = "1";
      if (!strcmp (a, "1")) a = "0";
      else a = "1";
      setenv ("BBS_COLOUR", a, 1);
      if (!strcmp (a, "1")) {
        mstrtoansi_colours (1);
      } else {
        mstrtoansi_colours (0);
      }
      udb_save ();
      menuview_rescan_now = 1;
      rf_redraw = 1;
      break;
  }
}

/* EOF */
