/* menu.c - deal with unknown entry types in a menu
 *
 * $Id: menu.c,v 1.1.1.1 1999/12/02 20:00:14 ivarch Exp $
 */

#include <string.h>
#include "viewmenu.h"
#include "terminal.h"
#include "bbs.h"


/* Deal with an unknown entry type being activated - entry "e".
 */
void hook_menu_action (menudata_t data, menuentry_t * e) {

  if (!strcmp (data->file, cf_str ("special"))) {	/* [ESC] menu */
    bbs_special_menu (data, e, e->key);
    return;
  }

  if (!strcmp (data->file, cf_str ("options"))) {	/* [ESC][O] menu */
    bbs_options_menu (data, e, e->key);
    return;
  }
}


/* Deal with an entry of type "Bin" being activated.
 *
 * Currently does nothing, since this menu entry type is not supported.
 */
void hook_menu_bin (menudata_t data, menuentry_t * e) {
}

/* EOF */
