program DirDump;
uses
  Types,
  ApiInt,
  TParam,
  TFileIO,
  TOSInt,
  Bits;

type
  PDirListing      = ^TDirListing;
  TDirListing      = object
    Language       : Char;
    AreaCode       : string;
    ListPath       : string;

    constructor Init;
    destructor Done;

    procedure ReadParams;
    procedure CreateList;
  end;

var
  DirListing       : PDirListing;

constructor TDirListing.Init;
begin
  dllInit( '', 0 );
end; { contructor Init }

destructor TDirListing.Done;
begin
end; { destructor Done }

procedure TDirListing.ReadParams;
begin
  if Par^.SwAct['L'] then
    case UpCh( Par^.SwStr['L', 1] ) of
      'A': Language := 'A';
      'E': Language := 'E';
    else
      Language := 'E';
    end
  else Language := 'E';

  if Par^.SwAct['A'] then AreaCode := Par^.SwStr['A']
  else AreaCode := 'MAIN';

  ListPath := Par^.Str[1];
end; { procedure ReadParams }

procedure TDirListing.CreateList;
var
  AreaRec          : Area_Config_Record;
  DirRec           : Area_Directory_Record;
  FileRec          : TFileRec;
  DPos             : LongInt;
  FPos             : LongInt;
  ListF            : TFile;
  fDate            : string[6];
  fSize            : string[4];
  dCount           : string[3];
  TInt             : LongInt;
  CurLine          : string;
  FirstLine        : Boolean;
  WL               : Byte;
  TotalFiles       : LongInt;
  TotalSize        : LongInt;
  DirFiles         : LongInt;
  DirSize          : LongInt;

begin
  fioFindAreaCode( AreaRec, AreaCode, 0 );

  with ListF do
  begin
    Assign( ListPath,
            fmWriteOnly or fmExclusive,
            1,
            faNormalAccess,
            ftMaxTimeout );
    ReWrite;

    TotalFiles := 0;
    TotalSize := 0;
    DPos := 0;
    while fioReadDirCfg( DirRec, AreaRec, DPos ) do
    begin
      Inc( DPos );

      Writeln( DirRec.DirName );
      WriteTextln( 'Directory of ' + DirRec.DirName + ' in ' + AreaRec.AreaName + ' ...' );
      WriteTextln( '' );
      WriteTextln( '    File name     Size  Date  Dls Min               Description' );
      WriteTextln( '      ' );

      DirFiles := 0;
      DirSize := 0;
      FPos := DirRec.FirstRec;
      while fioReadFileRec( FileRec, AreaRec, FPos ) do
      begin
        OS^.Sleep( 2 );
        Inc( FPos );
        if ( KilledFile in FileRec.FileFlags ) then Continue;
        if not ( FileRec.DirNo = DirRec.DirNo ) then
        begin
          if ( FPos < DirRec.NextRec ) then FPos := DirRec.NextRec;
          Continue;
        end;

        FirstLine := TRUE;
        with FileRec do
        begin
          repeat
            if ( Length( Description ) > 40 ) then
            begin
              CurLine := Copy( Description, 1, 41 );
              for WL := 41 downto 1 do
                if ( CurLine[WL] in [' ', '-'] ) then
                begin
                  if ( WL  = 41 ) then
                  begin
                    Delete( CurLine, 41, 1 );
                    Delete( Description, 1, 41 );
                  end
                  else
                  begin
                    Delete( CurLine, WL, 42 - WL );
                    Delete( Description, 1, WL );
                  end;
                  Break;
                end;

              if ( WL = 1 ) then
              begin
                Delete( CurLine, 41, 1 );
                Delete( Description, 1, 40 );
              end;
            end
            else
            begin
              CurLine := Description;
              Description := '';
            end;

            if FirstLine then
            begin
              with FileRec.Date.Date do
                fDate := I2S( Day, 2 ) +
                         I2S( Month, 2 ) +
                         I2S( Year - 1900, 2 );

              if ( FileRec.Size < 1000 ) then fSize := I2S( FileRec.Size, 0 ) + 'B'
              else
              begin
                TInt := FileRec.Size div 1024;
                if TInt < 10000 then fSize := I2S( TInt, 0 )
                else fSize := I2S( TInt Div 1024, 0 ) + 'M';
              end;
              fSize := PreFill( fSize, 4, ' ' );

              if ( FileRec.Downloads < 1000 ) then dCount := I2S( FileRec.Downloads, 0 )
              else dCount := '999';
              dCount := PreFill( dCount, 3, ' ' );

              CurLine := ' ' + Fill( FileRec.FileName, 16, ' ' ) +
                         ' ' + fSize +
                         ' ' + fDate +
                         ' ' + dCount +
                         ' n/a ' + CurLine;
              FirstLine := FALSE;
            end
            else CurLine := Fill( '', 38, ' ' ) + CurLine;

            WriteTextln( CurLine );
          until ( Description = '' );

          Inc( TotalFiles );
          Inc( DirFiles );
          Inc( TotalSize, Size div 1024 );
          Inc( DirSize, Size div 1024 );
        end;
      end;

      WriteTextln ( Fill( '', 32, ' ' ) +
                    PreFill( I2S( DirFiles, 254 ), 13, ' ' ) + ' file(s)  ' +
                    PreFill( I2S( DirSize, 254 ), 13, ' ' ) + ' KByte(s)' );
      WriteTextln ( '' );
    end;

    WriteTextln ( Fill( '', 32, ' ' ) +
                  PreFill( I2S( TotalFiles, 254 ), 13, ' ' ) + ' file(s)  ' +
                  PreFill( I2S( TotalSize, 254 ), 13, ' ' ) + ' KByte(s)' );

    Close;
  end;
end; { procedure CreateList }

begin
  Writeln;
  Writeln( 'DirDump v1.01 - Generate AscII file listing from FOSS system files' );
  Writeln;

  if not ( Par^.Count = 1 ) then
  begin
    Writeln( 'Usage:' );
    Writeln( '   DIRDUMP {-L[E|N] {-A[area]} [listpath]' );
    Writeln;
    Writeln( '   -L           Requested file list language (English or Norwegian)' );
    Writeln( '                (Default: English)' );
    Writeln( '   -A           Area code of area to collect info from' );
    Writeln( '                (Default: MAIN)' );
    Writeln( '   listpath     Path of file to write file list into' );
    Exit;
  end;

  New( DirListing, Init );
  DirListing^.ReadParams;
  DirListing^.CreateList;
  Dispose( DirListing, Done );
end.
