import threading
import socket
import time
import os
import sys
import Global

def CuteDuration(Seconds):
    if Seconds<1:
        return "<1 second"
    if Seconds<60:
        return "%d seconds"%Seconds
    Minutes = Seconds / 60
    Seconds = Seconds % 60
    if Minutes<60:
        return "%d minutes"%(Minutes)
    Hours = Minutes/60
    Minutes = Minutes%60
    if Hours<24:
        return "%d hours"%Hours
    return "%d days"%(Hours/24)

class SocketReaderThread(threading.Thread):
    "Socket reader thread - for non-blocking i/o"
    def __init__(self, Socket, **kw):
        threading.Thread.__init__(self,**kw)
        self.Socket = Socket
        self.Socket.setblocking(0)
        self.Text = ""
        self.KeepRunning = 1
        self.StringLock = threading.Lock()
        self.setDaemon(1)
    def run(self):
        "* Subthread function"
        print "Socket thread activated.  You can count on me, boss."
        while (1):
            time.sleep(0.1)
            try:
                Str = self.Socket.recv(2048)
            except:
                Str = ""
                
            if Str:
                self.StringLock.acquire()
                self.Text = self.Text + Str
                self.StringLock.release()
            if not self.KeepRunning:
                del self.StringLock
                break
    def GetText(self):
        self.StringLock.acquire()
        Str = self.Text
        self.Text = ""
        self.StringLock.release()
        return Str
    def Kill(self):
        self.KeepRunning = 0
        
class FileReaderThread(threading.Thread):
    "File reader thread - for non-blocking i/o"
    def __init__(self, File, **kw):
        threading.Thread.__init__(self,**kw)
        self.File = File
        self.Text = ""
        self.StringLock = threading.Lock()
        self.setDaemon(1)
        self.KeepRunning = 1
    def run(self):
        "* Subthread function"
        print "File thread activated.  You can count on me, boss."
        while (1):
            Str = self.File.read(1)
            if Str:
                self.StringLock.acquire()
                self.Text = self.Text + Str
                self.StringLock.release()
            else:
                time.sleep(0.1)
            if not self.KeepRunning:
                del self.StringLock
                break
    def GetText(self):
        self.StringLock.acquire()
        Str = self.Text
        self.Text = ""
        self.StringLock.release()
        return Str

    def Kill(self):
        self.KeepRunning = 0

class Watcher:
    "Hack - trying to get COM redirection to end the process when game is over!"
    def __init__(self, PID):
        #Log("Watcher created for %s"%PID)
        self.PID = PID
    def Watch(self):
        self.Thread = threading.Thread(None, target=self.Main)
        self.Thread.setDaemon(1)
        self.Thread.start()
        self.Alive = 1
    def Main(self):
        #Log("Waiting on %s"%self.PID)
        os.waitpid(self.PID, 0)
        #Log("Our wait is complete.")
        self.Alive = 0


def Log(Text):
    Global.SysLog.write(str(Text) + "\n")
    Global.SysLog.flush()

def GetXMLText(Node):
    rc = ""
    for SubNode in Node.childNodes:
        if SubNode.nodeType == SubNode.TEXT_NODE:
            rc = rc + SubNode.data
    return rc


