import traceback
import os
import sys
from Utils import *
class PipeRunner:
    def __init__(self, Session, Door):
        self.Session = Session
        self.Door = Door
        self.ReaderThread = None
        self.GameStdin = None
        self.GameStdout = None
        self.GameStderr = None
    def EndGameSession(self):
        if self.ReaderThread:
            print "Kill reader thread:"
            self.ReaderThread.Kill()
            print "Killed reader thread:"
            self.ReaderThread = None
        if self.GameStdin:
            print "Close stdin:"
            self.GameStdin.close()
            self.GameStdin = None
            print "Closed stdin:"
        if self.GameStdout:
            print "Close stdout:"
            self.GameStdout.close()
            self.GameStdout = None
            print "Closed stdout:"
        if self.GameStderr:
            print "Close stderr:"
            self.GameStderr.close()
            self.GameStderr = None
            print "Closed sterr:"
        print "EGS complete."
    def Run(self):
        # Start the process:
        Command = self.Door.GetCommand()
        try:
            (self.GameStdin, self.GameStdout, self.GameStderr) = os.popen3(Command)
            self.ReaderThread = FileReaderThread(self.GameStdout)
            self.ReaderThread.start()                
        except:
            #LogError()
            traceback.print_exc()
            self.EndGameSession()
            self.Session.DoorFailed = 1
            return
        # Keep shunting bits between the Session socket and the stdin/stdout of the process:
        self.AccumText = ""
        while (1):
            Idle = 1
            try:
                Text = self.Session.request.recv(1)
            except:
                Text = ""
            if Text and len(Text):
                Idle = 0
                self.AccumText += Text
                Pos = self.AccumText.find("\n")
                if Pos!=-1:
                    try:
                        self.GameStdin.write(self.AccumText[:Pos+1])
                        self.GameStdin.flush()
                    except:
                        # The child process is dead:
                        Log("(Pipe process is dead; exit)")
                        break
                    self.AccumText = self.AccumText[Pos+1:]
            Output = self.ReaderThread.GetText()
            if Output:
                Idle = 0
                self.Session.request.send(Output)
            if Idle:
                time.sleep(0.1)
        self.EndGameSession()
        
