/***************************************************************************
 *   Copyright (C) 2004-2009 by Michael Griffin                            *
 *   mrmisticismo@hotmail.com                                              *
 *                                                                         *
 *   Purpose:                                                              *
 *                                                                         *
 *                                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

// Enthral SVN: $Id: user_list.cpp 118 2009-08-07 04:34:35Z frank $
// Source: $HeadURL: http://svn.enthralbbs.com/trunk/src/user_list.cpp $
// $LastChangedDate: 2009-08-07 00:34:35 -0400 (Fri, 07 Aug 2009) $
// $LastChangedRevision: 118 $
// $LastChangedBy: frank $

/*

Start Initial User List Classes
Working on Setup so we can do a user list before sending email
and also for the user listing itself,, can select a user and view their info. :)

*/

# include <stdio.h>
# include <time.h>
# include <ctype.h>
# include <fstream>
# include <string>

# include <cstring>
# include <cstdlib>

# include "struct.h"
# include "language.h"
# include "user_list.h"
# include "menu_func.h"
# include "dtfunc.h"
# include "users.h"

using namespace std;

bool usrlist_ini::usrl_exists() {

    iTop = 0;
    iBot = 0;

    strcpy(sPAGENUM,"");
    strcpy(sPAGETOTAL,"");
    strcpy(sMOREUP,"");
    strcpy(sMOREUP_CHAR,"");
    strcpy(sMOREDOWN,"");
    strcpy(sMOREDOWN_CHAR,"");
    strcpy(sMOREMSG_ON,"");
    strcpy(sMOREMSG_WORD_ON,"");
    strcpy(sMOREMSG_OFF,"");
    strcpy(sMOREMSG_WORD_OFF,"");
    strcpy(sINPUT_BOX,"");
    strcpy(sTEXT_COLOR,"");
    strcpy(sTEXT_HILIGHT,"");
    strcpy(sMAX_AREAS,"");
    strcpy(sANSI_FILE,"");
    strcpy(sANSI_HELP,"");
    strcpy(sTHEME_NAME,"");
    strcpy(sMENU_PROMPT,"");
    strcpy(sMENU_PROMPT2,"");

    std::string path = INIPATH;
    path += sININAME;

    FILE *stream;
    stream = fopen(path.c_str(),"rb+");
    if(stream == NULL) {
        perror("Error unable to read userlst.ini, check permissions!");
        return false; }
    fclose(stream);
    return true;
}

void usrlist_ini::usrl_create() {

    std::string name = INIPATH;
    name += sININAME;

    ofstream outStream2;
    outStream2.open( name.c_str(), ofstream::out | ofstream::trunc );
    if (!outStream2.is_open()) {
        printf( "\nError Creating: %s \n", name.c_str());
        return;
    }

    outStream2 << " * Generated By Program. " << endl;
    outStream2.close();
    return;
}

void usrlist_ini::usrl_chkpar(std::string &data) {

    std::string temp1;
    int st1 = -1;
    int st2 = -1;
    signed int  ct = -1;

    st1 = data.find('"', 0);
    st2 = data.find('"', st1+1);
    ++st1;
    temp1 = data.substr(st1,st2);
    ct = st2 - st1;
    if (temp1.length() > ct)
        temp1.erase(ct,temp1.length());
    data = temp1;
}

void usrlist_ini::usrl_check(std::string cfgdata) {

    int id1 = 0;
    std::string temp = cfgdata;
    if (temp[0] == '#') return;
    else
    if (temp.find("set TOP ", 0) != std::string::npos) {
        usrl_chkpar(temp);
        id1 = atoi(temp.c_str());
        iTop = id1;
    }
    else
    if (temp.find("set BOT ", 0) != std::string::npos) {
        usrl_chkpar(temp);
        id1 = atoi(temp.c_str());
        iBot = id1;
    }
    else
    if (temp.find("set THEME_NAME ", 0) != std::string::npos) {
        usrl_chkpar(temp);
        strcpy(sTHEME_NAME,(char *)temp.c_str());
    }
    else
    if (temp.find("set ANSI_FILE ", 0) != std::string::npos) {
        usrl_chkpar(temp);
        strcpy(sANSI_FILE,(char *)temp.c_str());
    }
    else
    if (temp.find("set ANSI_HELP ", 0) != std::string::npos) {
        usrl_chkpar(temp);
        strcpy(sANSI_HELP,(char *)temp.c_str());
    }
    else
    if (temp.find("set MENU_PROMPT ", 0) != std::string::npos) {
        usrl_chkpar(temp);
        strcpy(sMENU_PROMPT,(char *)temp.c_str());
    }
    else
    if (temp.find("set MENU_PROMPT2 ", 0) != std::string::npos) {
        usrl_chkpar(temp);
        strcpy(sMENU_PROMPT2,(char *)temp.c_str());
    }
    else
    if (temp.find("set PAGENUM ", 0) != std::string::npos) {
        usrl_chkpar(temp);
        strcpy(sPAGENUM,(char *)temp.c_str());
    }
    else
    if (temp.find("set PAGETOTAL ", 0) != std::string::npos) {
        usrl_chkpar(temp);
        strcpy(sPAGETOTAL,(char *)temp.c_str());
    }
    else
    if (temp.find("set MOREUP ", 0) != std::string::npos) {
        usrl_chkpar(temp);
        strcpy(sMOREUP,(char *)temp.c_str());
    }
    else
    if (temp.find("set MOREUP_CHAR ", 0) != std::string::npos) {
        usrl_chkpar(temp);
        strcpy(sMOREUP_CHAR,(char *)temp.c_str());
    }
    else
    if (temp.find("set MOREDOWN ", 0) != std::string::npos) {
        usrl_chkpar(temp);
        strcpy(sMOREDOWN,(char *)temp.c_str());
    }
    else
    if (temp.find("set MOREDOWN_CHAR ", 0) != std::string::npos) {
        usrl_chkpar(temp);
        strcpy(sMOREDOWN_CHAR,(char *)temp.c_str());
    }
    else
    if (temp.find("set MOREMSG_ON ", 0) != std::string::npos) {
        usrl_chkpar(temp);
        strcpy(sMOREMSG_ON,(char *)temp.c_str());
    }
    else
    if (temp.find("set MOREMSG_WORD_ON ", 0) != std::string::npos) {
        usrl_chkpar(temp);
        strcpy(sMOREMSG_WORD_ON,(char *)temp.c_str());
    }
    else
    if (temp.find("set MOREMSG_OFF ", 0) != std::string::npos) {
        usrl_chkpar(temp);
        strcpy(sMOREMSG_OFF,(char *)temp.c_str());
    }
    else
    if (temp.find("set MOREMSG_WORD_OFF ", 0) != std::string::npos) {
        usrl_chkpar(temp);
        strcpy(sMOREMSG_WORD_OFF,(char *)temp.c_str());
    }
    else
    if (temp.find("set INPUT_BOX ", 0) != std::string::npos) {
        usrl_chkpar(temp);
        strcpy(sINPUT_BOX,(char *)temp.c_str());
    }
    else
    if (temp.find("set TEXT_COLOR ", 0) != std::string::npos) {
        usrl_chkpar(temp);
        strcpy(sTEXT_COLOR,(char *)temp.c_str());
    }
    else
    if (temp.find("set MAX_AREAS ", 0) != std::string::npos) {
        usrl_chkpar(temp);
        strcpy(sMAX_AREAS,(char *)temp.c_str());
    }
}

int usrlist_ini::usrl_parse(int idx) {

    if (!usrl_exists()) {
        perror("Error unable to parse userlst.ini, check permissions!");
    }
        //usrl_create();

    char name[255]={0};
    char name2[255]={0};

    sprintf(name,"%s%s",INIPATH,sININAME);
    sprintf(name2,"%s%s%i.ini",INIPATH,sININAME,idx);

    if (idx != 0) strcpy(name,name2);

    // Check if Theme Exists, if not return FALSE.
    FILE *stream;
    stream = fopen(name,"rb+");
    if(stream == NULL) { // File is not Present
        return FALSE;
    }
    fclose(stream);


    ifstream inStream;
    inStream.open( name );
    if (!inStream.is_open()) {
        printf("Couldn't Open Config File: %s\n", name);
        return FALSE;
    }

    std::string cfgdata;
    for (;;) {
        std::getline(inStream,cfgdata,'\n');
        usrl_check(cfgdata);
        if(inStream.eof()) break;
    }
    inStream.close();
    return TRUE;
}

usr_list::usr_list() {

    tTop          = 1;
    tBot          = 1;
    CURRENT_ULIST = 0;
}

void usr_list::ParseHeader(char *filename) {

    std::string temp;
    std::string path = ANSIPATH;
    path += filename;
    path += ".ans";

    mb_list_rec mr;

    char MCI[3]     = {0};   // Holds MCI Codes to Parse
    char sTemp[255] = {0};
    int  space = 0, foundr = 0 , foundl = 0;
//    int  c = 0;
    std::string buff;

    // Reads in Ansi file into Buffer Only
    readinAnsi(filename, buff);


/* NOTE
MAKE THIS THE USERLIST!!!
*/
//    read_mbaselist(&mr, thisuser->lastmbarea);

    int id1 = 0;
    while (id1 != -1) {
        // parse justify spacing right / left passing in string before
        // replacing mci code. to Properly Space Output Ansi.
        id1 = buff.find("%", 0);
        if (id1 == -1) break;
        memset(&MCI,0,sizeof(MCI));
        space = 0;
        // Check if MCI Code is Justified then Process this.
        if (buff[id1+3] == '{') { // Left Justify
            //elog("left justify: %c%c",buff[id1+4],buff[id1+5]);
            MCI[0] = buff[id1+4]; // Get first Digit
            MCI[1] = buff[id1+5]; // Get Second Digit
            space  = atoi(MCI);
            foundr = FALSE;
            foundl = TRUE;
        }
        else
        if (buff[id1+3] == '}') { // Right Justify
            //elog("right justify: %c%c",buff[id1+4],buff[id1+5]);
            MCI[0] = buff[id1+4]; // Get first Digit
            MCI[1] = buff[id1+5]; // Get Second Digit
            space  = atoi(MCI);
            //elog("right justify: %i",space);
            foundl = FALSE;
            foundr = TRUE;
        }
        // Now Get MCI Code
        MCI[0] = buff[id1+1]; // Get first Digit
        MCI[1] = buff[id1+2]; // Get Second Digit

        memset(&sTemp,0,sizeof(sTemp));
        // Insert MCI Parsing here so we can reaplace full result with propering spacing.
    if (strcmp(MCI,"MA") == 0)  { temp += mr.mbdisplay; }
            else
            if (strcmp(MCI,"TH") == 0)  { temp += sTHEME_NAME; }


        if (strcmp(MCI,"MA") == 0)    {
            sprintf(sTemp,"%s", (char *)mr.mbdisplay); }
        else
        if (strcmp(MCI,"TH") == 0) {
            sprintf(sTemp,"%s", (char *)sTHEME_NAME); }

/*
        if (strcmp(MCI,"TH") == 0) {
            sprintf(sTemp,"#%i. %s",thisuser->readertheme+1,sTHEME_NAME); }
*/

        // MCI Translation .
        if (foundl == TRUE) {
            lspacing(sTemp,space);
        }
        else
        if (foundr == TRUE) {
           rspacing(sTemp,space);
        }

        //If we Parsed Justify, then Erase that MCI Code as well.
        (space != 0) ?
            buff.replace(id1,6,sTemp):
            buff.replace(id1,3,sTemp);
    }
    //elog("Finished Parsing MCI Codes...");
    pipe2ansi((char *)buff.c_str());
}

void usr_list::SetupList(UserRec *user) {

    sprintf(sININAME,"%s",(char *)"usrlist.ini");
    thisuser = user;
    // Check What Theme user has selected.
    if (usrl_parse(thisuser->readertheme) == FALSE) {
        usrl_parse();
    }
    tTop = iTop;
    tBot = iBot;
}

void usr_list::SetupEmailList(UserRec *user) {

    sprintf(sININAME,"%s",(char *)"eusrlist.ini");
    thisuser = user;
    // Check What Theme user has selected.
    if (usrl_parse(thisuser->readertheme) == FALSE) {
        usrl_parse();
    }
    tTop = iTop;
    tBot = iBot;
}

int usr_list::change_theme(int idx) {

    // Check What Theme user has selected.
    if (usrl_parse(idx) == FALSE) {
        // Theme Doesn't Exist.
        return FALSE;
    }
    thisuser->readertheme = idx;

    // Save User Settings.
    UserRec usr;
    usr = *thisuser;
    users _usr;
    _usr.users_write(&usr,usr.idx);

    tTop = iTop;
    tBot = iBot;
    mLink.Top = tTop;
    mLink.Bot = tBot;
    return TRUE;
}

void usr_list::UserList(std::string &tmp) {
// Message Area Listing - Add Later into Normal MCI Code Parsing!!!
//void msgs::ParseMArea(UserRec *usr, std::string &temp) {

    SESSION       s(thisuser); // Pass User Incase there are MCI Codes for User Info.

    int c = 0;
    std::string path  = "";
    std::string temp3 = "";

    FILE *inStream;
    int  idx;

    int  i   = 0;
    int  basenum = 0;

    char MCI[3]={0};
    char temp2[100]={0};
    int  space  = 0;
    int  foundr = FALSE;
    int  foundl = FALSE;

    std::string ans  = "";
    std::string ans1 = "";
    std::string ans2 = "";
    std::string ans3 = "";
    std::string ans4 = "";

    // Prefetch ansi's
    path = ANSIPATH;
    path += "ulistmid1.ans";
    if ((inStream = fopen(path.c_str(), "r+")) ==  NULL) {
        return;
    }
    while (c != EOF) {
        c = getc(inStream);
        if (c != EOF) ans1 += c;
    }
    fclose(inStream);
    c = '\0';
    path = ANSIPATH;
    path += "ulistmid2.ans";
    if ((inStream = fopen(path.c_str(), "r+")) ==  NULL) {
        return;
    }
    while (c != EOF) {
        c = getc(inStream);
        if (c != EOF) ans2 += c;
    }
    fclose(inStream);
    c = '\0';
    path = ANSIPATH;
    path += "ulistmid3.ans";
    if ((inStream = fopen(path.c_str(), "r+")) ==  NULL) {
        return;
    }
    while (c != EOF) {
        c = getc(inStream);
        if (c != EOF) ans3 += c;
    }
    fclose(inStream);
    c = '\0';
    path = ANSIPATH;
    path += "ulistmid4.ans";
    if ((inStream = fopen(path.c_str(), "r+")) ==  NULL) {
        return;
    }
    while (c != EOF) {
        c = getc(inStream);
        if (c != EOF) ans4 += c;
    }
    fclose(inStream);

    users   _usr; // Class
    UserRec urec;


    basenum = _usr.idx_count();


    idx = 0;
    while(_usr.users_read(&urec,idx)) {

        //printf("\n\nbase %i, idx %i, urec.handle %s",basenum, idx,urec.handle);

        //if (idx > basenum) break;     /// BUG SHOULD NOT NEED!!!!!
        ++idx;
        temp3.erase();

        if (CURRENT_ULIST == idx-1)
            ans = ans2; // Display HighLight None.
        else
            ans = ans1; // Dispaly Normal None

        i = 0;
        c = 0;
        do {
            memset(&MCI,0,sizeof(MCI));
            c = ans[i];
            if (c == '\0') break;

            // Check for Spacing MCI Code
            switch (c) {
              case '{' : // Left Justify
                MCI[0] = ans[++i];
                MCI[1] = ans[++i];
                space = atoi(MCI);

                if (space != 0) {
                    foundl = TRUE;
                }
                else {
                    temp3 += c;
                    temp3 += MCI;
                }
                break;

              case '}' : // Right Justify
                MCI[0] = ans[++i];
                MCI[1] = ans[++i];
                space = atoi(MCI);

                if (space != 0) {
                    foundr = TRUE;
                }
                else {
                    temp3 += c;
                    temp3 += MCI;
                }
                break;

              case '|' : // Pipe Codes
                MCI[0] = ans[++i];
                MCI[1] = ans[++i];
                if (strcmp(MCI,"U#") == 0) {
                    sprintf(temp2,"%i",idx);
                    if (foundl) {
                        s.lspacing(temp2,space);
                        foundl = FALSE;
                    }
                    else if (foundr) {
                        s.rspacing(temp2,space);
                        foundr = FALSE;
                    }
                    temp3 += temp2;
                }
                else if (strcmp(MCI,"UN") == 0) {
                    sprintf(temp2,"%s",urec.handle);
                    if (foundl) {
                        s.lspacing(temp2,space);
                        foundl = FALSE;
                    }
                    else if (foundr) {
                        s.rspacing(temp2,space);
                        foundr = FALSE;
                    }
                    temp3 += temp2;
                }
                else if (strcmp(MCI,"NO") == 0) {
                    sprintf(temp2,"%s",urec.usernote);
                    if (foundl) {
                        s.lspacing(temp2,space);
                        foundl = FALSE;
                    }
                    else if (foundr) {
                        s.rspacing(temp2,space);
                        foundr = FALSE;
                    }
                    temp3 += temp2;
                }
                else if (strcmp(MCI,"LO") == 0) {
                    sprintf(temp2,"%s",Sec2Date(urec.dtlaston));
                    if (foundl) {
                        s.lspacing(temp2,space);
                        foundl = FALSE;
                    }
                    else if (foundr) {
                        s.rspacing(temp2,space);
                        foundr = FALSE;
                    }
                    temp3 += temp2;
                }
                else {
                    temp3 += c;
                    temp3 += MCI;
                }
                break;

              case '\n' :
                  temp3 += '\r';
                break;

              default :
                temp3 += c;
                break;
            }
            ++i;
        }
        while (c != '\0');

        temp3 += "\r";
        tmp += temp3;
        temp3.erase();
    }

}



//char *usr_list::StartList(char *OrgMsg) {
int usr_list::StartList(int email) {

    /// Difference Between Area List and Users,
    /// Areas is 1 Based, Users = 0 Based!.

    bool more        = FALSE;
    bool showmore    = FALSE;
    char mString[10] = {0};
    unsigned char ch;
    std::string _output;
    char outBuffer[1024]={0};

    // Startup Friend Classes
    // language    _lang;
    menu_func   _mnuf;
    msg_readll  mLink;

    _mnuf.menu_setuser(thisuser);

    mLink.initList(sTEXT_COLOR, TRUE);

    mLink.Top = tTop;
    mLink.Bot = tBot;

    // Mainly for Text Selection.
    char rBuffer[100]={0};
    char text[100]={0};
    char sNum[3]={0};
    std::string rBuff;
    int id1; //id2,
    int num, num2;
    int len;

    std::string tmp;

    // For Next / Prev Message Areas
    int CurrentPage;
    int bSize;
    bSize = tBot - tTop;
    ++bSize;

    int Page;
    int Tot;
    int TotPages;

    CURRENT_ULIST = 0;

    // Run through Main Reader Loop until exit from user - This Loop Probably not needed anymore.
    while (1) {

        if (email == TRUE) {
            ParseHeader(sANSI_FILE); // Display Ansi
        }
        else {
            ParseHeader((char *)"ulist");    // UserList
        }

        tmp.erase();
        UserList(tmp);

        mLink.PutBuffer((char *)tmp.c_str(), FALSE);   // Send the Original Message into list Buffer
        mLink.box_start(CURRENT_ULIST);                // Draw Message Inside of Box

        //printf("\n0. CURRENT_ULIST %i, mLink.Tot %i, mLink.Page %i, mLink.TotPages %i", CURRENT_ULIST,mLink.Tot, mLink.Page,mLink.TotPages);

        mLink.Tot = mLink.line_total();

        while(1) {

            // Show Current/Total Pages
            if (mLink.Page == 0)
                mLink.Page = 1;

            if (mLink.TotPages == 0)
                mLink.TotPages = 1;

            _output.clear();

            more = FALSE;
            showmore = FALSE;
            //if (mLink.line_count() > 0) more = true;
            //if (mLink.Page < mLink.TotPages) more = TRUE;
            if (mLink.Page != mLink.TotPages) more = TRUE;

            // Show Down Arrow More!
            if (more == TRUE) {
                sprintf(outBuffer,"%s\x19",sMOREDOWN);  // On
                showmore = TRUE;
            }
            else {
                sprintf(outBuffer,"%s ",sMOREDOWN);     // Off
            }
            _output += outBuffer;

            // Show up Arrow More
            if (mLink.Page > 1) {
                sprintf(outBuffer,"%s\x18",sMOREUP);
                showmore = TRUE;
            }
            else {
                sprintf(outBuffer,"%s ",sMOREUP);
            }
            _output += outBuffer;

            if (showmore)
                sprintf(outBuffer,"%s%s",sMOREMSG_ON,sMOREMSG_WORD_ON);
            else
                sprintf(outBuffer,"%s%s",sMOREMSG_OFF,sMOREMSG_WORD_OFF);
            _output += outBuffer;


            sprintf(outBuffer,"%s%.2d",sPAGENUM,mLink.Page);
            _output += outBuffer;
            sprintf(outBuffer,"%s%.2d",sPAGETOTAL,mLink.TotPages);
            _output += outBuffer;

            // # of Message Areas
            sprintf(outBuffer,"%s%d",sMAX_AREAS,mLink.Tot);
            _output += outBuffer;

            // Draw Input Box
            memset(&text,0, sizeof(text));
            strcpy(text,sINPUT_BOX);
            len = 14;
            inputfield(text,len);
            _output += text;

            pipe2ansi((char *)_output.c_str());

            // Blank out the previous menu so we can reload, / redraw on restart.
            //memset(&_mnuf._premenu,0,sizeof(_mnuf._premenu));

            // Make Msgqp2 Prompt Optional, Use if exists!
            // Also Let user Toggle on / off
            if (_mnuf.cmdexist(sMENU_PROMPT2,0) /*&& thisuser->msgp2*/ ) {
                if ((more == TRUE) ||(mLink.Page > 1)) {
                    _mnuf._curmenu.clear();
                    _mnuf._curmenu = sMENU_PROMPT2;
                }
                else {
                    _mnuf._curmenu.clear();
                    _mnuf._curmenu = sMENU_PROMPT;
                }
            }
            else {
                _mnuf._curmenu.clear();
                _mnuf._curmenu = sMENU_PROMPT;
            }

            // Readin the Menu Prompt and get or wait for input.
            _mnuf.menu_readin();
            _mnuf.menu_proc(mString);
            ch = mString[1];

            //printf("\n01. CURRENT_ULIST %i, mLink.Tot %i, mLink.Page %i, mLink.TotPages %i", CURRENT_ULIST,mLink.Tot, mLink.Page,mLink.TotPages);

            // For Menu CmdKey Input
            if (mString[0] == '!')
                switch (toupper(ch)) {

                case 'E': // Entered User Number & Done.
                    mLink.dispose_list();
                    //_mnuf.~menu_func();
                    return CURRENT_ULIST;

                case 'Q': // Quit
                    mLink.dispose_list();
                    //_mnuf.~menu_func();
                    return EOF; //qBuf;

                case 'U': // Page UP
                    mLink.box_pgup();
                    break;

                case 'D': // Page Down
                    mLink.box_pgdn();
                    break;

                case '+': // Next Area - Move Down

                    if (CURRENT_ULIST+1 != mLink.Tot)
                        ++CURRENT_ULIST;

                    //thisuser->lastmbarea = CURRENT_ULIST;
                    mLink.dispose();

                    // If In current Page only refresh screen,
                    // otherwise page down to this page!
                    for (CurrentPage = 1; CurrentPage < mLink.TotPages+1; CurrentPage++) {
                        if ((bSize*CurrentPage) >= (CURRENT_ULIST+1)+CurrentPage) {
                            mLink.Page = CurrentPage;
                            break;
                        }
                    }

                    tmp.erase();
                    //ParseMArea(&trec, tmp);
                    UserList(tmp);
                    mLink.PutBuffer((char *)tmp.c_str(), FALSE);
                    //mLink.box_refresh();
                    mLink.box_overdraw(CURRENT_ULIST);
                    mLink.Tot = mLink.line_total();
                    break;

                case '-': // Previous Area - Move Up

                    if (CURRENT_ULIST != 0)
                        --CURRENT_ULIST;

                    mLink.dispose();

                    if (mLink.pgRows > 0) { // Scrolling Down. creap back up.

                        if (mLink.Tot-mLink.pgRows < (CURRENT_ULIST+1)) {
                            mLink.Page = CurrentPage;
                        }
                        else {
                        /// We've move 1 page below now. continue.
                            mLink.pgRows = 0;
                            // We have to move proper...
                            for (CurrentPage = 1; CurrentPage < mLink.TotPages+1; CurrentPage++) {
                                if ((bSize*CurrentPage) >= (CURRENT_ULIST+1)+CurrentPage) {
                                    mLink.Page = CurrentPage;
                                    break;
                                }
                            }
                            //break;
                        }

                    }
                    else {  // Good Working Up and Down
                        /// not on Last Page, page down like normal
                        for (CurrentPage = 1; CurrentPage < mLink.TotPages+1; CurrentPage++) {
                            if ((bSize*CurrentPage) >= (CURRENT_ULIST+1)+CurrentPage) {
                                mLink.Page = CurrentPage;
                                break;
                            }
                        }
                    }

                    tmp.erase();

                    UserList(tmp);
                    mLink.PutBuffer((char *)tmp.c_str(), FALSE);

                    mLink.box_overdraw(CURRENT_ULIST);
                    mLink.Tot = mLink.line_total();
                    break;
            } // end of case
            else
            if (mString[0] == '#') {
                // received Digit Input From Menu Prompt
                memset(&rBuffer,0, sizeof(rBuffer));
                memset(&text,0, sizeof(text));
                strcpy(text,sINPUT_BOX);
                len = 14;
                inputfield(text,len);
                pipe2ansi(text);
                sprintf(sNum,"%c",ch);
                getline(rBuffer,len,sNum);
                num = 0;
                num2 = 0;
                // Catch any invalid input
                id1 = atoi(rBuffer);
                if (id1 != 0) --id1;

                if (id1 > mLink.Tot || id1 < 0) {
                    // Redraw input box
                    memset(&text,0, sizeof(text));
                    strcpy(text,sINPUT_BOX);
                    len = 14;
                    inputfield(text,len);
                    pipe2ansi(text);
                    mLink.box_refresh(CURRENT_ULIST);
                }
                else {

                    CURRENT_ULIST = id1;
                    mLink.dispose();

                    if ((CURRENT_ULIST+1) <= bSize) { Page = 1; }
                    else {
                        Page = (CURRENT_ULIST+1) / bSize;
                        if ((CURRENT_ULIST+1) % bSize)
                            ++Page;
                    }

                    if (Tot <= bSize) { TotPages = 1; }
                    else {
                        Tot = mLink.line_total();
                        TotPages =  Tot / bSize;
                        if (Tot % bSize)
                            ++TotPages;
                    }

                    if (Page == TotPages) {

                        /// Scroll_Down.
                        if (mLink.Tot-mLink.pgRows < (CURRENT_ULIST+1)) {
                            mLink.Page = CurrentPage;
                        }
                        else {
                            mLink.pgRows = 0;
                            // We have to move proper...
                            for (CurrentPage = 1; CurrentPage < mLink.TotPages+1; CurrentPage++) {
                                if ((bSize*CurrentPage) >= (CURRENT_ULIST+1)+CurrentPage) {
                                    mLink.Page = CurrentPage;
                                    break;
                                }
                            }
                            //break;
                        }

                    }

                    break;
                }
            }
            else {  // For Escaped Key Input
                startpause();
                ch = mString[0];
                switch (toupper(ch)) {
                    case 'A':
                        mLink.box_pgup();
                        break;

                    case 'B':
                        mLink.box_pgdn();
                        break;

                    default :
                        // Redraw and refresh listing.
                        ParseHeader(sANSI_FILE);          // Display Ansi
                        mLink.dispose();
                        tmp.erase();
                        UserList(tmp);
                        mLink.PutBuffer((char *)tmp.c_str(), FALSE);
                        mLink.box_overdraw(CURRENT_ULIST);
                        mLink.Tot = mLink.line_total();
                        break;

                    break;
                }
            }
        }
    }
}
