

#include <stdio.h>              // C Standard I/o
#include <string>               // C++ String Library
#include <fstream>              // Files Streams C++
#include <stdlib.h>             // Program Exit() - Fix to Disconenct, Error Handling. Later

#include "mstats_struct.h"
#include "userdat.h"

using namespace std;

/*--------------------------------------------------------------------------------*/
// Globals
struct ListItem  *MYLIST  = 0 ;   // holds all user data
struct ListItem1 *MYLIST1 = 0 ;   // Sorts All Users by Top Calls / Uploads
struct ListItem2 *MYLIST2 = 0 ;   // Sorts All Users by Top Posts / Downloads
struct ListItem4 *MYLIST4 = 0 ;   // Hold ANSI for Writing out

/*--------------------------------------------------------------------------------*/
// Clears ListItem
void clearuserdata5() {

	struct ListItem *p, *next;
	if ( MYLIST == 0) {	return; }

	for(p = MYLIST ; p !=0 ; p = next ) { next = p->next; delete (p); }
	MYLIST = 0;
	return;
}


/*--------------------------------------------------------------------------------*/
// Clears ListItem1
void clearuserdata3() {

	struct ListItem1 *p, *next;
	if ( MYLIST1 == 0) { return; }

	for(p = MYLIST1 ; p !=0 ; p = next ) { next = p->next; delete (p); }
	MYLIST1 = 0;
	return;
}


/*--------------------------------------------------------------------------------*/
// Clears ListItem2
void clearuserdata4() {

	struct ListItem2 *p, *next;
	if ( MYLIST2 == 0) { return; }

	for(p = MYLIST2 ; p !=0 ; p = next ) { next = p->next; delete (p); }
	MYLIST2 = 0;
	return;
}


/*--------------------------------------------------------------------------------*/
// Clears Link List and Free's Current Memory
void clearANSI2() {

	struct ListItem4 *p, *next;
	if ( MYLIST4 == 0) { return; }

	for(p = MYLIST4 ; p !=0 ; p = next ) { next = p->next; delete (p); }
	MYLIST4 = 0;
}

/*--------------------------------------------------------------------------------*/
// LINK LISTS - Functions To Collect and Sort All Data
/*--------------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------------*/
// Stores all Data Recived into Link List w/out Sorting
void userdatacontainer2(UserRec * user) {

	struct ListItem *last;
	string data;

	// Don't Add Co's And Sysop's to Stats
	//short Sec = user->Security;
	//if (Sec > 199) { return; }

    if (user->handle == "Mercyful Fate") { return; }

	ListItem *item = new ListItem;

	if( !item )	{
		printf("\nMalloc Failed");
		exit(1);
	}

	// If it gets here, no Name Match was found, Add New Player to the Link List with Defaults
	// Creates Player And Sets Record's Defaults all to 0 in Memory.
	item->user = (*user);
	item->next = 0;

	if ( MYLIST == 0 ) { MYLIST = item;	return; }

	for( last = MYLIST ; last->next != 0 ; last = last->next );
	last->next = item;
	return;

}

/*--------------------------------------------------------------------------------*/
// This Receives Users From ListList and Sorts All Users by Calls to the BBS
void callsort(UserRec * user) {

	struct ListItem1 *next;
	string data;

	ListItem1 *item = new ListItem1;

	if( !item )	{
		printf("\nMalloc Failed");
		exit(1);
	}

	// If it gets here, no Name Match was found, Add New Weapon to the Link List with Defaults
	// Creates Weapon And Sets Record's Defaults all to 0 in Memory.
	item->user = (*user);
	item->next = 0;

	if ( MYLIST1 == 0 ) { MYLIST1 = item; return; }

	if((user->Calls - MYLIST1->user.Calls) > 0 ) {
		item->next = MYLIST1;
		MYLIST1 = item;
		return;
	}

	// Check to see if an item is inserted before the next item
	for ( next = MYLIST1 ; next->next != 0 ; next = next->next ) {
		if ((user->Calls - next->next->user.Calls) > 0 ) {
			// Insert Item before the next Item.
			item->next = next->next;
			next->next = item ;
			return;
		}
	}
	next->next = item;
	return;
}

/*--------------------------------------------------------------------------------*/
// This Receives Users From ListList and Sorts All Users by Calls to the BBS
void postsort(UserRec * user) {

	struct ListItem2 *next;
	string data;

	ListItem2 *item = new ListItem2;

	if( !item ) {
		printf("\nMalloc Failed");
		exit(1);
	}

	// If it gets here, no Name Match was found, Add New Weapon to the Link List with Defaults
	// Creates Weapon And Sets Record's Defaults all to 0 in Memory.
	item->user = (*user);
	item->next = 0;

	if ( MYLIST2 == 0 ) { MYLIST2 = item; return; }

	if((user->Posts - MYLIST2->user.Posts) > 0 ) {
		item->next = MYLIST2;
		MYLIST2 = item;
		return;
	}

	// Check to see if an item is inserted before the next item
	for ( next = MYLIST2 ; next->next != 0 ; next = next->next ) {
		if ((user->Posts - next->next->user.Posts) > 0 ) {
			  // Insert Item before the next Item.
			  item->next = next->next;
			  next->next = item ;
			  return;
		}
	}
	next->next = item;
	return;
}

/*--------------------------------------------------------------------------------*/
// Functions Reading ANSI Templates, and Parsing MCI Code and Writing Out ANSI STATS
/*--------------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------------*/
// Write out Ansi file for Top Calls / Posters
void writeANSI2() {

	std::string filename = "topstat2.ans";
	filename = PATH + "ansi/" + filename;

	struct ListItem4 *p;

	ofstream outStream3;
	outStream3.open( filename.c_str(), ofstream::out | ofstream::trunc);

	if (!outStream3.is_open()) {
		printf("\n\nError writing out topstat2.ans");
		clearANSI2();
		exit(1);
		return;
	}

	for ( p = MYLIST4 ; p != 0 ; p = p->next ) {	outStream3 << p->ansi; }

	outStream3.close();
	clearANSI2();
	return;
}

/*--------------------------------------------------------------------------------*/
// Holds all Parsed ANSI for Writting out to File
void buildANSI2(string ansi) {

	//std::string temp = ansi;

	struct ListItem4 *last;
	ListItem4 *item = new ListItem4;

	if ( !item ) {
		printf("\nMalloc Failed For Holding Parsed ANSI");
		exit(1);
		return;
	}

	//strcpy(item->ansi,temp.c_str());
    item->ansi = ansi;
	item->next = 0;

	if ( MYLIST4 == 0 ) { MYLIST4 = item; return; }

	for( last = MYLIST4 ; last->next != 0 ; last = last->next );
	last->next = item;
}


/*--------------------------------------------------------------------------------*/
// Parses MCI Codes for Top Callers / Posters
void checkMCI2(string ansidata) {

	string temp = ansidata;

	// Start String Processing Below
	int id1 = -1;

	id1 = temp.find('$', 0);
	// No MCI Code's Found, skip to next string
	if (id1 == -1) { buildANSI2(temp); return; }

	struct ListItem1 *ca; // Top Callers
	struct ListItem2 *po; // Top Posters

	// Holds all Users Data
	char     nc1[31]={0}, nc2[31]={0}, nc3[31]={0}, nc4[31]={0}, nc5[31]={0};
	char     np1[31]={0}, np2[31]={0}, np3[31]={0}, np4[31]={0}, np5[31]={0};

	long int c1=0, c2=0, c3=0, c4=0, c5=0;
	long int p1=0, p2=0, p3=0, p4=0, p5=0;

	// Copy Top Callers
	for ( ca = MYLIST1 ; ca != 0 ; ca = ca->next ) {
		if(ca > 0) { strcpy(nc1,ca->user.handle); c1 = ca->user.Calls; ca = ca->next; }
		if(ca > 0) { strcpy(nc2,ca->user.handle); c2 = ca->user.Calls; ca = ca->next; }
		if(ca > 0) { strcpy(nc3,ca->user.handle); c3 = ca->user.Calls; ca = ca->next; }
		if(ca > 0) { strcpy(nc4,ca->user.handle); c4 = ca->user.Calls; ca = ca->next; }
		if(ca > 0) { strcpy(nc5,ca->user.handle); c5 = ca->user.Calls; ca = ca->next; }
		break;
	}

	// Copy Top Posters
	for ( po = MYLIST2 ; po != 0 ; po = po->next ) {
		if(po > 0) { strcpy(np1,po->user.handle); p1 = po->user.Posts; po = po->next; }
		if(po > 0) { strcpy(np2,po->user.handle); p2 = po->user.Posts; po = po->next; }
		if(po > 0) { strcpy(np3,po->user.handle); p3 = po->user.Posts; po = po->next; }
		if(po > 0) { strcpy(np4,po->user.handle); p4 = po->user.Posts; po = po->next; }
		if(po > 0) { strcpy(np5,po->user.handle); p5 = po->user.Posts; po = po->next; }
		break;
	}

	// Parsing Starts Here
	while (id1 != string::npos) {
		// Top Callers
		id1 = -1;
		id1 = temp.find("$CN1", 0);
		if (id1 != -1) { temp.replace(id1,4,nc1); }
		id1 = -1;
		id1 = temp.find("$CA1", 0);
		if (id1 != -1) {
			char con[15]={0};
			if (c1 > 0) { sprintf(con, "%ld",c1); }
			temp.replace(id1,4,con);
		}
		id1 = -1;
		id1 = temp.find("$CN2", 0);
		if (id1 != -1) { temp.replace(id1,4,nc2); }
		id1 = -1;
		id1 = temp.find("$CA2", 0);
		if (id1 != -1) {
			char con[15]={0};
			if (c2 > 0) { sprintf(con, "%ld",c2); }
			temp.replace(id1,4,con);
		}
		id1 = -1;
		id1 = temp.find("$CN3", 0);
		if (id1 != -1) { temp.replace(id1,4,nc3); }
		id1 = -1;
		id1 = temp.find("$CA3", 0);
		if (id1 != -1) {
			char con[15]={0};
			if (c3 > 0) { sprintf(con, "%ld",c3); }
			temp.replace(id1,4,con);
		}
		id1 = -1;
		id1 = temp.find("$CN4", 0);
		if (id1 != -1) { temp.replace(id1,4,nc4); }
		id1 = -1;
		id1 = temp.find("$CA4", 0);
		if (id1 != -1) {
			char con[15]={0};
			if (c4 > 0) { sprintf(con, "%ld",c4); }
			temp.replace(id1,4,con);
		}
		id1 = -1;
		id1 = temp.find("$CN5", 0);
		if (id1 != -1) { temp.replace(id1,4,nc5); }
		id1 = -1;
		id1 = temp.find("$CA5", 0);
		if (id1 != -1) {
			char con[15]={0};
			if (c5 > 0) { sprintf(con, "%ld",c5); }
			temp.replace(id1,4,con);
		}
		// Top Posters
		id1 = -1;
		id1 = temp.find("$PN1", 0);
		if (id1 != -1) { temp.replace(id1,4,np1); }
		id1 = -1;
		id1 = temp.find("$PO1", 0);
		if (id1 != -1) {
			char con[15]={0};
			if (p1 > 0) { sprintf(con, "%ld",p1); }
			temp.replace(id1,4,con);
		}
		id1 = -1;
		id1 = temp.find("$PN2", 0);
		if (id1 != -1) { temp.replace(id1,4,np2); }
		id1 = -1;
		id1 = temp.find("$PO2", 0);
		if (id1 != -1) {
			char con[15]={0};
			if (p2 > 0) { sprintf(con, "%ld",p2); }
			temp.replace(id1,4,con);
		}
		id1 = -1;
		id1 = temp.find("$PN3", 0);
		if (id1 != -1) { temp.replace(id1,4,np3); }
		id1 = -1;
		id1 = temp.find("$PO3", 0);
		if (id1 != -1) {
			char con[15]={0};
			if (p3 > 0) { sprintf(con, "%ld",p3); }
			temp.replace(id1,4,con);
		}
		id1 = -1;
		id1 = temp.find("$PN4", 0);
		if (id1 != -1) { temp.replace(id1,4,np4); }
		id1 = -1;
		id1 = temp.find("$PO4", 0);
		if (id1 != -1) {
			char con[15]={0};
			if (p4 > 0) { sprintf(con, "%ld",p4); }
			temp.replace(id1,4,con);
		}
		id1 = -1;
		id1 = temp.find("$PN5", 0);
		if (id1 != -1) { temp.replace(id1,4,np5); }
		id1 = -1;
		id1 = temp.find("$PO5", 0);
		if (id1 != -1) {
			char con[15]={0};
			if (p5 > 0) { sprintf(con, "%ld",p5); }
			temp.replace(id1,4,con);
		}
		buildANSI2(temp);
		return;
	}
	buildANSI2(temp);
	return;
}


// Reads in Ansi file into Buffer Only
int parseansi2() {

    std::string buff;

    // Setup the Source
    string filename;
    filename = PATH + "stats/";
    filename = filename + "toppc.ans";

    FILE *fp;
    int c = 0;
    if ((fp = fopen(filename.c_str(), "r+")) ==  NULL) {
        return FALSE;
    }
    do {
        c = getc(fp);
        if (c == '\n') {
            c = '\r';
        }
        if (c != EOF) buff += c;
    }
    while (c != EOF);
    fclose(fp);

    checkMCI2(buff);
    return TRUE;
}


/*--------------------------------------------------------------------------------*/
// Function to retrive all users/data from Users.dat Populates Linklist
void getusers2(void) {

	UserRec user;
	string temp;

	int i, null = 0, idx = 0;
	int total = countusers();

	while(idx < total) {
		userread(&user,idx);
		null = user.handle[0];
		temp = '\0';
		for (i = 1; i < (null +1); i++) { temp += user.handle[i]; }
		temp.erase(0,1);
		strcpy(user.handle,temp.c_str());
		userdatacontainer2(&user);
		idx++;
	}
	return;
}


/*--------------------------------------------------------------------------------*/
// Kicks off Call / Posts Processing
void proccalls(void) {

	struct ListItem *us;

	for ( us = MYLIST ; us != 0 ; us = us->next ) {
		// Creates Sorted Users by Top Calls
		callsort(&us->user);  // List 1
		postsort(&us->user);  // List 2
	}
	// Kick off Processing of Top Callers Here
	parseansi2();  // Parses Ansi and Replaces MCI Codes
	writeANSI2();  // Writes out Completed ANSI with Statistics

	// Clears Link list with Top Callers
	clearuserdata3();
	clearuserdata4();
	return;
}


/*--------------------------------------------------------------------------------*/
// Main Starter Functions for Collecting and Processing all Data
void doallproc2(void) {

	getusers2();        // Gets All Users from USERS.DAT
	proccalls();       // Processes and Creates Top Calls/Posts Stats
	clearuserdata5();   // Clears all User Data from Memory
	return;
}


