/***************************************************************************
 *   Copyright (C) 2004-2009 by Michael Griffin                            *
 *   mrmisticismo@hotmail.com                                              *
 *                                                                         *
 *   Purpose:                                                              *
 *                                                                         *
 *                                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

// Enthral SVN: $Id: msg_title.cpp 110 2009-06-02 02:41:35Z frank $
// Source: $HeadURL: http://svn.enthralbbs.com/trunk/src/msg_title.cpp $
// $LastChangedDate: 2009-06-01 22:41:35 -0400 (Mon, 01 Jun 2009) $
// $LastChangedRevision: 110 $
// $LastChangedBy: frank $

# include <stdio.h>
# include <time.h>
# include <ctype.h>
# include <fstream>
# include <string>

# include <cstring> // gcc 4.3
# include <cstdlib> // gcc 4.3

# include "struct.h"
# include "msg_readll.h"
# include "msg_title.h"
# include "menu_func.h"

using namespace std;

bool msgtitle_ini::msgt_exists() {

    iTop = 0;
    iBot = 0;

    strcpy(sPAGENUM,"");
    strcpy(sPAGETOTAL,"");
    strcpy(sMOREUP,"");
    strcpy(sMOREUP_CHAR,"");
    strcpy(sMOREDOWN,"");
    strcpy(sMOREDOWN_CHAR,"");
    strcpy(sMOREMSG_ON,"");
    strcpy(sMOREMSG_WORD_ON,"");
    strcpy(sMOREMSG_OFF,"");
    strcpy(sMOREMSG_WORD_OFF,"");
    strcpy(sINPUT_BOX,"");
    strcpy(sTEXT_COLOR,"");
    //strcpy(sTEXT_HILIGHT,"");
    strcpy(sTOT_MSG,"");

    std::string path = INIPATH;
    path += "msgtitle.ini";

    FILE *stream;
    stream = fopen(path.c_str(),"rb+");
    if(stream == NULL) { return false; }
    fclose(stream);
    return true;
}

void msgtitle_ini::msgt_create() {

    std::string name = INIPATH;
    name += "msgtitle.ini";

    ofstream outStream2;
    outStream2.open( name.c_str(), ofstream::out | ofstream::trunc );
    if (!outStream2.is_open()) {
        printf( "\nError Creating: %s \n", name.c_str());
        return;
    }

    outStream2 << "#" << endl;
    outStream2 << "# .----------------------------------------------------------------." << endl;
    outStream2 << "# | " << BBSVERSION << "           |" << endl;
    outStream2 << "# | Message Title Scan Quoter Text Box Coords                      |" << endl;
    outStream2 << "# `----------------------------------------------------------------'" << endl;
    outStream2 << "#" << endl;
    outStream2 << "#" << endl;
    outStream2 << "# .----------------------------------------------------------------." << endl;
    outStream2 << "# | Note : This file is regenerated with defaults if missing.      |" << endl;
    outStream2 << "# | Note : Any Lines starting with # will be ignored!              |" << endl;
    outStream2 << "# `----------------------------------------------------------------'" << endl;
    outStream2 << endl;
    outStream2 << "#" << endl;
    outStream2 << "# .----------------------------------------------------------------." << endl;
    outStream2 << "# | Set the TOP Line # for the Top Margin                          |" << endl;
    outStream2 << "# `----------------------------------------------------------------'" << endl;
    outStream2 << "#" << endl;
    outStream2 << "set TOP \"5\"" << endl;
    outStream2 << endl;
    outStream2 << "#" << endl;
    outStream2 << "# .----------------------------------------------------------------." << endl;
    outStream2 << "# | Set the BOTTOM Line # for the Bottom Margin                    |" << endl;
    outStream2 << "# `----------------------------------------------------------------'" << endl;
    outStream2 << "#" << endl;
    outStream2 << "set BOT \"22\"" << endl;
    outStream2 << endl;
    outStream2.close();
    return;
}

void msgtitle_ini::msgt_check(std::string cfgdata) {

    std::string temp = cfgdata;
    int id1 = -1;

    // Disgards any Config lines with the # Character
    if (temp[0] == '#') return;

    // Sets if LOGGING is on / off
    id1 = -1;
    id1 = temp.find("set TOP ", 0);
    if (id1 != -1) {
        std::string temp1;
        int st1 = -1;
        int st2 = -1;
        signed int  ct = -1;

        st1 = temp.find('"', 0);
        st2 = temp.find('"', st1+1);
        ++st1;
        temp1 = temp.substr(st1,st2);
        ct = st2 - st1;
        if (temp1.length() > ct)
            temp1.erase(ct,temp1.length());
        id1 = atoi(temp1.c_str());
        iTop = id1;
        return;
    }

    // Sets Download Path
    id1 = -1;
    id1 = temp.find("set BOT ", 0);
    if (id1 != -1) {
        std::string temp1;
        int st1 = -1;
        int st2 = -1;
        signed int  ct = -1;

        st1 = temp.find('"', 0);
        st2 = temp.find('"', st1+1);
        ++st1;
        temp1 = temp.substr(st1,st2);
        ct = st2 - st1;
        if (temp1.length() > ct)
            temp1.erase(ct,temp1.length());
        id1 = atoi(temp1.c_str());
        iBot = id1;
        return;
    }

    // Sets XY PAGE Num
    id1 = -1;
    id1 = temp.find("set PAGENUM ", 0);
    if (id1 != -1) {
        std::string temp1;
        int st1 = -1;
        int st2 = -1;
        signed int  ct = -1;

        st1 = temp.find('"', 0);
        st2 = temp.find('"', st1+1);
        ++st1;
        temp1 = temp.substr(st1,st2);
        ct = st2 - st1;
        if (temp1.length() > ct)
            temp1.erase(ct,temp1.length());
        strcpy(sPAGENUM,(char *)temp1.c_str());
        return;
    }

    // Sets XY PAGE Num
    id1 = -1;
    id1 = temp.find("set PAGETOTAL ", 0);
    if (id1 != -1) {
        std::string temp1;
        int st1 = -1;
        int st2 = -1;
        signed int  ct = -1;

        st1 = temp.find('"', 0);
        st2 = temp.find('"', st1+1);
        ++st1;
        temp1 = temp.substr(st1,st2);
        ct = st2 - st1;
        if (temp1.length() > ct)
            temp1.erase(ct,temp1.length());
        strcpy(sPAGETOTAL,(char *)temp1.c_str());
        return;
    }

    // Sets XY PAGE Num
    id1 = -1;
    id1 = temp.find("set MOREUP ", 0);
    if (id1 != -1) {
        std::string temp1;
        int st1 = -1;
        int st2 = -1;
        signed int  ct = -1;

        st1 = temp.find('"', 0);
        st2 = temp.find('"', st1+1);
        ++st1;
        temp1 = temp.substr(st1,st2);
        ct = st2 - st1;
        if (temp1.length() > ct)
            temp1.erase(ct,temp1.length());
        strcpy(sMOREUP,(char *)temp1.c_str());
        return;
    }

    // Sets XY PAGE Num
    id1 = -1;
    id1 = temp.find("set MOREUP_CHAR ", 0);
    if (id1 != -1) {
        std::string temp1;
        int st1 = -1;
        int st2 = -1;
        signed int  ct = -1;

        st1 = temp.find('"', 0);
        st2 = temp.find('"', st1+1);
        ++st1;
        temp1 = temp.substr(st1,st2);
        ct = st2 - st1;
        if (temp1.length() > ct)
            temp1.erase(ct,temp1.length());
        strcpy(sMOREUP_CHAR,(char *)temp1.c_str());
        return;
    }

    // Sets XY PAGE Num
    id1 = -1;
    id1 = temp.find("set MOREDOWN ", 0);
    if (id1 != -1) {
        std::string temp1;
        int st1 = -1;
        int st2 = -1;
        signed int  ct = -1;

        st1 = temp.find('"', 0);
        st2 = temp.find('"', st1+1);
        ++st1;
        temp1 = temp.substr(st1,st2);
        ct = st2 - st1;
        if (temp1.length() > ct)
            temp1.erase(ct,temp1.length());
        strcpy(sMOREDOWN,(char *)temp1.c_str());
        return;
    }

    // Sets XY PAGE Num
    id1 = -1;
    id1 = temp.find("set MOREDOWN_CHAR ", 0);
    if (id1 != -1) {
        std::string temp1;
        int st1 = -1;
        int st2 = -1;
        signed int  ct = -1;

        st1 = temp.find('"', 0);
        st2 = temp.find('"', st1+1);
        ++st1;
        temp1 = temp.substr(st1,st2);
        ct = st2 - st1;
        if (temp1.length() > ct)
            temp1.erase(ct,temp1.length());
        strcpy(sMOREDOWN_CHAR,(char *)temp1.c_str());
        return;
    }

    // Sets XY PAGE Num
    id1 = -1;
    id1 = temp.find("set MOREMSG_ON ", 0);
    if (id1 != -1) {
        std::string temp1;
        int st1 = -1;
        int st2 = -1;
        signed int  ct = -1;

        st1 = temp.find('"', 0);
        st2 = temp.find('"', st1+1);
        ++st1;
        temp1 = temp.substr(st1,st2);
        ct = st2 - st1;
        if (temp1.length() > ct)
            temp1.erase(ct,temp1.length());
        strcpy(sMOREMSG_ON,(char *)temp1.c_str());
        return;
    }

    // Sets XY PAGE Num
    id1 = -1;
    id1 = temp.find("set MOREMSG_WORD_ON ", 0);
    if (id1 != -1) {
        std::string temp1;
        int st1 = -1;
        int st2 = -1;
        signed int  ct = -1;

        st1 = temp.find('"', 0);
        st2 = temp.find('"', st1+1);
        ++st1;
        temp1 = temp.substr(st1,st2);
        ct = st2 - st1;
        if (temp1.length() > ct)
            temp1.erase(ct,temp1.length());
        strcpy(sMOREMSG_WORD_ON,(char *)temp1.c_str());
        return;
    }

// Sets XY PAGE Num
    id1 = -1;
    id1 = temp.find("set MOREMSG_OFF ", 0);
    if (id1 != -1) {
        std::string temp1;
        int st1 = -1;
        int st2 = -1;
        signed int  ct = -1;

        st1 = temp.find('"', 0);
        st2 = temp.find('"', st1+1);
        ++st1;
        temp1 = temp.substr(st1,st2);
        ct = st2 - st1;
        if (temp1.length() > ct)
            temp1.erase(ct,temp1.length());
        strcpy(sMOREMSG_OFF,(char *)temp1.c_str());
        return;
    }

    // Sets XY PAGE Num
    id1 = -1;
    id1 = temp.find("set MOREMSG_WORD_OFF ", 0);
    if (id1 != -1) {
        std::string temp1;
        int st1 = -1;
        int st2 = -1;
        signed int  ct = -1;

        st1 = temp.find('"', 0);
        st2 = temp.find('"', st1+1);
        ++st1;
        temp1 = temp.substr(st1,st2);
        ct = st2 - st1;
        if (temp1.length() > ct)
            temp1.erase(ct,temp1.length());
        strcpy(sMOREMSG_WORD_OFF,(char *)temp1.c_str());
        return;
    }

    // Sets XY PAGE Num
    id1 = -1;
    id1 = temp.find("set INPUT_BOX ", 0);
    if (id1 != -1) {
        std::string temp1;
        int st1 = -1;
        int st2 = -1;
        signed int  ct = -1;

        st1 = temp.find('"', 0);
        st2 = temp.find('"', st1+1);
        ++st1;
        temp1 = temp.substr(st1,st2);
        ct = st2 - st1;
        if (temp1.length() > ct)
            temp1.erase(ct,temp1.length());
        strcpy(sINPUT_BOX,(char *)temp1.c_str());
        return;
    }

    // Sets XY PAGE Num
    id1 = -1;
    id1 = temp.find("set TEXT_COLOR ", 0);
    if (id1 != -1) {
        std::string temp1;
        int st1 = -1;
        int st2 = -1;
        signed int  ct = -1;

        st1 = temp.find('"', 0);
        st2 = temp.find('"', st1+1);
        ++st1;
        temp1 = temp.substr(st1,st2);
        ct = st2 - st1;
        if (temp1.length() > ct)
            temp1.erase(ct,temp1.length());
        strcpy(sTEXT_COLOR,(char *)temp1.c_str());
        return;
    }

    /*
    // Sets XY PAGE Num
    id1 = -1;
    id1 = temp.find("set TEXT_HILIGHT ", 0);
    if (id1 != -1) {
        std::string temp1;
        int st1 = -1;
        int st2 = -1;
        signed int  ct = -1;

        st1 = temp.find('"', 0);
        st2 = temp.find('"', st1+1);
        ++st1;
        temp1 = temp.substr(st1,st2);
        ct = st2 - st1;
        if (temp1.length() > ct)
            temp1.erase(ct,temp1.length());
        strcpy(sTEXT_HILIGHT,(char *)temp1.c_str());
        return;
    }*/


    // Sets XY PAGE Num
    id1 = -1;
    id1 = temp.find("set TOT_MSG ", 0);
    if (id1 != -1) {
        std::string temp1;
        int st1 = -1;
        int st2 = -1;
        signed int  ct = -1;

        st1 = temp.find('"', 0);
        st2 = temp.find('"', st1+1);
        ++st1;
        temp1 = temp.substr(st1,st2);
        ct = st2 - st1;
        if (temp1.length() > ct)
            temp1.erase(ct,temp1.length());
        strcpy(sTOT_MSG,(char *)temp1.c_str());
        return;
    }
}

void msgtitle_ini::msgt_parse() {

    std::string name = INIPATH;
    name += "msgtitle.ini";

    ifstream inStream;
    inStream.open( name.c_str() );
    if (!inStream.is_open()) {
        printf("Couldn't Open Config File: %s\n", name.c_str());
        return;
    }

    std::string cfgdata;
    for (;;) {
        getline(inStream,cfgdata);
        msgt_check(cfgdata);
        if(inStream.eof()) break;
    }
    inStream.close();
    return;
}

msg_title::msg_title() {

    tTop    = 1;
    tBot    = 1;
}

void msg_title::SetupTitleScan() {

    // Do quick Message Quoter ini parsing
    if (!msgt_exists()) {
        msgt_create();
    }
    msgt_parse();
	tTop = iTop;
    tBot = iBot;

}

int msg_title::StartTitleScan(char *OrgMsg, int iPage, int iTotal, int iTotMsg) {

    bool more 		 = false;
    bool showmore    = false;
    char mString[10] = {0};
    unsigned char ch;
    std::string _output;
    char outBuffer[200];
    // Startup Message Reader Link List for Holding Message Lines
    menu_func 	_mnuf;
    msg_readll 	mLink;

    //mLink.initReader(sTEXT_COLOR);
    mLink.Top = tTop;
    mLink.Bot = tBot;
    //mLink.add_to_list("");
   // mLink.move_up();

	// Mainly for Quoting Text Selection.
    char rBuffer[100]={0};
	char text[100]={0};
	char sNum[3]={0};
	std::string rBuff;
	int id1, num, num2;
    int len;

	mLink.clearBox();

    while (1) {
		mLink.PutBuffer(OrgMsg, FALSE);	// Send the Original Message into Quote Buffer
        mLink.box_start(CURRENT_MAREA);  		// Draw Message Inside of Box
        while(1) {
            _output = "";
			more = false;
			showmore = false;
			if (iPage < iTotal) more = true;
			/*-------------------------------------------------------*/
			// Show Down Arrow More!
			if (more) {
				sprintf(outBuffer,"%s\x19",sMOREDOWN); 	// On
				showmore = true;
			}
			else {
				sprintf(outBuffer,"%s ",sMOREDOWN);		// Off
			}
			_output += outBuffer;

			// Show up Arrow More
			if (iPage > 1) {
				sprintf(outBuffer,"%s\x18",sMOREUP);
				showmore = true;
			}
			else {
				sprintf(outBuffer,"%s ",sMOREUP);
			}
			_output += outBuffer;

			if (showmore)
				sprintf(outBuffer,"%s%s",sMOREMSG_ON,sMOREMSG_WORD_ON);
			else
				sprintf(outBuffer,"%s%s",sMOREMSG_OFF,sMOREMSG_WORD_OFF);
			_output += outBuffer;

			// Show Current/Total Pages
			sprintf(outBuffer,"%s%i",sPAGENUM,iPage);
			_output += outBuffer;
            sprintf(outBuffer,"%s%i",sPAGETOTAL,iTotal);
			_output += outBuffer;

			sprintf(outBuffer,"%s%i",sTOT_MSG,iTotMsg);
			_output += outBuffer;

			/*-------------------------------------------------------*/
            pipe2ansi((char *)_output.c_str());

            _mnuf._premenu.clear();
            _mnuf._premenu = _mnuf._curmenu;
            _mnuf._curmenu.clear();
            _mnuf._curmenu = "msg_title";
            _mnuf.menu_readin();
            _mnuf.menu_proc(mString);
            ch = mString[1];
			// For Menu CmdKey Input
            if (mString[0] == '!')
				switch (toupper(ch)) {
                case 'N': // Next Page
                    mLink.dispose_list();
                    //delete _mnuf;
                   // _mnuf.~menu_func();
					return 1;

                case 'U': // Page UP
                    mLink.dispose_list();
                    //delete _mnuf;
                    //_mnuf.~menu_func();
                    return 2;

                case 'D': // Page Down
                    mLink.dispose_list();
                    //delete _mnuf;
                    //_mnuf.~menu_func();
					return 1;

				case '?': // Help Screen with Commands
                    ansiPrintf((char *)"titlehlp");
                    //ansiPrintf("mquote");
					mLink.box_refresh(CURRENT_MAREA);
                    break;

                case 'P': // Select all Text To Quote
					mLink.dispose_list();
                    //delete _mnuf;
                    //_mnuf.~menu_func();
                    return 2;

                case 'Q': // Quit
					mLink.dispose_list();
                    //delete _mnuf;
                    //_mnuf.~menu_func();
					return 4;

				case 'R': // Read
                    // Set User Last Message to Current Mesasge
					mLink.dispose_list();
                    //delete _mnuf;
                    //_mnuf.~menu_func();
					return 3;

                default :
                    break;
            } // end of case
            else
            if (mString[0] == '#') {
				// received Digist Input From Menu Prompt, Start Input for Quoting Text!
				memset(&rBuffer,0, sizeof(rBuffer));
				memset(&text,0, sizeof(text));
				//lang_get(text,13);
				strcpy(text,sINPUT_BOX);
                len = 14;
				inputfield(text,len);
				pipe2ansi(text);
				sprintf(sNum,"%c",ch);
				getline(rBuffer,len,sNum);
				num = 0;
				num2 = 0;
				id1 = atoi(rBuffer);
				mLink.box_refresh(CURRENT_MAREA);
			}
			else {	// For Escaped Key Input / Up/DN Arrows
				ch = mString[0];
				switch (toupper(ch)) {
					case 'A':	// Previous Page
						mLink.dispose_list();
                    	return 2;

                	case 'B':   // Next Page
                    	mLink.dispose_list();
						return 1;

					default :
                    break;
				}
			}
        }
    }
}
