/***************************************************************************
 *   Copyright (C) 2004-2009 by Michael Griffin                            *
 *   mrmisticismo@hotmail.com                                              *
 *                                                                         *
 *   Purpose:                                                              *
 *                                                                         *
 *                                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

// Enthral SVN: $Id: msg_readll.h 110 2009-06-02 02:41:35Z frank $
// Source: $HeadURL: http://svn.enthralbbs.com/trunk/src/msg_readll.h $
// $LastChangedDate: 2009-06-01 22:41:35 -0400 (Mon, 01 Jun 2009) $
// $LastChangedRevision: 110 $
// $LastChangedBy: frank $

# ifndef MSG_READLL_H
# define MSG_READLL_H

# include <string>
# include "struct.h"
# include "conio.h"


typedef struct msg_readll : private SESSION {

    public:
    // Main List for Holding All Data
    LineRec *head;
    LineRec *current_node;
    LineRec *last;

    int Row;
    int Top;
    int Bot;
    int Tot;
    int Num;
    int Lines;
    int Page;
    int TotPages;
    int reader;
    int quote;
    int arealist;
    int pgRows;

    int headerrows;

    int PAGE_SCROLL;
    int CLEAR_BOX;

    // Quote and Title Scans
    char LoColor[10];
    char HiColor[10];

    // Message Reader
    char TEXT_COLOR[10];
    char QUOTE_COLOR[10];
    char SYS_COLOR[10];
    char ORIGIN_COLOR[10];

    msg_readll();
    ~msg_readll();

    void initQuote(char *sLow, char *sHigh,int q = FALSE);
    void initReader(char *sTEXT, char *sQUOTE, char *sSYS, char *sORIGIN);
    void initList(char *sLow, int alist = FALSE);
    void togglePageScroll(int on = TRUE);
	void clearBox();

	// Copy message from link lists to buffer
	void stripCRONLY(char *ostr);
	//char *GetBuffer();
    void GetBuffer(std::string &tbuf);
    char *PopulateQuoter();

    // Copy From buffer into Link List (UserSig) Clean
    void PutBufferSig(char *mBuff, int Strip = FALSE);
	void PutBuffer(char *mBuff, int Strip = TRUE);

    void cleartags(char *tag, char *origin);

	void clear_all();
	void select_all();
    void display_list(void);
    void flag_line(int iNum);
    void delete_line_up();
    void add_to_list(std::string add_data);
    int  move_up();
    int  move_down();
    int  line_count();
    int  line_total();
    void Last_Line();
    void dispose();
    void dispose_list();
    // Line Reader - old school scrolling.
    char *parseReadColorScroller(char *cap,std::string data);
    char *parsereadcolors(char *cap,int row, int col, std::string data);
    // Line Reader - old school scrolling.
    void box_scroll_reader();
    void box_pgdn_scroll();
    // Normal Lightbar...
    void box_start(unsigned long CURRENT); // CURRENT = ARea MAREA or ULIST etc...
    void box_scrolldn();
    void box_pgdn();
    void box_pgup();
    void box_refresh(unsigned long CURRENT);
    void box_overdraw(unsigned long CURRENT);

}msg_readll;

# endif
