/***************************************************************************
 *   Copyright (C) 2004-2009 by Michael Griffin                            *
 *   mrmisticismo@hotmail.com                                              *
 *                                                                         *
 *   Purpose: Logon & New User Application Routines                        *
 *                                                                         *
 *                                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

// Enthral SVN: $Id: logon.cpp 152 2010-04-10 10:53:59Z mercyful $
// Source: $HeadURL: http://svn.enthralbbs.com/trunk/src/logon.cpp $
// $LastChangedDate: 2010-04-10 06:53:59 -0400 (Sat, 10 Apr 2010) $
// $LastChangedRevision: 152 $
// $LastChangedBy: mercyful $

# include <stdio.h>
# include <string>

# include <cstring> //gcc 4.3
# include <cstdlib> //gcc 4.3

# include "struct.h"
# include "logon.h"

# include "dtfunc.h"
# include "language.h"
# include "menu_func.h"
# include "users.h"
# include "history.h"
# include "node.h"
# include "msgs.h"

using namespace std;

int  isSysop = FALSE;


logon::logon() {

    useScript     = FALSE;
    InvalidLogins = 0;
}

// New User Application
void logon::Handle(UserRec *u) {

    char rBuffer[100] ={0};
    char text[100]    ={0};
    char text2[100]   ={0};
    int  len = sizeof(u->handle)-1;

    while (1) {
        memset(&text,0,sizeof(text));
        lang_get(text,8);
        inputfield(text,len);
        pipe2ansi(text);
        getline(rBuffer,len);
        if (strcmp(rBuffer,"")     != 0 &&
            strcmp(rBuffer,"0")    != 0 &&
            strcmp(rBuffer,"\n")   != 0 &&
            atoi(rBuffer)          ==  0) {

            // Check if already exists
            if(!idx_match(rBuffer)) {
                strcpy(u->handle,rBuffer);
                break;
            }
            else { // Incorrect Handle
                lang_get(text2,18);
                pipe2ansi(text2);
            }
        }
        //pipe2ansi("|15|17");
        pipe2ansi(text);
    }
}

// New User Application
void logon::Name(UserRec *u) {

    char rBuffer[100]={0};
    char text[100]={0};
    lang_get(text,9);
    int len = sizeof(u->name)-1;
    inputfield(text,len);
    pipe2ansi(text);
    while(1) {
        // Ask for Users Real Name
        getline(rBuffer,len);
        if (strcmp(rBuffer,"") != 0 && strcmp(rBuffer,"\n") != 0) {
            strcpy(u->name,rBuffer);
            break;
        }
        //pipe2ansi("|15|17");
        pipe2ansi(text);
    }

}

// New User Application
void logon::Password(UserRec *u) {

    char rBuffer[100]={0};
    char text[100]={0};
    // Ask for Users Password
    lang_get(text,10);
    int len = sizeof(u->password)-1;
    inputfield(text,len);
    pipe2ansi(text);
    while(1) {
        getline(rBuffer,len,NULL,TRUE);
        if (strcmp(rBuffer,"") != 0 && strcmp(rBuffer,"\n") != 0) {
            strcpy(u->password,rBuffer);
            break;
        }
        //pipe2ansi("|15|17");
        pipe2ansi(text);
    }
}

// New User Application
int logon::VerifyPassword(UserRec *u) {

    char rBuffer[100]={0};
    char text[100]={0};
    // Ask for Users Password
    lang_get(text,45);
    int len = sizeof(u->password)-1;
    inputfield(text,len);
    pipe2ansi(text);
    while(1) {
        getline(rBuffer,len,NULL,TRUE);
        if (strcmp(rBuffer,"") != 0 && strcmp(rBuffer,"\n") != 0) {
            if (strcmp(u->password,rBuffer) == 0 && strlen(rBuffer) > 5) {
                return TRUE;
            }
            else {
                // Wrong password, doesn't match!
                memset(&text,0,sizeof(text));
                lang_get(text,46);
                pipe2ansi(text);
                return FALSE;
            }
        }
        //pipe2ansi("|15|17");
        pipe2ansi(text);
    }
}

// New User Application
void logon::Sex(UserRec *u) {

    char text[100]={0};
    unsigned char c;
    // Ask Sex M/F
    lang_get(text,11);
    int len = 1;
    inputfield(text,len);
    pipe2ansi(text);
    while (1) {
        c = getkey(true);
        if (toupper(c) == 'M' || toupper(c) == 'F') {
            sprintf(text,"|15|17%c",c);
            pipe2ansi(text);
            u->sex = c;
            break;
        }
        //pipe2ansi("|15|17");
        pipe2ansi(text);
    }
}

// New User Application
void logon::BDay(UserRec *u) {

    char rBuffer[100]={0};
    char text[100]={0};
    char text2[100]={0};
    long secs;

    // Ask for Users Bitchday
    lang_get(text,12);
    int len = 10;
    inputfield(text,len);
    pipe2ansi(text);
    while(1) {
        getline(rBuffer,len+1);
        if (strcmp(rBuffer,"") != 0 && strcmp(rBuffer,"\n") != 0) {
            if (isdigit(rBuffer[0]) && isdigit(rBuffer[1]) &&
                isdigit(rBuffer[3]) && isdigit(rBuffer[4]) &&
                isdigit(rBuffer[6]) && isdigit(rBuffer[7]) &&
                isdigit(rBuffer[8]) && isdigit(rBuffer[9]) &&
                rBuffer[2] == '/'   && rBuffer[5] == '/') {

                if (VerifyBday(rBuffer)) {
                    secs = Date2Sec(rBuffer);
                    u->dtbday = secs;
                    break;
                }
                else {
                    memset(&rBuffer,0,sizeof(rBuffer));
                    lang_get(text2,38);
                    pipe2ansi(text2);
                    pipe2ansi(text);
                }
            }
            else {
                memset(&rBuffer,0,sizeof(rBuffer));
                lang_get(text2,38);
                pipe2ansi(text2);
                pipe2ansi(text);

            }
        }
        //pipe2ansi("|15|17");
        pipe2ansi(text);
    }
}

// New User Application
void logon::Email(UserRec *u) {

    char rBuffer[100]={0};
    char text[100]={0};
    char text2[100]={0};
    std::string tmp;
    int i;

    // Ask for Email Address
    int len = sizeof(u->email)-1;
    lang_get(text,13);
    inputfield(text,len);
    pipe2ansi(text);
    while(1) {
        getline(rBuffer,len);
        if (strcmp(rBuffer,"") != 0 && strcmp(rBuffer,"\n") != 0) {
            tmp = rBuffer;
            i = strlen(rBuffer);
            // Remove checking for invalid format!
            //if (tmp.find("@",0) != std::string::npos && (rBuffer[i-4] == '.' || rBuffer[i-3] == '.')) {

            strcpy(u->email,rBuffer);
            break;

            //}
            /*
            else {
                memset(&rBuffer,0,sizeof(rBuffer));
                memset(&text2,0,sizeof(text2));
                memset(&text,0,sizeof(text));

                lang_get(text2,39);
                pipe2ansi(text2);

                lang_get(text,13);
                inputfield(text,len);
                pipe2ansi(text);

            } */
        }
        //pipe2ansi("|15|17");
        pipe2ansi(text);
    }
}

// New User Application
void logon::EmailPriv(UserRec *u) {

    char text[100]={0};
    unsigned char c;
    // Ask to Keep Email Private
    lang_get(text,14);
    int len = 1;
    inputfield(text,len);
    pipe2ansi(text);
    while (1) {
        c = getkey(true);
        if (toupper(c) == 'Y') {
            u->emprivate = true;
            break;
        }
        else if (toupper(c) == 'N') {
            u->emprivate = false;
            break;
        }
        //pipe2ansi("|15|17");
        pipe2ansi(text);
    }
    sprintf(text,"|15|17%c",c);
    pipe2ansi(text);
}

// New User Application
void logon::Note(UserRec *u) {

    char rBuffer[100]={0};
    char text[100]={0};
    // Desired User Note
    lang_get(text,15);
    int len = sizeof(u->usernote)-1;
    inputfield(text,len);
    pipe2ansi(text);
    while(1) {
        getline(rBuffer,len);
        if (strcmp(rBuffer,"") != 0 && strcmp(rBuffer,"\n") != 0) {
            strcpy(u->usernote,rBuffer);
            break;
        }
        //pipe2ansi("|15|17");
        pipe2ansi(text);
    }
}

// New User Application
void logon::ChallengeQuestion(UserRec *u) {

    char rBuffer[100]={0};
    char text[100]={0};

    lang_get(text,16);
    int len = 39;
    inputfield(text,len);
    pipe2ansi(text);
    while(1) {
        getline(rBuffer,len);
        if (strcmp(rBuffer,"") != 0 && strcmp(rBuffer,"\n") != 0) {
            strcpy(u->c_question,rBuffer);
            break;
        }
        //pipe2ansi("|15|17");
        pipe2ansi(text);
    }
}

// New User Application
void logon::ChallengeAnswer(UserRec *u) {

    char rBuffer[100]={0};
    char text[100]={0};

    lang_get(text,40);
    int len = 39;
    inputfield(text,len);
    pipe2ansi(text);
    while(1) {
        getline(rBuffer,len,NULL,TRUE);
        if (strcmp(rBuffer,"") != 0 && strcmp(rBuffer,"\n") != 0) {
            strcpy(u->c_answer,rBuffer);
            break;
        }
        //pipe2ansi("|15|17");
        pipe2ansi(text);
    }
}

// New User Application
void logon::application() {

    if (useScript) {
        ScriptApplication();
        return;
    }

    UserRec u;
    memset(&u,0,sizeof(UserRec));

    node _node;
    // Setup Default Node User as logging in...
    sprintf(u.handle,"New User Application");
    _node.node_write(&u,NODE_NUM);

    memset(&u,0,sizeof(UserRec));

    // Starting New User Application Process
    ansiPrintf((char *)"newuser");
    char text[100]={0};
    unsigned char c;

    // Ask If want to Register a new account
    lang_get(text,7);
    int len = 1;
    inputfield(text,len);
    pipe2ansi(text);
    while (1) {
        c = getkey(true);
        if (toupper(c) == 'Y') break;
        else if (toupper(c) == 'N') return;
    }
    sprintf(text,"|15|17%c",c);
    pipe2ansi(text);

    ansiPrintf((char *)"newmsg");

    Handle(&u);    // Handle
    Name(&u);      // Name
    Password(&u);  // Password

    int i = 0;
    while (1) {
        i = VerifyPassword(&u);
        if (i == TRUE) break;
        // Failed Verification, start over on password.
        Password(&u);
    }
    Sex(&u);       // Sex
    BDay(&u);      // Birthday
    Email(&u);     // Email
    EmailPriv(&u); // Keep Email Private
    Note(&u);      // Note
    ChallengeQuestion(&u);
    ChallengeAnswer(&u);
    // Save or Change User Info
    verify_info(&u);
}

// WIP
void logon::ScriptApplication() {

    UserRec u;
    memset(&u,0,sizeof(UserRec));
    // Starting New User Application Process
    ansiPrintf((char *)"newuser");
    char text[100]={0};
    unsigned char c;

    // Ask If want to Register a new account
    lang_get(text,7);
    int len = 1;
    inputfield(text,len);
    pipe2ansi(text);
    while (1) {
        c = getkey(true);
        if (toupper(c) == 'Y') break;
        else if (toupper(c) == 'N') return;
    }
    sprintf(text,"|15|17%c",c);
    pipe2ansi(text);

    Handle(&u);    // Handle
    Name(&u);      // Name
    Password(&u);  // Password
    Sex(&u);       // Sex
    BDay(&u);      // Birthday
    Email(&u);     // Email
    EmailPriv(&u); // Keep Email Private
    Note(&u);      // Note
    ChallengeQuestion(&u);
    ChallengeAnswer(&u);
    // Save or Change User Info
    //verify_info(&u);
    save_user(&u);

}

void logon::ParseVerify(char *filename, UserRec *u) {

    std::string path = ANSIPATH;
    path += filename;
    path += ".ans";

    char MCI[3]     = {0};   // Holds MCI Codes to Parse
    char sTemp[255] = {0};
    char masked[40] = {0};
    int  space = 0, foundr = 0 , foundl = 0;
    int  c = 0;
    std::string buff;

    // Buffer in Ansi
    FILE *inStream;
    if ((inStream = fopen(path.c_str(), "r+")) ==  NULL) {
        return;
    }
    do {
        c = getc(inStream);
        if  (c != EOF) buff += c;
    } while (c != EOF);
    fclose(inStream);

    int id1 = 0;
    while (id1 != -1) {
        // parse justify spacing right / left passing in string before
        // replacing mci code. to Properly Space Output Ansi.
        id1 = buff.find("%", 0);
        if (id1 == -1) break;
        memset(&MCI,0,sizeof(MCI));
        space = 0;
        // Check if MCI Code is Justified then Process this.
        if (buff[id1+3] == '{') { // Left Justify
            //elog("left justify: %c%c",buff[id1+4],buff[id1+5]);
            MCI[0] = buff[id1+4]; // Get first Digit
            MCI[1] = buff[id1+5]; // Get Second Digit
            space  = atoi(MCI);
            foundr = FALSE;
            foundl = TRUE;
        }
        else
        if (buff[id1+3] == '}') { // Right Justify
            //elog("right justify: %c%c",buff[id1+4],buff[id1+5]);
            MCI[0] = buff[id1+4]; // Get first Digit
            MCI[1] = buff[id1+5]; // Get Second Digit
            space  = atoi(MCI);
            //elog("right justify: %i",space);
            foundl = FALSE;
            foundr = TRUE;
        }
        // Now Get MCI Code
        MCI[0] = buff[id1+1]; // Get first Digit
        MCI[1] = buff[id1+2]; // Get Second Digit

        memset(&sTemp,0,sizeof(sTemp));
        // Insert MCI Parsing here so we can reaplace full result with propering spacing.

        if (strcmp(MCI,"UH") == 0)    {
            sprintf(sTemp,"%s", u->handle);
        }
        else
        if (strcmp(MCI,"UN") == 0) {
            sprintf(sTemp,"%s", u->name);
        }
        else
        if (strcmp(MCI,"UP") == 0) {
            // Mask Password
            sprintf(masked,"%s", u->password);
            mask(masked);
            sprintf(sTemp,"%s", masked);
        }
        else
        if (strcmp(MCI,"US") == 0) {
            if (u->sex == 'f' || u->sex == 'F') sprintf(sTemp,"female");
            else sprintf(sTemp,"male");
        }
        else
        if (strcmp(MCI,"BD") == 0) {
            sprintf(sTemp,"%s", Sec2Date(u->dtbday));
        }
        else
        if (strcmp(MCI,"NO") == 0){
            sprintf(sTemp,"%s", u->usernote);
        }

        else
        if (strcmp(MCI,"CQ") == 0) {
            sprintf(sTemp,"%s", u->c_question);
        }
        else
        if (strcmp(MCI,"CA") == 0){
            sprintf(sTemp,"%s", u->c_answer);
        }
        else
        if (strcmp(MCI,"EM") == 0) {
            sprintf(sTemp,"%s",u->email);
        }
        else
        if (strcmp(MCI,"PR") == 0) {
            if (u->emprivate) sprintf(sTemp,"yes");
            else sprintf(sTemp,"no");
        }

        // MCI Translation .
        if (foundl == TRUE) {
            lspacing(sTemp,space);
        }
        else
        if (foundr == TRUE) {
           rspacing(sTemp,space);
        }

        //If we Parsed Justify, then Erase that MCI Code as well.
        (space != 0) ?
            buff.replace(id1,6,sTemp):
            buff.replace(id1,3,sTemp);
    }
    //elog("Finished Parsing MCI Codes...");
    pipe2ansi((char *)buff.c_str());
}

void logon::save_user(UserRec *u) {

    // For setting last read pointers.
    msgs mf;

    int idx;

	idx = idx_count();
	if (idx == -1) idx = 0;

    //printf ("\nidx = %i",idx);

    u->idx         = idx;
    u->lastmbarea  = 0;
    u->lastmsg     = 1;
    u->linelen     = 80;
    u->pagelen     = 25;
    u->readertheme = 0;
    u->fsetheme    = 0;
    u->pageDn      = FALSE;
    u->readerFs    = TRUE;
    u->dtfirston   = GetCurrentDTSec();
    u->dtlaston    = u->dtfirston;

    strcpy(u->startmenu,"logon");
    idx_new(u->handle,idx);
    users_write(u,idx);

    mf.resetlastread(u);


    pipe2ansi((char *)"\n\n|15S|07av|08ing user information.. |15.|DE |15S|07av|08ed |CR|CR|PA");
}

void logon::verify_info(UserRec *u, char *mString) {
    // Initalize Menu Function Class
    menu_func _mf;
    char zString[10] = {0};
    char text[100]   = {0};
    bool done        = false;
    unsigned char ch;
    int len;

    // Setup the Menu For Lightbars
    _mf._premenu = _mf._curmenu;
    _mf._curmenu = mString;

    while(!done) {
        // Setup Screen Display Ansi Header
        pipe2ansi((char *)"|CS");
        ParseVerify((char *)"verify",u);
        // Readin the Menu Prompt
        _mf.menu_readin();
        _mf.menu_proc(zString);
        ch = zString[1];
        switch (toupper(ch)) {
            case 'Q': // Save & Exit
                save_user(u);
                return;

            case 'E': // Edit / Change a Setting
                // Display Mdify which string
                lang_get(text,22);
                len = 1;
                inputfield(text,len);
                pipe2ansi(text);

                ch = getkey(true);
                // Draw out key inputted
                sprintf(text,"|15|17%c",ch);
                pipe2ansi(text);
                if (isdigit(ch)) {
                    switch (ch) {
                        case '1':
                            Handle(u);
                            break;

                        case '2':
                            Name(u);
                            break;

                        case '3':
                            Password(u);
                            VerifyPassword(u);
                            break;

                        case '4':
                            Sex(u);
                            break;

                        case '5':
                            BDay(u);
                            break;

                        case '6':
                            Email(u);
                            break;

                        case '7':
                            EmailPriv(u);
                            break;

                        case '8':
                            Note(u);
                            break;

                        case '9':
                            ChallengeQuestion(u);
                            break;

                        case '0':
                            ChallengeAnswer(u);
                            break;

                        default :
                            break;
                    }
                }
                break;

            case 'A': // Abort
                return;

            default :
                break;
        }
    }
}

int logon::logon_system(UserRec *urec) {

    UserRec u;
    UserIdx idx;

    char rBuffer[100] = {0};
    char text[100]    = {0};
    int  usernum      = 0;

    ansiPrintf((char *)"login");

    memset(&u,0,sizeof(UserRec));
    //strcpy(rBuffer,"");
    lang_get(text,4);
    int len = sizeof(u.handle)-1;
    inputfield(text,len);
    pipe2ansi(text);

    while (1) {
        memset(rBuffer,0,sizeof(rBuffer));
        getline(rBuffer,len);
        if (strcmp(rBuffer,"") != 0 && strcmp(rBuffer,"\n") != 0) {
            // Check if already exists
            usernum = atoi(rBuffer); // Check if User Number was entered.
            if (usernum != 0) {
                if (idx_read(&idx,usernum-1)) {
//                    elog("User # found: %i, %s",usernum, idx.handle);
                    strcpy(u.handle,idx.handle);
                    pipe2ansi(text); // Redisplay prompt
                    putline(u.handle);
                }
                else {
//                    elog("User # NOT found: %i, %s",usernum, rBuffer);
                }
            }
            else
            if(idx_match(rBuffer)) {
                strcpy(u.handle,rBuffer);
//                elog("User Name found: %i, %s",usernum, rBuffer);
            }
            else {
//                elog("User Name NOT found: %i, %s",usernum, rBuffer);
            }

            break; // Move onto password.

        }
        //pipe2ansi("|15|17");
        pipe2ansi(text);
    }


    // Fill GLobal User Containter with Users Data that just logged in.
    memset(urec,0,sizeof(UserRec));
    u.idx = idx_find(u.handle);
    users_read(urec,u.idx);

    std::string buff;
    readinAnsi("login2",buff);

    // Parse Logon 2 if exists.
    int id1;

    // Node Number
    id1 = buff.find("%NN",0);
    if (id1 != -1) {
        sprintf(text,"%i",NODE_NUM);
        buff.replace(id1,3,text);
    }
    // User Number
    id1 = buff.find("%UN",0);
    if (id1 != -1) {
        sprintf(text,"%ld",u.idx+1);
        buff.replace(id1,3,text);
    }
    // Last On
    id1 = buff.find("%LO",0);
    if (id1 != -1) {
        sprintf(text,"%s",Sec2DateTM(urec->dtlaston,2));
        buff.replace(id1,3,text);
    }
    // Last On
    id1 = buff.find("%BD",0);
    if (id1 != -1) {
        sprintf(text,"%s",Sec2Date(urec->dtbday));
        buff.replace(id1,3,text);
    }

    pipe2ansi((char *)buff.c_str());
    buff.erase();

    // Add Scrolling text here telling the user welcome and their user #...
    // Ask for Users Password
    lang_get(text,5);
    len = sizeof(u.password)-1;
    inputfield(text,len);
    pipe2ansi(text);
    while(1) {
        memset(rBuffer,0,sizeof(rBuffer));
        getline(rBuffer,len,NULL,TRUE);
        if (strcmp(rBuffer,"") != 0 && strcmp(rBuffer,"\n") != 0) {
            if (check_password(u.handle,rBuffer)) {
                strcpy(u.password,rBuffer);
                break;
            }
            else { // Incorrect Login - password


//  - Getto find pass code for users who forget, gota write util 1 day! haha
/*
                memset(urec,0,sizeof(UserRec));
                u.idx = idx_find(u.handle);
                users_read(urec,u.idx);
                users_read(&u,u.idx);

                //sprintf(urec->password,"resethtc");
                pipe2ansi("|15pass: ");
                pipe2ansi(u.password);
                pipe2ansi("|15 :end ");

                //users_write(urec,u.idx);
                sleep(4);
//
*/
                lang_get(text,6);
                pipe2ansi(text);
                return 0;
            }
        }
        //pipe2ansi("|15|17");
        pipe2ansi(text);
    }

    // Fill GLobal User Containter with Users Data that just logged in.
 //   memset(urec,0,sizeof(UserRec));
 //   u.idx = idx_find(u.handle);
 //   users_read(urec,u.idx);
    // login successful

    // Set Default to 1st Area, 0 = Email.
    if (urec->lastmbarea == 0)
        urec->lastmbarea = 1;

    // Write History.
    hist_update(HIST_CALLS,urec);
    hist_display(); // testing.

    // Setup Node File.
    node _node;
    _node.node_write(urec,NODE_NUM);
    UserLoggedIn = TRUE;

//    _node.node_global_announce_login();

	// HACK!! For BLock Sysop Message Areas!!


	if (strcmp(urec->handle,SYSOP_NAME) == 0) {
		isSysop = TRUE;
        //mf.resetlastread(urec);
        errlog((char *)"%s is a Sysop!",urec->handle);
    }
    else {

        errlog((char *)"%s is NOT a Sysop!",urec->handle);
    }


    return 1;
}

void logon::forgot_password() {

    UserRec u;
    UserIdx idx;

    char rBuffer[100] = {0};
    char text[100]    = {0};
    int  usernum      = 0;
    int  index;
    std::string check;
    std::string check2;


    ansiPrintf((char *)"forgot");

    memset(&u,0,sizeof(UserRec));
//    lang_get(text,4);
    sprintf(text,"handle: ");
    int len = sizeof(u.handle)-1;
    inputfield(text,len);
    pipe2ansi(text);

    while (1) {
        memset(rBuffer,0,sizeof(rBuffer));
        getline(rBuffer,len);
        if (strcmp(rBuffer,"") != 0 && strcmp(rBuffer,"\n") != 0) {
            // Check if already exists
            usernum = atoi(rBuffer); // Check if User Number was entered.
            if (usernum != 0) {
                if (idx_read(&idx,usernum-1)) {
//                    elog("User # found: %i, %s",usernum, idx.handle);
                    strcpy(u.handle,idx.handle);
                    //pipe2ansi(text); // Redisplay prompt
                    //putline(u.handle);
                }
                else {
//                    elog("User # NOT found: %i, %s",usernum, rBuffer);
                }
            }
            else
            if(idx_match(rBuffer)) {
                strcpy(u.handle,rBuffer);
//                elog("User Name found: %i, %s",usernum, rBuffer);
            }
            else {
//                elog("User Name NOT found: %i, %s",usernum, rBuffer);
            }

            break; // Move onto password.

        }
        //pipe2ansi("|15|17");
        pipe2ansi(text);
    }

    index = idx_find(u.handle);
    memset(&u,0,sizeof(UserRec));
    users_read(&u,index);

    pipe2ansi((char *)"|CR|CR|07Challenge Question: |15");
    sprintf((char *)text,"%s",(char *)u.c_question);
    pipe2ansi(text);

    pipe2ansi((char *)"|CR");

    // Add Scrolling text here telling the user welcome and their user #...
    // Ask for Users Password
 //   lang_get(text,5);
    sprintf(text,"answer: ");
    len = 60; //sizeof(u.c_answer)-1;
    inputfield(text,len);
    pipe2ansi(text);
    while(1) {
        memset(rBuffer,0,sizeof(rBuffer));
        getline(rBuffer,len,NULL,TRUE);
        if (strcmp(rBuffer,"") != 0 && strcmp(rBuffer,"\n") != 0) {
            check  = rBuffer;
            check2 = u.c_answer;
            if (check == check2) {

                // Sysop Protection!
                if (strcmp(u.handle,SYSOP_NAME) == 0) {
                    sprintf(text,"|CR|CR|15In-Correct! |07aborting . . .|CR|PA");
                    pipe2ansi(text);
                    return; //0;
                }

                sprintf(text,"|CR|CR|15Correct! Your forgotten password is: |07%s|CR|PA",u.password);
                pipe2ansi(text);
                break;
            }
            else { // Incorrect Login - password

                sprintf(text,"|CR|CR|15In-Correct! |07aborting . . .|CR|PA");
                pipe2ansi(text);
                return; //0;
            }
        }
        //pipe2ansi("|15|17");
        pipe2ansi(text);
    }

    return; //1;
}

