/***************************************************************************
 *   Copyright (C) 2004-2009 by Michael Griffin                            *
 *   frmisticismo@hotmail.com                                              *
 *                                                                         *
 *   Purpose: Message Area Full Screen Listing                             *
 *                                                                         *
 *                                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

// Enthral SVN: $Id: file_area.cpp 110 2009-06-02 02:41:35Z frank $
// Source: $HeadURL: http://svn.enthralbbs.com/trunk/src/file_area.cpp $
// $LastChangedDate: 2009-06-01 22:41:35 -0400 (Mon, 01 Jun 2009) $
// $LastChangedRevision: 110 $
// $LastChangedBy: frank $

# include <stdio.h>
# include <time.h>
# include <ctype.h>
# include <fstream>
# include <string>

# include <cstring>
# include <cstdlib>

# include "struct.h"

# include "language.h"
# include "file_area.h"
# include "menu_func.h"

using namespace std;

bool filearea_ini::filea_exists() {

    iTop = 0;
    iBot = 0;

    strcpy(sPAGENUM,"");
    strcpy(sPAGETOTAL,"");
    strcpy(sMOREUP,"");
    strcpy(sMOREUP_CHAR,"");
    strcpy(sMOREDOWN,"");
    strcpy(sMOREDOWN_CHAR,"");
    strcpy(sMOREMSG_ON,"");
    strcpy(sMOREMSG_WORD_ON,"");
    strcpy(sMOREMSG_OFF,"");
    strcpy(sMOREMSG_WORD_OFF,"");
    strcpy(sINPUT_BOX,"");
    strcpy(sTEXT_COLOR,"");
    strcpy(sTEXT_HILIGHT,"");
    strcpy(sMAX_AREAS,"");
    strcpy(sANSI_FILE,"");
    strcpy(sANSI_HELP,"");
    strcpy(sTHEME_NAME,"");
    strcpy(sMENU_PROMPT,"");
    strcpy(sMENU_PROMPT2,"");


    std::string path = INIPATH;
    path += "filearea.ini";

    FILE *stream;
    stream = fopen(path.c_str(),"rb+");
    if(stream == NULL) { return false; }
    fclose(stream);
    return true;
}

void filearea_ini::filea_create() {

    std::string name = INIPATH;
    name += "filearea.ini";

    ofstream outStream2;
    outStream2.open( name.c_str(), ofstream::out | ofstream::trunc );
    if (!outStream2.is_open()) {
        printf( "\nError Creating: %s \n", name.c_str());
        return;
    }

    outStream2 << " * Generated By Program. " << endl;
    outStream2.close();
    return;
}

void filearea_ini::filea_chkpar(std::string &data) {

    std::string temp1;
    int st1 = -1;
    int st2 = -1;
    signed int  ct = -1;

    st1 = data.find('"', 0);
    st2 = data.find('"', st1+1);
    ++st1;
    temp1 = data.substr(st1,st2);
    ct = st2 - st1;
    if (temp1.length() > ct)
        temp1.erase(ct,temp1.length());
    data = temp1;
}

void filearea_ini::filea_check(std::string cfgdata) {

    int id1 = 0;
    std::string temp = cfgdata;
    if (temp[0] == '#') return;
    else
    if (temp.find("set TOP ", 0) != std::string::npos) {
        filea_chkpar(temp);
        id1 = atoi(temp.c_str());
        iTop = id1;
    }
    else
    if (temp.find("set BOT ", 0) != std::string::npos) {
        filea_chkpar(temp);
        id1 = atoi(temp.c_str());
        iBot = id1;
    }
    else
    if (temp.find("set THEME_NAME ", 0) != std::string::npos) {
        filea_chkpar(temp);
        strcpy(sTHEME_NAME,(char *)temp.c_str());
    }
    else
    if (temp.find("set ANSI_FILE ", 0) != std::string::npos) {
        filea_chkpar(temp);
        strcpy(sANSI_FILE,(char *)temp.c_str());
    }
    else
    if (temp.find("set ANSI_HELP ", 0) != std::string::npos) {
        filea_chkpar(temp);
        strcpy(sANSI_HELP,(char *)temp.c_str());
    }
    else
    if (temp.find("set MENU_PROMPT ", 0) != std::string::npos) {
        filea_chkpar(temp);
        strcpy(sMENU_PROMPT,(char *)temp.c_str());
    }
    else
    if (temp.find("set MENU_PROMPT2 ", 0) != std::string::npos) {
        filea_chkpar(temp);
        strcpy(sMENU_PROMPT2,(char *)temp.c_str());
    }
    else
    if (temp.find("set PAGENUM ", 0) != std::string::npos) {
        filea_chkpar(temp);
        strcpy(sPAGENUM,(char *)temp.c_str());
    }
    else
    if (temp.find("set PAGETOTAL ", 0) != std::string::npos) {
        filea_chkpar(temp);
        strcpy(sPAGETOTAL,(char *)temp.c_str());
    }
    else
    if (temp.find("set MOREUP ", 0) != std::string::npos) {
        filea_chkpar(temp);
        strcpy(sMOREUP,(char *)temp.c_str());
    }
    else
    if (temp.find("set MOREUP_CHAR ", 0) != std::string::npos) {
        filea_chkpar(temp);
        strcpy(sMOREUP_CHAR,(char *)temp.c_str());
    }
    else
    if (temp.find("set MOREDOWN ", 0) != std::string::npos) {
        filea_chkpar(temp);
        strcpy(sMOREDOWN,(char *)temp.c_str());
    }
    else
    if (temp.find("set MOREDOWN_CHAR ", 0) != std::string::npos) {
        filea_chkpar(temp);
        strcpy(sMOREDOWN_CHAR,(char *)temp.c_str());
    }
    else
    if (temp.find("set MOREMSG_ON ", 0) != std::string::npos) {
        filea_chkpar(temp);
        strcpy(sMOREMSG_ON,(char *)temp.c_str());
    }
    else
    if (temp.find("set MOREMSG_WORD_ON ", 0) != std::string::npos) {
        filea_chkpar(temp);
        strcpy(sMOREMSG_WORD_ON,(char *)temp.c_str());
    }
    else
    if (temp.find("set MOREMSG_OFF ", 0) != std::string::npos) {
        filea_chkpar(temp);
        strcpy(sMOREMSG_OFF,(char *)temp.c_str());
    }
    else
    if (temp.find("set MOREMSG_WORD_OFF ", 0) != std::string::npos) {
        filea_chkpar(temp);
        strcpy(sMOREMSG_WORD_OFF,(char *)temp.c_str());
    }
    else
    if (temp.find("set INPUT_BOX ", 0) != std::string::npos) {
        filea_chkpar(temp);
        strcpy(sINPUT_BOX,(char *)temp.c_str());
    }
    else
    if (temp.find("set TEXT_COLOR ", 0) != std::string::npos) {
        filea_chkpar(temp);
        strcpy(sTEXT_COLOR,(char *)temp.c_str());
    }
    else
    if (temp.find("set MAX_AREAS ", 0) != std::string::npos) {
        filea_chkpar(temp);
        strcpy(sMAX_AREAS,(char *)temp.c_str());
    }
}

int filearea_ini::filea_parse(int idx) {

    if (!filea_exists())
        filea_create();

    char name[255]={0};
    char name2[255]={0};

    sprintf(name,"%sfilearea.ini",INIPATH);
    sprintf(name2,"%sfilearea%i.ini",INIPATH,idx);

    if (idx != 0) strcpy(name,name2);

    // Check if Theme Exists, if not return FALSE.
    FILE *stream;
    stream = fopen(name,"rb+");
    if(stream == NULL) { // File is not Present
        return FALSE;
    }
    else {
        fclose(stream);
    }

    ifstream inStream;
    inStream.open( name );
    if (!inStream.is_open()) {
        printf("Couldn't Open Config File: %s\n", name);
        return FALSE;
    }

    std::string cfgdata;
    for (;;) {
        getline(inStream,cfgdata);
        filea_check(cfgdata);
        if(inStream.eof()) break;
    }
    inStream.close();
    return TRUE;
}



file_area::file_area() {

    tTop     = 1;
    tBot     = 1;
}

void file_area::ParseHeader(char *filename) {

    std::string temp;
    std::string path = ANSIPATH;
    path += filename;
    path += ".ans";

    fb_list_rec fr;

    char MCI[3]     = {0};   // Holds MCI Codes to Parse
    char sTemp[255] = {0};
    int  space = 0, foundr = 0 , foundl = 0;
//    int  c = 0;
    std::string buff;

    /*
    // Buffer in Ansi
    FILE *inStream;
    if ((inStream = fopen(path.c_str(), "r+")) ==  NULL) {
        return;
    }
    do {
        c = getc(inStream);
        if  (c != EOF) buff += c;
    } while (c != EOF);
    fclose(inStream);
    */

    readinAnsi(filename, buff);
    read_fbaselist(&fr, thisuser->lastmbarea);

    int id1 = 0;
    while (id1 != -1) {
        // parse justify spacing right / left passing in string before
        // replacing mci code. to Properly Space Output Ansi.
        id1 = buff.find("%", 0);
        if (id1 == -1) break;
        memset(&MCI,0,sizeof(MCI));
        space = 0;
        // Check if MCI Code is Justified then Process this.
        if (buff[id1+3] == '{') { // Left Justify
            //elog("left justify: %c%c",buff[id1+4],buff[id1+5]);
            MCI[0] = buff[id1+4]; // Get first Digit
            MCI[1] = buff[id1+5]; // Get Second Digit
            space  = atoi(MCI);
            foundr = FALSE;
            foundl = TRUE;
        }
        else
        if (buff[id1+3] == '}') { // Right Justify
            //elog("right justify: %c%c",buff[id1+4],buff[id1+5]);
            MCI[0] = buff[id1+4]; // Get first Digit
            MCI[1] = buff[id1+5]; // Get Second Digit
            space  = atoi(MCI);
            //elog("right justify: %i",space);
            foundl = FALSE;
            foundr = TRUE;
        }
        // Now Get MCI Code
        MCI[0] = buff[id1+1]; // Get first Digit
        MCI[1] = buff[id1+2]; // Get Second Digit

        memset(&sTemp,0,sizeof(sTemp));
        // Insert MCI Parsing here so we can reaplace full result with propering spacing.
        if (strcmp(MCI,"FA") == 0)  { temp += fr.fbdisplay; }
        else
        if (strcmp(MCI,"TH") == 0)  { temp += sTHEME_NAME; }


        if (strcmp(MCI,"FA") == 0)    {
            sprintf(sTemp,"%s", (char *)fr.fbdisplay); }
        else
        if (strcmp(MCI,"TH") == 0) {
            sprintf(sTemp,"%s", (char *)sTHEME_NAME); }

/*
        if (strcmp(MCI,"TH") == 0) {
            sprintf(sTemp,"#%i. %s",thisuser->readertheme+1,sTHEME_NAME); }
*/

        // MCI Translation .
        if (foundl == TRUE) {
            lspacing(sTemp,space);
        }
        else
        if (foundr == TRUE) {
           rspacing(sTemp,space);
        }

        //If we Parsed Justify, then Erase that MCI Code as well.
        (space != 0) ?
            buff.replace(id1,6,sTemp):
            buff.replace(id1,3,sTemp);
    }
    //elog("Finished Parsing MCI Codes...");
    pipe2ansi((char *)buff.c_str());
}

void file_area::SetupList(UserRec *user) {

    thisuser = user;
    // Check What Theme user has selected.
    if (filea_parse(thisuser->readertheme) == FALSE) {
        filea_parse();
    }
    tTop = iTop;
    tBot = iBot;
}

int file_area::change_theme(int idx) {

    // Check What Theme user has selected.
    if (filea_parse(idx) == FALSE) {
        // Theme Doesn't Exist.
        return FALSE;
    }
    thisuser->readertheme = idx;

    // Save User Settings.
    UserRec usr;
    usr = *thisuser;
    users _usr;
    _usr.users_write(&usr,usr.idx);

    tTop = iTop;
    tBot = iBot;
    mLink.Top = tTop;
    mLink.Bot = tBot;
    return TRUE;
}

char *file_area::StartList(char *OrgMsg) {

    bool more        = false;
    bool showmore    = false;
    char mString[10] = {0};
    unsigned char ch;
    std::string _output;
    char outBuffer[200];

    // Startup Friend Classes
    language    _lang;
    menu_func   _mnuf;
    msg_readll  mLink;

    mLink.initList(sTEXT_COLOR, TRUE);
    //mLink.togglePageScroll(FALSE);

    mLink.Top = tTop;
    mLink.Bot = tBot;

    // Prep Not needed anymore.
    //mLink.add_to_list("");
    //mLink.move_up();

    // Mainly for Text Selection.
    char rBuffer[100]={0};
    char text[100]={0};
    char sNum[3]={0};
    std::string rBuff;
    int id1; //id2,
    int num, num2;
    int len;

    std::string tmp;
    UserRec trec;

    // For Next / Prev Message Areas
    int CurrentPage;
    int bSize;
    bSize = tBot - tTop;
    ++bSize;

    // Run through Main Reader Loop until exit from user - This Loop Probably not needed anymore.
    while (1) {
        ParseHeader(sANSI_FILE);          // Display Ansi
        mLink.PutBuffer(OrgMsg, FALSE);   // Send the Original Message into list Buffer
        mLink.box_start(CURRENT_FAREA);                // Draw Message Inside of Box

        while(1) {
            _output = "";
            more = false;
            showmore = false;
            //if (mLink.line_count() > 0) more = true;
            if (mLink.Page != mLink.TotPages) more = true;

            // Show Down Arrow More!
            if (more) {
                sprintf(outBuffer,"%s\x19",sMOREDOWN);  // On
                showmore = true;
            }
            else {
                sprintf(outBuffer,"%s ",sMOREDOWN);     // Off
            }
            _output += outBuffer;

            // Show up Arrow More
            if (mLink.Page > 1) {
                sprintf(outBuffer,"%s\x18",sMOREUP);
                showmore = true;
            }
            else {
                sprintf(outBuffer,"%s ",sMOREUP);
            }
            _output += outBuffer;

            if (showmore)
                sprintf(outBuffer,"%s%s",sMOREMSG_ON,sMOREMSG_WORD_ON);
            else
                sprintf(outBuffer,"%s%s",sMOREMSG_OFF,sMOREMSG_WORD_OFF);
            _output += outBuffer;

            // Show Current/Total Pages
            sprintf(outBuffer,"%s%.2d",sPAGENUM,mLink.Page);
            _output += outBuffer;
            sprintf(outBuffer,"%s%.2d",sPAGETOTAL,mLink.TotPages);
            _output += outBuffer;

            // # of Message Areas
            sprintf(outBuffer,"%s%d",sMAX_AREAS,mLink.Tot);
            _output += outBuffer;

            // Draw Input Box
            memset(&text,0, sizeof(text));
            strcpy(text,sINPUT_BOX);
            len = 14;
            inputfield(text,len);
            _output += text;

            pipe2ansi((char *)_output.c_str());

            // Make Msgqp2 Prompt Optional, Use if exists!
            // Also Let user Toggle on / off
            _mnuf._premenu.clear();
            _mnuf._premenu = _mnuf._curmenu;

            if (_mnuf.cmdexist(sMENU_PROMPT2,0) /*&& thisuser->msgp2*/ ) {
                if (more || mLink.Page > 1) {
                    _mnuf._curmenu.clear();
                    _mnuf._curmenu = sMENU_PROMPT2;
                }
                else
                    _mnuf._curmenu.clear();
                    _mnuf._curmenu = sMENU_PROMPT;
            }
            else {
                _mnuf._curmenu.clear();
                _mnuf._curmenu = sMENU_PROMPT;
            }

//            elog2("Get Input");

            // Readin the Menu Prompt
            _mnuf.menu_readin();
            _mnuf.menu_proc(mString);
            ch = mString[1];

 //           elog2("Got Input: %c",ch);

            // For Menu CmdKey Input
            if (mString[0] == '!')
                switch (toupper(ch)) {

                case 'Q': // Quit
                    mLink.dispose_list();
                    //_mnuf.~menu_func();
                    return NULL; //qBuf;

                case 'U': // Page UP
                    mLink.box_pgup();
                    break;

                case 'D': // Page Down
                    mLink.box_pgdn();
                    break;

                case '+': // Next Area - Move Down

//                    elog2("Next Area");

                    if (CURRENT_FAREA+1 != mLink.Tot+1)
                        ++CURRENT_FAREA;

                    thisuser->lastmbarea = CURRENT_FAREA;
                    mLink.dispose();

                    // If In current Page only refresh screen,
                    // otherwise page down to this page!
                    for (CurrentPage = 1; CurrentPage < mLink.TotPages+1; CurrentPage++) {
                      if ((bSize*CurrentPage) >= CURRENT_FAREA+1) {
                            mLink.Page = CurrentPage;
                            break;
                        }
                    }

                    //  Redraw Box with new Area Selection.
                    memcpy(&trec,thisuser,sizeof(UserRec));
                    tmp.erase();
                    ParseFArea(&trec, tmp);
                    mLink.PutBuffer((char *)tmp.c_str(), FALSE);
                    //mLink.box_refresh();
                    mLink.box_overdraw(CURRENT_FAREA);
                    mLink.Tot = mLink.line_total();
                    break;

                case '-': // Previous Area - Move Up

//                    elog2("Previous Area");

                    if (CURRENT_FAREA == 1)
                        break;

                    --CURRENT_FAREA;
                    // Were not on the Last Page with ScrollDown. Change to Next Page
                    if (mLink.pgRows == 0) {
                        // otherwise page down to this page!
                        for (CurrentPage = 1; CurrentPage < mLink.TotPages+1; CurrentPage++) {
                          if ((bSize*CurrentPage) >= CURRENT_FAREA+1) {
                                mLink.Page = CurrentPage;
                                break;
                            }
                        }
                    }

                    // Were on Last Page which was scrolled down and contains some of the above
                    // page, when scroll back up, get to top line first, then page up to next page
                    // Else just keep moving up. mLink.pgRows = # of Rows on Last Page.
                    else
                    if (mLink.Tot - CURRENT_FAREA == mLink.pgRows) {
                        for (CurrentPage = 1; CurrentPage < mLink.TotPages+1; CurrentPage++) {
                          if ((bSize*CurrentPage) >= CURRENT_FAREA+1) {
                                mLink.Page = CurrentPage;
                                break;
                            }
                        }
                    }
                    thisuser->lastmbarea = CURRENT_FAREA;
                    mLink.dispose();

                    // Redraw Box with new Area Selection.
                    memcpy(&trec,thisuser,sizeof(UserRec));
                    tmp.erase();
                    ParseFArea(&trec, tmp);
                    mLink.PutBuffer((char *)tmp.c_str(), FALSE);
                    //mLink.box_refresh();
                    mLink.box_overdraw(CURRENT_FAREA);
                    mLink.Tot = mLink.line_total();
                    break;

                default :
                    break;
            } // end of case
            else
            if (mString[0] == '#') {
                // received Digit Input From Menu Prompt
                memset(&rBuffer,0, sizeof(rBuffer));
                memset(&text,0, sizeof(text));
                strcpy(text,sINPUT_BOX);
                len = 14;
                inputfield(text,len);
                pipe2ansi(text);
                sprintf(sNum,"%c",ch);
                getline(rBuffer,len,sNum);
                num = 0;
                num2 = 0;
                // Catch any invalid input
                id1 = atoi(rBuffer);

                if (id1 > mLink.Tot || id1 < 1) {
                    // Redraw input box
                    memset(&text,0, sizeof(text));
                    strcpy(text,sINPUT_BOX);
                    len = 14;
                    inputfield(text,len);
                    pipe2ansi(text);
                    mLink.box_refresh(CURRENT_FAREA);
                }
                else {

                    // Current Area is the one selected!
                    if (CURRENT_FAREA == id1) {
                        // Display Area Chaned, then exit back to menu.
                        memset(&text,0, sizeof(text));
                        _lang.lang_get(text,41);
                        pipe2ansi(text);
                        mLink.dispose_list();
                        return NULL;
                    }

                    CURRENT_FAREA = id1;
                    thisuser->lastmbarea = CURRENT_FAREA;

                    mLink.dispose(); //clear_all();

                    // Setup Box with new Area Selection.
                    memcpy(&trec,thisuser,sizeof(UserRec));
                    ParseFArea(&trec, tmp);
                    mLink.PutBuffer((char *)tmp.c_str(), FALSE);
                    //mLink.box_refresh();

                    // Redraw input box
                    memset(&text,0, sizeof(text));
                    strcpy(text,sINPUT_BOX);
                    len = 14;
                    inputfield(text,len);
                    //pipe2ansi(text);
                    mLink.box_refresh(CURRENT_FAREA);

                    // Display Area Chaned, then exit back to menu.
                    memset(&text,0, sizeof(text));
                    _lang.lang_get(text,27);
                    pipe2ansi(text);

                    // Clean and Exit!
                    mLink.dispose_list();
                    return NULL;
                }
            }
            else {  // For Escaped Key Input
                ch = mString[0];
                switch (toupper(ch)) {
                    case 'A':
                        mLink.box_pgup();
                        break;

                    case 'B':
                        mLink.box_pgdn();
                        break;

                    default :
                    break;
                }
            }
        }
    }
}
