#!/bin/sh
# fileannounce.sh - 11 Aug 2007 - Robert J. Clay
# what to do monthly for file announcements
#  add code to find actual month
BBBSDIR=/opt/bbbs
WORKPATH=/opt/bbbs/work
SCRIPTS=$BBBSDIR/scripts
SCRPTDIR=$BBBSDIR/scripts/sh

cd $BBBSDIR

#  post monthly announcements about files received
if [ -e $WORKPATH/tickinfo.m ]; then
  $BBBSDIR/bbbs btxt2bbs rocasa.stats $WORKPATH/tickinfo.m /F Sysop /S New Files, Last 30 Days
  $BBBSDIR/bbbs btxt2bbs files.metro $WORKPATH/tickinfo.m /F Rocasa BBS /S New Files, Last 30 Days
  $BBBSDIR/bbbs btxt2bbs files.new $WORKPATH/tickinfo.m /F Rocasa BBS /S New Files, Last 30 Days
  $BBBSDIR/bbbs btxt2bbs files.new.stn $WORKPATH/tickinfo.m /F Rocasa BBS /S New Files, Last 30 Days
  rm $WORKPATH/tickinfo.m
elif [ -e $WORKPATH/tickinfo.f ]; then
  $BBBSDIR/bbbs btxt2bbs rocasa.stats $WORKPATH/tickinfo.f /F Sysop /S New Files via FamilyNet, Last 30 Days
  $BBBSDIR/bbbs btxt2bbs files.metro $WORKPATH/tickinfo.f /F Robert Clay /S New Files via FamilyNet, Last 30 Days
  $BBBSDIR/bbbs btxt2bbs files.new.stn $WORKPATH/tickinfo.f /F Robert Clay /S New Files via FamilyNet, Last 30 Days
  $BBBSDIR/bbbs btxt2bbs files.fdn.announce $WORKPATH/tickinfo.f /F Robert Clay /S New Files via FamilyNet, Last 30 Days
  rm $WORKPATH/tickinfo.f
elif [ -e $WORKPATH/tickinfo.r ]; then
  $BBBSDIR/bbbs btxt2bbs rocasa.stats $WORKPATH/tickinfo.r /F Sysop /S New Files via ROCASA Distro, Last 30 Days
  rm $WORKPATH/tickinfo.r
fi
#
$BBBSDIR/bbbs bogus a
#
#  BBBS related file announcements 
$SCRIPTS/bbbsfdn/fileannounce.sh
#
#  PERL related file announcements 
$SCRIPTS/perlfdn/fileannounce.sh
#
#  IFDC related file announcements 
$SCRPTDIR/ifdc/fileannounce.sh
#
#  WWB related file announcements 
$SCRPTDIR/wwb/fileannounce.sh
#
#  LinuxNet related file announcements 
$SCRIPTS/ln/fileannounce.sh
#
#  STN related file announcements 
$SCRPTDIR/stn/fileannounce.sh
#
exit 0


