#!/bin/sh
# monthly.sh - 30 Jan 08 - Robert J. Clay
# what to do monthly
BBBSDIR=/opt/bbbs
SCRIPTS=$BBBSDIR/scripts
WORKPATH=$BBBSDIR/work
RULESPATH=/opt/ftn/rules 
cd $BBBSDIR

#  Purge files
$BBBSDIR/bbbs bpurge

#  post rules & announcements
##   monthly conference stats posting
#
/usr/bin/at now -q f -f $SCRIPTS/bconfmth.sh 
#
/usr/bin/at now -q f -f $SCRIPTS/chatstatmth.sh   

/usr/bin/at now -q f -f $SCRIPTS/sffstatmth.sh 

$BBBSDIR/bbbs bcstat ^rec. -30 > $WORKPATH/bcstat.txt 
$BBBSDIR/bbbs btxt2bbs rocasa.stats $WORKPATH/bcstat.txt /F Sysop /S 30 Day Totals for rec* echos
#
/usr/bin/at now -q f -f $SCRIPTS/pcstatmth.sh 
#
/usr/bin/at now -q f -f $SCRIPTS/progstatmth.sh 
#
/usr/bin/at now -q f -f $SCRIPTS/osstatsmth.sh 
##
#/usr/bin/at now -q f -f $SCRIPTS/mistatsmth.sh 
#
/usr/bin/at now -q f -f $SCRIPTS/altstatsmth.sh 
#
/usr/bin/at now -q f -f $SCRIPTS/sh/annnntpmth.sh 
#
#/usr/bin/at now -q f -f $SCRIPTS/sh/rhstatmth.sh 
#
#/usr/bin/at now -q f -f $SCRIPTS/sh/hamstatmth.sh 
#
#/usr/bin/at now -q f -f $SCRIPTS/sh/scistatmth.sh
#
/usr/bin/at now -q f -f $SCRIPTS/ftnstatmth.sh 
#
/usr/bin/at now -q f -f $SCRIPTS/stn/statmth.sh 
#
/usr/bin/at now -q f -f $SCRIPTS/sh/wwbstatmth.sh 
#
##  Post rules for SEMICH echo/mailing list, OS.NIX echo/mailing list,
# STN.PROG echo/mailing list, & STN.INTERNET echo/mailing list
/usr/bin/at now -q f -f $SCRIPTS/sh/rulespost.sh   
/usr/bin/at now -q f -f $SCRIPTS/stn/rulespost.sh   
/usr/bin/at now -q f -f $SCRIPTS/mac/rulespost.sh   
#  post monthly announcements about files received
/usr/bin/at now -q f -f $SCRIPTS/fileannounce.sh   

##  monthly hatching of various files 
#/usr/bin/at now -q f -f $SCRIPTS/sh/work/monthlyhatch.sh &  

#  monthly hatching of bbbsfdn files 
/usr/bin/at now -q f -f $SCRIPTS/bbbsfdn/hatchmonthly.sh   
#
$BBBSDIR/bbbs bogus a

#  monthly updates of available newsgroups
#$SCRIPTS/sh/getactive.sh
$BBBSDIR/bbbs bnntp g 192.168.4.5 $WORKPATH/rocasa.net.news
$BBBSDIR/bbbs bnntp g news-server.twmi.rr.com $WORKPATH/twmirr.news
$BBBSDIR/bbbs bnntp g news.redhat.com $WORKPATH/redhat.com.news
$BBBSDIR/bbbs bnntp g news.tardis.net $WORKPATH/tardis.net.news
$BBBSDIR/bbbs bnntp g news.osirusoft.com $WORKPATH/osirusoft.com.news
$BBBSDIR/bbbs bnntp g news.dyndns.org $WORKPATH/dyndns.org.news
#


#
exit 0


