UNIT EAUtils ;

INTERFACE

USES DOS,CRT,JPDoor32,EADef,EASup ;


PROCEDURE Restart ;
PROCEDURE DoMaintenance(n:byte) ;
PROCEDURE ImportTrivia ;
PROCEDURE PlayTrivia ;

IMPLEMENTATION


PROCEDURE Restart ;
VAR
   f   : TEXT ;
BEGIN
   writeln ;
   writeln(' Game restart/initialization') ;
   if exist('ea.dat') then begin
      assign(f,'ea.dat') ;
      erase(f) ;
   end ;
   if exist('ea.gam') then begin
      assign(f,'ea.gam') ;
      erase(f) ;
   end ;
   if exist('ea.log') then begin
      assign(f,'ea.log') ;
      erase(f) ;
   end ;
   if exist('ea.scr') then begin
      assign(f,'ea.scr') ;
      erase(f) ;
   end ;
   if exist('ea.msg') then begin
      assign(msgfile,'ea.msg') ;
      reset(msgfile) ;
      while not eof(msgfile) do begin
         read(msgfile,msg) ;
         if exist(msg.filename) then begin
            assign(f,msg.filename) ;
            erase(f) ;
         end ;
      end ;
      close(msgfile) ;
      erase(msgfile) ;
   end ;
   if exist('ea.trn') then begin
      assign(f,'ea.trn') ;
      erase(f) ;
   end ;
   if exist('eapast.dat') then begin
      assign(f,'eapast.dat') ;
      erase(f) ;
   end ;
   if exist('eapast.hst') then begin
      assign(f,'eapast.hst') ;
      erase(f) ;
   end ;
   if exist('alltime.dat') then begin
      assign(f,'alltime.dat') ;
      erase(f) ;
   end ;
   writeln(' Game restarted') ;
END ;


PROCEDURE ImportTrivia ;
VAR
   infile   : TEXT ;
   outfile  : TEXT ;
   tfile    : STRING ;
   instr    : STRING ;
   yr,mn,
   dt,dy,
   hr,min,
   sec,
   sec100   : WORD ;
   line     : STRING ;
   DirInfo  : SearchRec ;
BEGIN
   WRITELN ;
   WRITELN(' Import a trivia question file.') ;
   WRITELN ;
   WRITE('Enter filename to import: ') ;
   Readln(instr) ;
   IF instr = '' THEN EXIT ;
   IF Exist('LAST.TRV') THEN DeleteFile('LAST.TRV') ;
   IF Exist('EA.TRV') THEN BEGIN
      FindFirst('TRIVIA\*.T??',Archive,DirInfo) ;
      WHILE DosError = 0 DO BEGIN
         DeleteFile('TRIVIA\' + DirInfo.Name) ;
         WRITELN(' DELETING: TRIVIA\', DirInfo.Name) ;
         FindNext(DirInfo) ;
      END ;
      DeleteFile('EA.TRV') ;
   END ;
   ASSIGN(infile,instr) ;
   {$I-} RESET(infile) ; {$I+}
   IF IOResult <> 0 THEN EXIT ;
   ASSIGN(TrivFile,'EA.TRV') ;
   REWRITE(TrivFile) ;
   WHILE NOT EOF(InFile) DO BEGIN
      READLN(InFile,Line) ;
      IF Line[1] = '' THEN BEGIN
         GetTime(hr,min,sec,sec100) ;
         GetDate(yr,mn,dt,dy) ;
         WRITELN(' Importing question number: ',FilePos(TrivFile)+1) ;
         tfile := 'TRIVIA\'+FixByte(dt)+FixByte(hr)+FixByte(mn)+
                  FixByte(sec)+'.T'+FixByte(sec100) ;
         WRITELN('  Attaching file: ',tfile) ;
         ASSIGN(outfile,tfile) ;
         REWRITE(outfile) ;
         REPEAT
            READLN(InFile,Line) ;
            IF Line[1] <> '' THEN WRITELN(OutFile,Line) ;
         UNTIL Line[1] = '' ;
         FLUSH(outfile) ;
         CLOSE(outfile) ;
         READLN(InFile,Line) ;
         Trivia.Answer := UPCASE(Line[1]) ;
         READLN(InFile,Line) ;
         Trivia.Worth := AtoI(COPY(Line,1,5)) ;
         Trivia.QuestionFile := Tfile ;
         WRITE(TrivFile,Trivia) ;
      END ;
   END ;
   CLOSE(TrivFile) ;
   WRITELN(' Process complete') ;
   HALT(15) ;
END ;


FUNCTION GetTriviaNumber:INTEGER ;
BEGIN
   ASSIGN(TrivNumFile,'LAST.TRV') ;
   {$I-} RESET(TrivNumFile) ; {$I+}
   IF IOResult <> 0 THEN BEGIN
      REWRITE(TrivNumFile) ;
      TrivNumInfo.TriviaNumber := 1 ;
      WRITETrivNum ;
      CLOSE(TrivNumFile) ;
      GetTriviaNumber := 1 ;
      Exit ;
   END ;
   READTrivNum ;
   INC(TrivNumInfo.TriviaNumber) ;
   IF TrivNumInfo.TriviaNumber > FileSize(TrivFile)
     THEN TrivNumInfo.TriviaNumber := 1 ;
   SEEK(TrivNumFile,0) ;
   WRITETrivNum ;
   CLOSE(TrivNumFile) ;
   GetTriviaNumber := TrivNumInfo.TriviaNumber ;
END ;


PROCEDURE PlayTrivia ;
VAR
   i     : BYTE ;
   tfile : STRING ;
   ch    : CHAR ;
BEGIN
   Filemode := 66 ;
   IF NOT Exist('EA.TRV') THEN Exit ;
   ASSIGN(TrivFile,'EA.TRV') ;
   RESET(TrivFile) ;
   IF FileSize(TrivFile) < 1 THEN BEGIN
      CLOSE(TrivFile) ;
      EXIT ;
   END ;
   SEEK(TrivFile,GetTriviaNumber-1) ;
   READTrivia ;
   CLOSE(TrivFile) ;
   ResetButtons ;
   AddButton('A') ;
   AddButton('B') ;
   AddButton('C') ;
   AddButton('D') ;
   SendButtons(#13) ;
   buttonchange := true ;
   WriteToInnerBoard(Trivia.QuestionFile,False,0,False) ;
   CursorPos(20,1) ;
   sDisplay(0,15,0,'For $'+ItoA(Trivia.Worth)+', enter your answer: ') ;
   REPEAT
      ch := UPCASE(GetChar) ;
   UNTIL ch IN ['A','B','C','D'] ;
   sDisplay(0,14,0,ch) ;
   IF ch <> Trivia.Answer THEN BEGIN
      WriteDisplay(12,'Your answer was incorrect!') ;
   END ELSE BEGIN
      WriteDisplay(10,'You are correct!  Awarding $'+ItoA(Trivia.Worth)+'.') ;
      INC(PlayerScore,Trivia.Worth) ;
   END ;
END ;





PROCEDURE Task_1 ;
BEGIN
   WRITELN(' Task #1: Cleaning MultiLine Files/Variables') ;
   WRITELN('           Checking EA.USE') ;
   IF Exist('EA.USE') THEN BEGIN
      WRITELN('           Found and removed EA.USE') ;
      DeleteFile('EA.USE') ;
   END ELSE WRITELN('           EA.USE needs no attention') ;
   WRITELN('           Checking for games marked "InUse"') ;
   ASSIGN(GameFile,'EA.GAM') ;
   RESET(GameFile) ;
   WHILE NOT EOF(GameFile) DO BEGIN
      READ(GameFile,GameInfo) ;
      IF GameInfo.InUse THEN BEGIN
         WRITELN('           Clearing InUse flag for game #',FilePos(GameFile)) ;
         GameInfo.InUse := FALSE ;
         SEEK(GameFile,FilePos(GameFile)-1) ;
         WRITE(GameFile,GameInfo) ;
      END ;
   END ;
   CLOSE(GameFile) ;
   WRITELN(' Task #1: Complete') ;
END ;


PROCEDURE Task_2 ;
VAR
   NewFile     : FILE OF GameRecord ;
   newpastgamefile : file of pastgamerec ;
   a,b         : REAL ;
   numplayers,
   xx,x,z,
   i,j,jj      : BYTE ;
   yr,mn,dt,dy : WORD ;
   thewinner   : STRING[35] ;
   line        : STRING ;
   tempvar     : LONGINT ;
   temppos     : BYTE ;
   bestscore   : ARRAY [1..8] OF LONGINT ;
BEGIN
   WRITELN(' Task #2: Closing games ',Info.GameRetention,' days old') ;
   WRITELN('           Using ',ConfigFileName,' - Retention: ',Info.GameRetention) ;
   ASSIGN(GameFile,'EA.GAM') ;
   RESET(GameFile) ;
   ASSIGN(NewFile,'EAGAM.$$$') ;
   REWRITE(NewFile) ;
   j := 0 ;
   WHILE NOT EOF(GameFile) DO BEGIN
      READ(GameFile,GameInfo) ;
      a := GameInfo.StartDate ;
      GetDate(yr,mn,dt,dy) ;
      b := Julian(yr,mn,dt) ;
      IF Info.StartingNumber > 1 THEN BEGIN
         {count how many players are in the game }
         NumPlayers := 0 ;
         FOR jj := 1 TO 8 DO BEGIN
            IF GameInfo.PlayerName[jj] <> '' THEN INC(NumPlayers) ;
         END ;
         {if numplayers less than startingnumber don't nuke}
         IF NumPlayers < Info.StartingNumber THEN BEGIN
            a := b ;
            GameInfo.StartDate := a ;
            SEEK(GameFile,FilePos(GameFile)-1) ;
            WRITE(GameFile,GameInfo) ;
         END ;
      END ;
      IF (b - a) >= Info.GameRetention THEN BEGIN
         WRITELN('           Closed game: ',FilePos(GameFile)) ;
         INC(j) ;

         { count number of players }
         pastgame.numplayers := 0 ;
         for x := 1 to 8 do begin
            if gameinfo.PlayerName[x] <> '' then inc(pastgame.numplayers) ;
         end ;

         {zero out bestscore array }
         for x := 1 to 8 do bestscore[x] := 0 ;

         { re-score all score totals }
         for x := 1 to pastgame.numplayers do begin
            bestscore[x] := GameInfo.Playerscore[x] ;
            for z := 1 to 33 do begin
               if gameinfo.gamedata[z].owner = gameinfo.playername[x]
                  then inc(bestscore[x],gameinfo.gamedata[z].purchaseprice) ;
            end ;
         end ;

         { get the highest scoring dude }
         tempvar := 0 ;
         temppos := 0 ;
         thewinner := '' ;
         for x := 1 to pastgame.numplayers do begin
            if bestscore[x] > tempvar then begin
               tempvar := bestscore[x] ;
               temppos := x ;
               thewinner := gameinfo.playername[x] ;
            end ;
         end ;

         { temppos now holds the playernumber of the winner }
         { now record it in user record }
         if exist('ea.dat') then begin
            ASSIGN(userfile,'ea.dat') ;
            reset(userfile) ;
            while not eof(userfile) do begin
               read(userfile,user) ;
               if user.alias = gameinfo.playername[temppos] then begin
                  inc(user.gameswon) ;
                  seek(userfile,filepos(userfile)-1) ;
                  write(userfile,user) ;
                  seek(userfile,filesize(userfile)) ;
               end ;
            end ;
            close(userfile) ;
         end ;

         { now build the pastgamerec using temporary variables }
         for x := 1 to 8 do begin
            pastgame.propertyscores[x] := 0 ;
            pastgame.cashscores[x] := 0 ;
            pastgame.playernames[x] := '' ;
         end ;
         getdate(yr,mn,dt,dy) ;
         yr := yr - 1900 ;
         pastgame.closingdate := fixbyte(mn)+'-'+fixbyte(dt)+'-'+itoa(yr) ;
         pastgame.winner := thewinner ;
         for x := 1 to pastgame.numplayers do begin
            pastgame.playernames[x] := gameinfo.playername[x] ;
            pastgame.cashscores[x] := gameinfo.playerscore[x] ;
            for z := 1 to 33 do begin
               if gameinfo.gamedata[z].owner = gameinfo.playername[x] then
                  inc(pastgame.propertyscores[x],gameinfo.gamedata[z].purchaseprice) ;
            end ;
         end ;
         assign(pastgamefile,'EAPAST.HST') ;
         if exist('EAPAST.HST') then begin
            reset(pastgamefile) ;
            seek(pastgamefile,filesize(pastgamefile)) ;
         end else rewrite(pastgamefile) ;
         write(pastgamefile,pastgame) ;
         assign(newpastgamefile,'EAPAST.DAT') ;
         rewrite(newpastgamefile) ;
         for xx := (filesize(pastgamefile) - 1) downto 0 do begin
            seek(pastgamefile,xx) ;
            read(pastgamefile,pastgame) ;
            write(newpastgamefile,pastgame) ;
         end ;
         close(pastgamefile) ;
         close(newpastgamefile) ;
      END ELSE WRITE(NewFile,GameInfo) ;
   END ;
   CLOSE(GameFile) ;
   CLOSE(NewFile) ;
   ERASE(GameFile) ;
   RENAME(NewFile,'EA.GAM') ;
   WRITELN(' Task #2: Complete') ;
END ;


PROCEDURE Task_3 ;
BEGIN
   WRITELN(' Task #3: Nulling out empty messages in the database') ;
   ASSIGN(MsgFile,'EA.MSG') ;
   {$I-} RESET(MsgFile) ; {$I+}
   IF IOResult = 0 THEN BEGIN
      WHILE NOT EOF(MsgFile) DO BEGIN
         ReadMsg ;
         IF NOT Exist(Msg.FileName) THEN BEGIN
            WRITELN('  Nulling out empty message to '+Msg.WhoTo) ;
            Msg.WhoTo := '' ;
            SEEK(MsgFile,FilePos(MsgFile)-1) ;
            WriteMsg ;
         END ;
      END ;
      CLOSE(MsgFile) ;
   END ;
   WRITELN(' Task #3: Complete') ;
END ;


PROCEDURE Task_4 ;     { Purge nulled-out message headers }
VAR
   NewFile    : FILE OF MsgRecord ;
BEGIN
   WRITELN(' Task #4: Removing null messages from the database') ;
   ASSIGN(MsgFile,'EA.MSG') ;
   RESET(MsgFile) ;
   ASSIGN(NewFile,'EAMSG.$$$') ;
   REWRITE(NewFile) ;
   WHILE NOT EOF(MsgFile) DO BEGIN
      ReadMsg ;
      IF Msg.WhoTo <> '' THEN WRITE(NewFile,Msg) ;
   END ;
   CLOSE(MsgFile) ;
   CLOSE(NewFile) ;
   ERASE(MsgFile) ;
   RENAME(NewFile,'EA.MSG') ;
   WRITELN(' Task #4: Complete') ;
END ;


PROCEDURE Task_5 ;
VAR
   DirInfo    : SearchRec ;
BEGIN
   WRITELN(' Task #5: Deleting orphaned temporary files') ;
   FindFirst('*.$$$',Archive,DirInfo) ;
   WHILE DosError = 0 DO BEGIN
      WRITELN('           Deleting orphaned file: ',DirInfo.Name) ;
      DeleteFile(DirInfo.Name) ;
      FindNext(DirInfo) ;
   END ;
   WRITELN(' Task #5: Complete') ;
END ;


procedure task_6 ;
var
   newufile   : file of userrecord ;
   newmsgfile : file of msgrecord ;
   found      : boolean ;
   deleted    : integer ;
   f          : text ;
   today      : real ;
begin
   getdate(yr,mn,dt,dy) ;
   today := julian(yr,mn,dt) ;
   writeln(' Task #6: Removing inactive players') ;
   if exist('ea.dat') then begin
      assign(newufile,'ea.$$$') ;
      rewrite(newufile) ;
      assign(userfile,'ea.dat') ;
      reset(userfile) ;
      deleted := 0 ;
      while not eof(userfile) do begin
         read(userfile,user) ;
         if today - user.laston > info.inactivedays then begin
            writeln(' Deleting user: ',user.name) ;
            inc(deleted) ;
         end else write(newufile,user) ;
      end ;
      close(userfile) ;
      close(newufile) ;
      erase(userfile) ;
      rename(newufile,'ea.dat') ;
   end ;
   writeln(' Task #6: Complete') ;
   if (deleted > 0) and (exist('ea.msg')) then begin
      writeln(' Task #7: Removing messages to/from deleted players') ;
      assign(msgfile,'ea.msg') ;
      reset(msgfile) ;
      assign(newmsgfile,'ea.$$$') ;
      rewrite(newmsgfile) ;
      assign(userfile,'ea.dat') ;
      while not eof(msgfile) do begin
         read(msgfile,msg) ;
         reset(userfile) ;
         found := false ;
         while not eof(userfile) do begin
            read(userfile,user) ;
            if (msg.whoto = user.alias) or (msg.from = user.alias)
              then found := true ;
         end ;
         if found then write(newmsgfile,msg) else begin
            writeln('  Deleting message: ',msg.filename) ;
            assign(f,msg.filename) ;
            erase(f) ;
         end ;
      end ;
      close(userfile) ;
      close(msgfile) ;
      close(newmsgfile) ;
      erase(msgfile) ;
      rename(newmsgfile,'ea.msg') ;
      writeln(' Task #7: Complete') ;
   end ;
end ;



PROCEDURE DoMaintenance(n:byte) ;
BEGIN
   WRITELN(' Eclectic Avenue Maintenance Agent') ;
   WRITELN ;
   IF (NOT Exist('EA.GAM')) OR (NOT Exist('EA.DAT')) THEN BEGIN
      WRITELN(#7,' SERIOUS ERROR - Game and/or Player files missing!') ;
      Exit ;
   END ;
   ASSIGN(ConfigFile,ConfigFileName) ;
   RESET(ConfigFile) ;
   READ(ConfigFile,Info) ;
   CLOSE(ConfigFile) ;
   Task_1 ;   { get rid of ea.use and multiline files }
   if n = 2 then exit ;
   Task_2 ;
   IF Exist('EA.MSG') THEN BEGIN
      Task_3 ;
      Task_4 ;
   END ELSE BEGIN
      WRITELN(' Task #3: Skipping - no message file exists') ;
      WRITELN(' Task #4: Skipping - no message file exists') ;
   END ;
   Task_5 ;
   Task_6 ;        { also calls task 7 }
   WRITELN ;
   WRITELN(' Event ends') ;
   WRITELN ;
   DELAY(3000) ;
END ;

BEGIN
END.
