PROCEDURE ClearStatus ;
VAR
   i   : BYTE ;
BEGIN
   FOR i := 20 TO 22 DO BEGIN
      CursorPos(i,1) ;
      sdisplay(0,7,0,#27+'[K') ;    {clear to end of line}
   END ;
END ;


PROCEDURE Say(n:BYTE ; WhatToSay:STRING) ;
BEGIN
   CASE n OF
      1   : CursorPos(20,1) ;
      2   : CursorPos(21,1) ;
      3   : CursorPos(22,1) ;
   END ;
   sDisplay(0,11,0,WhatToSay) ;
END ;


PROCEDURE Chance(n:BYTE) ;
VAR
   Ch          : CHAR ;
   Rand        : INTEGER ;
   tval        : INTEGER ;
   i           : BYTE ;
   TempStr     : STRING ;
   ii          : INTEGER ;
BEGIN
   CASE n OF
      1   : BEGIN                             { Player drew a VD LUCK card }
               Say(1,'You are hungry and decide to eat.  You lose one turn') ;
               Say(2,'and spend $20 on a meal.') ;
               Pause ;
               IF PlayerScore < 20 THEN BEGIN
                   WriteDisplay(12,'You don''t have enough to pay for your meal!  Game over!') ;
                   GameOver(20,False) ;
               END ELSE BEGIN
                  DEC(PlayerScore,20) ;
                  INC(TurnCount,1) ;
               END ;
            END ;

      2   : BEGIN                            { Player Drew a tax LUCK card}
               Say(1,'City Tax assessment.') ;
               Say(2,'Cost to you $20 per property.') ;
               Pause ;
               Tval := 20 * NumberOfProperties ;
               IF Tval > PlayerScore THEN BEGIN
                  WriteDisplay(12,'You don''t have enough to pay taxes ($'+
                                  ItoA(Tval)+')!  Game over!') ;
                  GameOver(Tval,False) ;
               END ELSE BEGIN
                  DEC(PlayerScore,Tval) ;
                  WriteDisplay(12,'You paid $'+ItoA(Tval)+' in taxes.') ;
               END ;
            END;
      3   : BEGIN                           {Player drew Mugged LUCK card}
               Say(1,'You have been mugged!') ;
               Tval := TRUNC((PlayerScore * 0.1)) ;
               Say(2,'You lose 10% ($'+ItoA(Tval)+').') ;
               Pause ;
               DEC(PlayerScore,Tval) ;
            END;

      4   : BEGIN                           {Player drew hospital LUCK card}
               Say(1,'Pay Hospital Bill of $150') ;
               Pause ;
               IF PlayerScore < 150 THEN BEGIN
                  WriteDisplay(12,'You don''t have enough to pay your bills!  Game over!') ;
                  GameOver(150,False) ;
               END ELSE DEC(PlayerScore,150) ;
            END;

      5   : BEGIN                           {Player drew Premium due LUCK card}
               Say(1,'Insurance premium is due ($100).') ;
               Pause ;
               IF PlayerScore < 100 THEN BEGIN
                  WriteDisplay(12,'You don''t have enough to pay your bills!  Game over!') ;
                  GameOver(100,False) ;
               END ELSE BEGIN
                  WriteDisplay(10,'You pay $100') ;
                  DEC(PlayerScore,100) ;
               END ;
            END;

      6   :  BEGIN                           {Player drew Bad check LUCK card}
                Say(1,'You took a bad check.') ;
                Say(2,'The bank charges you $10') ;
                Pause ;
                IF PlayerScore < 10 THEN BEGIN
                   WriteDisplay(12,'You don''t have enough to pay the bills!  Game over!') ;
                   GameOver(10,False) ;
                END ELSE BEGIN
                   WriteDisplay(10,'You pay the bank $10.') ;
                   DEC(PlayerScore,10) ;
                END ;
             END;

      7   :  BEGIN                            {Player drew court supina LUCK card}
                Say(1,'You have been served a subpoena.') ;
                Say(2,'You lose one turn while in court.') ;
                Pause ;
                INC(TurnCount) ;
             END;

      8   :  BEGIN
                Say(1,'You volunteered to give blood.') ;
                Say(2,'You lose one turn but gain $50') ;
                Pause ;
                INC(TurnCount) ;
                INC(PlayerScore,50) ;
             END;

      9   :  BEGIN
                repeat
                   rand := random(300) ;
                until rand > 99 ;
                Say(1,'Bank error in your favor.') ;
                Say(2,'You collect $'+itoa(rand)+'.') ;
                Pause ;
                INC(PlayerScore,rand) ;
             END;

     10   :  BEGIN                             {player drew Sweeps week LUCK card}
                Say(1,'It''s sweeps week') ;
                Say(2,'You do the Geraldo show for $300.') ;
                Pause ;
                INC(PlayerScore,300) ;
             END;

     11   :  BEGIN                             {Player drew Investment LUCK card}
                If PlayerScore < 1 THEN BEGIN
                   REPEAT
                      Rand := Random(50) ;
                   UNTIL (Rand > 0) AND (Rand < MaxChances) ;
                   Chance(Rand) ;
                END ELSE BEGIN
                   Say(1,'Opportunity knocks.') ;
                   Say(2,'Your investment has a 50-50 chance.') ;
                   Say(3,'Enter amount of investment [$1..$'+
                         ItoA(PlayerScore)+']: ') ;
                   REPEAT
                     TempStr := GetInput('',1,Length(ItoA(PlayerScore))) ;
                     IF TempStr = '' THEN TempStr := '1' ;
                   UNTIL (AtoI(TempStr) >= 0) AND
                         (AtoI(TempStr) <= PlayerScore) ;
                   Tval := AtoI(TempStr) ;
                   Rand := Random(10003) ;
                   ClearStatusArea ;
                   If Odd(rand) then begin
                      Say(1,'Your investment went bad') ;
                      Say(3,'You lose $'+TempStr) ;
                      Dec(PlayerScore,Tval) ;
                   End Else Begin
                      Say(1,'Your Investment paid off!') ;
                      Say(3,'You Win $'+TempStr) ;
                      Inc(PlayerScore,Tval) ;
                   End ;
                   Pause ;
                END ;
             END ;
     12   :  BEGIN                                     {player drew get out of jail card}
                If GetOutOfJail = True Then BEGIN
                   REPEAT
                      Rand := Random(50) ;
                   UNTIL (Rand > 0) AND (Rand < MaxChances) ;
                   Chance(Rand) ;
                END ELSE BEGIN
                   Say(1,'Free Bail Bond Card') ;
                   Pause ;
                   GetOutOfJail := True ;
                END;
             END ;

     13   :  BEGIN                                     {player drew Raid card}
                IF PlayerScore < 301 THEN BEGIN
                   REPEAT
                      Rand := Random(50) ;
                   UNTIL (Rand > 0) AND (Rand < MaxChances) ;
                   Chance(Rand) ;
                END ELSE BEGIN
                   YesNo ;
                   Say(1,'Police Raid!. You stand to lose $200') ;
                   Say(3,'Would you like to bribe the cops? [Y,n]: ') ;
                   REPEAT
                      Ch  := UPCASE(GetChar) ;
                      IF Ch = #13 THEN Ch := 'Y' ;
                   UNTIL Ch IN ['Y','N'] ;
                   sDisplay(0,15,0,Ch) ;
                   IF Ch = 'Y' THEN BEGIN
                      Rand := Random(10003) ;
                      ClearStatusArea ;
                      IF ODD(Rand) THEN BEGIN
                         Say(1,'The cops accept your bribe.  You only pay $100.') ;
                         Pause ;
                         Tval := 100 ;
                      END ELSE BEGIN
                         Say(1,'The cops refuse to be bought!') ;
                         Say(2,'You pay the original $200 PLUS $100 for bribing a police officer!') ;
                         Pause ;
                         Tval := 300 ;
                      END ;
                   END ELSE BEGIN
                      Tval := 200 ;
                      Say(1,'You decide not to chance it and pay $200') ;
                      Pause ;
                   END ;
                   IF PlayerScore < Tval THEN BEGIN
                      WriteDisplay(12,'You don''t have enough to pay your bills!  Game over!') ;
                      GameOver(Tval,False) ;
                   END ELSE DEC(PlayerScore,Tval) ;
                END ;
             END ;
     14   :  BEGIN                                    {Player drew passed a bad check card}
                Say(1,'You passed a bad check.') ;
                Say(2,'The bank charges you $15.') ;
                Pause ;
                IF PlayerScore < 15 THEN BEGIN
                   WriteDisplay(12,'You don''t have enough to pay your bills!  Game over!') ;
                   GameOver(15,False) ;
                END ELSE DEC(PlayerScore,15) ;
             END ;

     15   :  BEGIN                                    {player drew Phone bill LUCK card}
                repeat
                   rand := random(150) ;
                until rand > 50 ;
                Say(1,'You''ve been calling long distance BBS''s.') ;
                Say(2,'Your phone bill is $'+itoa(rand)+'.') ;
                Pause ;
                IF PlayerScore < 100 THEN BEGIN
                   WriteDisplay(12,'You don''t have enough to pay your bills!  Game over!') ;
                   GameOver(rand,False) ;
                END ELSE DEC(PlayerScore,rand) ;
             END ;

     16   :  BEGIN                                  {Player drew lotto winner LUCK card}
                repeat
                   rand := random(500) ;
                until rand > 99 ;
                Say(1,'You hit $'+itoa(rand)+' on the lotto!') ;
                Pause ;
                INC(PlayerScore,rand) ;
             END ;

     17   :  BEGIN                                 {Player drew tax return LUCK card}
                repeat
                   rand := random(260) ;
                until rand > 80 ;
                Say(1,'Your Tax return came in.') ;
                Say(2,'You collect $'+itoa(rand)+'.') ;
                Pause ;
                Inc(PlayerScore,rand) ;
             END ;

     18   :  BEGIN                                 {Player Drew car trouble LUCK card}
                repeat
                   rand := random(300) ;
                until rand > 99 ;
                Say(1,'Your Car broke down.') ;
                Say(2,'Pay garage $'+itoa(rand)+'.') ;
                Pause ;
                IF PlayerScore < rand THEN BEGIN
                   WriteDisplay(12,'You don''t have enough to pay your bills!  Game over!') ;
                   GameOver(rand,False) ;
                END ELSE Dec(PlayerScore,rand) ;
             END ;

     19   :  BEGIN                                 {Player drew disk crash LUCK card}
                Say(1,'Your hard drive crashed.') ;
                Say(2,'The repair bill comes to $150.') ;
                Pause ;
                IF PlayerScore < 150 THEN BEGIN
                   WriteDisplay(12,'You don''t have enough to pay your bills!  Game over!') ;
                   GameOver(150,False) ;
                END ELSE DEC(PlayerScore,150) ;
             END ;

     20,31 : BEGIN
                Say(1,'FREE TURN!') ;
                Say(2,'You get an extra turn.') ;
                Pause ;
                DEC(TurnCount) ;
             END ;
     21   :  BEGIN
                REPEAT
                   i := Random(1000) ;
                UNTIL (i > 19) and (i < 501) ;
                Say(1,'Your Profit Sharing check came in!') ;
                Say(2,'It was a good year.  You collect $'+ItoA(i)+'!') ;
                Inc(PlayerScore,i) ;
                Pause ;
             END ;

     22   :  BEGIN                                 {track winnings}
                REPEAT
                   i := RANDOM(1000) ;
                UNTIL (i > 19) AND (i < 251) ;
                Say(1,'You go to the horse track.') ;
                Say(2,'You Win $'+ItoA(i)+'.') ;
                Inc(PlayerScore,i) ;
                Pause ;
             END ;

     23   :  BEGIN                                 {Found some cash}
                repeat
                   rand := random(150) ;
                until rand > 40 ;
                Say(1,'You found $'+itoa(rand)+' in cash.') ;
                Say(2,'You decide to turn it in... NOT!') ;
                Inc(PlayerScore,rand) ;
                Pause ;
             END ;

     24   :  BEGIN                                 {return cans}
                repeat
                   rand := random(100) ;
                until rand > 39 ;
                Say(1,'Turn in beer cans for recycling.') ;
                Say(2,'Collect $'+itoa(rand)+' and a good feeling.') ;
                Inc(PlayerScore,rand) ;
                Pause ;
             END ;
     25   :  BEGIN                                 {Garage Sale}
                repeat
                   rand := random(200) ;
                until rand > 99 ;
                Say(1,'You clean out your garage and have a sale.') ;
                Say(2,'You lose a turn but gain $'+itoa(rand)+'.') ;
                Inc(PlayerScore,rand) ;
                Inc(TurnCount) ;
                Pause ;
             END ;
     26   :  BEGIN                                     {player drew get out of jail card}
                If GetOutOfJail = True Then BEGIN
                   REPEAT
                      Rand := Random(50) ;
                   UNTIL (Rand > 0) AND (Rand < MaxChances) ;
                   Chance(Rand) ;
                END ELSE BEGIN
                   Say(1,'Free Bail Bond Card') ;
                   GetOutOfJail := True ;
                   Pause ;
                END;
             END ;
     27,
     28,
     29   :  BEGIN
                WriteDisplay(10,'Trivia Time!') ;
                PlayTrivia ;
                RedisplayInnerBoard ;
                SavedScore := 0 ;
                DrawFull := TRUE ;
             END ;
     30   :  BEGIN
                IF NumberOfProperties > 0 THEN BEGIN
                   FOR ii := 1 TO 33 DO BEGIN
                      IF GameInfo.GameData[ii].Owner = Alias THEN BEGIN
                         GameInfo.GameData[ii].Owner := '' ;
                         GameInfo.GameData[ii].SellPrice := 0 ;
                         INC(PlayerScore,GameInfo.GameData[ii].PurchasePrice) ;
                         Say(1,'Your property '+GameInfo.GameData[ii].Description+
                               ' burns to the ground.') ;
                         Say(2,'You collect a $'+ItoA(GameInfo.GameData[ii].PurchasePrice)+
                               ' insurance settlement.') ;
                         Say(3,'The insurance company rebuilds the property and places it back on the market.') ;
                         WriteNumbers ;
                         Pause ;
                         ii := 33 ;
                      END ;
                   END ;
                END ELSE Chance(29) ;
             END ;
     37,38 : BEGIN
                repeat
                   rand := random(1200) ;
                until rand > 300 ;
                IF (PlayerScore < rand) OR (NumberOfProperties < 1) THEN BEGIN
                   Chance(29) ;
                END ELSE BEGIN
                   repeat
                      tval := random(101) ;
                   until (tval > 4) and (tval mod 5 = 0) ;
                   FOR ii := 33 DOWNTO 1 DO BEGIN
                      IF GameInfo.GameData[ii].Owner = Alias THEN BEGIN
                         DEC(PlayerScore,rand) ;
                         INC(GameInfo.GameData[ii].RentalPrice,tval) ;
                         Say(1,'The city requires you to renovate your property '+GameInfo.GameData[ii].Description+'.') ;
                         Say(2,'You spend $'+ItoA(rand)+' on remodeling.') ;
                         Say(3,'The city allows you to raise the rent by $'+ItoA(tval)+'.') ;
                         Pause ;
                         ii := 1 ;
                      END ;
                   END ;
                END ;
             END ;
     ELSE WriteDisplay(12,'LUCK error! LUCK Number='+ItoA(n)) ;
   END ;  { end case }
   ClearStatusArea ;
END ;     { end proc }



