///////////////////////////////
// The Blue Moon Tavern v1.1 //
//  Written  March 14, 1997  //
//     By  Dan Shaurette     //
// As an IGM for  GOTHIK 1.6 //
///////////////////////////////
//     (C) Copyright 1997    // 
//     AQUARIUS Software     //
///////////////////////////////
/* 
   This game is written as a demonstration of how to access
   the GOTHIK.PLR file and NODExxxx.DAT file to garner information
   about the current player in GOTHIK.  You are free to use parts
   of this code to create new IGMs, but please, do not make changes
   to or rerelease the Blue Moon Tavern IGM without my permission.
   Make a whole new tavern, cannibalizing this one if you must,
   but don't make variations to my tavern.  Thank you.
   
   P.S. This was written using Brian Pirie's OpenDoors C Door Library
   functions.  They are not included with this distribution.  You may
   use whatever libraries you are familiar with.  But this is just so you
   know, all of the functions that you see in my code that begin od_,
   those are his communications functions.
*/

#include "c:\opendoor\opendoor.h"  /* Include required header file */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <dos.h>

#define BUF_SIZE 256
#define VERSION "1.1"

FILE *PlayerFile;
int playerNum;
char GothikDir[80], command[80];
char Convo[22][80];
int ConvoCount;
int Node=0;

struct PlayerData { //// This is the structure found in "GOTHIK.PLR".
   char name[36]; ////// The player's handle/real name from drop file.
   char gameName[26]; // The player's handle inside GOTHIK.
   char sex; /////////// Their sex, 'M' or 'F'.
   char fluff1; //////// Alignment fluff (ignore).
   char lastOn[9]; ///// Date the player played last in "mm-dd-yy" format.
   char fluff2; //////// More alignment fluff.
   char birthdate[9]; // Player's Birthdate in "mm-dd-yy" format.
   char fluff3; //////// Last piece of fluff.
   char attacked[26]; // gameName of who attacked player,"~" if not attacked.
   
   short int  level;      /// Player's level (1 to 13).
   short int  exp;      ///// Player's experience points.
   short int  mortal;      // 0 = Human, 1 = Vampire.
   short int  rating;      // 2 = LEWD, 1 = RUDE, 0 = PRUDE.
   short int  timesOn; ////// Number of times the player played today.
   short int  HP; /////////// Player's Hit Points left.
   short int  maxHP; //////// Maximum amount of HP.
   short int  moves; //////// Moves left to make.
   short int  maxMoves; ///// Maximum amount of moves.
   short int  weapon; /////// Weapon type owned by the player.
   short int  weaponPlus; /// A modifier to the weapon.
   short int  ammo; ///////// Ammunition type owned by the player.
   short int  ammoPlus; ///// A modifier to the ammo.
   short int  ammoAmount; /// Amount of ammunition remaining.
   short int  defense; ////// Type of ward that the player has (if Human).
   short int  defensePlus; // Modifier to the ward.
   
   short int  Str, Int, Wis, Dex, Con, Cha; // D&D style characteristics.
   short int  Willpower, Humanity, Thirst; /// New-style characteristics.
   short int  Faith, Inginuity;
   
   long inBank; ///////////// The amount of cash the player has in the bank.
   long onHand; ///////////// The amount of cash the player has on hand.
};

struct PlayerData Player;

void custom_line_function (char *keyword, char *options);
char before_chat_buffer[4004];
char before_chat_saved = FALSE;
void before_chat_function (void);
void after_chat_function (void);

///////////////////////////////////////////////////////////////////////////

int RandSeed;

void Randomize(void) {
time_t timer;

   time(&timer);
   RandSeed = (int) timer;
}

short Random() {
   RandSeed = (int)((RandSeed *25173 + 13849) % 65536);
   return ( (short) RandSeed);
}

int IntRand(int n) {
/* Returns a random integer from 1 to n */
float calculate;

   calculate = (float)(((float)Random()/32768.0 + 1.0) * ((float)n) / 2.0 + 1.0);
   return ((int) calculate);
}

////////////////////////////////////////////////////////////////////////////

void ClrScr(void) {
   od_clr_scr();
   if (od_control.user_rip) {
      od_printf ("\n\r");
   } 
}

void More (void) {
   od_printf ("`blue`[`bright blue` More... `blue`]");
   od_get_key (TRUE);
   od_printf ("\n\r`white`");
}

void Intro (void) {
   int temp = od_control.user_screen_length;
   od_control.user_screen_length = 50;
   od_send_file ("BMINTRO");
   od_control.user_screen_length = temp;
   More();
   ClrScr();
   od_printf("`bright blue`\n\r The Blue Moon Tavern `bright white`%s\n\r", VERSION);
   od_printf("`green` (C) Copyright 1997 `bright magenta`AQUARIUS `magenta`Software\n\r");
   od_printf("`blue` Written 3/14/97 `bright blue`By Dan Shaurette\n\r\n\r");
   od_set_colour (L_WHITE,D_BLACK);
}

void ThatsAll (void) {
   od_printf ("\n\r`bright blue`Check out the Desert Rain WebBBS at ");
   od_printf ("http://www.goodnet.com/~dshauret\n\r");
   od_printf ("`blue`Coming Soon... `red`GOTHIK: Tangled Web\n\r\n\r");
   od_printf ("`bright blue`Press Any Key to Return to `bright yellow`%s...\n\r", od_control.system_name);
   od_get_key (TRUE);
   od_exit (0, FALSE);
}

/////////////////////////////////////////////////////////////////////////////

void sleep (int seconds) {
// Will sleep for specified seconds, but keep the kernel active.
   long until = (*(long far*)0x46cL)+(18L*(long)seconds);
   while (until>*(long far*)0x46cL) {
      od_kernel();
   }
}

int RIPdetect (void) {
char ch;

   od_printf ("Attempting to detect RIP graphics...\n\r");

   if (od_control.user_rip) {      // First, was it set by a drop file?
      od_control.user_ansi=TRUE;
      od_printf ("RIP detected!\n\r");
      return (TRUE);
   }
   
   od_autodetect(DETECT_NORMAL);   // Can od_autodetect() tell?
   if (od_control.user_rip) {
      od_control.user_ansi=TRUE;
      od_printf ("RIP detected!\n\r");
      return (TRUE);
   }                                                                

   od_clear_keybuffer();
   od_disp_emu ("\x1b[!", TRUE);       /* \x1b sends the hex code for ESC */
   sleep(2);
   ch = od_get_key(FALSE);
   if ((ch == 'R')||(ch == 'I')||(ch == 'P')||(ch == 'S')||(ch == 'C')) {
      od_printf("!|*\n\r");      
      od_printf("!|*\n\r");      
      ClrScr();
      od_control.user_rip=TRUE;
      od_control.user_ansi=TRUE;
      od_printf ("RIP detected!\n\r");
      od_clear_keybuffer();
      return (TRUE);
   }   
   od_printf ("Attempting to detect ANSI...\n\r");
   od_clear_keybuffer();
   od_disp_emu ("\x1b[6n", TRUE);       /* \x1b sends the hex code for ESC */
   sleep(2);
   ch = od_get_key(FALSE);
   if ((ch == '\x1b')||(ch == '[')||(ch == 'n')||(ch == ';')||(ch == 'R')) {
      ClrScr();
      od_control.user_rip=FALSE;
      od_control.user_ansi=TRUE;
      od_printf ("`bright white`ANSI detected!\n\r");
      od_clear_keybuffer();
      return (FALSE);
   } else {
      od_control.user_rip=FALSE;
      od_control.user_ansi=FALSE;
      od_printf ("ASCII accepted\n\r");
      return (FALSE);
   }   
}

int Check (void) {
char Snd[80], Rec[80];
   sprintf (Snd, "!|1F010000bar1.icn\r");
   od_printf (Snd);
   od_input_str (Rec,79,'.',':');
   if (_stricmp(Rec, "1")==0) {
      return (TRUE);
   } else {
      return (FALSE);
   }
}

void Download1by1 (void) {
   od_printf("!|*\n\r");
   ClrScr();
   od_printf ("\n\r`bright white`You need the icon files necessary to properly view the intro screen.\n\r");
   od_printf ("If you choose to download them now, they will be sent to your term's icon\n\r");
   od_printf ("directory.  If you choose not to download them at this time, the game will end.\n\r\n\r");
   od_printf ("`gray`Do you wish to continue? `bright white`(Y/n) ");
   if ( (od_get_answer ("YN\n\r")) == 'N') {
      od_printf ("N\n\r\n\r");
      ThatsAll();
   }
   od_printf ("Y`gray`\n\r\n\r");
   od_printf ("!|9%c07020000bar1.icn<>\n\r", 27);
   sprintf (command, "dsz port %d sz bar1.icn", od_control.port+1);
   od_spawn(command);
   od_printf ("!|9%c07020000bar2.icn<>\n\r", 27);
   sprintf (command, "dsz port %d sz bar2.icn", od_control.port+1);
   od_spawn(command);
   More();
}

void RIPfileQuery(void) {
   od_printf("!|*\n\r");
   ClrScr();
   if (!Check())
      Download1by1();
}

/////////////////////////////////////////////////////////////////////////////

void custom_line_function (char *keyword, char *options) {
   if (strcmp(keyword, "GOTHIKDIR")==0) {
      strcpy(GothikDir, options);
   }
}

void before_chat_function (void) {
   before_chat_saved = od_save_screen(before_chat_buffer);
   ClrScr();
}

void after_chat_function (void) {
   if (before_chat_saved) {
      od_restore_screen(before_chat_buffer);
   }
}

/////////////////////////////////////////////////////////////////////////////

// get_access_hard -- uses a locking semaphore to protect a file you want
//                    to load/write
//                 -- If the locking semaphone file is in the directory,
//                    this will wait up to three seconds before deleting
//                    the semaphore.
//                 -- This should allow enough time for any user file access.
void get_access_hard( char *file_name )
  {
  char temp[128];
  struct find_t ffblk;
  int done, counter = 0;
  FILE *f;

  strcpy( temp, file_name );
  temp[ strlen( temp ) - 1] = 'X';

  done = _dos_findfirst( temp, _A_NORMAL, &ffblk );
  
  while ((done==0) && (counter < 3))
    {
    sleep( 1 );
    done = _dos_findfirst( temp, _A_NORMAL, &ffblk );
    counter++;
    }

  f = fopen( temp, "w");          /* create the semaphore file */
  fclose( f );
  }

// unlock_file -- deletes the semaphore file
void unlock_file( char *file_name )
  {
  char temp[128];

  strcpy( temp, file_name);
  temp[ strlen( temp ) - 1] = 'X';

  _unlink( temp );
  }

/////////////////////////////////////////////////////////////////////////////

void far GetPlayerNum (void) {
FILE *InPlayFile;
char Path[100];
   sprintf (Path, "%sNODE%04d.DAT", GothikDir, Node);
   get_access_hard (Path);
   if ( ( InPlayFile = fopen ( Path, "rb" ) ) == NULL ) {
      od_printf ("`white`NODE%04d.DAT File Not Found!\n\r", Node);
      ThatsAll();
   } else {
      fscanf (InPlayFile, "%d", &playerNum);
      fclose (PlayerFile);
   }
   unlock_file (Path);
}

void far LoadData (void) {
char Path[100];
   sprintf (Path, "%sGOTHIK.PLR", GothikDir);
   get_access_hard (Path);
   if ( ( PlayerFile = fopen ( Path, "rb" ) ) == NULL ) {
      od_printf ("`white`Player Data File Not Found!\n\r");
      ThatsAll();
   } else {
      fseek (PlayerFile, ((long)(playerNum*sizeof(struct PlayerData))), SEEK_SET);
      fread (&Player, sizeof (struct PlayerData), 1, PlayerFile);
      fclose (PlayerFile);
   }
   unlock_file (Path);
}

void far SaveData (void) {
char Path[100];
   sprintf (Path, "%sGOTHIK.PLR", GothikDir);
   get_access_hard (Path);
   if ( ( PlayerFile = fopen ( Path, "r+b" ) ) == NULL ) {
      od_printf ("`white`Player Data File Not Found!\n\r");
      ThatsAll();
   } else {
      fseek (PlayerFile, ((long)(playerNum*sizeof(struct PlayerData))), SEEK_SET);
      fwrite (&Player , sizeof (struct PlayerData), 1, PlayerFile);
      fclose (PlayerFile);
   }
   unlock_file (Path);
}

void far LoadConvo (void) {
FILE *ConvoFile;
   ConvoCount=0;
   if ( ( ConvoFile = fopen ( "CONVO.TXT", "r" ) ) == NULL ) {
      od_printf ("`white`You can make out some mumbling, but there is no conversation yet.\n\r");
   } else {
      fgets (Convo[ConvoCount], 79, ConvoFile);
      while (!feof(ConvoFile)) {
         od_printf ("`bright cyan`%s\r", Convo[ConvoCount++]);
         fgets (Convo[ConvoCount], 79, ConvoFile);
         od_printf ("`bright white`%s\r", Convo[ConvoCount++]);
         fgets (Convo[ConvoCount], 79, ConvoFile);
      }
   }
   fclose (ConvoFile);
}

void far SaveConvo (void) {
FILE *ConvoFile;
int i=0;
   if ( ( ConvoFile = fopen ( "CONVO.TXT", "w" ) ) == NULL ) {
      od_printf ("`white`Error opening CONVO.TXT!\n\r");
      ThatsAll();
   }
   if (ConvoCount>20) {
      i = 2;
   }
   while (i < ConvoCount) {
      fputs (Convo[i++], ConvoFile);
   }
   fclose (ConvoFile);
}

////////////////////////////////////////////////////////////////////////////

void far Donovan (void) {
char op;
long cost=0L;
int effect;
static int PGGB=0;
   ClrScr();
   od_printf ("`gray`   You make your way to a barstool.  Donovan walks over to you and you begin\n\r");
   od_printf ("to chat.  He eventually mentions that he's been experimenting with making\n\r");
   od_printf ("Pan Galactic Gargle Blasters again.  Each batch he makes never has the same\n\r");
   od_printf ("effect, and everyone seems to have a different reaction.  Some good, some bad.\n\r");
   od_printf ("And no matter what happens, you should never EVER drink more than two per day!\n\r\n\r");
   cost = (long)((Player.level*10)+(IntRand(10)-1));
   od_printf ("   He leans close and says, `bright white`\"I'll let ya try a glass for, say, $%ld.\"`gray`\n\r\n\r", cost);
   od_printf ("`bright cyan`You have `bright white`$%ld`bright cyan`.  Do you want to buy a glass?`gray` ", Player.onHand);
   op = od_get_answer("YN");
   if (op == 'Y') {
      if (Player.onHand-cost < 0) {
         od_printf ("\n\r\n\r`yellow`Sorry, but you can't afford that.\n\r");
         More();
      } else {
         if (PGGB < 2) {
            Player.onHand -= cost;
            PGGB++;
            switch (IntRand(7)) {
               case 1: Player.HP = Player.maxHP;
                       od_printf ("\n\r`bright white`Positive Effect!\n\r");
                       od_printf ("You have had all of your Hit Points restored!\n\r\n\r`gray`");
                       break;
               case 2: effect = IntRand(10)*10;
                       Player.HP = (int)(((float)Player.HP)*((float)effect/100.0));
                       od_printf ("\n\r`bright red`Negative Effect!\n\r`brite white`");
                       od_printf ("You now have only %d%% of your previous Hit Points,\n\r", effect);
                       od_printf ("bringing you down to %d HP!\n\r\n\r`gray`", Player.HP);
                       break;
               case 3: effect = IntRand(10);
                       Player.maxHP += effect;
                       od_printf ("\n\r`bright white`Positive Effect!\n\r");
                       od_printf ("Your maximum HP have been increased by %d!\n\r\n\r`gray`", effect);
                       break;
               case 4: effect = IntRand(5);
                       Player.moves += effect;
                       od_printf ("\n\r`bright white`Positive Effect!\n\r");
                       od_printf ("Your number of moves today have increased by %d!\n\r\n\r`gray`", effect);
                       break;
               case 5: effect = IntRand(5);
                       if (Player.moves <= 5) {
                          effect == 0;
                       }
                       Player.moves -= effect;
                       od_printf ("\n\r`bright red`Negative Effect!\n\r");
                       od_printf ("Your number of moves today have decreased by %d!\n\r\n\r`gray`", effect);
                       break;
               case 6: effect = IntRand(10)*IntRand(10)*IntRand(10);
                       Player.exp += effect;
                       od_printf ("\n\r`bright white`Positive Effect!\n\r");
                       od_printf ("You have gained %d experience!\n\r\n\r`gray`", effect);
                       break;
               case 7: effect = IntRand(10)*IntRand(10);
                       Player.exp -= effect;
                       od_printf ("\n\r`bright red`Negative Effect!\n\r");
                       od_printf ("You have lost %d experience!\n\r\n\r`gray`", effect);
            }
            More();
         } else {
            od_printf ("\n\r\n\r`bright white`\"I wouldn't have another one of those right now, if I were you.\"`gray`\n\r\n\r");
            More();
         }
      }
   } else {
      od_printf ("\n\r\n\r`gray`Don gets a sad, disappointed look and says, `bright white`\"Maybe later, eh?\"`gray`\n\r\n\r");
      More();
   }
   SaveData();
}

void far Lilith (void) {
char op;
long cost=0L;
   ClrScr();
   od_printf ("`gray`   You decide to sit down at a table and enjoy a drink.\n\r");
   od_printf ("The beautiful red-headed waitress, Lilith, walks up to you and asks what you\n\r");
   od_printf ("would like to drink.\n\r");
   if (Player.mortal == 0) { // Human
      od_printf ("\n\r   1) Mixed Drink     $1\n\r");
      od_printf ("   2) Beer from Tap   $2\n\r");
      od_printf ("   3) Bottle of Beer  $2\n\r");
      od_printf ("   4) Glass of Wine   $3\n\r");
      od_printf ("   0) None of the above\n\r\n\r");
      od_printf ("`bright cyan`You have `bright white`$%ld`bright cyan`.  What do you want to buy? ", Player.onHand);
      op = od_get_answer("01234");
      if (op!='0') {
         switch (op) {
            case '1': cost=1L; break;
            case '2': cost=2L; break;
            case '3': cost=2L; break;
            case '4': cost=3L;
         }
         if (Player.onHand-cost < 0) {
            od_printf ("\n\r\n\r`yellow`Sorry, but you can't afford that.\n\r");
            More();
         } else {
            Player.onHand -= cost;
            od_printf ("\n\r\n\r`grey`   That hit the spot!  ::urp::\n\r");
            More();
         }
      }
   } else { /////////////////// Vamp
      od_printf ("   She knows that you are a vampire, like she is, so she offers some\n\r");
      od_printf ("beverages that can disguise what it is you truly Thirst for.\n\r\n\r");
      od_printf ("   1) Bloody Mary     $1\n\r");
      od_printf ("   2) Red Lager       $2\n\r");
      od_printf ("   3) Red Wine        $3\n\r");
      od_printf ("   0) None of the above\n\r\n\r");
      od_printf ("`bright cyan`You have `bright white`$%ld`bright cyan`.  What do you want to buy? ", Player.onHand);
      op = od_get_answer("0123");
      if (op!='0') {
         switch (op) {
            case '1': cost=1L; break;
            case '2': cost=2L; break;
            case '3': cost=3L;
         }
         if (Player.onHand-cost < 0) {
            od_printf ("\n\r\n\r`yellow`Sorry, but you can't afford that.\n\r");
            More();
         } else {
            Player.onHand -= cost;
            Player.Thirst--;
            if (Player.Thirst<0) {
               Player.Thirst=0;
            }
            od_printf ("\n\r\n\r`grey`   That hit the spot!  ::urp::\n\r");
            More();
         }
      }
   }
   SaveData();
}

void far Converse (void) {
char string[80];
char op;

   ClrScr();
   od_printf ("`bright white`");
   LoadConvo();
   od_printf ("\n\r`bright yellow`Add to this conversation? `gray`");
   op = od_get_answer("YN");
   od_printf ("%c\n\r", op);
   
   if (op=='Y') {
      od_printf ("`bright cyan`Begin typing... you have 77 letters maximum!\n\r> `bright white`");
      od_input_str(string,77,32,127);
      sprintf (Convo[ConvoCount++], "%s said:\n", Player.gameName);
      sprintf (Convo[ConvoCount++], "%s\n", string);
      SaveConvo();
   }
   More();
}

void far Bar (void) {
char op;
int done=FALSE;

   od_printf ("`gray`   You walk down the street to a little bar with a blue neon sign that reads\n\r");
   od_printf ("`bright blue`The Blue Moon Tavern`gray`.  It seems inviting enough, but you really just want to\n\r");
   od_printf ("get out of the rain.  As you walk in, you are hailed by the regulars who\n\r");
   od_printf ("recognize you immediately.");
   while (!done) {
      od_printf ("\n\r\n\r`cyan`T)alk to Donovan, the Bartender\n\r");
      od_printf ("S)it down and order from Lilith, the Waitress\n\r");
      od_printf ("C)onverse with the regulars\n\r");
      od_printf ("L)eave the bar\n\r\n\r");
      od_printf ("`bright cyan`What do you want to do?`gray` ");
      op = od_get_answer("TSCL");
      od_printf ("%c\n\r", op);
      switch (op) {
         case 'T': // Order PGGB from Donovan
                   Donovan();
                   break;
         case 'S': // Order from Lilith
                   Lilith();
                   break;
         case 'C': // Converse with Patrons
                   Converse();
                   break;
         default:  done=TRUE;
      }
      ClrScr();
   }
}

/////////////////////////////////////////////////////////////////////////////

void main (int argc, char *argv[]) {
char Path[100];

   sprintf (od_registered_to, "Dan Shaurette");
   od_registration_key = 2149646336L;
   od_control.od_nocopyright=TRUE;
   sprintf (od_control.od_prog_name, "Blue Moon Bar");
   od_control.od_config_file = INCLUDE_CONFIG_FILE;
   od_control.od_config_function = custom_line_function;
   od_control.od_cbefore_chat = before_chat_function;   
   od_control.od_cafter_chat = after_chat_function;   
   od_control.od_default_rip_win = TRUE;
   od_control.od_node = 0;
   
   if (argc>1) {
      if (toupper(argv[1][1])=='N') {
            od_control.od_node = atoi(&argv[1][2]);
      }
   }
   sprintf (Path, "BLUEMN%02d.CFG", od_control.od_node);
   od_control.od_config_filename = Path;

   od_init();
   od_control.od_help_text2=(char *)"     The Blue Moon Tavern v.1.1   -=+*+=-  (C)opyright 1997 AQUARIUS Software ";

   Node = od_control.od_node;
   od_printf("!|*\n\r");
   ClrScr();
   if (od_control.baud == 0) {
      od_control.user_rip=FALSE;
      od_control.user_ansi=TRUE;
      od_printf ("`bright white`Local mode detected... defaulting to ANSI\n\r");
      sleep(1);
   } else {
      if (RIPdetect()) {
         RIPfileQuery();
      }
   }
   Intro();
   Randomize();
   GetPlayerNum();
   LoadData();
   Bar();
   ThatsAll();
}
