#include <OpenDoor.h>
#include <string.h>
#include <stdlib.h>
#include <inttypes.h>
#include "inih/ini.h"

#if defined(WIN32) || defined(_MSC_VER)
#define strcasecmp _stricmp
#endif

struct bbs_t {
	char name[64];
	char address[128];
	char type[16];
	uint16_t port;
};

struct bbs_t **bbses;
int bbs_count = 0;


static int handler(void *user, const char *section, const char *name,
                               const char *value) {

	struct bbs_t *bbs = NULL;
	struct bbs_t *abbs = NULL;
	struct bbs_t **tmp;
	
	if (strlen(section) == 0) return 1;
	
	for (size_t i = 0; i < bbs_count; ++i) {
		abbs = bbses[i];
		if (strcasecmp(abbs->name, section) == 0) {
			bbs = abbs;
			break;
		}
	}
	
	if (bbs == NULL) {
		bbs = (struct bbs_t *)malloc(sizeof(struct bbs_t));
		if (!bbs) {
			return 0;
		}
		memset(bbs, 0, sizeof(struct bbs_t));
		
		if (bbs_count == 0) {
			bbses = (struct bbs_t **)malloc(sizeof(struct bbs_t *));
		} else {
			tmp = (struct bbs_t **)realloc(bbses, sizeof(struct bbs_t *) * (bbs_count + 1));
			if (!tmp) {
				return 0;
			}
			bbses = tmp;
		}
		
		strncpy(bbs->name, section, 63);
		
		bbses[bbs_count] = bbs;
		bbs_count++;		
	}

	if (strcasecmp(name, "address") == 0) {
		strncpy(bbs->address, value, 127);
	} else if (strcasecmp(name, "connectiontype") == 0) {
		strncpy(bbs->type, value, 15);
	} else if (strcasecmp(name, "port") == 0) {
		bbs->port = (uint16_t)strtoul(value, NULL, 10);
	}

	return 1;
}

int lastposition = -1;
int position = 0;
int start = 0;
int redraw = 1;

void display_list() {
	int i;

	
	if (position > start + 15) {
		start = position;
		redraw = 1;
	} else if (position < start) {
		start = position - 15;
		if (start < 0) start = 0;
		redraw = 1;
	}
	
	if (redraw == 1) {
		od_clr_scr();
		od_set_cursor(1, 1);
		od_set_color(L_WHITE, D_BLUE);
		od_printf("apam's Yet Another BBS Listing - %d entries", bbs_count);
		od_clr_line();
		
		od_set_cursor(24, 1);
		od_set_color(L_WHITE, D_BLUE);
		od_printf("UP/DOWN/PAGE-UP/PAGE-DOWN Move through List, Q - Quit");
		od_clr_line();
		
		od_set_color(D_GREY, D_BLACK);
		
		for (i=start;i<start + 16 && i < bbs_count; i++) {
			od_set_cursor(i - start + 2, 1);
			if (i == position) {
				od_set_color(D_BLACK, D_CYAN);
			}
			
			od_printf("%-79.79s", bbses[i]->name);
			if (i == position) {
				od_set_color(D_GREY, D_BLACK);			
			}
		}
		redraw = 0;
	} else {
		if (lastposition != -1 && lastposition < start + 16) {
			od_set_cursor(lastposition - start + 2, 1);
			od_set_color(D_GREY, D_BLACK);
			od_printf("%-79.79s", bbses[lastposition]->name);
		}
		od_set_cursor(position - start + 2, 1);
		od_set_color(D_BLACK, D_CYAN);
		od_printf("%-79.79s", bbses[position]->name);
	}
	
	// draw current BBS info
	od_set_cursor(18, 1);
	od_set_color(L_WHITE, D_BLUE);
	od_printf("BBS Info: %-69.69s", bbses[position]->name);
	od_clr_line();
	od_set_color(L_CYAN, D_BLACK);
	od_set_cursor(19, 2);
	od_printf("%s:", bbses[position]->type);
	od_clr_line();
	od_set_color(L_WHITE, D_BLACK);
	od_set_cursor(20, 4);
	od_printf("%-79.79s", bbses[position]->address);
	od_clr_line();
	od_set_cursor(22, 4);
	od_printf("Port: %d", bbses[position]->port);
	od_clr_line();
	
	
	
}

int load_bbs_list() {
	if (ini_parse("syncterm.lst", handler, NULL) < 0) {
		fprintf(stderr, "Unable to load syncterm.lst!\n");
		return 0;
	}
	
	return 1;
}

#if defined(WIN32) || defined(_MSC_VER)
int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance,LPSTR lpszCmdLine,int nCmdShow)
{
#else
int main(int argc, char **argv)
{
#endif
	
	int done = 0;
	tODInputEvent ch;
	
#if defined(WIN32) || defined(_MSC_VER)
	od_parse_cmd_line(lpszCmdLine);
#else
	od_parse_cmd_line(argc, argv);
#endif
	od_init();
	
	if (!load_bbs_list()) {
		od_exit(0, FALSE);
	}

	while (!done) {
		display_list();
		od_get_input(&ch, OD_NO_TIMEOUT, GETIN_NORMAL);
        if (ch.EventType == EVENT_EXTENDED_KEY) {
			switch(ch.chKeyPress) {
			case OD_KEY_DOWN:
				if (position + 1 < bbs_count) {
					lastposition = position;
					position++;
				} else {
					lastposition = -1;
				}
				break;
			case OD_KEY_UP:
				if (position - 1 >= 0) {
					lastposition = position;
					position--;
				} else {
					lastposition = -1;
				}
				break;				
			case OD_KEY_PGUP:
				if (position - 16 >= 0) {
					position = position - 16;
					redraw = 1;
				}
				break;
			case OD_KEY_PGDN:
				if (position + 16 < bbs_count) {
					position = position + 16;
					redraw = 1;
				}
				break;
			}
		} else if (ch.EventType == EVENT_CHARACTER) {
			switch (ch.chKeyPress) {
				case 'q':
				case 'Q':
					done = 1;
					break;
			}
		}
			
	}
	
	od_exit(0, FALSE);
}
