/* A REXX Script for AdeptXBBS, this script produces information about
   drives installed in your System.

   It also produces a graph of available space on the drive letter.
   The output is FULLY ansi/ascii compatable.

   As with all my utilities, this is freeware, but I would appreciate
   feedback so I know that people are using them :-).

   I have included this source coz it only took me a couple of hours to do
   it, and provides good examples of how to use the various REXX functions.

   Enjoy!.

          -Robert Stephens   ('Jewfish' in IRC #adept)

          Fido     : 3:622/421
          Internet : ourjs@net-unix.newcastle.edu.au
                                                                           */
Arg Line

Call RxFuncAdd 'SysDriveInfo', 'RexxUtil', 'SysDriveInfo'

STRF_UCASE = X2D(00000001)      
STRF_NOECHO = X2D(00000008)     
STRF_MUSTHOT = X2D(00000100)    

Adept_Drive_Letter = VALUE('APATH',,'OS2ENVIRONMENT')
If Adept_Drive_Letter = "" Then Do
   Call AdeptPrint Line, "\r\n{FDSysop Warning!:\r\nThe 'APATH' environment variable isn't set, AdeptXBBSCallers will\r\nnot operate correctly without it."
   Call AdeptHitReturn Line
   Call AdeptPrint Line, '\r\n\r\nExiting ...'
   Exit
End
Parse VAR Adept_Drive_Letter Drive_Letter ':'
Adept_Drive_Letter = Drive_Letter":"

Temp = Stream(Adept_Drive_Letter'\ADEPT\MENUS\DRIVES.TXT','c','query exists')
If Temp = "" Then Do
   Call AdeptPrint Line, '\r\n\r\nThe File DRIVES.TXT has not been found in your Adept MENUS directory,\r\nplease check the Docs that came with AdeptDriveSpace\r\nThanks!.'
   Call AdeptHitReturn Line
   Exit
End
Available_Drives = LineIn(Adept_Drive_Letter'\ADEPT\MENUS\DRIVES.TXT')
Do Until Position = 0
   Position = Pos(':',Available_Drives)
   If Position = 0 Then Leave
   Temp_Drives = DelStr(Available_Drives,Position,1)
   Available_Drives = Temp_Drives
End

Drive = Word(Available_Drives,1)
Number_Of_Drives = Words(Available_Drives)

Loopey:
Info = SysDriveInfo(Drive)
Drive_Letter = Left(Word(Info,1),2)
Space_Free = Word(Info,2)
Total_Space = Word(Info,3)
Drive_Label = Left(Word(Info,4),10)
Space_Used = Total_Space - Space_Free

Percent_Full = Trunc((((Total_Space - Space_Free) / Total_Space) * 100),1)
Length = Trunc((50 * (Percent_Full / 100)),1)
Parse Var Length Temp1 '.' Temp2
If Temp2 >= 5 Then Temp1 = Temp1 + 1
Length = Temp1

Graph_Line = Left(Copies('',Length),49,' ')

To_Do = Total_Space
Call To_Convert_Out
Total_Space = To_Do

To_Do = Space_Free
Call To_Convert_Out
Space_Free = To_Do

To_Do = Space_Used
Call To_Convert_Out
Space_Used = To_Do

Percent_Full = Left(Percent_Full'%',5)
Call AdeptPrint Line, '\r\n\r\n{FA   Ŀ'
Call AdeptPrint Line, '\r\n    {FGDrive 'Drive_Letter', Volume Label : 'Drive_Label'                                   {FA'
Call AdeptPrint Line, '\r\n                                                                          '
Call AdeptPrint Line, '\r\n                {FBTotal Storage   : 'Total_Space'                    {FA'
Call AdeptPrint Line, '\r\n                {FBBytes Used      : 'Space_Used'                    {FA'
Call AdeptPrint Line, '\r\n                                                                          '
Call AdeptPrint Line, '\r\n                {FGSpace Remaining : 'Space_Free'                    {FA'
Call AdeptPrint Line, '\r\n                                                                          '
Call AdeptPrint Line, '\r\n                 {FD0%       20%       40%       60%       80%       100%    {FA'
Call AdeptPrint Line, '\r\n   Ĵ'
Call AdeptPrint Line, '\r\n    {FCSpace Used :  {FF'Graph_Line'{FA {FG'Percent_Full'{FA'
Call AdeptPrint Line, '\r\n   {F8\r\n\r\n\'

Ask_Again:
Call AdeptPrint Line, '\r\n{FCQ=Quit\r\n{FGChoose a Drive Letter to view ['Available_Drives'] : '
Drive_To_Show = AdeptInput(Line,1,1,,STRF_UCASE+STRF_NOECHO+STRF_MUSTHOT,'',,,)
If Drive_To_Show = '-2' Then Exit
Check = WordPos(Drive_To_Show,Available_Drives)
If Drive_To_Show = "Q" Then Exit
If Check = 0 Then Do
   Call AdeptPrint Line, '\r{FDDrive Letter NOT Available! -- Choose Again'
   Signal Ask_Again
End
Drive = Drive_To_Show':'
Signal Loopey

/******| Convert 123456789 to 123,456,789 |************/
To_Convert_Out:
   Str_Length = Length(To_Do)
   Do While Str_Length >= 0
      Str_Length = Str_Length - 3
      If Str_Length <= 0 Then Leave
      To_Do = Left(Insert(',',To_Do' bytes',Str_Length),20)
   End
Return
/******| End of Conversion Routine |*******************/
